/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.JoinKeyProperties;
import software.amazon.awssdk.services.quicksight.model.JoinType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JoinInstruction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JoinInstruction> {
    private static final SdkField<String> LEFT_OPERAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LeftOperand").getter(JoinInstruction.getter(JoinInstruction::leftOperand)).setter(JoinInstruction.setter(Builder::leftOperand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeftOperand").build()}).build();
    private static final SdkField<String> RIGHT_OPERAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RightOperand").getter(JoinInstruction.getter(JoinInstruction::rightOperand)).setter(JoinInstruction.setter(Builder::rightOperand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RightOperand").build()}).build();
    private static final SdkField<JoinKeyProperties> LEFT_JOIN_KEY_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LeftJoinKeyProperties").getter(JoinInstruction.getter(JoinInstruction::leftJoinKeyProperties)).setter(JoinInstruction.setter(Builder::leftJoinKeyProperties)).constructor(JoinKeyProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeftJoinKeyProperties").build()}).build();
    private static final SdkField<JoinKeyProperties> RIGHT_JOIN_KEY_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RightJoinKeyProperties").getter(JoinInstruction.getter(JoinInstruction::rightJoinKeyProperties)).setter(JoinInstruction.setter(Builder::rightJoinKeyProperties)).constructor(JoinKeyProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RightJoinKeyProperties").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(JoinInstruction.getter(JoinInstruction::typeAsString)).setter(JoinInstruction.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> ON_CLAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OnClause").getter(JoinInstruction.getter(JoinInstruction::onClause)).setter(JoinInstruction.setter(Builder::onClause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnClause").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEFT_OPERAND_FIELD, RIGHT_OPERAND_FIELD, LEFT_JOIN_KEY_PROPERTIES_FIELD, RIGHT_JOIN_KEY_PROPERTIES_FIELD, TYPE_FIELD, ON_CLAUSE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JoinInstruction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String leftOperand;
    private final String rightOperand;
    private final JoinKeyProperties leftJoinKeyProperties;
    private final JoinKeyProperties rightJoinKeyProperties;
    private final String type;
    private final String onClause;

    private JoinInstruction(BuilderImpl builder) {
        this.leftOperand = builder.leftOperand;
        this.rightOperand = builder.rightOperand;
        this.leftJoinKeyProperties = builder.leftJoinKeyProperties;
        this.rightJoinKeyProperties = builder.rightJoinKeyProperties;
        this.type = builder.type;
        this.onClause = builder.onClause;
    }

    public final String leftOperand() {
        return this.leftOperand;
    }

    public final String rightOperand() {
        return this.rightOperand;
    }

    public final JoinKeyProperties leftJoinKeyProperties() {
        return this.leftJoinKeyProperties;
    }

    public final JoinKeyProperties rightJoinKeyProperties() {
        return this.rightJoinKeyProperties;
    }

    public final JoinType type() {
        return JoinType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String onClause() {
        return this.onClause;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.leftOperand());
        hashCode = 31 * hashCode + Objects.hashCode(this.rightOperand());
        hashCode = 31 * hashCode + Objects.hashCode(this.leftJoinKeyProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.rightJoinKeyProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.onClause());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JoinInstruction)) {
            return false;
        }
        JoinInstruction other = (JoinInstruction)obj;
        return Objects.equals(this.leftOperand(), other.leftOperand()) && Objects.equals(this.rightOperand(), other.rightOperand()) && Objects.equals(this.leftJoinKeyProperties(), other.leftJoinKeyProperties()) && Objects.equals(this.rightJoinKeyProperties(), other.rightJoinKeyProperties()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.onClause(), other.onClause());
    }

    public final String toString() {
        return ToString.builder((String)"JoinInstruction").add("LeftOperand", (Object)this.leftOperand()).add("RightOperand", (Object)this.rightOperand()).add("LeftJoinKeyProperties", (Object)this.leftJoinKeyProperties()).add("RightJoinKeyProperties", (Object)this.rightJoinKeyProperties()).add("Type", (Object)this.typeAsString()).add("OnClause", (Object)this.onClause()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LeftOperand": {
                return Optional.ofNullable(clazz.cast(this.leftOperand()));
            }
            case "RightOperand": {
                return Optional.ofNullable(clazz.cast(this.rightOperand()));
            }
            case "LeftJoinKeyProperties": {
                return Optional.ofNullable(clazz.cast(this.leftJoinKeyProperties()));
            }
            case "RightJoinKeyProperties": {
                return Optional.ofNullable(clazz.cast(this.rightJoinKeyProperties()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "OnClause": {
                return Optional.ofNullable(clazz.cast(this.onClause()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LeftOperand", LEFT_OPERAND_FIELD);
        map.put("RightOperand", RIGHT_OPERAND_FIELD);
        map.put("LeftJoinKeyProperties", LEFT_JOIN_KEY_PROPERTIES_FIELD);
        map.put("RightJoinKeyProperties", RIGHT_JOIN_KEY_PROPERTIES_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("OnClause", ON_CLAUSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JoinInstruction, T> g) {
        return obj -> g.apply((JoinInstruction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String leftOperand;
        private String rightOperand;
        private JoinKeyProperties leftJoinKeyProperties;
        private JoinKeyProperties rightJoinKeyProperties;
        private String type;
        private String onClause;

        private BuilderImpl() {
        }

        private BuilderImpl(JoinInstruction model) {
            this.leftOperand(model.leftOperand);
            this.rightOperand(model.rightOperand);
            this.leftJoinKeyProperties(model.leftJoinKeyProperties);
            this.rightJoinKeyProperties(model.rightJoinKeyProperties);
            this.type(model.type);
            this.onClause(model.onClause);
        }

        public final String getLeftOperand() {
            return this.leftOperand;
        }

        public final void setLeftOperand(String leftOperand) {
            this.leftOperand = leftOperand;
        }

        @Override
        public final Builder leftOperand(String leftOperand) {
            this.leftOperand = leftOperand;
            return this;
        }

        public final String getRightOperand() {
            return this.rightOperand;
        }

        public final void setRightOperand(String rightOperand) {
            this.rightOperand = rightOperand;
        }

        @Override
        public final Builder rightOperand(String rightOperand) {
            this.rightOperand = rightOperand;
            return this;
        }

        public final JoinKeyProperties.Builder getLeftJoinKeyProperties() {
            return this.leftJoinKeyProperties != null ? this.leftJoinKeyProperties.toBuilder() : null;
        }

        public final void setLeftJoinKeyProperties(JoinKeyProperties.BuilderImpl leftJoinKeyProperties) {
            this.leftJoinKeyProperties = leftJoinKeyProperties != null ? leftJoinKeyProperties.build() : null;
        }

        @Override
        public final Builder leftJoinKeyProperties(JoinKeyProperties leftJoinKeyProperties) {
            this.leftJoinKeyProperties = leftJoinKeyProperties;
            return this;
        }

        public final JoinKeyProperties.Builder getRightJoinKeyProperties() {
            return this.rightJoinKeyProperties != null ? this.rightJoinKeyProperties.toBuilder() : null;
        }

        public final void setRightJoinKeyProperties(JoinKeyProperties.BuilderImpl rightJoinKeyProperties) {
            this.rightJoinKeyProperties = rightJoinKeyProperties != null ? rightJoinKeyProperties.build() : null;
        }

        @Override
        public final Builder rightJoinKeyProperties(JoinKeyProperties rightJoinKeyProperties) {
            this.rightJoinKeyProperties = rightJoinKeyProperties;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(JoinType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getOnClause() {
            return this.onClause;
        }

        public final void setOnClause(String onClause) {
            this.onClause = onClause;
        }

        @Override
        public final Builder onClause(String onClause) {
            this.onClause = onClause;
            return this;
        }

        public JoinInstruction build() {
            return new JoinInstruction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JoinInstruction> {
        public Builder leftOperand(String var1);

        public Builder rightOperand(String var1);

        public Builder leftJoinKeyProperties(JoinKeyProperties var1);

        default public Builder leftJoinKeyProperties(Consumer<JoinKeyProperties.Builder> leftJoinKeyProperties) {
            return this.leftJoinKeyProperties((JoinKeyProperties)((JoinKeyProperties.Builder)JoinKeyProperties.builder().applyMutation(leftJoinKeyProperties)).build());
        }

        public Builder rightJoinKeyProperties(JoinKeyProperties var1);

        default public Builder rightJoinKeyProperties(Consumer<JoinKeyProperties.Builder> rightJoinKeyProperties) {
            return this.rightJoinKeyProperties((JoinKeyProperties)((JoinKeyProperties.Builder)JoinKeyProperties.builder().applyMutation(rightJoinKeyProperties)).build());
        }

        public Builder type(String var1);

        public Builder type(JoinType var1);

        public Builder onClause(String var1);
    }
}

