/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The theme colors that apply to UI and to charts, excluding data colors. The colors description is a hexadecimal color
 * code that consists of six alphanumerical characters, prefixed with <code>#</code>, for example #37BFF5. For more
 * information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html">Using Themes
 * in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide.</i>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UIColorPalette implements SdkPojo, Serializable, ToCopyableBuilder<UIColorPalette.Builder, UIColorPalette> {
    private static final SdkField<String> PRIMARY_FOREGROUND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryForeground").getter(getter(UIColorPalette::primaryForeground))
            .setter(setter(Builder::primaryForeground))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryForeground").build()).build();

    private static final SdkField<String> PRIMARY_BACKGROUND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryBackground").getter(getter(UIColorPalette::primaryBackground))
            .setter(setter(Builder::primaryBackground))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryBackground").build()).build();

    private static final SdkField<String> SECONDARY_FOREGROUND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecondaryForeground").getter(getter(UIColorPalette::secondaryForeground))
            .setter(setter(Builder::secondaryForeground))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryForeground").build())
            .build();

    private static final SdkField<String> SECONDARY_BACKGROUND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecondaryBackground").getter(getter(UIColorPalette::secondaryBackground))
            .setter(setter(Builder::secondaryBackground))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryBackground").build())
            .build();

    private static final SdkField<String> ACCENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Accent")
            .getter(getter(UIColorPalette::accent)).setter(setter(Builder::accent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accent").build()).build();

    private static final SdkField<String> ACCENT_FOREGROUND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccentForeground").getter(getter(UIColorPalette::accentForeground))
            .setter(setter(Builder::accentForeground))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccentForeground").build()).build();

    private static final SdkField<String> DANGER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Danger")
            .getter(getter(UIColorPalette::danger)).setter(setter(Builder::danger))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Danger").build()).build();

    private static final SdkField<String> DANGER_FOREGROUND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DangerForeground").getter(getter(UIColorPalette::dangerForeground))
            .setter(setter(Builder::dangerForeground))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DangerForeground").build()).build();

    private static final SdkField<String> WARNING_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Warning")
            .getter(getter(UIColorPalette::warning)).setter(setter(Builder::warning))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warning").build()).build();

    private static final SdkField<String> WARNING_FOREGROUND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WarningForeground").getter(getter(UIColorPalette::warningForeground))
            .setter(setter(Builder::warningForeground))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarningForeground").build()).build();

    private static final SdkField<String> SUCCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Success")
            .getter(getter(UIColorPalette::success)).setter(setter(Builder::success))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Success").build()).build();

    private static final SdkField<String> SUCCESS_FOREGROUND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SuccessForeground").getter(getter(UIColorPalette::successForeground))
            .setter(setter(Builder::successForeground))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessForeground").build()).build();

    private static final SdkField<String> DIMENSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Dimension").getter(getter(UIColorPalette::dimension)).setter(setter(Builder::dimension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimension").build()).build();

    private static final SdkField<String> DIMENSION_FOREGROUND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DimensionForeground").getter(getter(UIColorPalette::dimensionForeground))
            .setter(setter(Builder::dimensionForeground))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionForeground").build())
            .build();

    private static final SdkField<String> MEASURE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Measure")
            .getter(getter(UIColorPalette::measure)).setter(setter(Builder::measure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Measure").build()).build();

    private static final SdkField<String> MEASURE_FOREGROUND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeasureForeground").getter(getter(UIColorPalette::measureForeground))
            .setter(setter(Builder::measureForeground))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureForeground").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_FOREGROUND_FIELD,
            PRIMARY_BACKGROUND_FIELD, SECONDARY_FOREGROUND_FIELD, SECONDARY_BACKGROUND_FIELD, ACCENT_FIELD,
            ACCENT_FOREGROUND_FIELD, DANGER_FIELD, DANGER_FOREGROUND_FIELD, WARNING_FIELD, WARNING_FOREGROUND_FIELD,
            SUCCESS_FIELD, SUCCESS_FOREGROUND_FIELD, DIMENSION_FIELD, DIMENSION_FOREGROUND_FIELD, MEASURE_FIELD,
            MEASURE_FOREGROUND_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String primaryForeground;

    private final String primaryBackground;

    private final String secondaryForeground;

    private final String secondaryBackground;

    private final String accent;

    private final String accentForeground;

    private final String danger;

    private final String dangerForeground;

    private final String warning;

    private final String warningForeground;

    private final String success;

    private final String successForeground;

    private final String dimension;

    private final String dimensionForeground;

    private final String measure;

    private final String measureForeground;

    private UIColorPalette(BuilderImpl builder) {
        this.primaryForeground = builder.primaryForeground;
        this.primaryBackground = builder.primaryBackground;
        this.secondaryForeground = builder.secondaryForeground;
        this.secondaryBackground = builder.secondaryBackground;
        this.accent = builder.accent;
        this.accentForeground = builder.accentForeground;
        this.danger = builder.danger;
        this.dangerForeground = builder.dangerForeground;
        this.warning = builder.warning;
        this.warningForeground = builder.warningForeground;
        this.success = builder.success;
        this.successForeground = builder.successForeground;
        this.dimension = builder.dimension;
        this.dimensionForeground = builder.dimensionForeground;
        this.measure = builder.measure;
        this.measureForeground = builder.measureForeground;
    }

    /**
     * <p>
     * The color of text and other foreground elements that appear over the primary background regions, such as grid
     * lines, borders, table banding, icons, and so on.
     * </p>
     * 
     * @return The color of text and other foreground elements that appear over the primary background regions, such as
     *         grid lines, borders, table banding, icons, and so on.
     */
    public final String primaryForeground() {
        return primaryForeground;
    }

    /**
     * <p>
     * The background color that applies to visuals and other high emphasis UI.
     * </p>
     * 
     * @return The background color that applies to visuals and other high emphasis UI.
     */
    public final String primaryBackground() {
        return primaryBackground;
    }

    /**
     * <p>
     * The foreground color that applies to any sheet title, sheet control text, or UI that appears over the secondary
     * background.
     * </p>
     * 
     * @return The foreground color that applies to any sheet title, sheet control text, or UI that appears over the
     *         secondary background.
     */
    public final String secondaryForeground() {
        return secondaryForeground;
    }

    /**
     * <p>
     * The background color that applies to the sheet background and sheet controls.
     * </p>
     * 
     * @return The background color that applies to the sheet background and sheet controls.
     */
    public final String secondaryBackground() {
        return secondaryBackground;
    }

    /**
     * <p>
     * This color is that applies to selected states and buttons.
     * </p>
     * 
     * @return This color is that applies to selected states and buttons.
     */
    public final String accent() {
        return accent;
    }

    /**
     * <p>
     * The foreground color that applies to any text or other elements that appear over the accent color.
     * </p>
     * 
     * @return The foreground color that applies to any text or other elements that appear over the accent color.
     */
    public final String accentForeground() {
        return accentForeground;
    }

    /**
     * <p>
     * The color that applies to error messages.
     * </p>
     * 
     * @return The color that applies to error messages.
     */
    public final String danger() {
        return danger;
    }

    /**
     * <p>
     * The foreground color that applies to any text or other elements that appear over the error color.
     * </p>
     * 
     * @return The foreground color that applies to any text or other elements that appear over the error color.
     */
    public final String dangerForeground() {
        return dangerForeground;
    }

    /**
     * <p>
     * This color that applies to warning and informational messages.
     * </p>
     * 
     * @return This color that applies to warning and informational messages.
     */
    public final String warning() {
        return warning;
    }

    /**
     * <p>
     * The foreground color that applies to any text or other elements that appear over the warning color.
     * </p>
     * 
     * @return The foreground color that applies to any text or other elements that appear over the warning color.
     */
    public final String warningForeground() {
        return warningForeground;
    }

    /**
     * <p>
     * The color that applies to success messages, for example the check mark for a successful download.
     * </p>
     * 
     * @return The color that applies to success messages, for example the check mark for a successful download.
     */
    public final String success() {
        return success;
    }

    /**
     * <p>
     * The foreground color that applies to any text or other elements that appear over the success color.
     * </p>
     * 
     * @return The foreground color that applies to any text or other elements that appear over the success color.
     */
    public final String successForeground() {
        return successForeground;
    }

    /**
     * <p>
     * The color that applies to the names of fields that are identified as dimensions.
     * </p>
     * 
     * @return The color that applies to the names of fields that are identified as dimensions.
     */
    public final String dimension() {
        return dimension;
    }

    /**
     * <p>
     * The foreground color that applies to any text or other elements that appear over the dimension color.
     * </p>
     * 
     * @return The foreground color that applies to any text or other elements that appear over the dimension color.
     */
    public final String dimensionForeground() {
        return dimensionForeground;
    }

    /**
     * <p>
     * The color that applies to the names of fields that are identified as measures.
     * </p>
     * 
     * @return The color that applies to the names of fields that are identified as measures.
     */
    public final String measure() {
        return measure;
    }

    /**
     * <p>
     * The foreground color that applies to any text or other elements that appear over the measure color.
     * </p>
     * 
     * @return The foreground color that applies to any text or other elements that appear over the measure color.
     */
    public final String measureForeground() {
        return measureForeground;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primaryForeground());
        hashCode = 31 * hashCode + Objects.hashCode(primaryBackground());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryForeground());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryBackground());
        hashCode = 31 * hashCode + Objects.hashCode(accent());
        hashCode = 31 * hashCode + Objects.hashCode(accentForeground());
        hashCode = 31 * hashCode + Objects.hashCode(danger());
        hashCode = 31 * hashCode + Objects.hashCode(dangerForeground());
        hashCode = 31 * hashCode + Objects.hashCode(warning());
        hashCode = 31 * hashCode + Objects.hashCode(warningForeground());
        hashCode = 31 * hashCode + Objects.hashCode(success());
        hashCode = 31 * hashCode + Objects.hashCode(successForeground());
        hashCode = 31 * hashCode + Objects.hashCode(dimension());
        hashCode = 31 * hashCode + Objects.hashCode(dimensionForeground());
        hashCode = 31 * hashCode + Objects.hashCode(measure());
        hashCode = 31 * hashCode + Objects.hashCode(measureForeground());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UIColorPalette)) {
            return false;
        }
        UIColorPalette other = (UIColorPalette) obj;
        return Objects.equals(primaryForeground(), other.primaryForeground())
                && Objects.equals(primaryBackground(), other.primaryBackground())
                && Objects.equals(secondaryForeground(), other.secondaryForeground())
                && Objects.equals(secondaryBackground(), other.secondaryBackground()) && Objects.equals(accent(), other.accent())
                && Objects.equals(accentForeground(), other.accentForeground()) && Objects.equals(danger(), other.danger())
                && Objects.equals(dangerForeground(), other.dangerForeground()) && Objects.equals(warning(), other.warning())
                && Objects.equals(warningForeground(), other.warningForeground()) && Objects.equals(success(), other.success())
                && Objects.equals(successForeground(), other.successForeground())
                && Objects.equals(dimension(), other.dimension())
                && Objects.equals(dimensionForeground(), other.dimensionForeground())
                && Objects.equals(measure(), other.measure()) && Objects.equals(measureForeground(), other.measureForeground());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UIColorPalette").add("PrimaryForeground", primaryForeground())
                .add("PrimaryBackground", primaryBackground()).add("SecondaryForeground", secondaryForeground())
                .add("SecondaryBackground", secondaryBackground()).add("Accent", accent())
                .add("AccentForeground", accentForeground()).add("Danger", danger()).add("DangerForeground", dangerForeground())
                .add("Warning", warning()).add("WarningForeground", warningForeground()).add("Success", success())
                .add("SuccessForeground", successForeground()).add("Dimension", dimension())
                .add("DimensionForeground", dimensionForeground()).add("Measure", measure())
                .add("MeasureForeground", measureForeground()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrimaryForeground":
            return Optional.ofNullable(clazz.cast(primaryForeground()));
        case "PrimaryBackground":
            return Optional.ofNullable(clazz.cast(primaryBackground()));
        case "SecondaryForeground":
            return Optional.ofNullable(clazz.cast(secondaryForeground()));
        case "SecondaryBackground":
            return Optional.ofNullable(clazz.cast(secondaryBackground()));
        case "Accent":
            return Optional.ofNullable(clazz.cast(accent()));
        case "AccentForeground":
            return Optional.ofNullable(clazz.cast(accentForeground()));
        case "Danger":
            return Optional.ofNullable(clazz.cast(danger()));
        case "DangerForeground":
            return Optional.ofNullable(clazz.cast(dangerForeground()));
        case "Warning":
            return Optional.ofNullable(clazz.cast(warning()));
        case "WarningForeground":
            return Optional.ofNullable(clazz.cast(warningForeground()));
        case "Success":
            return Optional.ofNullable(clazz.cast(success()));
        case "SuccessForeground":
            return Optional.ofNullable(clazz.cast(successForeground()));
        case "Dimension":
            return Optional.ofNullable(clazz.cast(dimension()));
        case "DimensionForeground":
            return Optional.ofNullable(clazz.cast(dimensionForeground()));
        case "Measure":
            return Optional.ofNullable(clazz.cast(measure()));
        case "MeasureForeground":
            return Optional.ofNullable(clazz.cast(measureForeground()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PrimaryForeground", PRIMARY_FOREGROUND_FIELD);
        map.put("PrimaryBackground", PRIMARY_BACKGROUND_FIELD);
        map.put("SecondaryForeground", SECONDARY_FOREGROUND_FIELD);
        map.put("SecondaryBackground", SECONDARY_BACKGROUND_FIELD);
        map.put("Accent", ACCENT_FIELD);
        map.put("AccentForeground", ACCENT_FOREGROUND_FIELD);
        map.put("Danger", DANGER_FIELD);
        map.put("DangerForeground", DANGER_FOREGROUND_FIELD);
        map.put("Warning", WARNING_FIELD);
        map.put("WarningForeground", WARNING_FOREGROUND_FIELD);
        map.put("Success", SUCCESS_FIELD);
        map.put("SuccessForeground", SUCCESS_FOREGROUND_FIELD);
        map.put("Dimension", DIMENSION_FIELD);
        map.put("DimensionForeground", DIMENSION_FOREGROUND_FIELD);
        map.put("Measure", MEASURE_FIELD);
        map.put("MeasureForeground", MEASURE_FOREGROUND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UIColorPalette, T> g) {
        return obj -> g.apply((UIColorPalette) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UIColorPalette> {
        /**
         * <p>
         * The color of text and other foreground elements that appear over the primary background regions, such as grid
         * lines, borders, table banding, icons, and so on.
         * </p>
         * 
         * @param primaryForeground
         *        The color of text and other foreground elements that appear over the primary background regions, such
         *        as grid lines, borders, table banding, icons, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryForeground(String primaryForeground);

        /**
         * <p>
         * The background color that applies to visuals and other high emphasis UI.
         * </p>
         * 
         * @param primaryBackground
         *        The background color that applies to visuals and other high emphasis UI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryBackground(String primaryBackground);

        /**
         * <p>
         * The foreground color that applies to any sheet title, sheet control text, or UI that appears over the
         * secondary background.
         * </p>
         * 
         * @param secondaryForeground
         *        The foreground color that applies to any sheet title, sheet control text, or UI that appears over the
         *        secondary background.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryForeground(String secondaryForeground);

        /**
         * <p>
         * The background color that applies to the sheet background and sheet controls.
         * </p>
         * 
         * @param secondaryBackground
         *        The background color that applies to the sheet background and sheet controls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryBackground(String secondaryBackground);

        /**
         * <p>
         * This color is that applies to selected states and buttons.
         * </p>
         * 
         * @param accent
         *        This color is that applies to selected states and buttons.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accent(String accent);

        /**
         * <p>
         * The foreground color that applies to any text or other elements that appear over the accent color.
         * </p>
         * 
         * @param accentForeground
         *        The foreground color that applies to any text or other elements that appear over the accent color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accentForeground(String accentForeground);

        /**
         * <p>
         * The color that applies to error messages.
         * </p>
         * 
         * @param danger
         *        The color that applies to error messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder danger(String danger);

        /**
         * <p>
         * The foreground color that applies to any text or other elements that appear over the error color.
         * </p>
         * 
         * @param dangerForeground
         *        The foreground color that applies to any text or other elements that appear over the error color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dangerForeground(String dangerForeground);

        /**
         * <p>
         * This color that applies to warning and informational messages.
         * </p>
         * 
         * @param warning
         *        This color that applies to warning and informational messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warning(String warning);

        /**
         * <p>
         * The foreground color that applies to any text or other elements that appear over the warning color.
         * </p>
         * 
         * @param warningForeground
         *        The foreground color that applies to any text or other elements that appear over the warning color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warningForeground(String warningForeground);

        /**
         * <p>
         * The color that applies to success messages, for example the check mark for a successful download.
         * </p>
         * 
         * @param success
         *        The color that applies to success messages, for example the check mark for a successful download.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder success(String success);

        /**
         * <p>
         * The foreground color that applies to any text or other elements that appear over the success color.
         * </p>
         * 
         * @param successForeground
         *        The foreground color that applies to any text or other elements that appear over the success color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successForeground(String successForeground);

        /**
         * <p>
         * The color that applies to the names of fields that are identified as dimensions.
         * </p>
         * 
         * @param dimension
         *        The color that applies to the names of fields that are identified as dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimension(String dimension);

        /**
         * <p>
         * The foreground color that applies to any text or other elements that appear over the dimension color.
         * </p>
         * 
         * @param dimensionForeground
         *        The foreground color that applies to any text or other elements that appear over the dimension color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionForeground(String dimensionForeground);

        /**
         * <p>
         * The color that applies to the names of fields that are identified as measures.
         * </p>
         * 
         * @param measure
         *        The color that applies to the names of fields that are identified as measures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder measure(String measure);

        /**
         * <p>
         * The foreground color that applies to any text or other elements that appear over the measure color.
         * </p>
         * 
         * @param measureForeground
         *        The foreground color that applies to any text or other elements that appear over the measure color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder measureForeground(String measureForeground);
    }

    static final class BuilderImpl implements Builder {
        private String primaryForeground;

        private String primaryBackground;

        private String secondaryForeground;

        private String secondaryBackground;

        private String accent;

        private String accentForeground;

        private String danger;

        private String dangerForeground;

        private String warning;

        private String warningForeground;

        private String success;

        private String successForeground;

        private String dimension;

        private String dimensionForeground;

        private String measure;

        private String measureForeground;

        private BuilderImpl() {
        }

        private BuilderImpl(UIColorPalette model) {
            primaryForeground(model.primaryForeground);
            primaryBackground(model.primaryBackground);
            secondaryForeground(model.secondaryForeground);
            secondaryBackground(model.secondaryBackground);
            accent(model.accent);
            accentForeground(model.accentForeground);
            danger(model.danger);
            dangerForeground(model.dangerForeground);
            warning(model.warning);
            warningForeground(model.warningForeground);
            success(model.success);
            successForeground(model.successForeground);
            dimension(model.dimension);
            dimensionForeground(model.dimensionForeground);
            measure(model.measure);
            measureForeground(model.measureForeground);
        }

        public final String getPrimaryForeground() {
            return primaryForeground;
        }

        public final void setPrimaryForeground(String primaryForeground) {
            this.primaryForeground = primaryForeground;
        }

        @Override
        public final Builder primaryForeground(String primaryForeground) {
            this.primaryForeground = primaryForeground;
            return this;
        }

        public final String getPrimaryBackground() {
            return primaryBackground;
        }

        public final void setPrimaryBackground(String primaryBackground) {
            this.primaryBackground = primaryBackground;
        }

        @Override
        public final Builder primaryBackground(String primaryBackground) {
            this.primaryBackground = primaryBackground;
            return this;
        }

        public final String getSecondaryForeground() {
            return secondaryForeground;
        }

        public final void setSecondaryForeground(String secondaryForeground) {
            this.secondaryForeground = secondaryForeground;
        }

        @Override
        public final Builder secondaryForeground(String secondaryForeground) {
            this.secondaryForeground = secondaryForeground;
            return this;
        }

        public final String getSecondaryBackground() {
            return secondaryBackground;
        }

        public final void setSecondaryBackground(String secondaryBackground) {
            this.secondaryBackground = secondaryBackground;
        }

        @Override
        public final Builder secondaryBackground(String secondaryBackground) {
            this.secondaryBackground = secondaryBackground;
            return this;
        }

        public final String getAccent() {
            return accent;
        }

        public final void setAccent(String accent) {
            this.accent = accent;
        }

        @Override
        public final Builder accent(String accent) {
            this.accent = accent;
            return this;
        }

        public final String getAccentForeground() {
            return accentForeground;
        }

        public final void setAccentForeground(String accentForeground) {
            this.accentForeground = accentForeground;
        }

        @Override
        public final Builder accentForeground(String accentForeground) {
            this.accentForeground = accentForeground;
            return this;
        }

        public final String getDanger() {
            return danger;
        }

        public final void setDanger(String danger) {
            this.danger = danger;
        }

        @Override
        public final Builder danger(String danger) {
            this.danger = danger;
            return this;
        }

        public final String getDangerForeground() {
            return dangerForeground;
        }

        public final void setDangerForeground(String dangerForeground) {
            this.dangerForeground = dangerForeground;
        }

        @Override
        public final Builder dangerForeground(String dangerForeground) {
            this.dangerForeground = dangerForeground;
            return this;
        }

        public final String getWarning() {
            return warning;
        }

        public final void setWarning(String warning) {
            this.warning = warning;
        }

        @Override
        public final Builder warning(String warning) {
            this.warning = warning;
            return this;
        }

        public final String getWarningForeground() {
            return warningForeground;
        }

        public final void setWarningForeground(String warningForeground) {
            this.warningForeground = warningForeground;
        }

        @Override
        public final Builder warningForeground(String warningForeground) {
            this.warningForeground = warningForeground;
            return this;
        }

        public final String getSuccess() {
            return success;
        }

        public final void setSuccess(String success) {
            this.success = success;
        }

        @Override
        public final Builder success(String success) {
            this.success = success;
            return this;
        }

        public final String getSuccessForeground() {
            return successForeground;
        }

        public final void setSuccessForeground(String successForeground) {
            this.successForeground = successForeground;
        }

        @Override
        public final Builder successForeground(String successForeground) {
            this.successForeground = successForeground;
            return this;
        }

        public final String getDimension() {
            return dimension;
        }

        public final void setDimension(String dimension) {
            this.dimension = dimension;
        }

        @Override
        public final Builder dimension(String dimension) {
            this.dimension = dimension;
            return this;
        }

        public final String getDimensionForeground() {
            return dimensionForeground;
        }

        public final void setDimensionForeground(String dimensionForeground) {
            this.dimensionForeground = dimensionForeground;
        }

        @Override
        public final Builder dimensionForeground(String dimensionForeground) {
            this.dimensionForeground = dimensionForeground;
            return this;
        }

        public final String getMeasure() {
            return measure;
        }

        public final void setMeasure(String measure) {
            this.measure = measure;
        }

        @Override
        public final Builder measure(String measure) {
            this.measure = measure;
            return this;
        }

        public final String getMeasureForeground() {
            return measureForeground;
        }

        public final void setMeasureForeground(String measureForeground) {
            this.measureForeground = measureForeground;
        }

        @Override
        public final Builder measureForeground(String measureForeground) {
            this.measureForeground = measureForeground;
            return this;
        }

        @Override
        public UIColorPalette build() {
            return new UIColorPalette(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
