/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The column option of the transposed table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransposedTableOption implements SdkPojo, Serializable,
        ToCopyableBuilder<TransposedTableOption.Builder, TransposedTableOption> {
    private static final SdkField<Integer> COLUMN_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ColumnIndex").getter(getter(TransposedTableOption::columnIndex)).setter(setter(Builder::columnIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnIndex").build()).build();

    private static final SdkField<String> COLUMN_WIDTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnWidth").getter(getter(TransposedTableOption::columnWidth)).setter(setter(Builder::columnWidth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnWidth").build()).build();

    private static final SdkField<String> COLUMN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnType").getter(getter(TransposedTableOption::columnTypeAsString))
            .setter(setter(Builder::columnType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_INDEX_FIELD,
            COLUMN_WIDTH_FIELD, COLUMN_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer columnIndex;

    private final String columnWidth;

    private final String columnType;

    private TransposedTableOption(BuilderImpl builder) {
        this.columnIndex = builder.columnIndex;
        this.columnWidth = builder.columnWidth;
        this.columnType = builder.columnType;
    }

    /**
     * <p>
     * The index of a columns in a transposed table. The index range is 0-9999.
     * </p>
     * 
     * @return The index of a columns in a transposed table. The index range is 0-9999.
     */
    public final Integer columnIndex() {
        return columnIndex;
    }

    /**
     * <p>
     * The width of a column in a transposed table.
     * </p>
     * 
     * @return The width of a column in a transposed table.
     */
    public final String columnWidth() {
        return columnWidth;
    }

    /**
     * <p>
     * The column type of the column in a transposed table. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ROW_HEADER_COLUMN</code>: Refers to the leftmost column of the row header in the transposed table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VALUE_COLUMN</code>: Refers to all value columns in the transposed table.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #columnType} will
     * return {@link TransposedColumnType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #columnTypeAsString}.
     * </p>
     * 
     * @return The column type of the column in a transposed table. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ROW_HEADER_COLUMN</code>: Refers to the leftmost column of the row header in the transposed table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VALUE_COLUMN</code>: Refers to all value columns in the transposed table.
     *         </p>
     *         </li>
     * @see TransposedColumnType
     */
    public final TransposedColumnType columnType() {
        return TransposedColumnType.fromValue(columnType);
    }

    /**
     * <p>
     * The column type of the column in a transposed table. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ROW_HEADER_COLUMN</code>: Refers to the leftmost column of the row header in the transposed table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VALUE_COLUMN</code>: Refers to all value columns in the transposed table.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #columnType} will
     * return {@link TransposedColumnType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #columnTypeAsString}.
     * </p>
     * 
     * @return The column type of the column in a transposed table. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ROW_HEADER_COLUMN</code>: Refers to the leftmost column of the row header in the transposed table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VALUE_COLUMN</code>: Refers to all value columns in the transposed table.
     *         </p>
     *         </li>
     * @see TransposedColumnType
     */
    public final String columnTypeAsString() {
        return columnType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnIndex());
        hashCode = 31 * hashCode + Objects.hashCode(columnWidth());
        hashCode = 31 * hashCode + Objects.hashCode(columnTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransposedTableOption)) {
            return false;
        }
        TransposedTableOption other = (TransposedTableOption) obj;
        return Objects.equals(columnIndex(), other.columnIndex()) && Objects.equals(columnWidth(), other.columnWidth())
                && Objects.equals(columnTypeAsString(), other.columnTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransposedTableOption").add("ColumnIndex", columnIndex()).add("ColumnWidth", columnWidth())
                .add("ColumnType", columnTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnIndex":
            return Optional.ofNullable(clazz.cast(columnIndex()));
        case "ColumnWidth":
            return Optional.ofNullable(clazz.cast(columnWidth()));
        case "ColumnType":
            return Optional.ofNullable(clazz.cast(columnTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ColumnIndex", COLUMN_INDEX_FIELD);
        map.put("ColumnWidth", COLUMN_WIDTH_FIELD);
        map.put("ColumnType", COLUMN_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransposedTableOption, T> g) {
        return obj -> g.apply((TransposedTableOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransposedTableOption> {
        /**
         * <p>
         * The index of a columns in a transposed table. The index range is 0-9999.
         * </p>
         * 
         * @param columnIndex
         *        The index of a columns in a transposed table. The index range is 0-9999.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnIndex(Integer columnIndex);

        /**
         * <p>
         * The width of a column in a transposed table.
         * </p>
         * 
         * @param columnWidth
         *        The width of a column in a transposed table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnWidth(String columnWidth);

        /**
         * <p>
         * The column type of the column in a transposed table. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ROW_HEADER_COLUMN</code>: Refers to the leftmost column of the row header in the transposed table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VALUE_COLUMN</code>: Refers to all value columns in the transposed table.
         * </p>
         * </li>
         * </ul>
         * 
         * @param columnType
         *        The column type of the column in a transposed table. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ROW_HEADER_COLUMN</code>: Refers to the leftmost column of the row header in the transposed
         *        table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VALUE_COLUMN</code>: Refers to all value columns in the transposed table.
         *        </p>
         *        </li>
         * @see TransposedColumnType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransposedColumnType
         */
        Builder columnType(String columnType);

        /**
         * <p>
         * The column type of the column in a transposed table. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ROW_HEADER_COLUMN</code>: Refers to the leftmost column of the row header in the transposed table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VALUE_COLUMN</code>: Refers to all value columns in the transposed table.
         * </p>
         * </li>
         * </ul>
         * 
         * @param columnType
         *        The column type of the column in a transposed table. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ROW_HEADER_COLUMN</code>: Refers to the leftmost column of the row header in the transposed
         *        table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VALUE_COLUMN</code>: Refers to all value columns in the transposed table.
         *        </p>
         *        </li>
         * @see TransposedColumnType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransposedColumnType
         */
        Builder columnType(TransposedColumnType columnType);
    }

    static final class BuilderImpl implements Builder {
        private Integer columnIndex;

        private String columnWidth;

        private String columnType;

        private BuilderImpl() {
        }

        private BuilderImpl(TransposedTableOption model) {
            columnIndex(model.columnIndex);
            columnWidth(model.columnWidth);
            columnType(model.columnType);
        }

        public final Integer getColumnIndex() {
            return columnIndex;
        }

        public final void setColumnIndex(Integer columnIndex) {
            this.columnIndex = columnIndex;
        }

        @Override
        public final Builder columnIndex(Integer columnIndex) {
            this.columnIndex = columnIndex;
            return this;
        }

        public final String getColumnWidth() {
            return columnWidth;
        }

        public final void setColumnWidth(String columnWidth) {
            this.columnWidth = columnWidth;
        }

        @Override
        public final Builder columnWidth(String columnWidth) {
            this.columnWidth = columnWidth;
            return this;
        }

        public final String getColumnType() {
            return columnType;
        }

        public final void setColumnType(String columnType) {
            this.columnType = columnType;
        }

        @Override
        public final Builder columnType(String columnType) {
            this.columnType = columnType;
            return this;
        }

        @Override
        public final Builder columnType(TransposedColumnType columnType) {
            this.columnType(columnType == null ? null : columnType.toString());
            return this;
        }

        @Override
        public TransposedTableOption build() {
            return new TransposedTableOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
