/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition for a <code>TopicIRContributionAnalysis</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicIRContributionAnalysis implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicIRContributionAnalysis.Builder, TopicIRContributionAnalysis> {
    private static final SdkField<List<ContributionAnalysisFactor>> FACTORS_FIELD = SdkField
            .<List<ContributionAnalysisFactor>> builder(MarshallingType.LIST)
            .memberName("Factors")
            .getter(getter(TopicIRContributionAnalysis::factors))
            .setter(setter(Builder::factors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Factors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContributionAnalysisFactor> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContributionAnalysisFactor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ContributionAnalysisTimeRanges> TIME_RANGES_FIELD = SdkField
            .<ContributionAnalysisTimeRanges> builder(MarshallingType.SDK_POJO).memberName("TimeRanges")
            .getter(getter(TopicIRContributionAnalysis::timeRanges)).setter(setter(Builder::timeRanges))
            .constructor(ContributionAnalysisTimeRanges::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRanges").build()).build();

    private static final SdkField<String> DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Direction").getter(getter(TopicIRContributionAnalysis::directionAsString))
            .setter(setter(Builder::direction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()).build();

    private static final SdkField<String> SORT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortType").getter(getter(TopicIRContributionAnalysis::sortTypeAsString))
            .setter(setter(Builder::sortType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACTORS_FIELD,
            TIME_RANGES_FIELD, DIRECTION_FIELD, SORT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ContributionAnalysisFactor> factors;

    private final ContributionAnalysisTimeRanges timeRanges;

    private final String direction;

    private final String sortType;

    private TopicIRContributionAnalysis(BuilderImpl builder) {
        this.factors = builder.factors;
        this.timeRanges = builder.timeRanges;
        this.direction = builder.direction;
        this.sortType = builder.sortType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Factors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFactors() {
        return factors != null && !(factors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The factors for a <code>TopicIRContributionAnalysis</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFactors} method.
     * </p>
     * 
     * @return The factors for a <code>TopicIRContributionAnalysis</code>.
     */
    public final List<ContributionAnalysisFactor> factors() {
        return factors;
    }

    /**
     * <p>
     * The time ranges for the <code>TopicIRContributionAnalysis</code>.
     * </p>
     * 
     * @return The time ranges for the <code>TopicIRContributionAnalysis</code>.
     */
    public final ContributionAnalysisTimeRanges timeRanges() {
        return timeRanges;
    }

    /**
     * <p>
     * The direction for the <code>TopicIRContributionAnalysis</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link ContributionAnalysisDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #directionAsString}.
     * </p>
     * 
     * @return The direction for the <code>TopicIRContributionAnalysis</code>.
     * @see ContributionAnalysisDirection
     */
    public final ContributionAnalysisDirection direction() {
        return ContributionAnalysisDirection.fromValue(direction);
    }

    /**
     * <p>
     * The direction for the <code>TopicIRContributionAnalysis</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link ContributionAnalysisDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #directionAsString}.
     * </p>
     * 
     * @return The direction for the <code>TopicIRContributionAnalysis</code>.
     * @see ContributionAnalysisDirection
     */
    public final String directionAsString() {
        return direction;
    }

    /**
     * <p>
     * The sort type for the <code>TopicIRContributionAnalysis</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortType} will
     * return {@link ContributionAnalysisSortType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortTypeAsString}.
     * </p>
     * 
     * @return The sort type for the <code>TopicIRContributionAnalysis</code>.
     * @see ContributionAnalysisSortType
     */
    public final ContributionAnalysisSortType sortType() {
        return ContributionAnalysisSortType.fromValue(sortType);
    }

    /**
     * <p>
     * The sort type for the <code>TopicIRContributionAnalysis</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortType} will
     * return {@link ContributionAnalysisSortType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortTypeAsString}.
     * </p>
     * 
     * @return The sort type for the <code>TopicIRContributionAnalysis</code>.
     * @see ContributionAnalysisSortType
     */
    public final String sortTypeAsString() {
        return sortType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFactors() ? factors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeRanges());
        hashCode = 31 * hashCode + Objects.hashCode(directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicIRContributionAnalysis)) {
            return false;
        }
        TopicIRContributionAnalysis other = (TopicIRContributionAnalysis) obj;
        return hasFactors() == other.hasFactors() && Objects.equals(factors(), other.factors())
                && Objects.equals(timeRanges(), other.timeRanges())
                && Objects.equals(directionAsString(), other.directionAsString())
                && Objects.equals(sortTypeAsString(), other.sortTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicIRContributionAnalysis").add("Factors", hasFactors() ? factors() : null)
                .add("TimeRanges", timeRanges()).add("Direction", directionAsString()).add("SortType", sortTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Factors":
            return Optional.ofNullable(clazz.cast(factors()));
        case "TimeRanges":
            return Optional.ofNullable(clazz.cast(timeRanges()));
        case "Direction":
            return Optional.ofNullable(clazz.cast(directionAsString()));
        case "SortType":
            return Optional.ofNullable(clazz.cast(sortTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Factors", FACTORS_FIELD);
        map.put("TimeRanges", TIME_RANGES_FIELD);
        map.put("Direction", DIRECTION_FIELD);
        map.put("SortType", SORT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicIRContributionAnalysis, T> g) {
        return obj -> g.apply((TopicIRContributionAnalysis) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicIRContributionAnalysis> {
        /**
         * <p>
         * The factors for a <code>TopicIRContributionAnalysis</code>.
         * </p>
         * 
         * @param factors
         *        The factors for a <code>TopicIRContributionAnalysis</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder factors(Collection<ContributionAnalysisFactor> factors);

        /**
         * <p>
         * The factors for a <code>TopicIRContributionAnalysis</code>.
         * </p>
         * 
         * @param factors
         *        The factors for a <code>TopicIRContributionAnalysis</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder factors(ContributionAnalysisFactor... factors);

        /**
         * <p>
         * The factors for a <code>TopicIRContributionAnalysis</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ContributionAnalysisFactor.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.ContributionAnalysisFactor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ContributionAnalysisFactor.Builder#build()} is called
         * immediately and its result is passed to {@link #factors(List<ContributionAnalysisFactor>)}.
         * 
         * @param factors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ContributionAnalysisFactor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #factors(java.util.Collection<ContributionAnalysisFactor>)
         */
        Builder factors(Consumer<ContributionAnalysisFactor.Builder>... factors);

        /**
         * <p>
         * The time ranges for the <code>TopicIRContributionAnalysis</code>.
         * </p>
         * 
         * @param timeRanges
         *        The time ranges for the <code>TopicIRContributionAnalysis</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRanges(ContributionAnalysisTimeRanges timeRanges);

        /**
         * <p>
         * The time ranges for the <code>TopicIRContributionAnalysis</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContributionAnalysisTimeRanges.Builder}
         * avoiding the need to create one manually via {@link ContributionAnalysisTimeRanges#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContributionAnalysisTimeRanges.Builder#build()} is called
         * immediately and its result is passed to {@link #timeRanges(ContributionAnalysisTimeRanges)}.
         * 
         * @param timeRanges
         *        a consumer that will call methods on {@link ContributionAnalysisTimeRanges.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeRanges(ContributionAnalysisTimeRanges)
         */
        default Builder timeRanges(Consumer<ContributionAnalysisTimeRanges.Builder> timeRanges) {
            return timeRanges(ContributionAnalysisTimeRanges.builder().applyMutation(timeRanges).build());
        }

        /**
         * <p>
         * The direction for the <code>TopicIRContributionAnalysis</code>.
         * </p>
         * 
         * @param direction
         *        The direction for the <code>TopicIRContributionAnalysis</code>.
         * @see ContributionAnalysisDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContributionAnalysisDirection
         */
        Builder direction(String direction);

        /**
         * <p>
         * The direction for the <code>TopicIRContributionAnalysis</code>.
         * </p>
         * 
         * @param direction
         *        The direction for the <code>TopicIRContributionAnalysis</code>.
         * @see ContributionAnalysisDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContributionAnalysisDirection
         */
        Builder direction(ContributionAnalysisDirection direction);

        /**
         * <p>
         * The sort type for the <code>TopicIRContributionAnalysis</code>.
         * </p>
         * 
         * @param sortType
         *        The sort type for the <code>TopicIRContributionAnalysis</code>.
         * @see ContributionAnalysisSortType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContributionAnalysisSortType
         */
        Builder sortType(String sortType);

        /**
         * <p>
         * The sort type for the <code>TopicIRContributionAnalysis</code>.
         * </p>
         * 
         * @param sortType
         *        The sort type for the <code>TopicIRContributionAnalysis</code>.
         * @see ContributionAnalysisSortType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContributionAnalysisSortType
         */
        Builder sortType(ContributionAnalysisSortType sortType);
    }

    static final class BuilderImpl implements Builder {
        private List<ContributionAnalysisFactor> factors = DefaultSdkAutoConstructList.getInstance();

        private ContributionAnalysisTimeRanges timeRanges;

        private String direction;

        private String sortType;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicIRContributionAnalysis model) {
            factors(model.factors);
            timeRanges(model.timeRanges);
            direction(model.direction);
            sortType(model.sortType);
        }

        public final List<ContributionAnalysisFactor.Builder> getFactors() {
            List<ContributionAnalysisFactor.Builder> result = ContributionAnalysisFactorsListCopier.copyToBuilder(this.factors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFactors(Collection<ContributionAnalysisFactor.BuilderImpl> factors) {
            this.factors = ContributionAnalysisFactorsListCopier.copyFromBuilder(factors);
        }

        @Override
        public final Builder factors(Collection<ContributionAnalysisFactor> factors) {
            this.factors = ContributionAnalysisFactorsListCopier.copy(factors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder factors(ContributionAnalysisFactor... factors) {
            factors(Arrays.asList(factors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder factors(Consumer<ContributionAnalysisFactor.Builder>... factors) {
            factors(Stream.of(factors).map(c -> ContributionAnalysisFactor.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ContributionAnalysisTimeRanges.Builder getTimeRanges() {
            return timeRanges != null ? timeRanges.toBuilder() : null;
        }

        public final void setTimeRanges(ContributionAnalysisTimeRanges.BuilderImpl timeRanges) {
            this.timeRanges = timeRanges != null ? timeRanges.build() : null;
        }

        @Override
        public final Builder timeRanges(ContributionAnalysisTimeRanges timeRanges) {
            this.timeRanges = timeRanges;
            return this;
        }

        public final String getDirection() {
            return direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(ContributionAnalysisDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final String getSortType() {
            return sortType;
        }

        public final void setSortType(String sortType) {
            this.sortType = sortType;
        }

        @Override
        public final Builder sortType(String sortType) {
            this.sortType = sortType;
            return this;
        }

        @Override
        public final Builder sortType(ContributionAnalysisSortType sortType) {
            this.sortType(sortType == null ? null : sortType.toString());
            return this;
        }

        @Override
        public TopicIRContributionAnalysis build() {
            return new TopicIRContributionAnalysis(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
