/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The table cell style for a cell in pivot table or table visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableCellStyle implements SdkPojo, Serializable, ToCopyableBuilder<TableCellStyle.Builder, TableCellStyle> {
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(TableCellStyle::visibilityAsString)).setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<FontConfiguration> FONT_CONFIGURATION_FIELD = SdkField
            .<FontConfiguration> builder(MarshallingType.SDK_POJO).memberName("FontConfiguration")
            .getter(getter(TableCellStyle::fontConfiguration)).setter(setter(Builder::fontConfiguration))
            .constructor(FontConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontConfiguration").build()).build();

    private static final SdkField<String> TEXT_WRAP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TextWrap").getter(getter(TableCellStyle::textWrapAsString)).setter(setter(Builder::textWrap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextWrap").build()).build();

    private static final SdkField<String> HORIZONTAL_TEXT_ALIGNMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HorizontalTextAlignment").getter(getter(TableCellStyle::horizontalTextAlignmentAsString))
            .setter(setter(Builder::horizontalTextAlignment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HorizontalTextAlignment").build())
            .build();

    private static final SdkField<String> VERTICAL_TEXT_ALIGNMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VerticalTextAlignment").getter(getter(TableCellStyle::verticalTextAlignmentAsString))
            .setter(setter(Builder::verticalTextAlignment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerticalTextAlignment").build())
            .build();

    private static final SdkField<String> BACKGROUND_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackgroundColor").getter(getter(TableCellStyle::backgroundColor))
            .setter(setter(Builder::backgroundColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackgroundColor").build()).build();

    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Height").getter(getter(TableCellStyle::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Height").build()).build();

    private static final SdkField<GlobalTableBorderOptions> BORDER_FIELD = SdkField
            .<GlobalTableBorderOptions> builder(MarshallingType.SDK_POJO).memberName("Border")
            .getter(getter(TableCellStyle::border)).setter(setter(Builder::border))
            .constructor(GlobalTableBorderOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Border").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISIBILITY_FIELD,
            FONT_CONFIGURATION_FIELD, TEXT_WRAP_FIELD, HORIZONTAL_TEXT_ALIGNMENT_FIELD, VERTICAL_TEXT_ALIGNMENT_FIELD,
            BACKGROUND_COLOR_FIELD, HEIGHT_FIELD, BORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String visibility;

    private final FontConfiguration fontConfiguration;

    private final String textWrap;

    private final String horizontalTextAlignment;

    private final String verticalTextAlignment;

    private final String backgroundColor;

    private final Integer height;

    private final GlobalTableBorderOptions border;

    private TableCellStyle(BuilderImpl builder) {
        this.visibility = builder.visibility;
        this.fontConfiguration = builder.fontConfiguration;
        this.textWrap = builder.textWrap;
        this.horizontalTextAlignment = builder.horizontalTextAlignment;
        this.verticalTextAlignment = builder.verticalTextAlignment;
        this.backgroundColor = builder.backgroundColor;
        this.height = builder.height;
        this.border = builder.border;
    }

    /**
     * <p>
     * The visibility of the table cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of the table cells.
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * The visibility of the table cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of the table cells.
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    /**
     * <p>
     * The font configuration of the table cells.
     * </p>
     * 
     * @return The font configuration of the table cells.
     */
    public final FontConfiguration fontConfiguration() {
        return fontConfiguration;
    }

    /**
     * <p>
     * The text wrap (none, wrap) for the table cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #textWrap} will
     * return {@link TextWrap#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #textWrapAsString}.
     * </p>
     * 
     * @return The text wrap (none, wrap) for the table cells.
     * @see TextWrap
     */
    public final TextWrap textWrap() {
        return TextWrap.fromValue(textWrap);
    }

    /**
     * <p>
     * The text wrap (none, wrap) for the table cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #textWrap} will
     * return {@link TextWrap#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #textWrapAsString}.
     * </p>
     * 
     * @return The text wrap (none, wrap) for the table cells.
     * @see TextWrap
     */
    public final String textWrapAsString() {
        return textWrap;
    }

    /**
     * <p>
     * The horizontal text alignment (left, center, right, auto) for the table cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #horizontalTextAlignment} will return {@link HorizontalTextAlignment#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #horizontalTextAlignmentAsString}.
     * </p>
     * 
     * @return The horizontal text alignment (left, center, right, auto) for the table cells.
     * @see HorizontalTextAlignment
     */
    public final HorizontalTextAlignment horizontalTextAlignment() {
        return HorizontalTextAlignment.fromValue(horizontalTextAlignment);
    }

    /**
     * <p>
     * The horizontal text alignment (left, center, right, auto) for the table cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #horizontalTextAlignment} will return {@link HorizontalTextAlignment#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #horizontalTextAlignmentAsString}.
     * </p>
     * 
     * @return The horizontal text alignment (left, center, right, auto) for the table cells.
     * @see HorizontalTextAlignment
     */
    public final String horizontalTextAlignmentAsString() {
        return horizontalTextAlignment;
    }

    /**
     * <p>
     * The vertical text alignment (top, middle, bottom) for the table cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #verticalTextAlignment} will return {@link VerticalTextAlignment#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #verticalTextAlignmentAsString}.
     * </p>
     * 
     * @return The vertical text alignment (top, middle, bottom) for the table cells.
     * @see VerticalTextAlignment
     */
    public final VerticalTextAlignment verticalTextAlignment() {
        return VerticalTextAlignment.fromValue(verticalTextAlignment);
    }

    /**
     * <p>
     * The vertical text alignment (top, middle, bottom) for the table cells.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #verticalTextAlignment} will return {@link VerticalTextAlignment#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #verticalTextAlignmentAsString}.
     * </p>
     * 
     * @return The vertical text alignment (top, middle, bottom) for the table cells.
     * @see VerticalTextAlignment
     */
    public final String verticalTextAlignmentAsString() {
        return verticalTextAlignment;
    }

    /**
     * <p>
     * The background color for the table cells.
     * </p>
     * 
     * @return The background color for the table cells.
     */
    public final String backgroundColor() {
        return backgroundColor;
    }

    /**
     * <p>
     * The height color for the table cells.
     * </p>
     * 
     * @return The height color for the table cells.
     */
    public final Integer height() {
        return height;
    }

    /**
     * <p>
     * The borders for the table cells.
     * </p>
     * 
     * @return The borders for the table cells.
     */
    public final GlobalTableBorderOptions border() {
        return border;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(textWrapAsString());
        hashCode = 31 * hashCode + Objects.hashCode(horizontalTextAlignmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(verticalTextAlignmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(backgroundColor());
        hashCode = 31 * hashCode + Objects.hashCode(height());
        hashCode = 31 * hashCode + Objects.hashCode(border());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableCellStyle)) {
            return false;
        }
        TableCellStyle other = (TableCellStyle) obj;
        return Objects.equals(visibilityAsString(), other.visibilityAsString())
                && Objects.equals(fontConfiguration(), other.fontConfiguration())
                && Objects.equals(textWrapAsString(), other.textWrapAsString())
                && Objects.equals(horizontalTextAlignmentAsString(), other.horizontalTextAlignmentAsString())
                && Objects.equals(verticalTextAlignmentAsString(), other.verticalTextAlignmentAsString())
                && Objects.equals(backgroundColor(), other.backgroundColor()) && Objects.equals(height(), other.height())
                && Objects.equals(border(), other.border());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableCellStyle").add("Visibility", visibilityAsString())
                .add("FontConfiguration", fontConfiguration()).add("TextWrap", textWrapAsString())
                .add("HorizontalTextAlignment", horizontalTextAlignmentAsString())
                .add("VerticalTextAlignment", verticalTextAlignmentAsString()).add("BackgroundColor", backgroundColor())
                .add("Height", height()).add("Border", border()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "FontConfiguration":
            return Optional.ofNullable(clazz.cast(fontConfiguration()));
        case "TextWrap":
            return Optional.ofNullable(clazz.cast(textWrapAsString()));
        case "HorizontalTextAlignment":
            return Optional.ofNullable(clazz.cast(horizontalTextAlignmentAsString()));
        case "VerticalTextAlignment":
            return Optional.ofNullable(clazz.cast(verticalTextAlignmentAsString()));
        case "BackgroundColor":
            return Optional.ofNullable(clazz.cast(backgroundColor()));
        case "Height":
            return Optional.ofNullable(clazz.cast(height()));
        case "Border":
            return Optional.ofNullable(clazz.cast(border()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("FontConfiguration", FONT_CONFIGURATION_FIELD);
        map.put("TextWrap", TEXT_WRAP_FIELD);
        map.put("HorizontalTextAlignment", HORIZONTAL_TEXT_ALIGNMENT_FIELD);
        map.put("VerticalTextAlignment", VERTICAL_TEXT_ALIGNMENT_FIELD);
        map.put("BackgroundColor", BACKGROUND_COLOR_FIELD);
        map.put("Height", HEIGHT_FIELD);
        map.put("Border", BORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableCellStyle, T> g) {
        return obj -> g.apply((TableCellStyle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableCellStyle> {
        /**
         * <p>
         * The visibility of the table cells.
         * </p>
         * 
         * @param visibility
         *        The visibility of the table cells.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The visibility of the table cells.
         * </p>
         * 
         * @param visibility
         *        The visibility of the table cells.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);

        /**
         * <p>
         * The font configuration of the table cells.
         * </p>
         * 
         * @param fontConfiguration
         *        The font configuration of the table cells.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontConfiguration(FontConfiguration fontConfiguration);

        /**
         * <p>
         * The font configuration of the table cells.
         * </p>
         * This is a convenience method that creates an instance of the {@link FontConfiguration.Builder} avoiding the
         * need to create one manually via {@link FontConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FontConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #fontConfiguration(FontConfiguration)}.
         * 
         * @param fontConfiguration
         *        a consumer that will call methods on {@link FontConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fontConfiguration(FontConfiguration)
         */
        default Builder fontConfiguration(Consumer<FontConfiguration.Builder> fontConfiguration) {
            return fontConfiguration(FontConfiguration.builder().applyMutation(fontConfiguration).build());
        }

        /**
         * <p>
         * The text wrap (none, wrap) for the table cells.
         * </p>
         * 
         * @param textWrap
         *        The text wrap (none, wrap) for the table cells.
         * @see TextWrap
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TextWrap
         */
        Builder textWrap(String textWrap);

        /**
         * <p>
         * The text wrap (none, wrap) for the table cells.
         * </p>
         * 
         * @param textWrap
         *        The text wrap (none, wrap) for the table cells.
         * @see TextWrap
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TextWrap
         */
        Builder textWrap(TextWrap textWrap);

        /**
         * <p>
         * The horizontal text alignment (left, center, right, auto) for the table cells.
         * </p>
         * 
         * @param horizontalTextAlignment
         *        The horizontal text alignment (left, center, right, auto) for the table cells.
         * @see HorizontalTextAlignment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HorizontalTextAlignment
         */
        Builder horizontalTextAlignment(String horizontalTextAlignment);

        /**
         * <p>
         * The horizontal text alignment (left, center, right, auto) for the table cells.
         * </p>
         * 
         * @param horizontalTextAlignment
         *        The horizontal text alignment (left, center, right, auto) for the table cells.
         * @see HorizontalTextAlignment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HorizontalTextAlignment
         */
        Builder horizontalTextAlignment(HorizontalTextAlignment horizontalTextAlignment);

        /**
         * <p>
         * The vertical text alignment (top, middle, bottom) for the table cells.
         * </p>
         * 
         * @param verticalTextAlignment
         *        The vertical text alignment (top, middle, bottom) for the table cells.
         * @see VerticalTextAlignment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerticalTextAlignment
         */
        Builder verticalTextAlignment(String verticalTextAlignment);

        /**
         * <p>
         * The vertical text alignment (top, middle, bottom) for the table cells.
         * </p>
         * 
         * @param verticalTextAlignment
         *        The vertical text alignment (top, middle, bottom) for the table cells.
         * @see VerticalTextAlignment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerticalTextAlignment
         */
        Builder verticalTextAlignment(VerticalTextAlignment verticalTextAlignment);

        /**
         * <p>
         * The background color for the table cells.
         * </p>
         * 
         * @param backgroundColor
         *        The background color for the table cells.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backgroundColor(String backgroundColor);

        /**
         * <p>
         * The height color for the table cells.
         * </p>
         * 
         * @param height
         *        The height color for the table cells.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(Integer height);

        /**
         * <p>
         * The borders for the table cells.
         * </p>
         * 
         * @param border
         *        The borders for the table cells.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder border(GlobalTableBorderOptions border);

        /**
         * <p>
         * The borders for the table cells.
         * </p>
         * This is a convenience method that creates an instance of the {@link GlobalTableBorderOptions.Builder}
         * avoiding the need to create one manually via {@link GlobalTableBorderOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GlobalTableBorderOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #border(GlobalTableBorderOptions)}.
         * 
         * @param border
         *        a consumer that will call methods on {@link GlobalTableBorderOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #border(GlobalTableBorderOptions)
         */
        default Builder border(Consumer<GlobalTableBorderOptions.Builder> border) {
            return border(GlobalTableBorderOptions.builder().applyMutation(border).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String visibility;

        private FontConfiguration fontConfiguration;

        private String textWrap;

        private String horizontalTextAlignment;

        private String verticalTextAlignment;

        private String backgroundColor;

        private Integer height;

        private GlobalTableBorderOptions border;

        private BuilderImpl() {
        }

        private BuilderImpl(TableCellStyle model) {
            visibility(model.visibility);
            fontConfiguration(model.fontConfiguration);
            textWrap(model.textWrap);
            horizontalTextAlignment(model.horizontalTextAlignment);
            verticalTextAlignment(model.verticalTextAlignment);
            backgroundColor(model.backgroundColor);
            height(model.height);
            border(model.border);
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final FontConfiguration.Builder getFontConfiguration() {
            return fontConfiguration != null ? fontConfiguration.toBuilder() : null;
        }

        public final void setFontConfiguration(FontConfiguration.BuilderImpl fontConfiguration) {
            this.fontConfiguration = fontConfiguration != null ? fontConfiguration.build() : null;
        }

        @Override
        public final Builder fontConfiguration(FontConfiguration fontConfiguration) {
            this.fontConfiguration = fontConfiguration;
            return this;
        }

        public final String getTextWrap() {
            return textWrap;
        }

        public final void setTextWrap(String textWrap) {
            this.textWrap = textWrap;
        }

        @Override
        public final Builder textWrap(String textWrap) {
            this.textWrap = textWrap;
            return this;
        }

        @Override
        public final Builder textWrap(TextWrap textWrap) {
            this.textWrap(textWrap == null ? null : textWrap.toString());
            return this;
        }

        public final String getHorizontalTextAlignment() {
            return horizontalTextAlignment;
        }

        public final void setHorizontalTextAlignment(String horizontalTextAlignment) {
            this.horizontalTextAlignment = horizontalTextAlignment;
        }

        @Override
        public final Builder horizontalTextAlignment(String horizontalTextAlignment) {
            this.horizontalTextAlignment = horizontalTextAlignment;
            return this;
        }

        @Override
        public final Builder horizontalTextAlignment(HorizontalTextAlignment horizontalTextAlignment) {
            this.horizontalTextAlignment(horizontalTextAlignment == null ? null : horizontalTextAlignment.toString());
            return this;
        }

        public final String getVerticalTextAlignment() {
            return verticalTextAlignment;
        }

        public final void setVerticalTextAlignment(String verticalTextAlignment) {
            this.verticalTextAlignment = verticalTextAlignment;
        }

        @Override
        public final Builder verticalTextAlignment(String verticalTextAlignment) {
            this.verticalTextAlignment = verticalTextAlignment;
            return this;
        }

        @Override
        public final Builder verticalTextAlignment(VerticalTextAlignment verticalTextAlignment) {
            this.verticalTextAlignment(verticalTextAlignment == null ? null : verticalTextAlignment.toString());
            return this;
        }

        public final String getBackgroundColor() {
            return backgroundColor;
        }

        public final void setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        @Override
        public final Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public final Integer getHeight() {
            return height;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final GlobalTableBorderOptions.Builder getBorder() {
            return border != null ? border.toBuilder() : null;
        }

        public final void setBorder(GlobalTableBorderOptions.BuilderImpl border) {
            this.border = border != null ? border.build() : null;
        }

        @Override
        public final Builder border(GlobalTableBorderOptions border) {
            this.border = border;
            return this;
        }

        @Override
        public TableCellStyle build() {
            return new TableCellStyle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
