/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information on the generated snapshot file groups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotJobResultFileGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<SnapshotJobResultFileGroup.Builder, SnapshotJobResultFileGroup> {
    private static final SdkField<List<SnapshotFile>> FILES_FIELD = SdkField
            .<List<SnapshotFile>> builder(MarshallingType.LIST)
            .memberName("Files")
            .getter(getter(SnapshotJobResultFileGroup::files))
            .setter(setter(Builder::files))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Files").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SnapshotFile> builder(MarshallingType.SDK_POJO)
                                            .constructor(SnapshotFile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SnapshotJobS3Result>> S3_RESULTS_FIELD = SdkField
            .<List<SnapshotJobS3Result>> builder(MarshallingType.LIST)
            .memberName("S3Results")
            .getter(getter(SnapshotJobResultFileGroup::s3Results))
            .setter(setter(Builder::s3Results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Results").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SnapshotJobS3Result> builder(MarshallingType.SDK_POJO)
                                            .constructor(SnapshotJobS3Result::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(FILES_FIELD, S3_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<SnapshotFile> files;

    private final List<SnapshotJobS3Result> s3Results;

    private SnapshotJobResultFileGroup(BuilderImpl builder) {
        this.files = builder.files;
        this.s3Results = builder.s3Results;
    }

    /**
     * For responses, this returns true if the service returned a value for the Files property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasFiles() {
        return files != null && !(files instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>SnapshotFile</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFiles} method.
     * </p>
     * 
     * @return A list of <code>SnapshotFile</code> objects.
     */
    public final List<SnapshotFile> files() {
        return files;
    }

    /**
     * For responses, this returns true if the service returned a value for the S3Results property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasS3Results() {
        return s3Results != null && !(s3Results instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>SnapshotJobS3Result</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasS3Results} method.
     * </p>
     * 
     * @return A list of <code>SnapshotJobS3Result</code> objects.
     */
    public final List<SnapshotJobS3Result> s3Results() {
        return s3Results;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFiles() ? files() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasS3Results() ? s3Results() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotJobResultFileGroup)) {
            return false;
        }
        SnapshotJobResultFileGroup other = (SnapshotJobResultFileGroup) obj;
        return hasFiles() == other.hasFiles() && Objects.equals(files(), other.files()) && hasS3Results() == other.hasS3Results()
                && Objects.equals(s3Results(), other.s3Results());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapshotJobResultFileGroup").add("Files", hasFiles() ? files() : null)
                .add("S3Results", hasS3Results() ? s3Results() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Files":
            return Optional.ofNullable(clazz.cast(files()));
        case "S3Results":
            return Optional.ofNullable(clazz.cast(s3Results()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Files", FILES_FIELD);
        map.put("S3Results", S3_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnapshotJobResultFileGroup, T> g) {
        return obj -> g.apply((SnapshotJobResultFileGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotJobResultFileGroup> {
        /**
         * <p>
         * A list of <code>SnapshotFile</code> objects.
         * </p>
         * 
         * @param files
         *        A list of <code>SnapshotFile</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder files(Collection<SnapshotFile> files);

        /**
         * <p>
         * A list of <code>SnapshotFile</code> objects.
         * </p>
         * 
         * @param files
         *        A list of <code>SnapshotFile</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder files(SnapshotFile... files);

        /**
         * <p>
         * A list of <code>SnapshotFile</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotFile.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.SnapshotFile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotFile.Builder#build()} is called immediately
         * and its result is passed to {@link #files(List<SnapshotFile>)}.
         * 
         * @param files
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.SnapshotFile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #files(java.util.Collection<SnapshotFile>)
         */
        Builder files(Consumer<SnapshotFile.Builder>... files);

        /**
         * <p>
         * A list of <code>SnapshotJobS3Result</code> objects.
         * </p>
         * 
         * @param s3Results
         *        A list of <code>SnapshotJobS3Result</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Results(Collection<SnapshotJobS3Result> s3Results);

        /**
         * <p>
         * A list of <code>SnapshotJobS3Result</code> objects.
         * </p>
         * 
         * @param s3Results
         *        A list of <code>SnapshotJobS3Result</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Results(SnapshotJobS3Result... s3Results);

        /**
         * <p>
         * A list of <code>SnapshotJobS3Result</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotJobS3Result.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotJobS3Result#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotJobS3Result.Builder#build()} is called
         * immediately and its result is passed to {@link #s3Results(List<SnapshotJobS3Result>)}.
         * 
         * @param s3Results
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.SnapshotJobS3Result.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Results(java.util.Collection<SnapshotJobS3Result>)
         */
        Builder s3Results(Consumer<SnapshotJobS3Result.Builder>... s3Results);
    }

    static final class BuilderImpl implements Builder {
        private List<SnapshotFile> files = DefaultSdkAutoConstructList.getInstance();

        private List<SnapshotJobS3Result> s3Results = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotJobResultFileGroup model) {
            files(model.files);
            s3Results(model.s3Results);
        }

        public final List<SnapshotFile.Builder> getFiles() {
            List<SnapshotFile.Builder> result = SnapshotFileListCopier.copyToBuilder(this.files);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFiles(Collection<SnapshotFile.BuilderImpl> files) {
            this.files = SnapshotFileListCopier.copyFromBuilder(files);
        }

        @Override
        public final Builder files(Collection<SnapshotFile> files) {
            this.files = SnapshotFileListCopier.copy(files);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(SnapshotFile... files) {
            files(Arrays.asList(files));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(Consumer<SnapshotFile.Builder>... files) {
            files(Stream.of(files).map(c -> SnapshotFile.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SnapshotJobS3Result.Builder> getS3Results() {
            List<SnapshotJobS3Result.Builder> result = SnapshotJobS3ResultListCopier.copyToBuilder(this.s3Results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setS3Results(Collection<SnapshotJobS3Result.BuilderImpl> s3Results) {
            this.s3Results = SnapshotJobS3ResultListCopier.copyFromBuilder(s3Results);
        }

        @Override
        public final Builder s3Results(Collection<SnapshotJobS3Result> s3Results) {
            this.s3Results = SnapshotJobS3ResultListCopier.copy(s3Results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Results(SnapshotJobS3Result... s3Results) {
            s3Results(Arrays.asList(s3Results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Results(Consumer<SnapshotJobS3Result.Builder>... s3Results) {
            s3Results(Stream.of(s3Results).map(c -> SnapshotJobS3Result.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SnapshotJobResultFileGroup build() {
            return new SnapshotJobResultFileGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
