/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of adding parameters in action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetParameterValueConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SetParameterValueConfiguration.Builder, SetParameterValueConfiguration> {
    private static final SdkField<String> DESTINATION_PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationParameterName").getter(getter(SetParameterValueConfiguration::destinationParameterName))
            .setter(setter(Builder::destinationParameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationParameterName").build())
            .build();

    private static final SdkField<DestinationParameterValueConfiguration> VALUE_FIELD = SdkField
            .<DestinationParameterValueConfiguration> builder(MarshallingType.SDK_POJO).memberName("Value")
            .getter(getter(SetParameterValueConfiguration::value)).setter(setter(Builder::value))
            .constructor(DestinationParameterValueConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DESTINATION_PARAMETER_NAME_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destinationParameterName;

    private final DestinationParameterValueConfiguration value;

    private SetParameterValueConfiguration(BuilderImpl builder) {
        this.destinationParameterName = builder.destinationParameterName;
        this.value = builder.value;
    }

    /**
     * <p>
     * The destination parameter name of the <code>SetParameterValueConfiguration</code>.
     * </p>
     * 
     * @return The destination parameter name of the <code>SetParameterValueConfiguration</code>.
     */
    public final String destinationParameterName() {
        return destinationParameterName;
    }

    /**
     * Returns the value of the Value property for this object.
     * 
     * @return The value of the Value property for this object.
     */
    public final DestinationParameterValueConfiguration value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetParameterValueConfiguration)) {
            return false;
        }
        SetParameterValueConfiguration other = (SetParameterValueConfiguration) obj;
        return Objects.equals(destinationParameterName(), other.destinationParameterName())
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetParameterValueConfiguration").add("DestinationParameterName", destinationParameterName())
                .add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationParameterName":
            return Optional.ofNullable(clazz.cast(destinationParameterName()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DestinationParameterName", DESTINATION_PARAMETER_NAME_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetParameterValueConfiguration, T> g) {
        return obj -> g.apply((SetParameterValueConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SetParameterValueConfiguration> {
        /**
         * <p>
         * The destination parameter name of the <code>SetParameterValueConfiguration</code>.
         * </p>
         * 
         * @param destinationParameterName
         *        The destination parameter name of the <code>SetParameterValueConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationParameterName(String destinationParameterName);

        /**
         * Sets the value of the Value property for this object.
         *
         * @param value
         *        The new value for the Value property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(DestinationParameterValueConfiguration value);

        /**
         * Sets the value of the Value property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link DestinationParameterValueConfiguration.Builder} avoiding the need to create one manually via
         * {@link DestinationParameterValueConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationParameterValueConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #value(DestinationParameterValueConfiguration)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link DestinationParameterValueConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(DestinationParameterValueConfiguration)
         */
        default Builder value(Consumer<DestinationParameterValueConfiguration.Builder> value) {
            return value(DestinationParameterValueConfiguration.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String destinationParameterName;

        private DestinationParameterValueConfiguration value;

        private BuilderImpl() {
        }

        private BuilderImpl(SetParameterValueConfiguration model) {
            destinationParameterName(model.destinationParameterName);
            value(model.value);
        }

        public final String getDestinationParameterName() {
            return destinationParameterName;
        }

        public final void setDestinationParameterName(String destinationParameterName) {
            this.destinationParameterName = destinationParameterName;
        }

        @Override
        public final Builder destinationParameterName(String destinationParameterName) {
            this.destinationParameterName = destinationParameterName;
            return this;
        }

        public final DestinationParameterValueConfiguration.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(DestinationParameterValueConfiguration.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(DestinationParameterValueConfiguration value) {
            this.value = value;
            return this;
        }

        @Override
        public SetParameterValueConfiguration build() {
            return new SetParameterValueConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
