/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The failure configuration of a dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RefreshFailureConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RefreshFailureConfiguration.Builder, RefreshFailureConfiguration> {
    private static final SdkField<RefreshFailureEmailAlert> EMAIL_ALERT_FIELD = SdkField
            .<RefreshFailureEmailAlert> builder(MarshallingType.SDK_POJO).memberName("EmailAlert")
            .getter(getter(RefreshFailureConfiguration::emailAlert)).setter(setter(Builder::emailAlert))
            .constructor(RefreshFailureEmailAlert::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAlert").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_ALERT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RefreshFailureEmailAlert emailAlert;

    private RefreshFailureConfiguration(BuilderImpl builder) {
        this.emailAlert = builder.emailAlert;
    }

    /**
     * <p>
     * The email alert configuration for a dataset refresh failure.
     * </p>
     * 
     * @return The email alert configuration for a dataset refresh failure.
     */
    public final RefreshFailureEmailAlert emailAlert() {
        return emailAlert;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(emailAlert());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshFailureConfiguration)) {
            return false;
        }
        RefreshFailureConfiguration other = (RefreshFailureConfiguration) obj;
        return Objects.equals(emailAlert(), other.emailAlert());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RefreshFailureConfiguration").add("EmailAlert", emailAlert()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailAlert":
            return Optional.ofNullable(clazz.cast(emailAlert()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EmailAlert", EMAIL_ALERT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RefreshFailureConfiguration, T> g) {
        return obj -> g.apply((RefreshFailureConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RefreshFailureConfiguration> {
        /**
         * <p>
         * The email alert configuration for a dataset refresh failure.
         * </p>
         * 
         * @param emailAlert
         *        The email alert configuration for a dataset refresh failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAlert(RefreshFailureEmailAlert emailAlert);

        /**
         * <p>
         * The email alert configuration for a dataset refresh failure.
         * </p>
         * This is a convenience method that creates an instance of the {@link RefreshFailureEmailAlert.Builder}
         * avoiding the need to create one manually via {@link RefreshFailureEmailAlert#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RefreshFailureEmailAlert.Builder#build()} is called immediately
         * and its result is passed to {@link #emailAlert(RefreshFailureEmailAlert)}.
         * 
         * @param emailAlert
         *        a consumer that will call methods on {@link RefreshFailureEmailAlert.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailAlert(RefreshFailureEmailAlert)
         */
        default Builder emailAlert(Consumer<RefreshFailureEmailAlert.Builder> emailAlert) {
            return emailAlert(RefreshFailureEmailAlert.builder().applyMutation(emailAlert).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RefreshFailureEmailAlert emailAlert;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshFailureConfiguration model) {
            emailAlert(model.emailAlert);
        }

        public final RefreshFailureEmailAlert.Builder getEmailAlert() {
            return emailAlert != null ? emailAlert.toBuilder() : null;
        }

        public final void setEmailAlert(RefreshFailureEmailAlert.BuilderImpl emailAlert) {
            this.emailAlert = emailAlert != null ? emailAlert.build() : null;
        }

        @Override
        public final Builder emailAlert(RefreshFailureEmailAlert emailAlert) {
            this.emailAlert = emailAlert;
            return this;
        }

        @Override
        public RefreshFailureConfiguration build() {
            return new RefreshFailureConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
