/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for Oracle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OracleParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<OracleParameters.Builder, OracleParameters> {
    private static final SdkField<String> HOST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Host")
            .getter(getter(OracleParameters::host)).setter(setter(Builder::host))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(OracleParameters::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(OracleParameters::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<Boolean> USE_SERVICE_NAME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseServiceName").getter(getter(OracleParameters::useServiceName))
            .setter(setter(Builder::useServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseServiceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD, PORT_FIELD,
            DATABASE_FIELD, USE_SERVICE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String host;

    private final Integer port;

    private final String database;

    private final Boolean useServiceName;

    private OracleParameters(BuilderImpl builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.database = builder.database;
        this.useServiceName = builder.useServiceName;
    }

    /**
     * <p>
     * An Oracle host.
     * </p>
     * 
     * @return An Oracle host.
     */
    public final String host() {
        return host;
    }

    /**
     * <p>
     * The port.
     * </p>
     * 
     * @return The port.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The database.
     * </p>
     * 
     * @return The database.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * A Boolean value that indicates whether the <code>Database</code> uses a service name or an SID. If this value is
     * left blank, the default value is <code>SID</code>. If this value is set to <code>false</code>, the value is
     * <code>SID</code>.
     * </p>
     * 
     * @return A Boolean value that indicates whether the <code>Database</code> uses a service name or an SID. If this
     *         value is left blank, the default value is <code>SID</code>. If this value is set to <code>false</code>,
     *         the value is <code>SID</code>.
     */
    public final Boolean useServiceName() {
        return useServiceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(host());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(useServiceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OracleParameters)) {
            return false;
        }
        OracleParameters other = (OracleParameters) obj;
        return Objects.equals(host(), other.host()) && Objects.equals(port(), other.port())
                && Objects.equals(database(), other.database()) && Objects.equals(useServiceName(), other.useServiceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OracleParameters").add("Host", host()).add("Port", port()).add("Database", database())
                .add("UseServiceName", useServiceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Host":
            return Optional.ofNullable(clazz.cast(host()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "UseServiceName":
            return Optional.ofNullable(clazz.cast(useServiceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Host", HOST_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("Database", DATABASE_FIELD);
        map.put("UseServiceName", USE_SERVICE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OracleParameters, T> g) {
        return obj -> g.apply((OracleParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OracleParameters> {
        /**
         * <p>
         * An Oracle host.
         * </p>
         * 
         * @param host
         *        An Oracle host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(String host);

        /**
         * <p>
         * The port.
         * </p>
         * 
         * @param port
         *        The port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The database.
         * </p>
         * 
         * @param database
         *        The database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * A Boolean value that indicates whether the <code>Database</code> uses a service name or an SID. If this value
         * is left blank, the default value is <code>SID</code>. If this value is set to <code>false</code>, the value
         * is <code>SID</code>.
         * </p>
         * 
         * @param useServiceName
         *        A Boolean value that indicates whether the <code>Database</code> uses a service name or an SID. If
         *        this value is left blank, the default value is <code>SID</code>. If this value is set to
         *        <code>false</code>, the value is <code>SID</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useServiceName(Boolean useServiceName);
    }

    static final class BuilderImpl implements Builder {
        private String host;

        private Integer port;

        private String database;

        private Boolean useServiceName;

        private BuilderImpl() {
        }

        private BuilderImpl(OracleParameters model) {
            host(model.host);
            port(model.port);
            database(model.database);
            useServiceName(model.useServiceName);
        }

        public final String getHost() {
            return host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final Boolean getUseServiceName() {
            return useServiceName;
        }

        public final void setUseServiceName(Boolean useServiceName) {
            this.useServiceName = useServiceName;
        }

        @Override
        public final Builder useServiceName(Boolean useServiceName) {
            this.useServiceName = useServiceName;
            return this;
        }

        @Override
        public OracleParameters build() {
            return new OracleParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
