/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that determine the numeric separator configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NumericSeparatorConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NumericSeparatorConfiguration.Builder, NumericSeparatorConfiguration> {
    private static final SdkField<String> DECIMAL_SEPARATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DecimalSeparator").getter(getter(NumericSeparatorConfiguration::decimalSeparatorAsString))
            .setter(setter(Builder::decimalSeparator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecimalSeparator").build()).build();

    private static final SdkField<ThousandSeparatorOptions> THOUSANDS_SEPARATOR_FIELD = SdkField
            .<ThousandSeparatorOptions> builder(MarshallingType.SDK_POJO).memberName("ThousandsSeparator")
            .getter(getter(NumericSeparatorConfiguration::thousandsSeparator)).setter(setter(Builder::thousandsSeparator))
            .constructor(ThousandSeparatorOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThousandsSeparator").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECIMAL_SEPARATOR_FIELD,
            THOUSANDS_SEPARATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String decimalSeparator;

    private final ThousandSeparatorOptions thousandsSeparator;

    private NumericSeparatorConfiguration(BuilderImpl builder) {
        this.decimalSeparator = builder.decimalSeparator;
        this.thousandsSeparator = builder.thousandsSeparator;
    }

    /**
     * <p>
     * Determines the decimal separator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #decimalSeparator}
     * will return {@link NumericSeparatorSymbol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #decimalSeparatorAsString}.
     * </p>
     * 
     * @return Determines the decimal separator.
     * @see NumericSeparatorSymbol
     */
    public final NumericSeparatorSymbol decimalSeparator() {
        return NumericSeparatorSymbol.fromValue(decimalSeparator);
    }

    /**
     * <p>
     * Determines the decimal separator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #decimalSeparator}
     * will return {@link NumericSeparatorSymbol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #decimalSeparatorAsString}.
     * </p>
     * 
     * @return Determines the decimal separator.
     * @see NumericSeparatorSymbol
     */
    public final String decimalSeparatorAsString() {
        return decimalSeparator;
    }

    /**
     * <p>
     * The options that determine the thousands separator configuration.
     * </p>
     * 
     * @return The options that determine the thousands separator configuration.
     */
    public final ThousandSeparatorOptions thousandsSeparator() {
        return thousandsSeparator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(decimalSeparatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(thousandsSeparator());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumericSeparatorConfiguration)) {
            return false;
        }
        NumericSeparatorConfiguration other = (NumericSeparatorConfiguration) obj;
        return Objects.equals(decimalSeparatorAsString(), other.decimalSeparatorAsString())
                && Objects.equals(thousandsSeparator(), other.thousandsSeparator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NumericSeparatorConfiguration").add("DecimalSeparator", decimalSeparatorAsString())
                .add("ThousandsSeparator", thousandsSeparator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DecimalSeparator":
            return Optional.ofNullable(clazz.cast(decimalSeparatorAsString()));
        case "ThousandsSeparator":
            return Optional.ofNullable(clazz.cast(thousandsSeparator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DecimalSeparator", DECIMAL_SEPARATOR_FIELD);
        map.put("ThousandsSeparator", THOUSANDS_SEPARATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NumericSeparatorConfiguration, T> g) {
        return obj -> g.apply((NumericSeparatorConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NumericSeparatorConfiguration> {
        /**
         * <p>
         * Determines the decimal separator.
         * </p>
         * 
         * @param decimalSeparator
         *        Determines the decimal separator.
         * @see NumericSeparatorSymbol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumericSeparatorSymbol
         */
        Builder decimalSeparator(String decimalSeparator);

        /**
         * <p>
         * Determines the decimal separator.
         * </p>
         * 
         * @param decimalSeparator
         *        Determines the decimal separator.
         * @see NumericSeparatorSymbol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumericSeparatorSymbol
         */
        Builder decimalSeparator(NumericSeparatorSymbol decimalSeparator);

        /**
         * <p>
         * The options that determine the thousands separator configuration.
         * </p>
         * 
         * @param thousandsSeparator
         *        The options that determine the thousands separator configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thousandsSeparator(ThousandSeparatorOptions thousandsSeparator);

        /**
         * <p>
         * The options that determine the thousands separator configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ThousandSeparatorOptions.Builder}
         * avoiding the need to create one manually via {@link ThousandSeparatorOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ThousandSeparatorOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #thousandsSeparator(ThousandSeparatorOptions)}.
         * 
         * @param thousandsSeparator
         *        a consumer that will call methods on {@link ThousandSeparatorOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thousandsSeparator(ThousandSeparatorOptions)
         */
        default Builder thousandsSeparator(Consumer<ThousandSeparatorOptions.Builder> thousandsSeparator) {
            return thousandsSeparator(ThousandSeparatorOptions.builder().applyMutation(thousandsSeparator).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String decimalSeparator;

        private ThousandSeparatorOptions thousandsSeparator;

        private BuilderImpl() {
        }

        private BuilderImpl(NumericSeparatorConfiguration model) {
            decimalSeparator(model.decimalSeparator);
            thousandsSeparator(model.thousandsSeparator);
        }

        public final String getDecimalSeparator() {
            return decimalSeparator;
        }

        public final void setDecimalSeparator(String decimalSeparator) {
            this.decimalSeparator = decimalSeparator;
        }

        @Override
        public final Builder decimalSeparator(String decimalSeparator) {
            this.decimalSeparator = decimalSeparator;
            return this;
        }

        @Override
        public final Builder decimalSeparator(NumericSeparatorSymbol decimalSeparator) {
            this.decimalSeparator(decimalSeparator == null ? null : decimalSeparator.toString());
            return this;
        }

        public final ThousandSeparatorOptions.Builder getThousandsSeparator() {
            return thousandsSeparator != null ? thousandsSeparator.toBuilder() : null;
        }

        public final void setThousandsSeparator(ThousandSeparatorOptions.BuilderImpl thousandsSeparator) {
            this.thousandsSeparator = thousandsSeparator != null ? thousandsSeparator.build() : null;
        }

        @Override
        public final Builder thousandsSeparator(ThousandSeparatorOptions thousandsSeparator) {
            this.thousandsSeparator = thousandsSeparator;
            return this;
        }

        @Override
        public NumericSeparatorConfiguration build() {
            return new NumericSeparatorConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
