/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options for an axis with a numeric field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NumericAxisOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<NumericAxisOptions.Builder, NumericAxisOptions> {
    private static final SdkField<AxisScale> SCALE_FIELD = SdkField.<AxisScale> builder(MarshallingType.SDK_POJO)
            .memberName("Scale").getter(getter(NumericAxisOptions::scale)).setter(setter(Builder::scale))
            .constructor(AxisScale::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scale").build()).build();

    private static final SdkField<AxisDisplayRange> RANGE_FIELD = SdkField.<AxisDisplayRange> builder(MarshallingType.SDK_POJO)
            .memberName("Range").getter(getter(NumericAxisOptions::range)).setter(setter(Builder::range))
            .constructor(AxisDisplayRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Range").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALE_FIELD, RANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AxisScale scale;

    private final AxisDisplayRange range;

    private NumericAxisOptions(BuilderImpl builder) {
        this.scale = builder.scale;
        this.range = builder.range;
    }

    /**
     * <p>
     * The scale setup of a numeric axis.
     * </p>
     * 
     * @return The scale setup of a numeric axis.
     */
    public final AxisScale scale() {
        return scale;
    }

    /**
     * <p>
     * The range setup of a numeric axis.
     * </p>
     * 
     * @return The range setup of a numeric axis.
     */
    public final AxisDisplayRange range() {
        return range;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scale());
        hashCode = 31 * hashCode + Objects.hashCode(range());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumericAxisOptions)) {
            return false;
        }
        NumericAxisOptions other = (NumericAxisOptions) obj;
        return Objects.equals(scale(), other.scale()) && Objects.equals(range(), other.range());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NumericAxisOptions").add("Scale", scale()).add("Range", range()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Scale":
            return Optional.ofNullable(clazz.cast(scale()));
        case "Range":
            return Optional.ofNullable(clazz.cast(range()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Scale", SCALE_FIELD);
        map.put("Range", RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NumericAxisOptions, T> g) {
        return obj -> g.apply((NumericAxisOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NumericAxisOptions> {
        /**
         * <p>
         * The scale setup of a numeric axis.
         * </p>
         * 
         * @param scale
         *        The scale setup of a numeric axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scale(AxisScale scale);

        /**
         * <p>
         * The scale setup of a numeric axis.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisScale.Builder} avoiding the need to
         * create one manually via {@link AxisScale#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisScale.Builder#build()} is called immediately and its result
         * is passed to {@link #scale(AxisScale)}.
         * 
         * @param scale
         *        a consumer that will call methods on {@link AxisScale.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scale(AxisScale)
         */
        default Builder scale(Consumer<AxisScale.Builder> scale) {
            return scale(AxisScale.builder().applyMutation(scale).build());
        }

        /**
         * <p>
         * The range setup of a numeric axis.
         * </p>
         * 
         * @param range
         *        The range setup of a numeric axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder range(AxisDisplayRange range);

        /**
         * <p>
         * The range setup of a numeric axis.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDisplayRange.Builder} avoiding the
         * need to create one manually via {@link AxisDisplayRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDisplayRange.Builder#build()} is called immediately and its
         * result is passed to {@link #range(AxisDisplayRange)}.
         * 
         * @param range
         *        a consumer that will call methods on {@link AxisDisplayRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #range(AxisDisplayRange)
         */
        default Builder range(Consumer<AxisDisplayRange.Builder> range) {
            return range(AxisDisplayRange.builder().applyMutation(range).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AxisScale scale;

        private AxisDisplayRange range;

        private BuilderImpl() {
        }

        private BuilderImpl(NumericAxisOptions model) {
            scale(model.scale);
            range(model.range);
        }

        public final AxisScale.Builder getScale() {
            return scale != null ? scale.toBuilder() : null;
        }

        public final void setScale(AxisScale.BuilderImpl scale) {
            this.scale = scale != null ? scale.build() : null;
        }

        @Override
        public final Builder scale(AxisScale scale) {
            this.scale = scale;
            return this;
        }

        public final AxisDisplayRange.Builder getRange() {
            return range != null ? range.toBuilder() : null;
        }

        public final void setRange(AxisDisplayRange.BuilderImpl range) {
            this.range = range != null ? range.build() : null;
        }

        @Override
        public final Builder range(AxisDisplayRange range) {
            this.range = range;
            return this;
        }

        @Override
        public NumericAxisOptions build() {
            return new NumericAxisOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
