/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a <code>HistogramVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HistogramConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<HistogramConfiguration.Builder, HistogramConfiguration> {
    private static final SdkField<HistogramFieldWells> FIELD_WELLS_FIELD = SdkField
            .<HistogramFieldWells> builder(MarshallingType.SDK_POJO).memberName("FieldWells")
            .getter(getter(HistogramConfiguration::fieldWells)).setter(setter(Builder::fieldWells))
            .constructor(HistogramFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()).build();

    private static final SdkField<AxisDisplayOptions> X_AXIS_DISPLAY_OPTIONS_FIELD = SdkField
            .<AxisDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("XAxisDisplayOptions")
            .getter(getter(HistogramConfiguration::xAxisDisplayOptions)).setter(setter(Builder::xAxisDisplayOptions))
            .constructor(AxisDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XAxisDisplayOptions").build())
            .build();

    private static final SdkField<ChartAxisLabelOptions> X_AXIS_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("XAxisLabelOptions")
            .getter(getter(HistogramConfiguration::xAxisLabelOptions)).setter(setter(Builder::xAxisLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XAxisLabelOptions").build()).build();

    private static final SdkField<AxisDisplayOptions> Y_AXIS_DISPLAY_OPTIONS_FIELD = SdkField
            .<AxisDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("YAxisDisplayOptions")
            .getter(getter(HistogramConfiguration::yAxisDisplayOptions)).setter(setter(Builder::yAxisDisplayOptions))
            .constructor(AxisDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("YAxisDisplayOptions").build())
            .build();

    private static final SdkField<HistogramBinOptions> BIN_OPTIONS_FIELD = SdkField
            .<HistogramBinOptions> builder(MarshallingType.SDK_POJO).memberName("BinOptions")
            .getter(getter(HistogramConfiguration::binOptions)).setter(setter(Builder::binOptions))
            .constructor(HistogramBinOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BinOptions").build()).build();

    private static final SdkField<DataLabelOptions> DATA_LABELS_FIELD = SdkField
            .<DataLabelOptions> builder(MarshallingType.SDK_POJO).memberName("DataLabels")
            .getter(getter(HistogramConfiguration::dataLabels)).setter(setter(Builder::dataLabels))
            .constructor(DataLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLabels").build()).build();

    private static final SdkField<TooltipOptions> TOOLTIP_FIELD = SdkField.<TooltipOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Tooltip").getter(getter(HistogramConfiguration::tooltip)).setter(setter(Builder::tooltip))
            .constructor(TooltipOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()).build();

    private static final SdkField<VisualPalette> VISUAL_PALETTE_FIELD = SdkField
            .<VisualPalette> builder(MarshallingType.SDK_POJO).memberName("VisualPalette")
            .getter(getter(HistogramConfiguration::visualPalette)).setter(setter(Builder::visualPalette))
            .constructor(VisualPalette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualPalette").build()).build();

    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField
            .<VisualInteractionOptions> builder(MarshallingType.SDK_POJO).memberName("Interactions")
            .getter(getter(HistogramConfiguration::interactions)).setter(setter(Builder::interactions))
            .constructor(VisualInteractionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD,
            X_AXIS_DISPLAY_OPTIONS_FIELD, X_AXIS_LABEL_OPTIONS_FIELD, Y_AXIS_DISPLAY_OPTIONS_FIELD, BIN_OPTIONS_FIELD,
            DATA_LABELS_FIELD, TOOLTIP_FIELD, VISUAL_PALETTE_FIELD, INTERACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final HistogramFieldWells fieldWells;

    private final AxisDisplayOptions xAxisDisplayOptions;

    private final ChartAxisLabelOptions xAxisLabelOptions;

    private final AxisDisplayOptions yAxisDisplayOptions;

    private final HistogramBinOptions binOptions;

    private final DataLabelOptions dataLabels;

    private final TooltipOptions tooltip;

    private final VisualPalette visualPalette;

    private final VisualInteractionOptions interactions;

    private HistogramConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.xAxisDisplayOptions = builder.xAxisDisplayOptions;
        this.xAxisLabelOptions = builder.xAxisLabelOptions;
        this.yAxisDisplayOptions = builder.yAxisDisplayOptions;
        this.binOptions = builder.binOptions;
        this.dataLabels = builder.dataLabels;
        this.tooltip = builder.tooltip;
        this.visualPalette = builder.visualPalette;
        this.interactions = builder.interactions;
    }

    /**
     * <p>
     * The field well configuration of a histogram.
     * </p>
     * 
     * @return The field well configuration of a histogram.
     */
    public final HistogramFieldWells fieldWells() {
        return fieldWells;
    }

    /**
     * <p>
     * The options that determine the presentation of the x-axis.
     * </p>
     * 
     * @return The options that determine the presentation of the x-axis.
     */
    public final AxisDisplayOptions xAxisDisplayOptions() {
        return xAxisDisplayOptions;
    }

    /**
     * <p>
     * The options that determine the presentation of the x-axis label.
     * </p>
     * 
     * @return The options that determine the presentation of the x-axis label.
     */
    public final ChartAxisLabelOptions xAxisLabelOptions() {
        return xAxisLabelOptions;
    }

    /**
     * <p>
     * The options that determine the presentation of the y-axis.
     * </p>
     * 
     * @return The options that determine the presentation of the y-axis.
     */
    public final AxisDisplayOptions yAxisDisplayOptions() {
        return yAxisDisplayOptions;
    }

    /**
     * <p>
     * The options that determine the presentation of histogram bins.
     * </p>
     * 
     * @return The options that determine the presentation of histogram bins.
     */
    public final HistogramBinOptions binOptions() {
        return binOptions;
    }

    /**
     * <p>
     * The data label configuration of a histogram.
     * </p>
     * 
     * @return The data label configuration of a histogram.
     */
    public final DataLabelOptions dataLabels() {
        return dataLabels;
    }

    /**
     * <p>
     * The tooltip configuration of a histogram.
     * </p>
     * 
     * @return The tooltip configuration of a histogram.
     */
    public final TooltipOptions tooltip() {
        return tooltip;
    }

    /**
     * <p>
     * The visual palette configuration of a histogram.
     * </p>
     * 
     * @return The visual palette configuration of a histogram.
     */
    public final VisualPalette visualPalette() {
        return visualPalette;
    }

    /**
     * <p>
     * The general visual interactions setup for a visual.
     * </p>
     * 
     * @return The general visual interactions setup for a visual.
     */
    public final VisualInteractionOptions interactions() {
        return interactions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(xAxisDisplayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(xAxisLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(yAxisDisplayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(binOptions());
        hashCode = 31 * hashCode + Objects.hashCode(dataLabels());
        hashCode = 31 * hashCode + Objects.hashCode(tooltip());
        hashCode = 31 * hashCode + Objects.hashCode(visualPalette());
        hashCode = 31 * hashCode + Objects.hashCode(interactions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistogramConfiguration)) {
            return false;
        }
        HistogramConfiguration other = (HistogramConfiguration) obj;
        return Objects.equals(fieldWells(), other.fieldWells())
                && Objects.equals(xAxisDisplayOptions(), other.xAxisDisplayOptions())
                && Objects.equals(xAxisLabelOptions(), other.xAxisLabelOptions())
                && Objects.equals(yAxisDisplayOptions(), other.yAxisDisplayOptions())
                && Objects.equals(binOptions(), other.binOptions()) && Objects.equals(dataLabels(), other.dataLabels())
                && Objects.equals(tooltip(), other.tooltip()) && Objects.equals(visualPalette(), other.visualPalette())
                && Objects.equals(interactions(), other.interactions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HistogramConfiguration").add("FieldWells", fieldWells())
                .add("XAxisDisplayOptions", xAxisDisplayOptions()).add("XAxisLabelOptions", xAxisLabelOptions())
                .add("YAxisDisplayOptions", yAxisDisplayOptions()).add("BinOptions", binOptions())
                .add("DataLabels", dataLabels()).add("Tooltip", tooltip()).add("VisualPalette", visualPalette())
                .add("Interactions", interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldWells":
            return Optional.ofNullable(clazz.cast(fieldWells()));
        case "XAxisDisplayOptions":
            return Optional.ofNullable(clazz.cast(xAxisDisplayOptions()));
        case "XAxisLabelOptions":
            return Optional.ofNullable(clazz.cast(xAxisLabelOptions()));
        case "YAxisDisplayOptions":
            return Optional.ofNullable(clazz.cast(yAxisDisplayOptions()));
        case "BinOptions":
            return Optional.ofNullable(clazz.cast(binOptions()));
        case "DataLabels":
            return Optional.ofNullable(clazz.cast(dataLabels()));
        case "Tooltip":
            return Optional.ofNullable(clazz.cast(tooltip()));
        case "VisualPalette":
            return Optional.ofNullable(clazz.cast(visualPalette()));
        case "Interactions":
            return Optional.ofNullable(clazz.cast(interactions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldWells", FIELD_WELLS_FIELD);
        map.put("XAxisDisplayOptions", X_AXIS_DISPLAY_OPTIONS_FIELD);
        map.put("XAxisLabelOptions", X_AXIS_LABEL_OPTIONS_FIELD);
        map.put("YAxisDisplayOptions", Y_AXIS_DISPLAY_OPTIONS_FIELD);
        map.put("BinOptions", BIN_OPTIONS_FIELD);
        map.put("DataLabels", DATA_LABELS_FIELD);
        map.put("Tooltip", TOOLTIP_FIELD);
        map.put("VisualPalette", VISUAL_PALETTE_FIELD);
        map.put("Interactions", INTERACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HistogramConfiguration, T> g) {
        return obj -> g.apply((HistogramConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HistogramConfiguration> {
        /**
         * <p>
         * The field well configuration of a histogram.
         * </p>
         * 
         * @param fieldWells
         *        The field well configuration of a histogram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldWells(HistogramFieldWells fieldWells);

        /**
         * <p>
         * The field well configuration of a histogram.
         * </p>
         * This is a convenience method that creates an instance of the {@link HistogramFieldWells.Builder} avoiding the
         * need to create one manually via {@link HistogramFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HistogramFieldWells.Builder#build()} is called immediately and
         * its result is passed to {@link #fieldWells(HistogramFieldWells)}.
         * 
         * @param fieldWells
         *        a consumer that will call methods on {@link HistogramFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldWells(HistogramFieldWells)
         */
        default Builder fieldWells(Consumer<HistogramFieldWells.Builder> fieldWells) {
            return fieldWells(HistogramFieldWells.builder().applyMutation(fieldWells).build());
        }

        /**
         * <p>
         * The options that determine the presentation of the x-axis.
         * </p>
         * 
         * @param xAxisDisplayOptions
         *        The options that determine the presentation of the x-axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xAxisDisplayOptions(AxisDisplayOptions xAxisDisplayOptions);

        /**
         * <p>
         * The options that determine the presentation of the x-axis.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDisplayOptions.Builder} avoiding the
         * need to create one manually via {@link AxisDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDisplayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #xAxisDisplayOptions(AxisDisplayOptions)}.
         * 
         * @param xAxisDisplayOptions
         *        a consumer that will call methods on {@link AxisDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xAxisDisplayOptions(AxisDisplayOptions)
         */
        default Builder xAxisDisplayOptions(Consumer<AxisDisplayOptions.Builder> xAxisDisplayOptions) {
            return xAxisDisplayOptions(AxisDisplayOptions.builder().applyMutation(xAxisDisplayOptions).build());
        }

        /**
         * <p>
         * The options that determine the presentation of the x-axis label.
         * </p>
         * 
         * @param xAxisLabelOptions
         *        The options that determine the presentation of the x-axis label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xAxisLabelOptions(ChartAxisLabelOptions xAxisLabelOptions);

        /**
         * <p>
         * The options that determine the presentation of the x-axis label.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #xAxisLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param xAxisLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xAxisLabelOptions(ChartAxisLabelOptions)
         */
        default Builder xAxisLabelOptions(Consumer<ChartAxisLabelOptions.Builder> xAxisLabelOptions) {
            return xAxisLabelOptions(ChartAxisLabelOptions.builder().applyMutation(xAxisLabelOptions).build());
        }

        /**
         * <p>
         * The options that determine the presentation of the y-axis.
         * </p>
         * 
         * @param yAxisDisplayOptions
         *        The options that determine the presentation of the y-axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder yAxisDisplayOptions(AxisDisplayOptions yAxisDisplayOptions);

        /**
         * <p>
         * The options that determine the presentation of the y-axis.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDisplayOptions.Builder} avoiding the
         * need to create one manually via {@link AxisDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDisplayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #yAxisDisplayOptions(AxisDisplayOptions)}.
         * 
         * @param yAxisDisplayOptions
         *        a consumer that will call methods on {@link AxisDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #yAxisDisplayOptions(AxisDisplayOptions)
         */
        default Builder yAxisDisplayOptions(Consumer<AxisDisplayOptions.Builder> yAxisDisplayOptions) {
            return yAxisDisplayOptions(AxisDisplayOptions.builder().applyMutation(yAxisDisplayOptions).build());
        }

        /**
         * <p>
         * The options that determine the presentation of histogram bins.
         * </p>
         * 
         * @param binOptions
         *        The options that determine the presentation of histogram bins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder binOptions(HistogramBinOptions binOptions);

        /**
         * <p>
         * The options that determine the presentation of histogram bins.
         * </p>
         * This is a convenience method that creates an instance of the {@link HistogramBinOptions.Builder} avoiding the
         * need to create one manually via {@link HistogramBinOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HistogramBinOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #binOptions(HistogramBinOptions)}.
         * 
         * @param binOptions
         *        a consumer that will call methods on {@link HistogramBinOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #binOptions(HistogramBinOptions)
         */
        default Builder binOptions(Consumer<HistogramBinOptions.Builder> binOptions) {
            return binOptions(HistogramBinOptions.builder().applyMutation(binOptions).build());
        }

        /**
         * <p>
         * The data label configuration of a histogram.
         * </p>
         * 
         * @param dataLabels
         *        The data label configuration of a histogram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLabels(DataLabelOptions dataLabels);

        /**
         * <p>
         * The data label configuration of a histogram.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLabelOptions.Builder} avoiding the
         * need to create one manually via {@link DataLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLabelOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #dataLabels(DataLabelOptions)}.
         * 
         * @param dataLabels
         *        a consumer that will call methods on {@link DataLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataLabels(DataLabelOptions)
         */
        default Builder dataLabels(Consumer<DataLabelOptions.Builder> dataLabels) {
            return dataLabels(DataLabelOptions.builder().applyMutation(dataLabels).build());
        }

        /**
         * <p>
         * The tooltip configuration of a histogram.
         * </p>
         * 
         * @param tooltip
         *        The tooltip configuration of a histogram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooltip(TooltipOptions tooltip);

        /**
         * <p>
         * The tooltip configuration of a histogram.
         * </p>
         * This is a convenience method that creates an instance of the {@link TooltipOptions.Builder} avoiding the need
         * to create one manually via {@link TooltipOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TooltipOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #tooltip(TooltipOptions)}.
         * 
         * @param tooltip
         *        a consumer that will call methods on {@link TooltipOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tooltip(TooltipOptions)
         */
        default Builder tooltip(Consumer<TooltipOptions.Builder> tooltip) {
            return tooltip(TooltipOptions.builder().applyMutation(tooltip).build());
        }

        /**
         * <p>
         * The visual palette configuration of a histogram.
         * </p>
         * 
         * @param visualPalette
         *        The visual palette configuration of a histogram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualPalette(VisualPalette visualPalette);

        /**
         * <p>
         * The visual palette configuration of a histogram.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualPalette.Builder} avoiding the need
         * to create one manually via {@link VisualPalette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualPalette.Builder#build()} is called immediately and its
         * result is passed to {@link #visualPalette(VisualPalette)}.
         * 
         * @param visualPalette
         *        a consumer that will call methods on {@link VisualPalette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visualPalette(VisualPalette)
         */
        default Builder visualPalette(Consumer<VisualPalette.Builder> visualPalette) {
            return visualPalette(VisualPalette.builder().applyMutation(visualPalette).build());
        }

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * 
         * @param interactions
         *        The general visual interactions setup for a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactions(VisualInteractionOptions interactions);

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualInteractionOptions.Builder}
         * avoiding the need to create one manually via {@link VisualInteractionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualInteractionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #interactions(VisualInteractionOptions)}.
         * 
         * @param interactions
         *        a consumer that will call methods on {@link VisualInteractionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interactions(VisualInteractionOptions)
         */
        default Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return interactions(VisualInteractionOptions.builder().applyMutation(interactions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HistogramFieldWells fieldWells;

        private AxisDisplayOptions xAxisDisplayOptions;

        private ChartAxisLabelOptions xAxisLabelOptions;

        private AxisDisplayOptions yAxisDisplayOptions;

        private HistogramBinOptions binOptions;

        private DataLabelOptions dataLabels;

        private TooltipOptions tooltip;

        private VisualPalette visualPalette;

        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(HistogramConfiguration model) {
            fieldWells(model.fieldWells);
            xAxisDisplayOptions(model.xAxisDisplayOptions);
            xAxisLabelOptions(model.xAxisLabelOptions);
            yAxisDisplayOptions(model.yAxisDisplayOptions);
            binOptions(model.binOptions);
            dataLabels(model.dataLabels);
            tooltip(model.tooltip);
            visualPalette(model.visualPalette);
            interactions(model.interactions);
        }

        public final HistogramFieldWells.Builder getFieldWells() {
            return fieldWells != null ? fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(HistogramFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(HistogramFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final AxisDisplayOptions.Builder getXAxisDisplayOptions() {
            return xAxisDisplayOptions != null ? xAxisDisplayOptions.toBuilder() : null;
        }

        public final void setXAxisDisplayOptions(AxisDisplayOptions.BuilderImpl xAxisDisplayOptions) {
            this.xAxisDisplayOptions = xAxisDisplayOptions != null ? xAxisDisplayOptions.build() : null;
        }

        @Override
        public final Builder xAxisDisplayOptions(AxisDisplayOptions xAxisDisplayOptions) {
            this.xAxisDisplayOptions = xAxisDisplayOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getXAxisLabelOptions() {
            return xAxisLabelOptions != null ? xAxisLabelOptions.toBuilder() : null;
        }

        public final void setXAxisLabelOptions(ChartAxisLabelOptions.BuilderImpl xAxisLabelOptions) {
            this.xAxisLabelOptions = xAxisLabelOptions != null ? xAxisLabelOptions.build() : null;
        }

        @Override
        public final Builder xAxisLabelOptions(ChartAxisLabelOptions xAxisLabelOptions) {
            this.xAxisLabelOptions = xAxisLabelOptions;
            return this;
        }

        public final AxisDisplayOptions.Builder getYAxisDisplayOptions() {
            return yAxisDisplayOptions != null ? yAxisDisplayOptions.toBuilder() : null;
        }

        public final void setYAxisDisplayOptions(AxisDisplayOptions.BuilderImpl yAxisDisplayOptions) {
            this.yAxisDisplayOptions = yAxisDisplayOptions != null ? yAxisDisplayOptions.build() : null;
        }

        @Override
        public final Builder yAxisDisplayOptions(AxisDisplayOptions yAxisDisplayOptions) {
            this.yAxisDisplayOptions = yAxisDisplayOptions;
            return this;
        }

        public final HistogramBinOptions.Builder getBinOptions() {
            return binOptions != null ? binOptions.toBuilder() : null;
        }

        public final void setBinOptions(HistogramBinOptions.BuilderImpl binOptions) {
            this.binOptions = binOptions != null ? binOptions.build() : null;
        }

        @Override
        public final Builder binOptions(HistogramBinOptions binOptions) {
            this.binOptions = binOptions;
            return this;
        }

        public final DataLabelOptions.Builder getDataLabels() {
            return dataLabels != null ? dataLabels.toBuilder() : null;
        }

        public final void setDataLabels(DataLabelOptions.BuilderImpl dataLabels) {
            this.dataLabels = dataLabels != null ? dataLabels.build() : null;
        }

        @Override
        public final Builder dataLabels(DataLabelOptions dataLabels) {
            this.dataLabels = dataLabels;
            return this;
        }

        public final TooltipOptions.Builder getTooltip() {
            return tooltip != null ? tooltip.toBuilder() : null;
        }

        public final void setTooltip(TooltipOptions.BuilderImpl tooltip) {
            this.tooltip = tooltip != null ? tooltip.build() : null;
        }

        @Override
        public final Builder tooltip(TooltipOptions tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public final VisualPalette.Builder getVisualPalette() {
            return visualPalette != null ? visualPalette.toBuilder() : null;
        }

        public final void setVisualPalette(VisualPalette.BuilderImpl visualPalette) {
            this.visualPalette = visualPalette != null ? visualPalette.build() : null;
        }

        @Override
        public final Builder visualPalette(VisualPalette visualPalette) {
            this.visualPalette = visualPalette;
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return interactions != null ? interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        @Override
        public HistogramConfiguration build() {
            return new HistogramConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
