/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The visualization style for a line layer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialLineStyle implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialLineStyle.Builder, GeospatialLineStyle> {
    private static final SdkField<GeospatialLineSymbolStyle> LINE_SYMBOL_STYLE_FIELD = SdkField
            .<GeospatialLineSymbolStyle> builder(MarshallingType.SDK_POJO).memberName("LineSymbolStyle")
            .getter(getter(GeospatialLineStyle::lineSymbolStyle)).setter(setter(Builder::lineSymbolStyle))
            .constructor(GeospatialLineSymbolStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineSymbolStyle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINE_SYMBOL_STYLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GeospatialLineSymbolStyle lineSymbolStyle;

    private GeospatialLineStyle(BuilderImpl builder) {
        this.lineSymbolStyle = builder.lineSymbolStyle;
    }

    /**
     * <p>
     * The symbol style for a line style.
     * </p>
     * 
     * @return The symbol style for a line style.
     */
    public final GeospatialLineSymbolStyle lineSymbolStyle() {
        return lineSymbolStyle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lineSymbolStyle());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialLineStyle)) {
            return false;
        }
        GeospatialLineStyle other = (GeospatialLineStyle) obj;
        return Objects.equals(lineSymbolStyle(), other.lineSymbolStyle());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialLineStyle").add("LineSymbolStyle", lineSymbolStyle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LineSymbolStyle":
            return Optional.ofNullable(clazz.cast(lineSymbolStyle()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LineSymbolStyle", LINE_SYMBOL_STYLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialLineStyle, T> g) {
        return obj -> g.apply((GeospatialLineStyle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialLineStyle> {
        /**
         * <p>
         * The symbol style for a line style.
         * </p>
         * 
         * @param lineSymbolStyle
         *        The symbol style for a line style.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineSymbolStyle(GeospatialLineSymbolStyle lineSymbolStyle);

        /**
         * <p>
         * The symbol style for a line style.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialLineSymbolStyle.Builder}
         * avoiding the need to create one manually via {@link GeospatialLineSymbolStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialLineSymbolStyle.Builder#build()} is called immediately
         * and its result is passed to {@link #lineSymbolStyle(GeospatialLineSymbolStyle)}.
         * 
         * @param lineSymbolStyle
         *        a consumer that will call methods on {@link GeospatialLineSymbolStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineSymbolStyle(GeospatialLineSymbolStyle)
         */
        default Builder lineSymbolStyle(Consumer<GeospatialLineSymbolStyle.Builder> lineSymbolStyle) {
            return lineSymbolStyle(GeospatialLineSymbolStyle.builder().applyMutation(lineSymbolStyle).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GeospatialLineSymbolStyle lineSymbolStyle;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialLineStyle model) {
            lineSymbolStyle(model.lineSymbolStyle);
        }

        public final GeospatialLineSymbolStyle.Builder getLineSymbolStyle() {
            return lineSymbolStyle != null ? lineSymbolStyle.toBuilder() : null;
        }

        public final void setLineSymbolStyle(GeospatialLineSymbolStyle.BuilderImpl lineSymbolStyle) {
            this.lineSymbolStyle = lineSymbolStyle != null ? lineSymbolStyle.build() : null;
        }

        @Override
        public final Builder lineSymbolStyle(GeospatialLineSymbolStyle lineSymbolStyle) {
            this.lineSymbolStyle = lineSymbolStyle;
            return this;
        }

        @Override
        public GeospatialLineStyle build() {
            return new GeospatialLineStyle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
