/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field well configuration of a <code>FunnelChartVisual</code>.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FunnelChartFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<FunnelChartFieldWells.Builder, FunnelChartFieldWells> {
    private static final SdkField<FunnelChartAggregatedFieldWells> FUNNEL_CHART_AGGREGATED_FIELD_WELLS_FIELD = SdkField
            .<FunnelChartAggregatedFieldWells> builder(MarshallingType.SDK_POJO)
            .memberName("FunnelChartAggregatedFieldWells")
            .getter(getter(FunnelChartFieldWells::funnelChartAggregatedFieldWells))
            .setter(setter(Builder::funnelChartAggregatedFieldWells))
            .constructor(FunnelChartAggregatedFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunnelChartAggregatedFieldWells")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FUNNEL_CHART_AGGREGATED_FIELD_WELLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FunnelChartAggregatedFieldWells funnelChartAggregatedFieldWells;

    private FunnelChartFieldWells(BuilderImpl builder) {
        this.funnelChartAggregatedFieldWells = builder.funnelChartAggregatedFieldWells;
    }

    /**
     * <p>
     * The field well configuration of a <code>FunnelChartVisual</code>.
     * </p>
     * 
     * @return The field well configuration of a <code>FunnelChartVisual</code>.
     */
    public final FunnelChartAggregatedFieldWells funnelChartAggregatedFieldWells() {
        return funnelChartAggregatedFieldWells;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(funnelChartAggregatedFieldWells());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunnelChartFieldWells)) {
            return false;
        }
        FunnelChartFieldWells other = (FunnelChartFieldWells) obj;
        return Objects.equals(funnelChartAggregatedFieldWells(), other.funnelChartAggregatedFieldWells());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FunnelChartFieldWells")
                .add("FunnelChartAggregatedFieldWells", funnelChartAggregatedFieldWells()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunnelChartAggregatedFieldWells":
            return Optional.ofNullable(clazz.cast(funnelChartAggregatedFieldWells()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FunnelChartAggregatedFieldWells", FUNNEL_CHART_AGGREGATED_FIELD_WELLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FunnelChartFieldWells, T> g) {
        return obj -> g.apply((FunnelChartFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FunnelChartFieldWells> {
        /**
         * <p>
         * The field well configuration of a <code>FunnelChartVisual</code>.
         * </p>
         * 
         * @param funnelChartAggregatedFieldWells
         *        The field well configuration of a <code>FunnelChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder funnelChartAggregatedFieldWells(FunnelChartAggregatedFieldWells funnelChartAggregatedFieldWells);

        /**
         * <p>
         * The field well configuration of a <code>FunnelChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link FunnelChartAggregatedFieldWells.Builder}
         * avoiding the need to create one manually via {@link FunnelChartAggregatedFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FunnelChartAggregatedFieldWells.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #funnelChartAggregatedFieldWells(FunnelChartAggregatedFieldWells)}.
         * 
         * @param funnelChartAggregatedFieldWells
         *        a consumer that will call methods on {@link FunnelChartAggregatedFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #funnelChartAggregatedFieldWells(FunnelChartAggregatedFieldWells)
         */
        default Builder funnelChartAggregatedFieldWells(
                Consumer<FunnelChartAggregatedFieldWells.Builder> funnelChartAggregatedFieldWells) {
            return funnelChartAggregatedFieldWells(FunnelChartAggregatedFieldWells.builder()
                    .applyMutation(funnelChartAggregatedFieldWells).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FunnelChartAggregatedFieldWells funnelChartAggregatedFieldWells;

        private BuilderImpl() {
        }

        private BuilderImpl(FunnelChartFieldWells model) {
            funnelChartAggregatedFieldWells(model.funnelChartAggregatedFieldWells);
        }

        public final FunnelChartAggregatedFieldWells.Builder getFunnelChartAggregatedFieldWells() {
            return funnelChartAggregatedFieldWells != null ? funnelChartAggregatedFieldWells.toBuilder() : null;
        }

        public final void setFunnelChartAggregatedFieldWells(
                FunnelChartAggregatedFieldWells.BuilderImpl funnelChartAggregatedFieldWells) {
            this.funnelChartAggregatedFieldWells = funnelChartAggregatedFieldWells != null ? funnelChartAggregatedFieldWells
                    .build() : null;
        }

        @Override
        public final Builder funnelChartAggregatedFieldWells(FunnelChartAggregatedFieldWells funnelChartAggregatedFieldWells) {
            this.funnelChartAggregatedFieldWells = funnelChartAggregatedFieldWells;
            return this;
        }

        @Override
        public FunnelChartFieldWells build() {
            return new FunnelChartFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
