/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents additional options for display formatting.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisplayFormatOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DisplayFormatOptions.Builder, DisplayFormatOptions> {
    private static final SdkField<Boolean> USE_BLANK_CELL_FORMAT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseBlankCellFormat").getter(getter(DisplayFormatOptions::useBlankCellFormat))
            .setter(setter(Builder::useBlankCellFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseBlankCellFormat").build())
            .build();

    private static final SdkField<String> BLANK_CELL_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BlankCellFormat").getter(getter(DisplayFormatOptions::blankCellFormat))
            .setter(setter(Builder::blankCellFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlankCellFormat").build()).build();

    private static final SdkField<String> DATE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DateFormat").getter(getter(DisplayFormatOptions::dateFormat)).setter(setter(Builder::dateFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateFormat").build()).build();

    private static final SdkField<String> DECIMAL_SEPARATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DecimalSeparator").getter(getter(DisplayFormatOptions::decimalSeparatorAsString))
            .setter(setter(Builder::decimalSeparator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecimalSeparator").build()).build();

    private static final SdkField<String> GROUPING_SEPARATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupingSeparator").getter(getter(DisplayFormatOptions::groupingSeparator))
            .setter(setter(Builder::groupingSeparator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupingSeparator").build()).build();

    private static final SdkField<Boolean> USE_GROUPING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseGrouping").getter(getter(DisplayFormatOptions::useGrouping)).setter(setter(Builder::useGrouping))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseGrouping").build()).build();

    private static final SdkField<Integer> FRACTION_DIGITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FractionDigits").getter(getter(DisplayFormatOptions::fractionDigits))
            .setter(setter(Builder::fractionDigits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FractionDigits").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Prefix")
            .getter(getter(DisplayFormatOptions::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()).build();

    private static final SdkField<String> SUFFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Suffix")
            .getter(getter(DisplayFormatOptions::suffix)).setter(setter(Builder::suffix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Suffix").build()).build();

    private static final SdkField<String> UNIT_SCALER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UnitScaler").getter(getter(DisplayFormatOptions::unitScalerAsString))
            .setter(setter(Builder::unitScaler))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnitScaler").build()).build();

    private static final SdkField<NegativeFormat> NEGATIVE_FORMAT_FIELD = SdkField
            .<NegativeFormat> builder(MarshallingType.SDK_POJO).memberName("NegativeFormat")
            .getter(getter(DisplayFormatOptions::negativeFormat)).setter(setter(Builder::negativeFormat))
            .constructor(NegativeFormat::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NegativeFormat").build()).build();

    private static final SdkField<String> CURRENCY_SYMBOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencySymbol").getter(getter(DisplayFormatOptions::currencySymbol))
            .setter(setter(Builder::currencySymbol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencySymbol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USE_BLANK_CELL_FORMAT_FIELD,
            BLANK_CELL_FORMAT_FIELD, DATE_FORMAT_FIELD, DECIMAL_SEPARATOR_FIELD, GROUPING_SEPARATOR_FIELD, USE_GROUPING_FIELD,
            FRACTION_DIGITS_FIELD, PREFIX_FIELD, SUFFIX_FIELD, UNIT_SCALER_FIELD, NEGATIVE_FORMAT_FIELD, CURRENCY_SYMBOL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean useBlankCellFormat;

    private final String blankCellFormat;

    private final String dateFormat;

    private final String decimalSeparator;

    private final String groupingSeparator;

    private final Boolean useGrouping;

    private final Integer fractionDigits;

    private final String prefix;

    private final String suffix;

    private final String unitScaler;

    private final NegativeFormat negativeFormat;

    private final String currencySymbol;

    private DisplayFormatOptions(BuilderImpl builder) {
        this.useBlankCellFormat = builder.useBlankCellFormat;
        this.blankCellFormat = builder.blankCellFormat;
        this.dateFormat = builder.dateFormat;
        this.decimalSeparator = builder.decimalSeparator;
        this.groupingSeparator = builder.groupingSeparator;
        this.useGrouping = builder.useGrouping;
        this.fractionDigits = builder.fractionDigits;
        this.prefix = builder.prefix;
        this.suffix = builder.suffix;
        this.unitScaler = builder.unitScaler;
        this.negativeFormat = builder.negativeFormat;
        this.currencySymbol = builder.currencySymbol;
    }

    /**
     * <p>
     * A Boolean value that indicates whether to use blank cell format.
     * </p>
     * 
     * @return A Boolean value that indicates whether to use blank cell format.
     */
    public final Boolean useBlankCellFormat() {
        return useBlankCellFormat;
    }

    /**
     * <p>
     * Determines the blank cell format.
     * </p>
     * 
     * @return Determines the blank cell format.
     */
    public final String blankCellFormat() {
        return blankCellFormat;
    }

    /**
     * <p>
     * Determines the <code>DateTime</code> format.
     * </p>
     * 
     * @return Determines the <code>DateTime</code> format.
     */
    public final String dateFormat() {
        return dateFormat;
    }

    /**
     * <p>
     * Determines the decimal separator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #decimalSeparator}
     * will return {@link TopicNumericSeparatorSymbol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #decimalSeparatorAsString}.
     * </p>
     * 
     * @return Determines the decimal separator.
     * @see TopicNumericSeparatorSymbol
     */
    public final TopicNumericSeparatorSymbol decimalSeparator() {
        return TopicNumericSeparatorSymbol.fromValue(decimalSeparator);
    }

    /**
     * <p>
     * Determines the decimal separator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #decimalSeparator}
     * will return {@link TopicNumericSeparatorSymbol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #decimalSeparatorAsString}.
     * </p>
     * 
     * @return Determines the decimal separator.
     * @see TopicNumericSeparatorSymbol
     */
    public final String decimalSeparatorAsString() {
        return decimalSeparator;
    }

    /**
     * <p>
     * Determines the grouping separator.
     * </p>
     * 
     * @return Determines the grouping separator.
     */
    public final String groupingSeparator() {
        return groupingSeparator;
    }

    /**
     * <p>
     * A Boolean value that indicates whether to use grouping.
     * </p>
     * 
     * @return A Boolean value that indicates whether to use grouping.
     */
    public final Boolean useGrouping() {
        return useGrouping;
    }

    /**
     * <p>
     * Determines the number of fraction digits.
     * </p>
     * 
     * @return Determines the number of fraction digits.
     */
    public final Integer fractionDigits() {
        return fractionDigits;
    }

    /**
     * <p>
     * The prefix value for a display format.
     * </p>
     * 
     * @return The prefix value for a display format.
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * <p>
     * The suffix value for a display format.
     * </p>
     * 
     * @return The suffix value for a display format.
     */
    public final String suffix() {
        return suffix;
    }

    /**
     * <p>
     * The unit scaler. Valid values for this structure are: <code>NONE</code>, <code>AUTO</code>,
     * <code>THOUSANDS</code>, <code>MILLIONS</code>, <code>BILLIONS</code>, and <code>TRILLIONS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unitScaler} will
     * return {@link NumberScale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitScalerAsString}.
     * </p>
     * 
     * @return The unit scaler. Valid values for this structure are: <code>NONE</code>, <code>AUTO</code>,
     *         <code>THOUSANDS</code>, <code>MILLIONS</code>, <code>BILLIONS</code>, and <code>TRILLIONS</code>.
     * @see NumberScale
     */
    public final NumberScale unitScaler() {
        return NumberScale.fromValue(unitScaler);
    }

    /**
     * <p>
     * The unit scaler. Valid values for this structure are: <code>NONE</code>, <code>AUTO</code>,
     * <code>THOUSANDS</code>, <code>MILLIONS</code>, <code>BILLIONS</code>, and <code>TRILLIONS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unitScaler} will
     * return {@link NumberScale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitScalerAsString}.
     * </p>
     * 
     * @return The unit scaler. Valid values for this structure are: <code>NONE</code>, <code>AUTO</code>,
     *         <code>THOUSANDS</code>, <code>MILLIONS</code>, <code>BILLIONS</code>, and <code>TRILLIONS</code>.
     * @see NumberScale
     */
    public final String unitScalerAsString() {
        return unitScaler;
    }

    /**
     * <p>
     * The negative format.
     * </p>
     * 
     * @return The negative format.
     */
    public final NegativeFormat negativeFormat() {
        return negativeFormat;
    }

    /**
     * <p>
     * The currency symbol, such as <code>USD</code>.
     * </p>
     * 
     * @return The currency symbol, such as <code>USD</code>.
     */
    public final String currencySymbol() {
        return currencySymbol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(useBlankCellFormat());
        hashCode = 31 * hashCode + Objects.hashCode(blankCellFormat());
        hashCode = 31 * hashCode + Objects.hashCode(dateFormat());
        hashCode = 31 * hashCode + Objects.hashCode(decimalSeparatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(groupingSeparator());
        hashCode = 31 * hashCode + Objects.hashCode(useGrouping());
        hashCode = 31 * hashCode + Objects.hashCode(fractionDigits());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(suffix());
        hashCode = 31 * hashCode + Objects.hashCode(unitScalerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(negativeFormat());
        hashCode = 31 * hashCode + Objects.hashCode(currencySymbol());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisplayFormatOptions)) {
            return false;
        }
        DisplayFormatOptions other = (DisplayFormatOptions) obj;
        return Objects.equals(useBlankCellFormat(), other.useBlankCellFormat())
                && Objects.equals(blankCellFormat(), other.blankCellFormat()) && Objects.equals(dateFormat(), other.dateFormat())
                && Objects.equals(decimalSeparatorAsString(), other.decimalSeparatorAsString())
                && Objects.equals(groupingSeparator(), other.groupingSeparator())
                && Objects.equals(useGrouping(), other.useGrouping()) && Objects.equals(fractionDigits(), other.fractionDigits())
                && Objects.equals(prefix(), other.prefix()) && Objects.equals(suffix(), other.suffix())
                && Objects.equals(unitScalerAsString(), other.unitScalerAsString())
                && Objects.equals(negativeFormat(), other.negativeFormat())
                && Objects.equals(currencySymbol(), other.currencySymbol());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisplayFormatOptions").add("UseBlankCellFormat", useBlankCellFormat())
                .add("BlankCellFormat", blankCellFormat()).add("DateFormat", dateFormat())
                .add("DecimalSeparator", decimalSeparatorAsString()).add("GroupingSeparator", groupingSeparator())
                .add("UseGrouping", useGrouping()).add("FractionDigits", fractionDigits()).add("Prefix", prefix())
                .add("Suffix", suffix()).add("UnitScaler", unitScalerAsString()).add("NegativeFormat", negativeFormat())
                .add("CurrencySymbol", currencySymbol()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UseBlankCellFormat":
            return Optional.ofNullable(clazz.cast(useBlankCellFormat()));
        case "BlankCellFormat":
            return Optional.ofNullable(clazz.cast(blankCellFormat()));
        case "DateFormat":
            return Optional.ofNullable(clazz.cast(dateFormat()));
        case "DecimalSeparator":
            return Optional.ofNullable(clazz.cast(decimalSeparatorAsString()));
        case "GroupingSeparator":
            return Optional.ofNullable(clazz.cast(groupingSeparator()));
        case "UseGrouping":
            return Optional.ofNullable(clazz.cast(useGrouping()));
        case "FractionDigits":
            return Optional.ofNullable(clazz.cast(fractionDigits()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "Suffix":
            return Optional.ofNullable(clazz.cast(suffix()));
        case "UnitScaler":
            return Optional.ofNullable(clazz.cast(unitScalerAsString()));
        case "NegativeFormat":
            return Optional.ofNullable(clazz.cast(negativeFormat()));
        case "CurrencySymbol":
            return Optional.ofNullable(clazz.cast(currencySymbol()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UseBlankCellFormat", USE_BLANK_CELL_FORMAT_FIELD);
        map.put("BlankCellFormat", BLANK_CELL_FORMAT_FIELD);
        map.put("DateFormat", DATE_FORMAT_FIELD);
        map.put("DecimalSeparator", DECIMAL_SEPARATOR_FIELD);
        map.put("GroupingSeparator", GROUPING_SEPARATOR_FIELD);
        map.put("UseGrouping", USE_GROUPING_FIELD);
        map.put("FractionDigits", FRACTION_DIGITS_FIELD);
        map.put("Prefix", PREFIX_FIELD);
        map.put("Suffix", SUFFIX_FIELD);
        map.put("UnitScaler", UNIT_SCALER_FIELD);
        map.put("NegativeFormat", NEGATIVE_FORMAT_FIELD);
        map.put("CurrencySymbol", CURRENCY_SYMBOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisplayFormatOptions, T> g) {
        return obj -> g.apply((DisplayFormatOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DisplayFormatOptions> {
        /**
         * <p>
         * A Boolean value that indicates whether to use blank cell format.
         * </p>
         * 
         * @param useBlankCellFormat
         *        A Boolean value that indicates whether to use blank cell format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useBlankCellFormat(Boolean useBlankCellFormat);

        /**
         * <p>
         * Determines the blank cell format.
         * </p>
         * 
         * @param blankCellFormat
         *        Determines the blank cell format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blankCellFormat(String blankCellFormat);

        /**
         * <p>
         * Determines the <code>DateTime</code> format.
         * </p>
         * 
         * @param dateFormat
         *        Determines the <code>DateTime</code> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateFormat(String dateFormat);

        /**
         * <p>
         * Determines the decimal separator.
         * </p>
         * 
         * @param decimalSeparator
         *        Determines the decimal separator.
         * @see TopicNumericSeparatorSymbol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicNumericSeparatorSymbol
         */
        Builder decimalSeparator(String decimalSeparator);

        /**
         * <p>
         * Determines the decimal separator.
         * </p>
         * 
         * @param decimalSeparator
         *        Determines the decimal separator.
         * @see TopicNumericSeparatorSymbol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicNumericSeparatorSymbol
         */
        Builder decimalSeparator(TopicNumericSeparatorSymbol decimalSeparator);

        /**
         * <p>
         * Determines the grouping separator.
         * </p>
         * 
         * @param groupingSeparator
         *        Determines the grouping separator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingSeparator(String groupingSeparator);

        /**
         * <p>
         * A Boolean value that indicates whether to use grouping.
         * </p>
         * 
         * @param useGrouping
         *        A Boolean value that indicates whether to use grouping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useGrouping(Boolean useGrouping);

        /**
         * <p>
         * Determines the number of fraction digits.
         * </p>
         * 
         * @param fractionDigits
         *        Determines the number of fraction digits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fractionDigits(Integer fractionDigits);

        /**
         * <p>
         * The prefix value for a display format.
         * </p>
         * 
         * @param prefix
         *        The prefix value for a display format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * The suffix value for a display format.
         * </p>
         * 
         * @param suffix
         *        The suffix value for a display format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suffix(String suffix);

        /**
         * <p>
         * The unit scaler. Valid values for this structure are: <code>NONE</code>, <code>AUTO</code>,
         * <code>THOUSANDS</code>, <code>MILLIONS</code>, <code>BILLIONS</code>, and <code>TRILLIONS</code>.
         * </p>
         * 
         * @param unitScaler
         *        The unit scaler. Valid values for this structure are: <code>NONE</code>, <code>AUTO</code>,
         *        <code>THOUSANDS</code>, <code>MILLIONS</code>, <code>BILLIONS</code>, and <code>TRILLIONS</code>.
         * @see NumberScale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumberScale
         */
        Builder unitScaler(String unitScaler);

        /**
         * <p>
         * The unit scaler. Valid values for this structure are: <code>NONE</code>, <code>AUTO</code>,
         * <code>THOUSANDS</code>, <code>MILLIONS</code>, <code>BILLIONS</code>, and <code>TRILLIONS</code>.
         * </p>
         * 
         * @param unitScaler
         *        The unit scaler. Valid values for this structure are: <code>NONE</code>, <code>AUTO</code>,
         *        <code>THOUSANDS</code>, <code>MILLIONS</code>, <code>BILLIONS</code>, and <code>TRILLIONS</code>.
         * @see NumberScale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumberScale
         */
        Builder unitScaler(NumberScale unitScaler);

        /**
         * <p>
         * The negative format.
         * </p>
         * 
         * @param negativeFormat
         *        The negative format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder negativeFormat(NegativeFormat negativeFormat);

        /**
         * <p>
         * The negative format.
         * </p>
         * This is a convenience method that creates an instance of the {@link NegativeFormat.Builder} avoiding the need
         * to create one manually via {@link NegativeFormat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NegativeFormat.Builder#build()} is called immediately and its
         * result is passed to {@link #negativeFormat(NegativeFormat)}.
         * 
         * @param negativeFormat
         *        a consumer that will call methods on {@link NegativeFormat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #negativeFormat(NegativeFormat)
         */
        default Builder negativeFormat(Consumer<NegativeFormat.Builder> negativeFormat) {
            return negativeFormat(NegativeFormat.builder().applyMutation(negativeFormat).build());
        }

        /**
         * <p>
         * The currency symbol, such as <code>USD</code>.
         * </p>
         * 
         * @param currencySymbol
         *        The currency symbol, such as <code>USD</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencySymbol(String currencySymbol);
    }

    static final class BuilderImpl implements Builder {
        private Boolean useBlankCellFormat;

        private String blankCellFormat;

        private String dateFormat;

        private String decimalSeparator;

        private String groupingSeparator;

        private Boolean useGrouping;

        private Integer fractionDigits;

        private String prefix;

        private String suffix;

        private String unitScaler;

        private NegativeFormat negativeFormat;

        private String currencySymbol;

        private BuilderImpl() {
        }

        private BuilderImpl(DisplayFormatOptions model) {
            useBlankCellFormat(model.useBlankCellFormat);
            blankCellFormat(model.blankCellFormat);
            dateFormat(model.dateFormat);
            decimalSeparator(model.decimalSeparator);
            groupingSeparator(model.groupingSeparator);
            useGrouping(model.useGrouping);
            fractionDigits(model.fractionDigits);
            prefix(model.prefix);
            suffix(model.suffix);
            unitScaler(model.unitScaler);
            negativeFormat(model.negativeFormat);
            currencySymbol(model.currencySymbol);
        }

        public final Boolean getUseBlankCellFormat() {
            return useBlankCellFormat;
        }

        public final void setUseBlankCellFormat(Boolean useBlankCellFormat) {
            this.useBlankCellFormat = useBlankCellFormat;
        }

        @Override
        public final Builder useBlankCellFormat(Boolean useBlankCellFormat) {
            this.useBlankCellFormat = useBlankCellFormat;
            return this;
        }

        public final String getBlankCellFormat() {
            return blankCellFormat;
        }

        public final void setBlankCellFormat(String blankCellFormat) {
            this.blankCellFormat = blankCellFormat;
        }

        @Override
        public final Builder blankCellFormat(String blankCellFormat) {
            this.blankCellFormat = blankCellFormat;
            return this;
        }

        public final String getDateFormat() {
            return dateFormat;
        }

        public final void setDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public final Builder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public final String getDecimalSeparator() {
            return decimalSeparator;
        }

        public final void setDecimalSeparator(String decimalSeparator) {
            this.decimalSeparator = decimalSeparator;
        }

        @Override
        public final Builder decimalSeparator(String decimalSeparator) {
            this.decimalSeparator = decimalSeparator;
            return this;
        }

        @Override
        public final Builder decimalSeparator(TopicNumericSeparatorSymbol decimalSeparator) {
            this.decimalSeparator(decimalSeparator == null ? null : decimalSeparator.toString());
            return this;
        }

        public final String getGroupingSeparator() {
            return groupingSeparator;
        }

        public final void setGroupingSeparator(String groupingSeparator) {
            this.groupingSeparator = groupingSeparator;
        }

        @Override
        public final Builder groupingSeparator(String groupingSeparator) {
            this.groupingSeparator = groupingSeparator;
            return this;
        }

        public final Boolean getUseGrouping() {
            return useGrouping;
        }

        public final void setUseGrouping(Boolean useGrouping) {
            this.useGrouping = useGrouping;
        }

        @Override
        public final Builder useGrouping(Boolean useGrouping) {
            this.useGrouping = useGrouping;
            return this;
        }

        public final Integer getFractionDigits() {
            return fractionDigits;
        }

        public final void setFractionDigits(Integer fractionDigits) {
            this.fractionDigits = fractionDigits;
        }

        @Override
        public final Builder fractionDigits(Integer fractionDigits) {
            this.fractionDigits = fractionDigits;
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getSuffix() {
            return suffix;
        }

        public final void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public final Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public final String getUnitScaler() {
            return unitScaler;
        }

        public final void setUnitScaler(String unitScaler) {
            this.unitScaler = unitScaler;
        }

        @Override
        public final Builder unitScaler(String unitScaler) {
            this.unitScaler = unitScaler;
            return this;
        }

        @Override
        public final Builder unitScaler(NumberScale unitScaler) {
            this.unitScaler(unitScaler == null ? null : unitScaler.toString());
            return this;
        }

        public final NegativeFormat.Builder getNegativeFormat() {
            return negativeFormat != null ? negativeFormat.toBuilder() : null;
        }

        public final void setNegativeFormat(NegativeFormat.BuilderImpl negativeFormat) {
            this.negativeFormat = negativeFormat != null ? negativeFormat.build() : null;
        }

        @Override
        public final Builder negativeFormat(NegativeFormat negativeFormat) {
            this.negativeFormat = negativeFormat;
            return this;
        }

        public final String getCurrencySymbol() {
            return currencySymbol;
        }

        public final void setCurrencySymbol(String currencySymbol) {
            this.currencySymbol = currencySymbol;
        }

        @Override
        public final Builder currencySymbol(String currencySymbol) {
            this.currencySymbol = currencySymbol;
            return this;
        }

        @Override
        public DisplayFormatOptions build() {
            return new DisplayFormatOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
