/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that determine how a date axis is displayed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateAxisOptions implements SdkPojo, Serializable, ToCopyableBuilder<DateAxisOptions.Builder, DateAxisOptions> {
    private static final SdkField<String> MISSING_DATE_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MissingDateVisibility").getter(getter(DateAxisOptions::missingDateVisibilityAsString))
            .setter(setter(Builder::missingDateVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingDateVisibility").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(MISSING_DATE_VISIBILITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String missingDateVisibility;

    private DateAxisOptions(BuilderImpl builder) {
        this.missingDateVisibility = builder.missingDateVisibility;
    }

    /**
     * <p>
     * Determines whether or not missing dates are displayed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #missingDateVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #missingDateVisibilityAsString}.
     * </p>
     * 
     * @return Determines whether or not missing dates are displayed.
     * @see Visibility
     */
    public final Visibility missingDateVisibility() {
        return Visibility.fromValue(missingDateVisibility);
    }

    /**
     * <p>
     * Determines whether or not missing dates are displayed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #missingDateVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #missingDateVisibilityAsString}.
     * </p>
     * 
     * @return Determines whether or not missing dates are displayed.
     * @see Visibility
     */
    public final String missingDateVisibilityAsString() {
        return missingDateVisibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(missingDateVisibilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateAxisOptions)) {
            return false;
        }
        DateAxisOptions other = (DateAxisOptions) obj;
        return Objects.equals(missingDateVisibilityAsString(), other.missingDateVisibilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DateAxisOptions").add("MissingDateVisibility", missingDateVisibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MissingDateVisibility":
            return Optional.ofNullable(clazz.cast(missingDateVisibilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MissingDateVisibility", MISSING_DATE_VISIBILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DateAxisOptions, T> g) {
        return obj -> g.apply((DateAxisOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateAxisOptions> {
        /**
         * <p>
         * Determines whether or not missing dates are displayed.
         * </p>
         * 
         * @param missingDateVisibility
         *        Determines whether or not missing dates are displayed.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder missingDateVisibility(String missingDateVisibility);

        /**
         * <p>
         * Determines whether or not missing dates are displayed.
         * </p>
         * 
         * @param missingDateVisibility
         *        Determines whether or not missing dates are displayed.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder missingDateVisibility(Visibility missingDateVisibility);
    }

    static final class BuilderImpl implements Builder {
        private String missingDateVisibility;

        private BuilderImpl() {
        }

        private BuilderImpl(DateAxisOptions model) {
            missingDateVisibility(model.missingDateVisibility);
        }

        public final String getMissingDateVisibility() {
            return missingDateVisibility;
        }

        public final void setMissingDateVisibility(String missingDateVisibility) {
            this.missingDateVisibility = missingDateVisibility;
        }

        @Override
        public final Builder missingDateVisibility(String missingDateVisibility) {
            this.missingDateVisibility = missingDateVisibility;
            return this;
        }

        @Override
        public final Builder missingDateVisibility(Visibility missingDateVisibility) {
            this.missingDateVisibility(missingDateVisibility == null ? null : missingDateVisibility.toString());
            return this;
        }

        @Override
        public DateAxisOptions build() {
            return new DateAxisOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
