/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The aggregated field wells of a combo chart.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComboChartAggregatedFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<ComboChartAggregatedFieldWells.Builder, ComboChartAggregatedFieldWells> {
    private static final SdkField<List<DimensionField>> CATEGORY_FIELD = SdkField
            .<List<DimensionField>> builder(MarshallingType.LIST)
            .memberName("Category")
            .getter(getter(ComboChartAggregatedFieldWells::category))
            .setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MeasureField>> BAR_VALUES_FIELD = SdkField
            .<List<MeasureField>> builder(MarshallingType.LIST)
            .memberName("BarValues")
            .getter(getter(ComboChartAggregatedFieldWells::barValues))
            .setter(setter(Builder::barValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BarValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
                                            .constructor(MeasureField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DimensionField>> COLORS_FIELD = SdkField
            .<List<DimensionField>> builder(MarshallingType.LIST)
            .memberName("Colors")
            .getter(getter(ComboChartAggregatedFieldWells::colors))
            .setter(setter(Builder::colors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Colors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MeasureField>> LINE_VALUES_FIELD = SdkField
            .<List<MeasureField>> builder(MarshallingType.LIST)
            .memberName("LineValues")
            .getter(getter(ComboChartAggregatedFieldWells::lineValues))
            .setter(setter(Builder::lineValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
                                            .constructor(MeasureField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD,
            BAR_VALUES_FIELD, COLORS_FIELD, LINE_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<DimensionField> category;

    private final List<MeasureField> barValues;

    private final List<DimensionField> colors;

    private final List<MeasureField> lineValues;

    private ComboChartAggregatedFieldWells(BuilderImpl builder) {
        this.category = builder.category;
        this.barValues = builder.barValues;
        this.colors = builder.colors;
        this.lineValues = builder.lineValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the Category property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCategory() {
        return category != null && !(category instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The aggregated category field wells of a combo chart.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategory} method.
     * </p>
     * 
     * @return The aggregated category field wells of a combo chart.
     */
    public final List<DimensionField> category() {
        return category;
    }

    /**
     * For responses, this returns true if the service returned a value for the BarValues property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBarValues() {
        return barValues != null && !(barValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The aggregated <code>BarValues</code> field well of a combo chart.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBarValues} method.
     * </p>
     * 
     * @return The aggregated <code>BarValues</code> field well of a combo chart.
     */
    public final List<MeasureField> barValues() {
        return barValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the Colors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasColors() {
        return colors != null && !(colors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The aggregated colors field well of a combo chart.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColors} method.
     * </p>
     * 
     * @return The aggregated colors field well of a combo chart.
     */
    public final List<DimensionField> colors() {
        return colors;
    }

    /**
     * For responses, this returns true if the service returned a value for the LineValues property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLineValues() {
        return lineValues != null && !(lineValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The aggregated <code>LineValues</code> field well of a combo chart.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLineValues} method.
     * </p>
     * 
     * @return The aggregated <code>LineValues</code> field well of a combo chart.
     */
    public final List<MeasureField> lineValues() {
        return lineValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCategory() ? category() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBarValues() ? barValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasColors() ? colors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLineValues() ? lineValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComboChartAggregatedFieldWells)) {
            return false;
        }
        ComboChartAggregatedFieldWells other = (ComboChartAggregatedFieldWells) obj;
        return hasCategory() == other.hasCategory() && Objects.equals(category(), other.category())
                && hasBarValues() == other.hasBarValues() && Objects.equals(barValues(), other.barValues())
                && hasColors() == other.hasColors() && Objects.equals(colors(), other.colors())
                && hasLineValues() == other.hasLineValues() && Objects.equals(lineValues(), other.lineValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComboChartAggregatedFieldWells").add("Category", hasCategory() ? category() : null)
                .add("BarValues", hasBarValues() ? barValues() : null).add("Colors", hasColors() ? colors() : null)
                .add("LineValues", hasLineValues() ? lineValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "BarValues":
            return Optional.ofNullable(clazz.cast(barValues()));
        case "Colors":
            return Optional.ofNullable(clazz.cast(colors()));
        case "LineValues":
            return Optional.ofNullable(clazz.cast(lineValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Category", CATEGORY_FIELD);
        map.put("BarValues", BAR_VALUES_FIELD);
        map.put("Colors", COLORS_FIELD);
        map.put("LineValues", LINE_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComboChartAggregatedFieldWells, T> g) {
        return obj -> g.apply((ComboChartAggregatedFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComboChartAggregatedFieldWells> {
        /**
         * <p>
         * The aggregated category field wells of a combo chart.
         * </p>
         * 
         * @param category
         *        The aggregated category field wells of a combo chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(Collection<DimensionField> category);

        /**
         * <p>
         * The aggregated category field wells of a combo chart.
         * </p>
         * 
         * @param category
         *        The aggregated category field wells of a combo chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(DimensionField... category);

        /**
         * <p>
         * The aggregated category field wells of a combo chart.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #category(List<DimensionField>)}.
         * 
         * @param category
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #category(java.util.Collection<DimensionField>)
         */
        Builder category(Consumer<DimensionField.Builder>... category);

        /**
         * <p>
         * The aggregated <code>BarValues</code> field well of a combo chart.
         * </p>
         * 
         * @param barValues
         *        The aggregated <code>BarValues</code> field well of a combo chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder barValues(Collection<MeasureField> barValues);

        /**
         * <p>
         * The aggregated <code>BarValues</code> field well of a combo chart.
         * </p>
         * 
         * @param barValues
         *        The aggregated <code>BarValues</code> field well of a combo chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder barValues(MeasureField... barValues);

        /**
         * <p>
         * The aggregated <code>BarValues</code> field well of a combo chart.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder#build()} is called immediately
         * and its result is passed to {@link #barValues(List<MeasureField>)}.
         * 
         * @param barValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #barValues(java.util.Collection<MeasureField>)
         */
        Builder barValues(Consumer<MeasureField.Builder>... barValues);

        /**
         * <p>
         * The aggregated colors field well of a combo chart.
         * </p>
         * 
         * @param colors
         *        The aggregated colors field well of a combo chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colors(Collection<DimensionField> colors);

        /**
         * <p>
         * The aggregated colors field well of a combo chart.
         * </p>
         * 
         * @param colors
         *        The aggregated colors field well of a combo chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colors(DimensionField... colors);

        /**
         * <p>
         * The aggregated colors field well of a combo chart.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #colors(List<DimensionField>)}.
         * 
         * @param colors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colors(java.util.Collection<DimensionField>)
         */
        Builder colors(Consumer<DimensionField.Builder>... colors);

        /**
         * <p>
         * The aggregated <code>LineValues</code> field well of a combo chart.
         * </p>
         * 
         * @param lineValues
         *        The aggregated <code>LineValues</code> field well of a combo chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineValues(Collection<MeasureField> lineValues);

        /**
         * <p>
         * The aggregated <code>LineValues</code> field well of a combo chart.
         * </p>
         * 
         * @param lineValues
         *        The aggregated <code>LineValues</code> field well of a combo chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineValues(MeasureField... lineValues);

        /**
         * <p>
         * The aggregated <code>LineValues</code> field well of a combo chart.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder#build()} is called immediately
         * and its result is passed to {@link #lineValues(List<MeasureField>)}.
         * 
         * @param lineValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineValues(java.util.Collection<MeasureField>)
         */
        Builder lineValues(Consumer<MeasureField.Builder>... lineValues);
    }

    static final class BuilderImpl implements Builder {
        private List<DimensionField> category = DefaultSdkAutoConstructList.getInstance();

        private List<MeasureField> barValues = DefaultSdkAutoConstructList.getInstance();

        private List<DimensionField> colors = DefaultSdkAutoConstructList.getInstance();

        private List<MeasureField> lineValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComboChartAggregatedFieldWells model) {
            category(model.category);
            barValues(model.barValues);
            colors(model.colors);
            lineValues(model.lineValues);
        }

        public final List<DimensionField.Builder> getCategory() {
            List<DimensionField.Builder> result = DimensionFieldListCopier.copyToBuilder(this.category);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategory(Collection<DimensionField.BuilderImpl> category) {
            this.category = DimensionFieldListCopier.copyFromBuilder(category);
        }

        @Override
        public final Builder category(Collection<DimensionField> category) {
            this.category = DimensionFieldListCopier.copy(category);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder category(DimensionField... category) {
            category(Arrays.asList(category));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder category(Consumer<DimensionField.Builder>... category) {
            category(Stream.of(category).map(c -> DimensionField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MeasureField.Builder> getBarValues() {
            List<MeasureField.Builder> result = MeasureFieldListCopier.copyToBuilder(this.barValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBarValues(Collection<MeasureField.BuilderImpl> barValues) {
            this.barValues = MeasureFieldListCopier.copyFromBuilder(barValues);
        }

        @Override
        public final Builder barValues(Collection<MeasureField> barValues) {
            this.barValues = MeasureFieldListCopier.copy(barValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder barValues(MeasureField... barValues) {
            barValues(Arrays.asList(barValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder barValues(Consumer<MeasureField.Builder>... barValues) {
            barValues(Stream.of(barValues).map(c -> MeasureField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DimensionField.Builder> getColors() {
            List<DimensionField.Builder> result = DimensionFieldListCopier.copyToBuilder(this.colors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColors(Collection<DimensionField.BuilderImpl> colors) {
            this.colors = DimensionFieldListCopier.copyFromBuilder(colors);
        }

        @Override
        public final Builder colors(Collection<DimensionField> colors) {
            this.colors = DimensionFieldListCopier.copy(colors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colors(DimensionField... colors) {
            colors(Arrays.asList(colors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colors(Consumer<DimensionField.Builder>... colors) {
            colors(Stream.of(colors).map(c -> DimensionField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MeasureField.Builder> getLineValues() {
            List<MeasureField.Builder> result = MeasureFieldListCopier.copyToBuilder(this.lineValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLineValues(Collection<MeasureField.BuilderImpl> lineValues) {
            this.lineValues = MeasureFieldListCopier.copyFromBuilder(lineValues);
        }

        @Override
        public final Builder lineValues(Collection<MeasureField> lineValues) {
            this.lineValues = MeasureFieldListCopier.copy(lineValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineValues(MeasureField... lineValues) {
            lineValues(Arrays.asList(lineValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineValues(Consumer<MeasureField.Builder>... lineValues) {
            lineValues(Stream.of(lineValues).map(c -> MeasureField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ComboChartAggregatedFieldWells build() {
            return new ComboChartAggregatedFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
