/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateTopicReviewedAnswerResponse extends QuickSightResponse implements
        ToCopyableBuilder<BatchCreateTopicReviewedAnswerResponse.Builder, BatchCreateTopicReviewedAnswerResponse> {
    private static final SdkField<String> TOPIC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicId").getter(getter(BatchCreateTopicReviewedAnswerResponse::topicId))
            .setter(setter(Builder::topicId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicId").build()).build();

    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicArn").getter(getter(BatchCreateTopicReviewedAnswerResponse::topicArn))
            .setter(setter(Builder::topicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()).build();

    private static final SdkField<List<SucceededTopicReviewedAnswer>> SUCCEEDED_ANSWERS_FIELD = SdkField
            .<List<SucceededTopicReviewedAnswer>> builder(MarshallingType.LIST)
            .memberName("SucceededAnswers")
            .getter(getter(BatchCreateTopicReviewedAnswerResponse::succeededAnswers))
            .setter(setter(Builder::succeededAnswers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SucceededAnswers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SucceededTopicReviewedAnswer> builder(MarshallingType.SDK_POJO)
                                            .constructor(SucceededTopicReviewedAnswer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<InvalidTopicReviewedAnswer>> INVALID_ANSWERS_FIELD = SdkField
            .<List<InvalidTopicReviewedAnswer>> builder(MarshallingType.LIST)
            .memberName("InvalidAnswers")
            .getter(getter(BatchCreateTopicReviewedAnswerResponse::invalidAnswers))
            .setter(setter(Builder::invalidAnswers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidAnswers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InvalidTopicReviewedAnswer> builder(MarshallingType.SDK_POJO)
                                            .constructor(InvalidTopicReviewedAnswer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(BatchCreateTopicReviewedAnswerResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(BatchCreateTopicReviewedAnswerResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ID_FIELD,
            TOPIC_ARN_FIELD, SUCCEEDED_ANSWERS_FIELD, INVALID_ANSWERS_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String topicId;

    private final String topicArn;

    private final List<SucceededTopicReviewedAnswer> succeededAnswers;

    private final List<InvalidTopicReviewedAnswer> invalidAnswers;

    private final Integer status;

    private final String requestId;

    private BatchCreateTopicReviewedAnswerResponse(BuilderImpl builder) {
        super(builder);
        this.topicId = builder.topicId;
        this.topicArn = builder.topicArn;
        this.succeededAnswers = builder.succeededAnswers;
        this.invalidAnswers = builder.invalidAnswers;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * The ID for the topic reviewed answer that you want to create. This ID is unique per Amazon Web Services Region
     * for each Amazon Web Services account.
     * </p>
     * 
     * @return The ID for the topic reviewed answer that you want to create. This ID is unique per Amazon Web Services
     *         Region for each Amazon Web Services account.
     */
    public final String topicId() {
        return topicId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the topic.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the topic.
     */
    public final String topicArn() {
        return topicArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the SucceededAnswers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSucceededAnswers() {
        return succeededAnswers != null && !(succeededAnswers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The definition of Answers that are successfully created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSucceededAnswers} method.
     * </p>
     * 
     * @return The definition of Answers that are successfully created.
     */
    public final List<SucceededTopicReviewedAnswer> succeededAnswers() {
        return succeededAnswers;
    }

    /**
     * For responses, this returns true if the service returned a value for the InvalidAnswers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInvalidAnswers() {
        return invalidAnswers != null && !(invalidAnswers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The definition of Answers that are invalid and not created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInvalidAnswers} method.
     * </p>
     * 
     * @return The definition of Answers that are invalid and not created.
     */
    public final List<InvalidTopicReviewedAnswer> invalidAnswers() {
        return invalidAnswers;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(topicId());
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSucceededAnswers() ? succeededAnswers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInvalidAnswers() ? invalidAnswers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateTopicReviewedAnswerResponse)) {
            return false;
        }
        BatchCreateTopicReviewedAnswerResponse other = (BatchCreateTopicReviewedAnswerResponse) obj;
        return Objects.equals(topicId(), other.topicId()) && Objects.equals(topicArn(), other.topicArn())
                && hasSucceededAnswers() == other.hasSucceededAnswers()
                && Objects.equals(succeededAnswers(), other.succeededAnswers())
                && hasInvalidAnswers() == other.hasInvalidAnswers() && Objects.equals(invalidAnswers(), other.invalidAnswers())
                && Objects.equals(status(), other.status()) && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateTopicReviewedAnswerResponse").add("TopicId", topicId()).add("TopicArn", topicArn())
                .add("SucceededAnswers", hasSucceededAnswers() ? succeededAnswers() : null)
                .add("InvalidAnswers", hasInvalidAnswers() ? invalidAnswers() : null).add("Status", status())
                .add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicId":
            return Optional.ofNullable(clazz.cast(topicId()));
        case "TopicArn":
            return Optional.ofNullable(clazz.cast(topicArn()));
        case "SucceededAnswers":
            return Optional.ofNullable(clazz.cast(succeededAnswers()));
        case "InvalidAnswers":
            return Optional.ofNullable(clazz.cast(invalidAnswers()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TopicId", TOPIC_ID_FIELD);
        map.put("TopicArn", TOPIC_ARN_FIELD);
        map.put("SucceededAnswers", SUCCEEDED_ANSWERS_FIELD);
        map.put("InvalidAnswers", INVALID_ANSWERS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateTopicReviewedAnswerResponse, T> g) {
        return obj -> g.apply((BatchCreateTopicReviewedAnswerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchCreateTopicReviewedAnswerResponse> {
        /**
         * <p>
         * The ID for the topic reviewed answer that you want to create. This ID is unique per Amazon Web Services
         * Region for each Amazon Web Services account.
         * </p>
         * 
         * @param topicId
         *        The ID for the topic reviewed answer that you want to create. This ID is unique per Amazon Web
         *        Services Region for each Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicId(String topicId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the topic.
         * </p>
         * 
         * @param topicArn
         *        The Amazon Resource Name (ARN) of the topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * The definition of Answers that are successfully created.
         * </p>
         * 
         * @param succeededAnswers
         *        The definition of Answers that are successfully created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder succeededAnswers(Collection<SucceededTopicReviewedAnswer> succeededAnswers);

        /**
         * <p>
         * The definition of Answers that are successfully created.
         * </p>
         * 
         * @param succeededAnswers
         *        The definition of Answers that are successfully created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder succeededAnswers(SucceededTopicReviewedAnswer... succeededAnswers);

        /**
         * <p>
         * The definition of Answers that are successfully created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.SucceededTopicReviewedAnswer.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.SucceededTopicReviewedAnswer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.SucceededTopicReviewedAnswer.Builder#build()} is
         * called immediately and its result is passed to {@link #succeededAnswers(List<SucceededTopicReviewedAnswer>)}.
         * 
         * @param succeededAnswers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.SucceededTopicReviewedAnswer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #succeededAnswers(java.util.Collection<SucceededTopicReviewedAnswer>)
         */
        Builder succeededAnswers(Consumer<SucceededTopicReviewedAnswer.Builder>... succeededAnswers);

        /**
         * <p>
         * The definition of Answers that are invalid and not created.
         * </p>
         * 
         * @param invalidAnswers
         *        The definition of Answers that are invalid and not created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidAnswers(Collection<InvalidTopicReviewedAnswer> invalidAnswers);

        /**
         * <p>
         * The definition of Answers that are invalid and not created.
         * </p>
         * 
         * @param invalidAnswers
         *        The definition of Answers that are invalid and not created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidAnswers(InvalidTopicReviewedAnswer... invalidAnswers);

        /**
         * <p>
         * The definition of Answers that are invalid and not created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.InvalidTopicReviewedAnswer.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.InvalidTopicReviewedAnswer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.InvalidTopicReviewedAnswer.Builder#build()} is called
         * immediately and its result is passed to {@link #invalidAnswers(List<InvalidTopicReviewedAnswer>)}.
         * 
         * @param invalidAnswers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.InvalidTopicReviewedAnswer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invalidAnswers(java.util.Collection<InvalidTopicReviewedAnswer>)
         */
        Builder invalidAnswers(Consumer<InvalidTopicReviewedAnswer.Builder>... invalidAnswers);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String topicId;

        private String topicArn;

        private List<SucceededTopicReviewedAnswer> succeededAnswers = DefaultSdkAutoConstructList.getInstance();

        private List<InvalidTopicReviewedAnswer> invalidAnswers = DefaultSdkAutoConstructList.getInstance();

        private Integer status;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateTopicReviewedAnswerResponse model) {
            super(model);
            topicId(model.topicId);
            topicArn(model.topicArn);
            succeededAnswers(model.succeededAnswers);
            invalidAnswers(model.invalidAnswers);
            status(model.status);
            requestId(model.requestId);
        }

        public final String getTopicId() {
            return topicId;
        }

        public final void setTopicId(String topicId) {
            this.topicId = topicId;
        }

        @Override
        public final Builder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public final String getTopicArn() {
            return topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final List<SucceededTopicReviewedAnswer.Builder> getSucceededAnswers() {
            List<SucceededTopicReviewedAnswer.Builder> result = SucceededTopicReviewedAnswersCopier
                    .copyToBuilder(this.succeededAnswers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSucceededAnswers(Collection<SucceededTopicReviewedAnswer.BuilderImpl> succeededAnswers) {
            this.succeededAnswers = SucceededTopicReviewedAnswersCopier.copyFromBuilder(succeededAnswers);
        }

        @Override
        public final Builder succeededAnswers(Collection<SucceededTopicReviewedAnswer> succeededAnswers) {
            this.succeededAnswers = SucceededTopicReviewedAnswersCopier.copy(succeededAnswers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder succeededAnswers(SucceededTopicReviewedAnswer... succeededAnswers) {
            succeededAnswers(Arrays.asList(succeededAnswers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder succeededAnswers(Consumer<SucceededTopicReviewedAnswer.Builder>... succeededAnswers) {
            succeededAnswers(Stream.of(succeededAnswers)
                    .map(c -> SucceededTopicReviewedAnswer.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<InvalidTopicReviewedAnswer.Builder> getInvalidAnswers() {
            List<InvalidTopicReviewedAnswer.Builder> result = InvalidTopicReviewedAnswersCopier
                    .copyToBuilder(this.invalidAnswers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvalidAnswers(Collection<InvalidTopicReviewedAnswer.BuilderImpl> invalidAnswers) {
            this.invalidAnswers = InvalidTopicReviewedAnswersCopier.copyFromBuilder(invalidAnswers);
        }

        @Override
        public final Builder invalidAnswers(Collection<InvalidTopicReviewedAnswer> invalidAnswers) {
            this.invalidAnswers = InvalidTopicReviewedAnswersCopier.copy(invalidAnswers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidAnswers(InvalidTopicReviewedAnswer... invalidAnswers) {
            invalidAnswers(Arrays.asList(invalidAnswers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidAnswers(Consumer<InvalidTopicReviewedAnswer.Builder>... invalidAnswers) {
            invalidAnswers(Stream.of(invalidAnswers).map(c -> InvalidTopicReviewedAnswer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BatchCreateTopicReviewedAnswerResponse build() {
            return new BatchCreateTopicReviewedAnswerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
