/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration options to sort aggregated values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregationSortConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregationSortConfiguration.Builder, AggregationSortConfiguration> {
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.<ColumnIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("Column").getter(getter(AggregationSortConfiguration::column)).setter(setter(Builder::column))
            .constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()).build();

    private static final SdkField<String> SORT_DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortDirection").getter(getter(AggregationSortConfiguration::sortDirectionAsString))
            .setter(setter(Builder::sortDirection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortDirection").build()).build();

    private static final SdkField<AggregationFunction> AGGREGATION_FUNCTION_FIELD = SdkField
            .<AggregationFunction> builder(MarshallingType.SDK_POJO).memberName("AggregationFunction")
            .getter(getter(AggregationSortConfiguration::aggregationFunction)).setter(setter(Builder::aggregationFunction))
            .constructor(AggregationFunction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationFunction").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD,
            SORT_DIRECTION_FIELD, AGGREGATION_FUNCTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ColumnIdentifier column;

    private final String sortDirection;

    private final AggregationFunction aggregationFunction;

    private AggregationSortConfiguration(BuilderImpl builder) {
        this.column = builder.column;
        this.sortDirection = builder.sortDirection;
        this.aggregationFunction = builder.aggregationFunction;
    }

    /**
     * <p>
     * The column that determines the sort order of aggregated values.
     * </p>
     * 
     * @return The column that determines the sort order of aggregated values.
     */
    public final ColumnIdentifier column() {
        return column;
    }

    /**
     * <p>
     * The sort direction of values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ASC</code>: Sort in ascending order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DESC</code>: Sort in descending order.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortDirection}
     * will return {@link SortDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortDirectionAsString}.
     * </p>
     * 
     * @return The sort direction of values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ASC</code>: Sort in ascending order.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DESC</code>: Sort in descending order.
     *         </p>
     *         </li>
     * @see SortDirection
     */
    public final SortDirection sortDirection() {
        return SortDirection.fromValue(sortDirection);
    }

    /**
     * <p>
     * The sort direction of values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ASC</code>: Sort in ascending order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DESC</code>: Sort in descending order.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortDirection}
     * will return {@link SortDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortDirectionAsString}.
     * </p>
     * 
     * @return The sort direction of values.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ASC</code>: Sort in ascending order.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DESC</code>: Sort in descending order.
     *         </p>
     *         </li>
     * @see SortDirection
     */
    public final String sortDirectionAsString() {
        return sortDirection;
    }

    /**
     * <p>
     * The function that aggregates the values in <code>Column</code>.
     * </p>
     * 
     * @return The function that aggregates the values in <code>Column</code>.
     */
    public final AggregationFunction aggregationFunction() {
        return aggregationFunction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(column());
        hashCode = 31 * hashCode + Objects.hashCode(sortDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationFunction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationSortConfiguration)) {
            return false;
        }
        AggregationSortConfiguration other = (AggregationSortConfiguration) obj;
        return Objects.equals(column(), other.column()) && Objects.equals(sortDirectionAsString(), other.sortDirectionAsString())
                && Objects.equals(aggregationFunction(), other.aggregationFunction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregationSortConfiguration").add("Column", column())
                .add("SortDirection", sortDirectionAsString()).add("AggregationFunction", aggregationFunction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Column":
            return Optional.ofNullable(clazz.cast(column()));
        case "SortDirection":
            return Optional.ofNullable(clazz.cast(sortDirectionAsString()));
        case "AggregationFunction":
            return Optional.ofNullable(clazz.cast(aggregationFunction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Column", COLUMN_FIELD);
        map.put("SortDirection", SORT_DIRECTION_FIELD);
        map.put("AggregationFunction", AGGREGATION_FUNCTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregationSortConfiguration, T> g) {
        return obj -> g.apply((AggregationSortConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregationSortConfiguration> {
        /**
         * <p>
         * The column that determines the sort order of aggregated values.
         * </p>
         * 
         * @param column
         *        The column that determines the sort order of aggregated values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(ColumnIdentifier column);

        /**
         * <p>
         * The column that determines the sort order of aggregated values.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #column(ColumnIdentifier)}.
         * 
         * @param column
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #column(ColumnIdentifier)
         */
        default Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return column(ColumnIdentifier.builder().applyMutation(column).build());
        }

        /**
         * <p>
         * The sort direction of values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASC</code>: Sort in ascending order.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DESC</code>: Sort in descending order.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sortDirection
         *        The sort direction of values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ASC</code>: Sort in ascending order.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DESC</code>: Sort in descending order.
         *        </p>
         *        </li>
         * @see SortDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortDirection
         */
        Builder sortDirection(String sortDirection);

        /**
         * <p>
         * The sort direction of values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASC</code>: Sort in ascending order.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DESC</code>: Sort in descending order.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sortDirection
         *        The sort direction of values.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ASC</code>: Sort in ascending order.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DESC</code>: Sort in descending order.
         *        </p>
         *        </li>
         * @see SortDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortDirection
         */
        Builder sortDirection(SortDirection sortDirection);

        /**
         * <p>
         * The function that aggregates the values in <code>Column</code>.
         * </p>
         * 
         * @param aggregationFunction
         *        The function that aggregates the values in <code>Column</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationFunction(AggregationFunction aggregationFunction);

        /**
         * <p>
         * The function that aggregates the values in <code>Column</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AggregationFunction.Builder} avoiding the
         * need to create one manually via {@link AggregationFunction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggregationFunction.Builder#build()} is called immediately and
         * its result is passed to {@link #aggregationFunction(AggregationFunction)}.
         * 
         * @param aggregationFunction
         *        a consumer that will call methods on {@link AggregationFunction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregationFunction(AggregationFunction)
         */
        default Builder aggregationFunction(Consumer<AggregationFunction.Builder> aggregationFunction) {
            return aggregationFunction(AggregationFunction.builder().applyMutation(aggregationFunction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ColumnIdentifier column;

        private String sortDirection;

        private AggregationFunction aggregationFunction;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregationSortConfiguration model) {
            column(model.column);
            sortDirection(model.sortDirection);
            aggregationFunction(model.aggregationFunction);
        }

        public final ColumnIdentifier.Builder getColumn() {
            return column != null ? column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final String getSortDirection() {
            return sortDirection;
        }

        public final void setSortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
        }

        @Override
        public final Builder sortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        @Override
        public final Builder sortDirection(SortDirection sortDirection) {
            this.sortDirection(sortDirection == null ? null : sortDirection.toString());
            return this;
        }

        public final AggregationFunction.Builder getAggregationFunction() {
            return aggregationFunction != null ? aggregationFunction.toBuilder() : null;
        }

        public final void setAggregationFunction(AggregationFunction.BuilderImpl aggregationFunction) {
            this.aggregationFunction = aggregationFunction != null ? aggregationFunction.build() : null;
        }

        @Override
        public final Builder aggregationFunction(AggregationFunction aggregationFunction) {
            this.aggregationFunction = aggregationFunction;
            return this;
        }

        @Override
        public AggregationSortConfiguration build() {
            return new AggregationSortConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
