/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.FontConfiguration;
import software.amazon.awssdk.services.quicksight.model.LabelOptions;
import software.amazon.awssdk.services.quicksight.model.LegendPosition;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LegendOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LegendOptions> {
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(LegendOptions.getter(LegendOptions::visibilityAsString)).setter(LegendOptions.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<LabelOptions> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Title").getter(LegendOptions.getter(LegendOptions::title)).setter(LegendOptions.setter(Builder::title)).constructor(LabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Position").getter(LegendOptions.getter(LegendOptions::positionAsString)).setter(LegendOptions.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build()}).build();
    private static final SdkField<String> WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Width").getter(LegendOptions.getter(LegendOptions::width)).setter(LegendOptions.setter(Builder::width)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Width").build()}).build();
    private static final SdkField<String> HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Height").getter(LegendOptions.getter(LegendOptions::height)).setter(LegendOptions.setter(Builder::height)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Height").build()}).build();
    private static final SdkField<FontConfiguration> VALUE_FONT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValueFontConfiguration").getter(LegendOptions.getter(LegendOptions::valueFontConfiguration)).setter(LegendOptions.setter(Builder::valueFontConfiguration)).constructor(FontConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueFontConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISIBILITY_FIELD, TITLE_FIELD, POSITION_FIELD, WIDTH_FIELD, HEIGHT_FIELD, VALUE_FONT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LegendOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String visibility;
    private final LabelOptions title;
    private final String position;
    private final String width;
    private final String height;
    private final FontConfiguration valueFontConfiguration;

    private LegendOptions(BuilderImpl builder) {
        this.visibility = builder.visibility;
        this.title = builder.title;
        this.position = builder.position;
        this.width = builder.width;
        this.height = builder.height;
        this.valueFontConfiguration = builder.valueFontConfiguration;
    }

    public final Visibility visibility() {
        return Visibility.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public final LabelOptions title() {
        return this.title;
    }

    public final LegendPosition position() {
        return LegendPosition.fromValue(this.position);
    }

    public final String positionAsString() {
        return this.position;
    }

    public final String width() {
        return this.width;
    }

    public final String height() {
        return this.height;
    }

    public final FontConfiguration valueFontConfiguration() {
        return this.valueFontConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.positionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.width());
        hashCode = 31 * hashCode + Objects.hashCode(this.height());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueFontConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LegendOptions)) {
            return false;
        }
        LegendOptions other = (LegendOptions)obj;
        return Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.positionAsString(), other.positionAsString()) && Objects.equals(this.width(), other.width()) && Objects.equals(this.height(), other.height()) && Objects.equals(this.valueFontConfiguration(), other.valueFontConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"LegendOptions").add("Visibility", (Object)this.visibilityAsString()).add("Title", (Object)this.title()).add("Position", (Object)this.positionAsString()).add("Width", (Object)this.width()).add("Height", (Object)this.height()).add("ValueFontConfiguration", (Object)this.valueFontConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.positionAsString()));
            }
            case "Width": {
                return Optional.ofNullable(clazz.cast(this.width()));
            }
            case "Height": {
                return Optional.ofNullable(clazz.cast(this.height()));
            }
            case "ValueFontConfiguration": {
                return Optional.ofNullable(clazz.cast(this.valueFontConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Position", POSITION_FIELD);
        map.put("Width", WIDTH_FIELD);
        map.put("Height", HEIGHT_FIELD);
        map.put("ValueFontConfiguration", VALUE_FONT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LegendOptions, T> g) {
        return obj -> g.apply((LegendOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String visibility;
        private LabelOptions title;
        private String position;
        private String width;
        private String height;
        private FontConfiguration valueFontConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(LegendOptions model) {
            this.visibility(model.visibility);
            this.title(model.title);
            this.position(model.position);
            this.width(model.width);
            this.height(model.height);
            this.valueFontConfiguration(model.valueFontConfiguration);
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final LabelOptions.Builder getTitle() {
            return this.title != null ? this.title.toBuilder() : null;
        }

        public final void setTitle(LabelOptions.BuilderImpl title) {
            this.title = title != null ? title.build() : null;
        }

        @Override
        public final Builder title(LabelOptions title) {
            this.title = title;
            return this;
        }

        public final String getPosition() {
            return this.position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        @Override
        public final Builder position(LegendPosition position) {
            this.position(position == null ? null : position.toString());
            return this;
        }

        public final String getWidth() {
            return this.width;
        }

        public final void setWidth(String width) {
            this.width = width;
        }

        @Override
        public final Builder width(String width) {
            this.width = width;
            return this;
        }

        public final String getHeight() {
            return this.height;
        }

        public final void setHeight(String height) {
            this.height = height;
        }

        @Override
        public final Builder height(String height) {
            this.height = height;
            return this;
        }

        public final FontConfiguration.Builder getValueFontConfiguration() {
            return this.valueFontConfiguration != null ? this.valueFontConfiguration.toBuilder() : null;
        }

        public final void setValueFontConfiguration(FontConfiguration.BuilderImpl valueFontConfiguration) {
            this.valueFontConfiguration = valueFontConfiguration != null ? valueFontConfiguration.build() : null;
        }

        @Override
        public final Builder valueFontConfiguration(FontConfiguration valueFontConfiguration) {
            this.valueFontConfiguration = valueFontConfiguration;
            return this;
        }

        public LegendOptions build() {
            return new LegendOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LegendOptions> {
        public Builder visibility(String var1);

        public Builder visibility(Visibility var1);

        public Builder title(LabelOptions var1);

        default public Builder title(Consumer<LabelOptions.Builder> title) {
            return this.title((LabelOptions)((LabelOptions.Builder)LabelOptions.builder().applyMutation(title)).build());
        }

        public Builder position(String var1);

        public Builder position(LegendPosition var1);

        public Builder width(String var1);

        public Builder height(String var1);

        public Builder valueFontConfiguration(FontConfiguration var1);

        default public Builder valueFontConfiguration(Consumer<FontConfiguration.Builder> valueFontConfiguration) {
            return this.valueFontConfiguration((FontConfiguration)((FontConfiguration.Builder)FontConfiguration.builder().applyMutation(valueFontConfiguration)).build());
        }
    }
}

