/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportFailureAction;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobError;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobErrorListCopier;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobOverrideParameters;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobOverridePermissions;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobOverrideTags;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobOverrideValidationStrategy;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobStatus;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobWarning;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobWarningListCopier;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportSourceDescription;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAssetBundleImportJobResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DescribeAssetBundleImportJobResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(DescribeAssetBundleImportJobResponse.getter(DescribeAssetBundleImportJobResponse::jobStatusAsString)).setter(DescribeAssetBundleImportJobResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<List<AssetBundleImportJobError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(DescribeAssetBundleImportJobResponse.getter(DescribeAssetBundleImportJobResponse::errors)).setter(DescribeAssetBundleImportJobResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetBundleImportJobError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AssetBundleImportJobError>> ROLLBACK_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RollbackErrors").getter(DescribeAssetBundleImportJobResponse.getter(DescribeAssetBundleImportJobResponse::rollbackErrors)).setter(DescribeAssetBundleImportJobResponse.setter(Builder::rollbackErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetBundleImportJobError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribeAssetBundleImportJobResponse.getter(DescribeAssetBundleImportJobResponse::arn)).setter(DescribeAssetBundleImportJobResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(DescribeAssetBundleImportJobResponse.getter(DescribeAssetBundleImportJobResponse::createdTime)).setter(DescribeAssetBundleImportJobResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> ASSET_BUNDLE_IMPORT_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssetBundleImportJobId").getter(DescribeAssetBundleImportJobResponse.getter(DescribeAssetBundleImportJobResponse::assetBundleImportJobId)).setter(DescribeAssetBundleImportJobResponse.setter(Builder::assetBundleImportJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetBundleImportJobId").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(DescribeAssetBundleImportJobResponse.getter(DescribeAssetBundleImportJobResponse::awsAccountId)).setter(DescribeAssetBundleImportJobResponse.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()}).build();
    private static final SdkField<AssetBundleImportSourceDescription> ASSET_BUNDLE_IMPORT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AssetBundleImportSource").getter(DescribeAssetBundleImportJobResponse.getter(DescribeAssetBundleImportJobResponse::assetBundleImportSource)).setter(DescribeAssetBundleImportJobResponse.setter(Builder::assetBundleImportSource)).constructor(AssetBundleImportSourceDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetBundleImportSource").build()}).build();
    private static final SdkField<AssetBundleImportJobOverrideParameters> OVERRIDE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OverrideParameters").getter(DescribeAssetBundleImportJobResponse.getter(DescribeAssetBundleImportJobResponse::overrideParameters)).setter(DescribeAssetBundleImportJobResponse.setter(Builder::overrideParameters)).constructor(AssetBundleImportJobOverrideParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideParameters").build()}).build();
    private static final SdkField<String> FAILURE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureAction").getter(DescribeAssetBundleImportJobResponse.getter(DescribeAssetBundleImportJobResponse::failureActionAsString)).setter(DescribeAssetBundleImportJobResponse.setter(Builder::failureAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureAction").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DescribeAssetBundleImportJobResponse.getter(DescribeAssetBundleImportJobResponse::requestId)).setter(DescribeAssetBundleImportJobResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DescribeAssetBundleImportJobResponse.getter(DescribeAssetBundleImportJobResponse::status)).setter(DescribeAssetBundleImportJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<AssetBundleImportJobOverridePermissions> OVERRIDE_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OverridePermissions").getter(DescribeAssetBundleImportJobResponse.getter(DescribeAssetBundleImportJobResponse::overridePermissions)).setter(DescribeAssetBundleImportJobResponse.setter(Builder::overridePermissions)).constructor(AssetBundleImportJobOverridePermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverridePermissions").build()}).build();
    private static final SdkField<AssetBundleImportJobOverrideTags> OVERRIDE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OverrideTags").getter(DescribeAssetBundleImportJobResponse.getter(DescribeAssetBundleImportJobResponse::overrideTags)).setter(DescribeAssetBundleImportJobResponse.setter(Builder::overrideTags)).constructor(AssetBundleImportJobOverrideTags::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideTags").build()}).build();
    private static final SdkField<AssetBundleImportJobOverrideValidationStrategy> OVERRIDE_VALIDATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OverrideValidationStrategy").getter(DescribeAssetBundleImportJobResponse.getter(DescribeAssetBundleImportJobResponse::overrideValidationStrategy)).setter(DescribeAssetBundleImportJobResponse.setter(Builder::overrideValidationStrategy)).constructor(AssetBundleImportJobOverrideValidationStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideValidationStrategy").build()}).build();
    private static final SdkField<List<AssetBundleImportJobWarning>> WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Warnings").getter(DescribeAssetBundleImportJobResponse.getter(DescribeAssetBundleImportJobResponse::warnings)).setter(DescribeAssetBundleImportJobResponse.setter(Builder::warnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warnings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetBundleImportJobWarning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD, ERRORS_FIELD, ROLLBACK_ERRORS_FIELD, ARN_FIELD, CREATED_TIME_FIELD, ASSET_BUNDLE_IMPORT_JOB_ID_FIELD, AWS_ACCOUNT_ID_FIELD, ASSET_BUNDLE_IMPORT_SOURCE_FIELD, OVERRIDE_PARAMETERS_FIELD, FAILURE_ACTION_FIELD, REQUEST_ID_FIELD, STATUS_FIELD, OVERRIDE_PERMISSIONS_FIELD, OVERRIDE_TAGS_FIELD, OVERRIDE_VALIDATION_STRATEGY_FIELD, WARNINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAssetBundleImportJobResponse.memberNameToFieldInitializer();
    private final String jobStatus;
    private final List<AssetBundleImportJobError> errors;
    private final List<AssetBundleImportJobError> rollbackErrors;
    private final String arn;
    private final Instant createdTime;
    private final String assetBundleImportJobId;
    private final String awsAccountId;
    private final AssetBundleImportSourceDescription assetBundleImportSource;
    private final AssetBundleImportJobOverrideParameters overrideParameters;
    private final String failureAction;
    private final String requestId;
    private final Integer status;
    private final AssetBundleImportJobOverridePermissions overridePermissions;
    private final AssetBundleImportJobOverrideTags overrideTags;
    private final AssetBundleImportJobOverrideValidationStrategy overrideValidationStrategy;
    private final List<AssetBundleImportJobWarning> warnings;

    private DescribeAssetBundleImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.errors = builder.errors;
        this.rollbackErrors = builder.rollbackErrors;
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.assetBundleImportJobId = builder.assetBundleImportJobId;
        this.awsAccountId = builder.awsAccountId;
        this.assetBundleImportSource = builder.assetBundleImportSource;
        this.overrideParameters = builder.overrideParameters;
        this.failureAction = builder.failureAction;
        this.requestId = builder.requestId;
        this.status = builder.status;
        this.overridePermissions = builder.overridePermissions;
        this.overrideTags = builder.overrideTags;
        this.overrideValidationStrategy = builder.overrideValidationStrategy;
        this.warnings = builder.warnings;
    }

    public final AssetBundleImportJobStatus jobStatus() {
        return AssetBundleImportJobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<AssetBundleImportJobError> errors() {
        return this.errors;
    }

    public final boolean hasRollbackErrors() {
        return this.rollbackErrors != null && !(this.rollbackErrors instanceof SdkAutoConstructList);
    }

    public final List<AssetBundleImportJobError> rollbackErrors() {
        return this.rollbackErrors;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String assetBundleImportJobId() {
        return this.assetBundleImportJobId;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final AssetBundleImportSourceDescription assetBundleImportSource() {
        return this.assetBundleImportSource;
    }

    public final AssetBundleImportJobOverrideParameters overrideParameters() {
        return this.overrideParameters;
    }

    public final AssetBundleImportFailureAction failureAction() {
        return AssetBundleImportFailureAction.fromValue(this.failureAction);
    }

    public final String failureActionAsString() {
        return this.failureAction;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public final AssetBundleImportJobOverridePermissions overridePermissions() {
        return this.overridePermissions;
    }

    public final AssetBundleImportJobOverrideTags overrideTags() {
        return this.overrideTags;
    }

    public final AssetBundleImportJobOverrideValidationStrategy overrideValidationStrategy() {
        return this.overrideValidationStrategy;
    }

    public final boolean hasWarnings() {
        return this.warnings != null && !(this.warnings instanceof SdkAutoConstructList);
    }

    public final List<AssetBundleImportJobWarning> warnings() {
        return this.warnings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRollbackErrors() ? this.rollbackErrors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetBundleImportJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetBundleImportSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.overridePermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideValidationStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWarnings() ? this.warnings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetBundleImportJobResponse)) {
            return false;
        }
        DescribeAssetBundleImportJobResponse other = (DescribeAssetBundleImportJobResponse)((Object)obj);
        return Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && this.hasRollbackErrors() == other.hasRollbackErrors() && Objects.equals(this.rollbackErrors(), other.rollbackErrors()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.assetBundleImportJobId(), other.assetBundleImportJobId()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.assetBundleImportSource(), other.assetBundleImportSource()) && Objects.equals(this.overrideParameters(), other.overrideParameters()) && Objects.equals(this.failureActionAsString(), other.failureActionAsString()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.overridePermissions(), other.overridePermissions()) && Objects.equals(this.overrideTags(), other.overrideTags()) && Objects.equals(this.overrideValidationStrategy(), other.overrideValidationStrategy()) && this.hasWarnings() == other.hasWarnings() && Objects.equals(this.warnings(), other.warnings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAssetBundleImportJobResponse").add("JobStatus", (Object)this.jobStatusAsString()).add("Errors", this.hasErrors() ? this.errors() : null).add("RollbackErrors", this.hasRollbackErrors() ? this.rollbackErrors() : null).add("Arn", (Object)this.arn()).add("CreatedTime", (Object)this.createdTime()).add("AssetBundleImportJobId", (Object)this.assetBundleImportJobId()).add("AwsAccountId", (Object)this.awsAccountId()).add("AssetBundleImportSource", (Object)this.assetBundleImportSource()).add("OverrideParameters", (Object)this.overrideParameters()).add("FailureAction", (Object)this.failureActionAsString()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).add("OverridePermissions", (Object)this.overridePermissions()).add("OverrideTags", (Object)this.overrideTags()).add("OverrideValidationStrategy", (Object)this.overrideValidationStrategy()).add("Warnings", this.hasWarnings() ? this.warnings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "RollbackErrors": {
                return Optional.ofNullable(clazz.cast(this.rollbackErrors()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "AssetBundleImportJobId": {
                return Optional.ofNullable(clazz.cast(this.assetBundleImportJobId()));
            }
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "AssetBundleImportSource": {
                return Optional.ofNullable(clazz.cast(this.assetBundleImportSource()));
            }
            case "OverrideParameters": {
                return Optional.ofNullable(clazz.cast(this.overrideParameters()));
            }
            case "FailureAction": {
                return Optional.ofNullable(clazz.cast(this.failureActionAsString()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "OverridePermissions": {
                return Optional.ofNullable(clazz.cast(this.overridePermissions()));
            }
            case "OverrideTags": {
                return Optional.ofNullable(clazz.cast(this.overrideTags()));
            }
            case "OverrideValidationStrategy": {
                return Optional.ofNullable(clazz.cast(this.overrideValidationStrategy()));
            }
            case "Warnings": {
                return Optional.ofNullable(clazz.cast(this.warnings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobStatus", JOB_STATUS_FIELD);
        map.put("Errors", ERRORS_FIELD);
        map.put("RollbackErrors", ROLLBACK_ERRORS_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("AssetBundleImportJobId", ASSET_BUNDLE_IMPORT_JOB_ID_FIELD);
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("AssetBundleImportSource", ASSET_BUNDLE_IMPORT_SOURCE_FIELD);
        map.put("OverrideParameters", OVERRIDE_PARAMETERS_FIELD);
        map.put("FailureAction", FAILURE_ACTION_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("OverridePermissions", OVERRIDE_PERMISSIONS_FIELD);
        map.put("OverrideTags", OVERRIDE_TAGS_FIELD);
        map.put("OverrideValidationStrategy", OVERRIDE_VALIDATION_STRATEGY_FIELD);
        map.put("Warnings", WARNINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetBundleImportJobResponse, T> g) {
        return obj -> g.apply((DescribeAssetBundleImportJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String jobStatus;
        private List<AssetBundleImportJobError> errors = DefaultSdkAutoConstructList.getInstance();
        private List<AssetBundleImportJobError> rollbackErrors = DefaultSdkAutoConstructList.getInstance();
        private String arn;
        private Instant createdTime;
        private String assetBundleImportJobId;
        private String awsAccountId;
        private AssetBundleImportSourceDescription assetBundleImportSource;
        private AssetBundleImportJobOverrideParameters overrideParameters;
        private String failureAction;
        private String requestId;
        private Integer status;
        private AssetBundleImportJobOverridePermissions overridePermissions;
        private AssetBundleImportJobOverrideTags overrideTags;
        private AssetBundleImportJobOverrideValidationStrategy overrideValidationStrategy;
        private List<AssetBundleImportJobWarning> warnings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetBundleImportJobResponse model) {
            super(model);
            this.jobStatus(model.jobStatus);
            this.errors(model.errors);
            this.rollbackErrors(model.rollbackErrors);
            this.arn(model.arn);
            this.createdTime(model.createdTime);
            this.assetBundleImportJobId(model.assetBundleImportJobId);
            this.awsAccountId(model.awsAccountId);
            this.assetBundleImportSource(model.assetBundleImportSource);
            this.overrideParameters(model.overrideParameters);
            this.failureAction(model.failureAction);
            this.requestId(model.requestId);
            this.status(model.status);
            this.overridePermissions(model.overridePermissions);
            this.overrideTags(model.overrideTags);
            this.overrideValidationStrategy(model.overrideValidationStrategy);
            this.warnings(model.warnings);
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(AssetBundleImportJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final List<AssetBundleImportJobError.Builder> getErrors() {
            List<AssetBundleImportJobError.Builder> result = AssetBundleImportJobErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<AssetBundleImportJobError.BuilderImpl> errors) {
            this.errors = AssetBundleImportJobErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<AssetBundleImportJobError> errors) {
            this.errors = AssetBundleImportJobErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(AssetBundleImportJobError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<AssetBundleImportJobError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (AssetBundleImportJobError)((AssetBundleImportJobError.Builder)AssetBundleImportJobError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleImportJobError.Builder> getRollbackErrors() {
            List<AssetBundleImportJobError.Builder> result = AssetBundleImportJobErrorListCopier.copyToBuilder(this.rollbackErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRollbackErrors(Collection<AssetBundleImportJobError.BuilderImpl> rollbackErrors) {
            this.rollbackErrors = AssetBundleImportJobErrorListCopier.copyFromBuilder(rollbackErrors);
        }

        @Override
        public final Builder rollbackErrors(Collection<AssetBundleImportJobError> rollbackErrors) {
            this.rollbackErrors = AssetBundleImportJobErrorListCopier.copy(rollbackErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rollbackErrors(AssetBundleImportJobError ... rollbackErrors) {
            this.rollbackErrors(Arrays.asList(rollbackErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rollbackErrors(Consumer<AssetBundleImportJobError.Builder> ... rollbackErrors) {
            this.rollbackErrors(Stream.of(rollbackErrors).map(c -> (AssetBundleImportJobError)((AssetBundleImportJobError.Builder)AssetBundleImportJobError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getAssetBundleImportJobId() {
            return this.assetBundleImportJobId;
        }

        public final void setAssetBundleImportJobId(String assetBundleImportJobId) {
            this.assetBundleImportJobId = assetBundleImportJobId;
        }

        @Override
        public final Builder assetBundleImportJobId(String assetBundleImportJobId) {
            this.assetBundleImportJobId = assetBundleImportJobId;
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final AssetBundleImportSourceDescription.Builder getAssetBundleImportSource() {
            return this.assetBundleImportSource != null ? this.assetBundleImportSource.toBuilder() : null;
        }

        public final void setAssetBundleImportSource(AssetBundleImportSourceDescription.BuilderImpl assetBundleImportSource) {
            this.assetBundleImportSource = assetBundleImportSource != null ? assetBundleImportSource.build() : null;
        }

        @Override
        public final Builder assetBundleImportSource(AssetBundleImportSourceDescription assetBundleImportSource) {
            this.assetBundleImportSource = assetBundleImportSource;
            return this;
        }

        public final AssetBundleImportJobOverrideParameters.Builder getOverrideParameters() {
            return this.overrideParameters != null ? this.overrideParameters.toBuilder() : null;
        }

        public final void setOverrideParameters(AssetBundleImportJobOverrideParameters.BuilderImpl overrideParameters) {
            this.overrideParameters = overrideParameters != null ? overrideParameters.build() : null;
        }

        @Override
        public final Builder overrideParameters(AssetBundleImportJobOverrideParameters overrideParameters) {
            this.overrideParameters = overrideParameters;
            return this;
        }

        public final String getFailureAction() {
            return this.failureAction;
        }

        public final void setFailureAction(String failureAction) {
            this.failureAction = failureAction;
        }

        @Override
        public final Builder failureAction(String failureAction) {
            this.failureAction = failureAction;
            return this;
        }

        @Override
        public final Builder failureAction(AssetBundleImportFailureAction failureAction) {
            this.failureAction(failureAction == null ? null : failureAction.toString());
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final AssetBundleImportJobOverridePermissions.Builder getOverridePermissions() {
            return this.overridePermissions != null ? this.overridePermissions.toBuilder() : null;
        }

        public final void setOverridePermissions(AssetBundleImportJobOverridePermissions.BuilderImpl overridePermissions) {
            this.overridePermissions = overridePermissions != null ? overridePermissions.build() : null;
        }

        @Override
        public final Builder overridePermissions(AssetBundleImportJobOverridePermissions overridePermissions) {
            this.overridePermissions = overridePermissions;
            return this;
        }

        public final AssetBundleImportJobOverrideTags.Builder getOverrideTags() {
            return this.overrideTags != null ? this.overrideTags.toBuilder() : null;
        }

        public final void setOverrideTags(AssetBundleImportJobOverrideTags.BuilderImpl overrideTags) {
            this.overrideTags = overrideTags != null ? overrideTags.build() : null;
        }

        @Override
        public final Builder overrideTags(AssetBundleImportJobOverrideTags overrideTags) {
            this.overrideTags = overrideTags;
            return this;
        }

        public final AssetBundleImportJobOverrideValidationStrategy.Builder getOverrideValidationStrategy() {
            return this.overrideValidationStrategy != null ? this.overrideValidationStrategy.toBuilder() : null;
        }

        public final void setOverrideValidationStrategy(AssetBundleImportJobOverrideValidationStrategy.BuilderImpl overrideValidationStrategy) {
            this.overrideValidationStrategy = overrideValidationStrategy != null ? overrideValidationStrategy.build() : null;
        }

        @Override
        public final Builder overrideValidationStrategy(AssetBundleImportJobOverrideValidationStrategy overrideValidationStrategy) {
            this.overrideValidationStrategy = overrideValidationStrategy;
            return this;
        }

        public final List<AssetBundleImportJobWarning.Builder> getWarnings() {
            List<AssetBundleImportJobWarning.Builder> result = AssetBundleImportJobWarningListCopier.copyToBuilder(this.warnings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWarnings(Collection<AssetBundleImportJobWarning.BuilderImpl> warnings) {
            this.warnings = AssetBundleImportJobWarningListCopier.copyFromBuilder(warnings);
        }

        @Override
        public final Builder warnings(Collection<AssetBundleImportJobWarning> warnings) {
            this.warnings = AssetBundleImportJobWarningListCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(AssetBundleImportJobWarning ... warnings) {
            this.warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Consumer<AssetBundleImportJobWarning.Builder> ... warnings) {
            this.warnings(Stream.of(warnings).map(c -> (AssetBundleImportJobWarning)((AssetBundleImportJobWarning.Builder)AssetBundleImportJobWarning.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAssetBundleImportJobResponse build() {
            return new DescribeAssetBundleImportJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAssetBundleImportJobResponse> {
        public Builder jobStatus(String var1);

        public Builder jobStatus(AssetBundleImportJobStatus var1);

        public Builder errors(Collection<AssetBundleImportJobError> var1);

        public Builder errors(AssetBundleImportJobError ... var1);

        public Builder errors(Consumer<AssetBundleImportJobError.Builder> ... var1);

        public Builder rollbackErrors(Collection<AssetBundleImportJobError> var1);

        public Builder rollbackErrors(AssetBundleImportJobError ... var1);

        public Builder rollbackErrors(Consumer<AssetBundleImportJobError.Builder> ... var1);

        public Builder arn(String var1);

        public Builder createdTime(Instant var1);

        public Builder assetBundleImportJobId(String var1);

        public Builder awsAccountId(String var1);

        public Builder assetBundleImportSource(AssetBundleImportSourceDescription var1);

        default public Builder assetBundleImportSource(Consumer<AssetBundleImportSourceDescription.Builder> assetBundleImportSource) {
            return this.assetBundleImportSource((AssetBundleImportSourceDescription)((AssetBundleImportSourceDescription.Builder)AssetBundleImportSourceDescription.builder().applyMutation(assetBundleImportSource)).build());
        }

        public Builder overrideParameters(AssetBundleImportJobOverrideParameters var1);

        default public Builder overrideParameters(Consumer<AssetBundleImportJobOverrideParameters.Builder> overrideParameters) {
            return this.overrideParameters((AssetBundleImportJobOverrideParameters)((AssetBundleImportJobOverrideParameters.Builder)AssetBundleImportJobOverrideParameters.builder().applyMutation(overrideParameters)).build());
        }

        public Builder failureAction(String var1);

        public Builder failureAction(AssetBundleImportFailureAction var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);

        public Builder overridePermissions(AssetBundleImportJobOverridePermissions var1);

        default public Builder overridePermissions(Consumer<AssetBundleImportJobOverridePermissions.Builder> overridePermissions) {
            return this.overridePermissions((AssetBundleImportJobOverridePermissions)((AssetBundleImportJobOverridePermissions.Builder)AssetBundleImportJobOverridePermissions.builder().applyMutation(overridePermissions)).build());
        }

        public Builder overrideTags(AssetBundleImportJobOverrideTags var1);

        default public Builder overrideTags(Consumer<AssetBundleImportJobOverrideTags.Builder> overrideTags) {
            return this.overrideTags((AssetBundleImportJobOverrideTags)((AssetBundleImportJobOverrideTags.Builder)AssetBundleImportJobOverrideTags.builder().applyMutation(overrideTags)).build());
        }

        public Builder overrideValidationStrategy(AssetBundleImportJobOverrideValidationStrategy var1);

        default public Builder overrideValidationStrategy(Consumer<AssetBundleImportJobOverrideValidationStrategy.Builder> overrideValidationStrategy) {
            return this.overrideValidationStrategy((AssetBundleImportJobOverrideValidationStrategy)((AssetBundleImportJobOverrideValidationStrategy.Builder)AssetBundleImportJobOverrideValidationStrategy.builder().applyMutation(overrideValidationStrategy)).build());
        }

        public Builder warnings(Collection<AssetBundleImportJobWarning> var1);

        public Builder warnings(AssetBundleImportJobWarning ... var1);

        public Builder warnings(Consumer<AssetBundleImportJobWarning.Builder> ... var1);
    }
}

