/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AxisDisplayOptions;
import software.amazon.awssdk.services.quicksight.model.BoxPlotFieldWells;
import software.amazon.awssdk.services.quicksight.model.BoxPlotOptions;
import software.amazon.awssdk.services.quicksight.model.BoxPlotSortConfiguration;
import software.amazon.awssdk.services.quicksight.model.ChartAxisLabelOptions;
import software.amazon.awssdk.services.quicksight.model.LegendOptions;
import software.amazon.awssdk.services.quicksight.model.ReferenceLine;
import software.amazon.awssdk.services.quicksight.model.ReferenceLineListCopier;
import software.amazon.awssdk.services.quicksight.model.TooltipOptions;
import software.amazon.awssdk.services.quicksight.model.VisualInteractionOptions;
import software.amazon.awssdk.services.quicksight.model.VisualPalette;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BoxPlotChartConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BoxPlotChartConfiguration> {
    private static final SdkField<BoxPlotFieldWells> FIELD_WELLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FieldWells").getter(BoxPlotChartConfiguration.getter(BoxPlotChartConfiguration::fieldWells)).setter(BoxPlotChartConfiguration.setter(Builder::fieldWells)).constructor(BoxPlotFieldWells::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()}).build();
    private static final SdkField<BoxPlotSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SortConfiguration").getter(BoxPlotChartConfiguration.getter(BoxPlotChartConfiguration::sortConfiguration)).setter(BoxPlotChartConfiguration.setter(Builder::sortConfiguration)).constructor(BoxPlotSortConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()}).build();
    private static final SdkField<BoxPlotOptions> BOX_PLOT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BoxPlotOptions").getter(BoxPlotChartConfiguration.getter(BoxPlotChartConfiguration::boxPlotOptions)).setter(BoxPlotChartConfiguration.setter(Builder::boxPlotOptions)).constructor(BoxPlotOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoxPlotOptions").build()}).build();
    private static final SdkField<AxisDisplayOptions> CATEGORY_AXIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CategoryAxis").getter(BoxPlotChartConfiguration.getter(BoxPlotChartConfiguration::categoryAxis)).setter(BoxPlotChartConfiguration.setter(Builder::categoryAxis)).constructor(AxisDisplayOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryAxis").build()}).build();
    private static final SdkField<ChartAxisLabelOptions> CATEGORY_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CategoryLabelOptions").getter(BoxPlotChartConfiguration.getter(BoxPlotChartConfiguration::categoryLabelOptions)).setter(BoxPlotChartConfiguration.setter(Builder::categoryLabelOptions)).constructor(ChartAxisLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryLabelOptions").build()}).build();
    private static final SdkField<AxisDisplayOptions> PRIMARY_Y_AXIS_DISPLAY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrimaryYAxisDisplayOptions").getter(BoxPlotChartConfiguration.getter(BoxPlotChartConfiguration::primaryYAxisDisplayOptions)).setter(BoxPlotChartConfiguration.setter(Builder::primaryYAxisDisplayOptions)).constructor(AxisDisplayOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryYAxisDisplayOptions").build()}).build();
    private static final SdkField<ChartAxisLabelOptions> PRIMARY_Y_AXIS_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrimaryYAxisLabelOptions").getter(BoxPlotChartConfiguration.getter(BoxPlotChartConfiguration::primaryYAxisLabelOptions)).setter(BoxPlotChartConfiguration.setter(Builder::primaryYAxisLabelOptions)).constructor(ChartAxisLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryYAxisLabelOptions").build()}).build();
    private static final SdkField<LegendOptions> LEGEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Legend").getter(BoxPlotChartConfiguration.getter(BoxPlotChartConfiguration::legend)).setter(BoxPlotChartConfiguration.setter(Builder::legend)).constructor(LegendOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legend").build()}).build();
    private static final SdkField<TooltipOptions> TOOLTIP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tooltip").getter(BoxPlotChartConfiguration.getter(BoxPlotChartConfiguration::tooltip)).setter(BoxPlotChartConfiguration.setter(Builder::tooltip)).constructor(TooltipOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()}).build();
    private static final SdkField<List<ReferenceLine>> REFERENCE_LINES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReferenceLines").getter(BoxPlotChartConfiguration.getter(BoxPlotChartConfiguration::referenceLines)).setter(BoxPlotChartConfiguration.setter(Builder::referenceLines)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceLines").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReferenceLine::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VisualPalette> VISUAL_PALETTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisualPalette").getter(BoxPlotChartConfiguration.getter(BoxPlotChartConfiguration::visualPalette)).setter(BoxPlotChartConfiguration.setter(Builder::visualPalette)).constructor(VisualPalette::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualPalette").build()}).build();
    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Interactions").getter(BoxPlotChartConfiguration.getter(BoxPlotChartConfiguration::interactions)).setter(BoxPlotChartConfiguration.setter(Builder::interactions)).constructor(VisualInteractionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD, SORT_CONFIGURATION_FIELD, BOX_PLOT_OPTIONS_FIELD, CATEGORY_AXIS_FIELD, CATEGORY_LABEL_OPTIONS_FIELD, PRIMARY_Y_AXIS_DISPLAY_OPTIONS_FIELD, PRIMARY_Y_AXIS_LABEL_OPTIONS_FIELD, LEGEND_FIELD, TOOLTIP_FIELD, REFERENCE_LINES_FIELD, VISUAL_PALETTE_FIELD, INTERACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BoxPlotChartConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final BoxPlotFieldWells fieldWells;
    private final BoxPlotSortConfiguration sortConfiguration;
    private final BoxPlotOptions boxPlotOptions;
    private final AxisDisplayOptions categoryAxis;
    private final ChartAxisLabelOptions categoryLabelOptions;
    private final AxisDisplayOptions primaryYAxisDisplayOptions;
    private final ChartAxisLabelOptions primaryYAxisLabelOptions;
    private final LegendOptions legend;
    private final TooltipOptions tooltip;
    private final List<ReferenceLine> referenceLines;
    private final VisualPalette visualPalette;
    private final VisualInteractionOptions interactions;

    private BoxPlotChartConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.boxPlotOptions = builder.boxPlotOptions;
        this.categoryAxis = builder.categoryAxis;
        this.categoryLabelOptions = builder.categoryLabelOptions;
        this.primaryYAxisDisplayOptions = builder.primaryYAxisDisplayOptions;
        this.primaryYAxisLabelOptions = builder.primaryYAxisLabelOptions;
        this.legend = builder.legend;
        this.tooltip = builder.tooltip;
        this.referenceLines = builder.referenceLines;
        this.visualPalette = builder.visualPalette;
        this.interactions = builder.interactions;
    }

    public final BoxPlotFieldWells fieldWells() {
        return this.fieldWells;
    }

    public final BoxPlotSortConfiguration sortConfiguration() {
        return this.sortConfiguration;
    }

    public final BoxPlotOptions boxPlotOptions() {
        return this.boxPlotOptions;
    }

    public final AxisDisplayOptions categoryAxis() {
        return this.categoryAxis;
    }

    public final ChartAxisLabelOptions categoryLabelOptions() {
        return this.categoryLabelOptions;
    }

    public final AxisDisplayOptions primaryYAxisDisplayOptions() {
        return this.primaryYAxisDisplayOptions;
    }

    public final ChartAxisLabelOptions primaryYAxisLabelOptions() {
        return this.primaryYAxisLabelOptions;
    }

    public final LegendOptions legend() {
        return this.legend;
    }

    public final TooltipOptions tooltip() {
        return this.tooltip;
    }

    public final boolean hasReferenceLines() {
        return this.referenceLines != null && !(this.referenceLines instanceof SdkAutoConstructList);
    }

    public final List<ReferenceLine> referenceLines() {
        return this.referenceLines;
    }

    public final VisualPalette visualPalette() {
        return this.visualPalette;
    }

    public final VisualInteractionOptions interactions() {
        return this.interactions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.boxPlotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAxis());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryYAxisDisplayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryYAxisLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.legend());
        hashCode = 31 * hashCode + Objects.hashCode(this.tooltip());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferenceLines() ? this.referenceLines() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.visualPalette());
        hashCode = 31 * hashCode + Objects.hashCode(this.interactions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BoxPlotChartConfiguration)) {
            return false;
        }
        BoxPlotChartConfiguration other = (BoxPlotChartConfiguration)obj;
        return Objects.equals(this.fieldWells(), other.fieldWells()) && Objects.equals(this.sortConfiguration(), other.sortConfiguration()) && Objects.equals(this.boxPlotOptions(), other.boxPlotOptions()) && Objects.equals(this.categoryAxis(), other.categoryAxis()) && Objects.equals(this.categoryLabelOptions(), other.categoryLabelOptions()) && Objects.equals(this.primaryYAxisDisplayOptions(), other.primaryYAxisDisplayOptions()) && Objects.equals(this.primaryYAxisLabelOptions(), other.primaryYAxisLabelOptions()) && Objects.equals(this.legend(), other.legend()) && Objects.equals(this.tooltip(), other.tooltip()) && this.hasReferenceLines() == other.hasReferenceLines() && Objects.equals(this.referenceLines(), other.referenceLines()) && Objects.equals(this.visualPalette(), other.visualPalette()) && Objects.equals(this.interactions(), other.interactions());
    }

    public final String toString() {
        return ToString.builder((String)"BoxPlotChartConfiguration").add("FieldWells", (Object)this.fieldWells()).add("SortConfiguration", (Object)this.sortConfiguration()).add("BoxPlotOptions", (Object)this.boxPlotOptions()).add("CategoryAxis", (Object)this.categoryAxis()).add("CategoryLabelOptions", (Object)this.categoryLabelOptions()).add("PrimaryYAxisDisplayOptions", (Object)this.primaryYAxisDisplayOptions()).add("PrimaryYAxisLabelOptions", (Object)this.primaryYAxisLabelOptions()).add("Legend", (Object)this.legend()).add("Tooltip", (Object)this.tooltip()).add("ReferenceLines", this.hasReferenceLines() ? this.referenceLines() : null).add("VisualPalette", (Object)this.visualPalette()).add("Interactions", (Object)this.interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldWells": {
                return Optional.ofNullable(clazz.cast(this.fieldWells()));
            }
            case "SortConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sortConfiguration()));
            }
            case "BoxPlotOptions": {
                return Optional.ofNullable(clazz.cast(this.boxPlotOptions()));
            }
            case "CategoryAxis": {
                return Optional.ofNullable(clazz.cast(this.categoryAxis()));
            }
            case "CategoryLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.categoryLabelOptions()));
            }
            case "PrimaryYAxisDisplayOptions": {
                return Optional.ofNullable(clazz.cast(this.primaryYAxisDisplayOptions()));
            }
            case "PrimaryYAxisLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.primaryYAxisLabelOptions()));
            }
            case "Legend": {
                return Optional.ofNullable(clazz.cast(this.legend()));
            }
            case "Tooltip": {
                return Optional.ofNullable(clazz.cast(this.tooltip()));
            }
            case "ReferenceLines": {
                return Optional.ofNullable(clazz.cast(this.referenceLines()));
            }
            case "VisualPalette": {
                return Optional.ofNullable(clazz.cast(this.visualPalette()));
            }
            case "Interactions": {
                return Optional.ofNullable(clazz.cast(this.interactions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FieldWells", FIELD_WELLS_FIELD);
        map.put("SortConfiguration", SORT_CONFIGURATION_FIELD);
        map.put("BoxPlotOptions", BOX_PLOT_OPTIONS_FIELD);
        map.put("CategoryAxis", CATEGORY_AXIS_FIELD);
        map.put("CategoryLabelOptions", CATEGORY_LABEL_OPTIONS_FIELD);
        map.put("PrimaryYAxisDisplayOptions", PRIMARY_Y_AXIS_DISPLAY_OPTIONS_FIELD);
        map.put("PrimaryYAxisLabelOptions", PRIMARY_Y_AXIS_LABEL_OPTIONS_FIELD);
        map.put("Legend", LEGEND_FIELD);
        map.put("Tooltip", TOOLTIP_FIELD);
        map.put("ReferenceLines", REFERENCE_LINES_FIELD);
        map.put("VisualPalette", VISUAL_PALETTE_FIELD);
        map.put("Interactions", INTERACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BoxPlotChartConfiguration, T> g) {
        return obj -> g.apply((BoxPlotChartConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BoxPlotFieldWells fieldWells;
        private BoxPlotSortConfiguration sortConfiguration;
        private BoxPlotOptions boxPlotOptions;
        private AxisDisplayOptions categoryAxis;
        private ChartAxisLabelOptions categoryLabelOptions;
        private AxisDisplayOptions primaryYAxisDisplayOptions;
        private ChartAxisLabelOptions primaryYAxisLabelOptions;
        private LegendOptions legend;
        private TooltipOptions tooltip;
        private List<ReferenceLine> referenceLines = DefaultSdkAutoConstructList.getInstance();
        private VisualPalette visualPalette;
        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(BoxPlotChartConfiguration model) {
            this.fieldWells(model.fieldWells);
            this.sortConfiguration(model.sortConfiguration);
            this.boxPlotOptions(model.boxPlotOptions);
            this.categoryAxis(model.categoryAxis);
            this.categoryLabelOptions(model.categoryLabelOptions);
            this.primaryYAxisDisplayOptions(model.primaryYAxisDisplayOptions);
            this.primaryYAxisLabelOptions(model.primaryYAxisLabelOptions);
            this.legend(model.legend);
            this.tooltip(model.tooltip);
            this.referenceLines(model.referenceLines);
            this.visualPalette(model.visualPalette);
            this.interactions(model.interactions);
        }

        public final BoxPlotFieldWells.Builder getFieldWells() {
            return this.fieldWells != null ? this.fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(BoxPlotFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(BoxPlotFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final BoxPlotSortConfiguration.Builder getSortConfiguration() {
            return this.sortConfiguration != null ? this.sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(BoxPlotSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(BoxPlotSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final BoxPlotOptions.Builder getBoxPlotOptions() {
            return this.boxPlotOptions != null ? this.boxPlotOptions.toBuilder() : null;
        }

        public final void setBoxPlotOptions(BoxPlotOptions.BuilderImpl boxPlotOptions) {
            this.boxPlotOptions = boxPlotOptions != null ? boxPlotOptions.build() : null;
        }

        @Override
        public final Builder boxPlotOptions(BoxPlotOptions boxPlotOptions) {
            this.boxPlotOptions = boxPlotOptions;
            return this;
        }

        public final AxisDisplayOptions.Builder getCategoryAxis() {
            return this.categoryAxis != null ? this.categoryAxis.toBuilder() : null;
        }

        public final void setCategoryAxis(AxisDisplayOptions.BuilderImpl categoryAxis) {
            this.categoryAxis = categoryAxis != null ? categoryAxis.build() : null;
        }

        @Override
        public final Builder categoryAxis(AxisDisplayOptions categoryAxis) {
            this.categoryAxis = categoryAxis;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getCategoryLabelOptions() {
            return this.categoryLabelOptions != null ? this.categoryLabelOptions.toBuilder() : null;
        }

        public final void setCategoryLabelOptions(ChartAxisLabelOptions.BuilderImpl categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions != null ? categoryLabelOptions.build() : null;
        }

        @Override
        public final Builder categoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions;
            return this;
        }

        public final AxisDisplayOptions.Builder getPrimaryYAxisDisplayOptions() {
            return this.primaryYAxisDisplayOptions != null ? this.primaryYAxisDisplayOptions.toBuilder() : null;
        }

        public final void setPrimaryYAxisDisplayOptions(AxisDisplayOptions.BuilderImpl primaryYAxisDisplayOptions) {
            this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions != null ? primaryYAxisDisplayOptions.build() : null;
        }

        @Override
        public final Builder primaryYAxisDisplayOptions(AxisDisplayOptions primaryYAxisDisplayOptions) {
            this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getPrimaryYAxisLabelOptions() {
            return this.primaryYAxisLabelOptions != null ? this.primaryYAxisLabelOptions.toBuilder() : null;
        }

        public final void setPrimaryYAxisLabelOptions(ChartAxisLabelOptions.BuilderImpl primaryYAxisLabelOptions) {
            this.primaryYAxisLabelOptions = primaryYAxisLabelOptions != null ? primaryYAxisLabelOptions.build() : null;
        }

        @Override
        public final Builder primaryYAxisLabelOptions(ChartAxisLabelOptions primaryYAxisLabelOptions) {
            this.primaryYAxisLabelOptions = primaryYAxisLabelOptions;
            return this;
        }

        public final LegendOptions.Builder getLegend() {
            return this.legend != null ? this.legend.toBuilder() : null;
        }

        public final void setLegend(LegendOptions.BuilderImpl legend) {
            this.legend = legend != null ? legend.build() : null;
        }

        @Override
        public final Builder legend(LegendOptions legend) {
            this.legend = legend;
            return this;
        }

        public final TooltipOptions.Builder getTooltip() {
            return this.tooltip != null ? this.tooltip.toBuilder() : null;
        }

        public final void setTooltip(TooltipOptions.BuilderImpl tooltip) {
            this.tooltip = tooltip != null ? tooltip.build() : null;
        }

        @Override
        public final Builder tooltip(TooltipOptions tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public final List<ReferenceLine.Builder> getReferenceLines() {
            List<ReferenceLine.Builder> result = ReferenceLineListCopier.copyToBuilder(this.referenceLines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferenceLines(Collection<ReferenceLine.BuilderImpl> referenceLines) {
            this.referenceLines = ReferenceLineListCopier.copyFromBuilder(referenceLines);
        }

        @Override
        public final Builder referenceLines(Collection<ReferenceLine> referenceLines) {
            this.referenceLines = ReferenceLineListCopier.copy(referenceLines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceLines(ReferenceLine ... referenceLines) {
            this.referenceLines(Arrays.asList(referenceLines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceLines(Consumer<ReferenceLine.Builder> ... referenceLines) {
            this.referenceLines(Stream.of(referenceLines).map(c -> (ReferenceLine)((ReferenceLine.Builder)ReferenceLine.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final VisualPalette.Builder getVisualPalette() {
            return this.visualPalette != null ? this.visualPalette.toBuilder() : null;
        }

        public final void setVisualPalette(VisualPalette.BuilderImpl visualPalette) {
            this.visualPalette = visualPalette != null ? visualPalette.build() : null;
        }

        @Override
        public final Builder visualPalette(VisualPalette visualPalette) {
            this.visualPalette = visualPalette;
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return this.interactions != null ? this.interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        public BoxPlotChartConfiguration build() {
            return new BoxPlotChartConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BoxPlotChartConfiguration> {
        public Builder fieldWells(BoxPlotFieldWells var1);

        default public Builder fieldWells(Consumer<BoxPlotFieldWells.Builder> fieldWells) {
            return this.fieldWells((BoxPlotFieldWells)((BoxPlotFieldWells.Builder)BoxPlotFieldWells.builder().applyMutation(fieldWells)).build());
        }

        public Builder sortConfiguration(BoxPlotSortConfiguration var1);

        default public Builder sortConfiguration(Consumer<BoxPlotSortConfiguration.Builder> sortConfiguration) {
            return this.sortConfiguration((BoxPlotSortConfiguration)((BoxPlotSortConfiguration.Builder)BoxPlotSortConfiguration.builder().applyMutation(sortConfiguration)).build());
        }

        public Builder boxPlotOptions(BoxPlotOptions var1);

        default public Builder boxPlotOptions(Consumer<BoxPlotOptions.Builder> boxPlotOptions) {
            return this.boxPlotOptions((BoxPlotOptions)((BoxPlotOptions.Builder)BoxPlotOptions.builder().applyMutation(boxPlotOptions)).build());
        }

        public Builder categoryAxis(AxisDisplayOptions var1);

        default public Builder categoryAxis(Consumer<AxisDisplayOptions.Builder> categoryAxis) {
            return this.categoryAxis((AxisDisplayOptions)((AxisDisplayOptions.Builder)AxisDisplayOptions.builder().applyMutation(categoryAxis)).build());
        }

        public Builder categoryLabelOptions(ChartAxisLabelOptions var1);

        default public Builder categoryLabelOptions(Consumer<ChartAxisLabelOptions.Builder> categoryLabelOptions) {
            return this.categoryLabelOptions((ChartAxisLabelOptions)((ChartAxisLabelOptions.Builder)ChartAxisLabelOptions.builder().applyMutation(categoryLabelOptions)).build());
        }

        public Builder primaryYAxisDisplayOptions(AxisDisplayOptions var1);

        default public Builder primaryYAxisDisplayOptions(Consumer<AxisDisplayOptions.Builder> primaryYAxisDisplayOptions) {
            return this.primaryYAxisDisplayOptions((AxisDisplayOptions)((AxisDisplayOptions.Builder)AxisDisplayOptions.builder().applyMutation(primaryYAxisDisplayOptions)).build());
        }

        public Builder primaryYAxisLabelOptions(ChartAxisLabelOptions var1);

        default public Builder primaryYAxisLabelOptions(Consumer<ChartAxisLabelOptions.Builder> primaryYAxisLabelOptions) {
            return this.primaryYAxisLabelOptions((ChartAxisLabelOptions)((ChartAxisLabelOptions.Builder)ChartAxisLabelOptions.builder().applyMutation(primaryYAxisLabelOptions)).build());
        }

        public Builder legend(LegendOptions var1);

        default public Builder legend(Consumer<LegendOptions.Builder> legend) {
            return this.legend((LegendOptions)((LegendOptions.Builder)LegendOptions.builder().applyMutation(legend)).build());
        }

        public Builder tooltip(TooltipOptions var1);

        default public Builder tooltip(Consumer<TooltipOptions.Builder> tooltip) {
            return this.tooltip((TooltipOptions)((TooltipOptions.Builder)TooltipOptions.builder().applyMutation(tooltip)).build());
        }

        public Builder referenceLines(Collection<ReferenceLine> var1);

        public Builder referenceLines(ReferenceLine ... var1);

        public Builder referenceLines(Consumer<ReferenceLine.Builder> ... var1);

        public Builder visualPalette(VisualPalette var1);

        default public Builder visualPalette(Consumer<VisualPalette.Builder> visualPalette) {
            return this.visualPalette((VisualPalette)((VisualPalette.Builder)VisualPalette.builder().applyMutation(visualPalette)).build());
        }

        public Builder interactions(VisualInteractionOptions var1);

        default public Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return this.interactions((VisualInteractionOptions)((VisualInteractionOptions.Builder)VisualInteractionOptions.builder().applyMutation(interactions)).build());
        }
    }
}

