/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field wells of a word cloud visual.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WordCloudFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<WordCloudFieldWells.Builder, WordCloudFieldWells> {
    private static final SdkField<WordCloudAggregatedFieldWells> WORD_CLOUD_AGGREGATED_FIELD_WELLS_FIELD = SdkField
            .<WordCloudAggregatedFieldWells> builder(MarshallingType.SDK_POJO)
            .memberName("WordCloudAggregatedFieldWells")
            .getter(getter(WordCloudFieldWells::wordCloudAggregatedFieldWells))
            .setter(setter(Builder::wordCloudAggregatedFieldWells))
            .constructor(WordCloudAggregatedFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WordCloudAggregatedFieldWells")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(WORD_CLOUD_AGGREGATED_FIELD_WELLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final WordCloudAggregatedFieldWells wordCloudAggregatedFieldWells;

    private WordCloudFieldWells(BuilderImpl builder) {
        this.wordCloudAggregatedFieldWells = builder.wordCloudAggregatedFieldWells;
    }

    /**
     * <p>
     * The aggregated field wells of a word cloud.
     * </p>
     * 
     * @return The aggregated field wells of a word cloud.
     */
    public final WordCloudAggregatedFieldWells wordCloudAggregatedFieldWells() {
        return wordCloudAggregatedFieldWells;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(wordCloudAggregatedFieldWells());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WordCloudFieldWells)) {
            return false;
        }
        WordCloudFieldWells other = (WordCloudFieldWells) obj;
        return Objects.equals(wordCloudAggregatedFieldWells(), other.wordCloudAggregatedFieldWells());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WordCloudFieldWells").add("WordCloudAggregatedFieldWells", wordCloudAggregatedFieldWells())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WordCloudAggregatedFieldWells":
            return Optional.ofNullable(clazz.cast(wordCloudAggregatedFieldWells()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WordCloudAggregatedFieldWells", WORD_CLOUD_AGGREGATED_FIELD_WELLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WordCloudFieldWells, T> g) {
        return obj -> g.apply((WordCloudFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WordCloudFieldWells> {
        /**
         * <p>
         * The aggregated field wells of a word cloud.
         * </p>
         * 
         * @param wordCloudAggregatedFieldWells
         *        The aggregated field wells of a word cloud.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wordCloudAggregatedFieldWells(WordCloudAggregatedFieldWells wordCloudAggregatedFieldWells);

        /**
         * <p>
         * The aggregated field wells of a word cloud.
         * </p>
         * This is a convenience method that creates an instance of the {@link WordCloudAggregatedFieldWells.Builder}
         * avoiding the need to create one manually via {@link WordCloudAggregatedFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WordCloudAggregatedFieldWells.Builder#build()} is called
         * immediately and its result is passed to {@link #wordCloudAggregatedFieldWells(WordCloudAggregatedFieldWells)}.
         * 
         * @param wordCloudAggregatedFieldWells
         *        a consumer that will call methods on {@link WordCloudAggregatedFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wordCloudAggregatedFieldWells(WordCloudAggregatedFieldWells)
         */
        default Builder wordCloudAggregatedFieldWells(
                Consumer<WordCloudAggregatedFieldWells.Builder> wordCloudAggregatedFieldWells) {
            return wordCloudAggregatedFieldWells(WordCloudAggregatedFieldWells.builder()
                    .applyMutation(wordCloudAggregatedFieldWells).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private WordCloudAggregatedFieldWells wordCloudAggregatedFieldWells;

        private BuilderImpl() {
        }

        private BuilderImpl(WordCloudFieldWells model) {
            wordCloudAggregatedFieldWells(model.wordCloudAggregatedFieldWells);
        }

        public final WordCloudAggregatedFieldWells.Builder getWordCloudAggregatedFieldWells() {
            return wordCloudAggregatedFieldWells != null ? wordCloudAggregatedFieldWells.toBuilder() : null;
        }

        public final void setWordCloudAggregatedFieldWells(WordCloudAggregatedFieldWells.BuilderImpl wordCloudAggregatedFieldWells) {
            this.wordCloudAggregatedFieldWells = wordCloudAggregatedFieldWells != null ? wordCloudAggregatedFieldWells.build()
                    : null;
        }

        @Override
        public final Builder wordCloudAggregatedFieldWells(WordCloudAggregatedFieldWells wordCloudAggregatedFieldWells) {
            this.wordCloudAggregatedFieldWells = wordCloudAggregatedFieldWells;
            return this;
        }

        @Override
        public WordCloudFieldWells build() {
            return new WordCloudFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
