/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determines the typography options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Typography implements SdkPojo, Serializable, ToCopyableBuilder<Typography.Builder, Typography> {
    private static final SdkField<List<Font>> FONT_FAMILIES_FIELD = SdkField
            .<List<Font>> builder(MarshallingType.LIST)
            .memberName("FontFamilies")
            .getter(getter(Typography::fontFamilies))
            .setter(setter(Builder::fontFamilies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontFamilies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Font> builder(MarshallingType.SDK_POJO)
                                            .constructor(Font::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FONT_FAMILIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Font> fontFamilies;

    private Typography(BuilderImpl builder) {
        this.fontFamilies = builder.fontFamilies;
    }

    /**
     * For responses, this returns true if the service returned a value for the FontFamilies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFontFamilies() {
        return fontFamilies != null && !(fontFamilies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Determines the list of font families.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFontFamilies} method.
     * </p>
     * 
     * @return Determines the list of font families.
     */
    public final List<Font> fontFamilies() {
        return fontFamilies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFontFamilies() ? fontFamilies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Typography)) {
            return false;
        }
        Typography other = (Typography) obj;
        return hasFontFamilies() == other.hasFontFamilies() && Objects.equals(fontFamilies(), other.fontFamilies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Typography").add("FontFamilies", hasFontFamilies() ? fontFamilies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FontFamilies":
            return Optional.ofNullable(clazz.cast(fontFamilies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FontFamilies", FONT_FAMILIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Typography, T> g) {
        return obj -> g.apply((Typography) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Typography> {
        /**
         * <p>
         * Determines the list of font families.
         * </p>
         * 
         * @param fontFamilies
         *        Determines the list of font families.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontFamilies(Collection<Font> fontFamilies);

        /**
         * <p>
         * Determines the list of font families.
         * </p>
         * 
         * @param fontFamilies
         *        Determines the list of font families.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontFamilies(Font... fontFamilies);

        /**
         * <p>
         * Determines the list of font families.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.Font.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.Font#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.Font.Builder#build()} is called immediately and its
         * result is passed to {@link #fontFamilies(List<Font>)}.
         * 
         * @param fontFamilies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.Font.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fontFamilies(java.util.Collection<Font>)
         */
        Builder fontFamilies(Consumer<Font.Builder>... fontFamilies);
    }

    static final class BuilderImpl implements Builder {
        private List<Font> fontFamilies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Typography model) {
            fontFamilies(model.fontFamilies);
        }

        public final List<Font.Builder> getFontFamilies() {
            List<Font.Builder> result = FontListCopier.copyToBuilder(this.fontFamilies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFontFamilies(Collection<Font.BuilderImpl> fontFamilies) {
            this.fontFamilies = FontListCopier.copyFromBuilder(fontFamilies);
        }

        @Override
        public final Builder fontFamilies(Collection<Font> fontFamilies) {
            this.fontFamilies = FontListCopier.copy(fontFamilies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fontFamilies(Font... fontFamilies) {
            fontFamilies(Arrays.asList(fontFamilies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fontFamilies(Consumer<Font.Builder>... fontFamilies) {
            fontFamilies(Stream.of(fontFamilies).map(c -> Font.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Typography build() {
            return new Typography(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
