/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The tooltip.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TooltipItem implements SdkPojo, Serializable, ToCopyableBuilder<TooltipItem.Builder, TooltipItem> {
    private static final SdkField<FieldTooltipItem> FIELD_TOOLTIP_ITEM_FIELD = SdkField
            .<FieldTooltipItem> builder(MarshallingType.SDK_POJO).memberName("FieldTooltipItem")
            .getter(getter(TooltipItem::fieldTooltipItem)).setter(setter(Builder::fieldTooltipItem))
            .constructor(FieldTooltipItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldTooltipItem").build()).build();

    private static final SdkField<ColumnTooltipItem> COLUMN_TOOLTIP_ITEM_FIELD = SdkField
            .<ColumnTooltipItem> builder(MarshallingType.SDK_POJO).memberName("ColumnTooltipItem")
            .getter(getter(TooltipItem::columnTooltipItem)).setter(setter(Builder::columnTooltipItem))
            .constructor(ColumnTooltipItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnTooltipItem").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_TOOLTIP_ITEM_FIELD,
            COLUMN_TOOLTIP_ITEM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FieldTooltipItem fieldTooltipItem;

    private final ColumnTooltipItem columnTooltipItem;

    private TooltipItem(BuilderImpl builder) {
        this.fieldTooltipItem = builder.fieldTooltipItem;
        this.columnTooltipItem = builder.columnTooltipItem;
    }

    /**
     * <p>
     * The tooltip item for the fields.
     * </p>
     * 
     * @return The tooltip item for the fields.
     */
    public final FieldTooltipItem fieldTooltipItem() {
        return fieldTooltipItem;
    }

    /**
     * <p>
     * The tooltip item for the columns that are not part of a field well.
     * </p>
     * 
     * @return The tooltip item for the columns that are not part of a field well.
     */
    public final ColumnTooltipItem columnTooltipItem() {
        return columnTooltipItem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldTooltipItem());
        hashCode = 31 * hashCode + Objects.hashCode(columnTooltipItem());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TooltipItem)) {
            return false;
        }
        TooltipItem other = (TooltipItem) obj;
        return Objects.equals(fieldTooltipItem(), other.fieldTooltipItem())
                && Objects.equals(columnTooltipItem(), other.columnTooltipItem());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TooltipItem").add("FieldTooltipItem", fieldTooltipItem())
                .add("ColumnTooltipItem", columnTooltipItem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldTooltipItem":
            return Optional.ofNullable(clazz.cast(fieldTooltipItem()));
        case "ColumnTooltipItem":
            return Optional.ofNullable(clazz.cast(columnTooltipItem()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldTooltipItem", FIELD_TOOLTIP_ITEM_FIELD);
        map.put("ColumnTooltipItem", COLUMN_TOOLTIP_ITEM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TooltipItem, T> g) {
        return obj -> g.apply((TooltipItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TooltipItem> {
        /**
         * <p>
         * The tooltip item for the fields.
         * </p>
         * 
         * @param fieldTooltipItem
         *        The tooltip item for the fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldTooltipItem(FieldTooltipItem fieldTooltipItem);

        /**
         * <p>
         * The tooltip item for the fields.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldTooltipItem.Builder} avoiding the
         * need to create one manually via {@link FieldTooltipItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldTooltipItem.Builder#build()} is called immediately and its
         * result is passed to {@link #fieldTooltipItem(FieldTooltipItem)}.
         * 
         * @param fieldTooltipItem
         *        a consumer that will call methods on {@link FieldTooltipItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldTooltipItem(FieldTooltipItem)
         */
        default Builder fieldTooltipItem(Consumer<FieldTooltipItem.Builder> fieldTooltipItem) {
            return fieldTooltipItem(FieldTooltipItem.builder().applyMutation(fieldTooltipItem).build());
        }

        /**
         * <p>
         * The tooltip item for the columns that are not part of a field well.
         * </p>
         * 
         * @param columnTooltipItem
         *        The tooltip item for the columns that are not part of a field well.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnTooltipItem(ColumnTooltipItem columnTooltipItem);

        /**
         * <p>
         * The tooltip item for the columns that are not part of a field well.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnTooltipItem.Builder} avoiding the
         * need to create one manually via {@link ColumnTooltipItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnTooltipItem.Builder#build()} is called immediately and its
         * result is passed to {@link #columnTooltipItem(ColumnTooltipItem)}.
         * 
         * @param columnTooltipItem
         *        a consumer that will call methods on {@link ColumnTooltipItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnTooltipItem(ColumnTooltipItem)
         */
        default Builder columnTooltipItem(Consumer<ColumnTooltipItem.Builder> columnTooltipItem) {
            return columnTooltipItem(ColumnTooltipItem.builder().applyMutation(columnTooltipItem).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FieldTooltipItem fieldTooltipItem;

        private ColumnTooltipItem columnTooltipItem;

        private BuilderImpl() {
        }

        private BuilderImpl(TooltipItem model) {
            fieldTooltipItem(model.fieldTooltipItem);
            columnTooltipItem(model.columnTooltipItem);
        }

        public final FieldTooltipItem.Builder getFieldTooltipItem() {
            return fieldTooltipItem != null ? fieldTooltipItem.toBuilder() : null;
        }

        public final void setFieldTooltipItem(FieldTooltipItem.BuilderImpl fieldTooltipItem) {
            this.fieldTooltipItem = fieldTooltipItem != null ? fieldTooltipItem.build() : null;
        }

        @Override
        public final Builder fieldTooltipItem(FieldTooltipItem fieldTooltipItem) {
            this.fieldTooltipItem = fieldTooltipItem;
            return this;
        }

        public final ColumnTooltipItem.Builder getColumnTooltipItem() {
            return columnTooltipItem != null ? columnTooltipItem.toBuilder() : null;
        }

        public final void setColumnTooltipItem(ColumnTooltipItem.BuilderImpl columnTooltipItem) {
            this.columnTooltipItem = columnTooltipItem != null ? columnTooltipItem.build() : null;
        }

        @Override
        public final Builder columnTooltipItem(ColumnTooltipItem columnTooltipItem) {
            this.columnTooltipItem = columnTooltipItem;
            return this;
        }

        @Override
        public TooltipItem build() {
            return new TooltipItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
