/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDataSetRefreshPropertiesRequest extends QuickSightRequest implements
        ToCopyableBuilder<PutDataSetRefreshPropertiesRequest.Builder, PutDataSetRefreshPropertiesRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(PutDataSetRefreshPropertiesRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetId").getter(getter(PutDataSetRefreshPropertiesRequest::dataSetId))
            .setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataSetId").build()).build();

    private static final SdkField<DataSetRefreshProperties> DATA_SET_REFRESH_PROPERTIES_FIELD = SdkField
            .<DataSetRefreshProperties> builder(MarshallingType.SDK_POJO).memberName("DataSetRefreshProperties")
            .getter(getter(PutDataSetRefreshPropertiesRequest::dataSetRefreshProperties))
            .setter(setter(Builder::dataSetRefreshProperties)).constructor(DataSetRefreshProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetRefreshProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            DATA_SET_ID_FIELD, DATA_SET_REFRESH_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String dataSetId;

    private final DataSetRefreshProperties dataSetRefreshProperties;

    private PutDataSetRefreshPropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dataSetId = builder.dataSetId;
        this.dataSetRefreshProperties = builder.dataSetRefreshProperties;
    }

    /**
     * <p>
     * The Amazon Web Services account ID.
     * </p>
     * 
     * @return The Amazon Web Services account ID.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID of the dataset.
     * </p>
     * 
     * @return The ID of the dataset.
     */
    public final String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * The dataset refresh properties.
     * </p>
     * 
     * @return The dataset refresh properties.
     */
    public final DataSetRefreshProperties dataSetRefreshProperties() {
        return dataSetRefreshProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetRefreshProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDataSetRefreshPropertiesRequest)) {
            return false;
        }
        PutDataSetRefreshPropertiesRequest other = (PutDataSetRefreshPropertiesRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(dataSetId(), other.dataSetId())
                && Objects.equals(dataSetRefreshProperties(), other.dataSetRefreshProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutDataSetRefreshPropertiesRequest").add("AwsAccountId", awsAccountId())
                .add("DataSetId", dataSetId()).add("DataSetRefreshProperties", dataSetRefreshProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "DataSetRefreshProperties":
            return Optional.ofNullable(clazz.cast(dataSetRefreshProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("DataSetId", DATA_SET_ID_FIELD);
        map.put("DataSetRefreshProperties", DATA_SET_REFRESH_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutDataSetRefreshPropertiesRequest, T> g) {
        return obj -> g.apply((PutDataSetRefreshPropertiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutDataSetRefreshPropertiesRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID of the dataset.
         * </p>
         * 
         * @param dataSetId
         *        The ID of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * The dataset refresh properties.
         * </p>
         * 
         * @param dataSetRefreshProperties
         *        The dataset refresh properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetRefreshProperties(DataSetRefreshProperties dataSetRefreshProperties);

        /**
         * <p>
         * The dataset refresh properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSetRefreshProperties.Builder}
         * avoiding the need to create one manually via {@link DataSetRefreshProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSetRefreshProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSetRefreshProperties(DataSetRefreshProperties)}.
         * 
         * @param dataSetRefreshProperties
         *        a consumer that will call methods on {@link DataSetRefreshProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSetRefreshProperties(DataSetRefreshProperties)
         */
        default Builder dataSetRefreshProperties(Consumer<DataSetRefreshProperties.Builder> dataSetRefreshProperties) {
            return dataSetRefreshProperties(DataSetRefreshProperties.builder().applyMutation(dataSetRefreshProperties).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String dataSetId;

        private DataSetRefreshProperties dataSetRefreshProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDataSetRefreshPropertiesRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            dataSetId(model.dataSetId);
            dataSetRefreshProperties(model.dataSetRefreshProperties);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final DataSetRefreshProperties.Builder getDataSetRefreshProperties() {
            return dataSetRefreshProperties != null ? dataSetRefreshProperties.toBuilder() : null;
        }

        public final void setDataSetRefreshProperties(DataSetRefreshProperties.BuilderImpl dataSetRefreshProperties) {
            this.dataSetRefreshProperties = dataSetRefreshProperties != null ? dataSetRefreshProperties.build() : null;
        }

        @Override
        public final Builder dataSetRefreshProperties(DataSetRefreshProperties dataSetRefreshProperties) {
            this.dataSetRefreshProperties = dataSetRefreshProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDataSetRefreshPropertiesRequest build() {
            return new PutDataSetRefreshPropertiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
