/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A view of a data source that contains information about the shape of the data in the underlying source. This is a
 * variant type structure. For this structure to be valid, only one of the attributes can be non-null.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PhysicalTable implements SdkPojo, Serializable, ToCopyableBuilder<PhysicalTable.Builder, PhysicalTable> {
    private static final SdkField<RelationalTable> RELATIONAL_TABLE_FIELD = SdkField
            .<RelationalTable> builder(MarshallingType.SDK_POJO).memberName("RelationalTable")
            .getter(getter(PhysicalTable::relationalTable)).setter(setter(Builder::relationalTable))
            .constructor(RelationalTable::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelationalTable").build()).build();

    private static final SdkField<CustomSql> CUSTOM_SQL_FIELD = SdkField.<CustomSql> builder(MarshallingType.SDK_POJO)
            .memberName("CustomSql").getter(getter(PhysicalTable::customSql)).setter(setter(Builder::customSql))
            .constructor(CustomSql::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomSql").build()).build();

    private static final SdkField<S3Source> S3_SOURCE_FIELD = SdkField.<S3Source> builder(MarshallingType.SDK_POJO)
            .memberName("S3Source").getter(getter(PhysicalTable::s3Source)).setter(setter(Builder::s3Source))
            .constructor(S3Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIONAL_TABLE_FIELD,
            CUSTOM_SQL_FIELD, S3_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RelationalTable relationalTable;

    private final CustomSql customSql;

    private final S3Source s3Source;

    private final Type type;

    private PhysicalTable(BuilderImpl builder) {
        this.relationalTable = builder.relationalTable;
        this.customSql = builder.customSql;
        this.s3Source = builder.s3Source;
        this.type = builder.type;
    }

    /**
     * <p>
     * A physical table type for relational data sources.
     * </p>
     * 
     * @return A physical table type for relational data sources.
     */
    public final RelationalTable relationalTable() {
        return relationalTable;
    }

    /**
     * <p>
     * A physical table type built from the results of the custom SQL query.
     * </p>
     * 
     * @return A physical table type built from the results of the custom SQL query.
     */
    public final CustomSql customSql() {
        return customSql;
    }

    /**
     * <p>
     * A physical table type for as S3 data source.
     * </p>
     * 
     * @return A physical table type for as S3 data source.
     */
    public final S3Source s3Source() {
        return s3Source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(relationalTable());
        hashCode = 31 * hashCode + Objects.hashCode(customSql());
        hashCode = 31 * hashCode + Objects.hashCode(s3Source());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhysicalTable)) {
            return false;
        }
        PhysicalTable other = (PhysicalTable) obj;
        return Objects.equals(relationalTable(), other.relationalTable()) && Objects.equals(customSql(), other.customSql())
                && Objects.equals(s3Source(), other.s3Source());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PhysicalTable").add("RelationalTable", relationalTable()).add("CustomSql", customSql())
                .add("S3Source", s3Source()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RelationalTable":
            return Optional.ofNullable(clazz.cast(relationalTable()));
        case "CustomSql":
            return Optional.ofNullable(clazz.cast(customSql()));
        case "S3Source":
            return Optional.ofNullable(clazz.cast(s3Source()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #relationalTable()} initialized to the given value.
     *
     * <p>
     * A physical table type for relational data sources.
     * </p>
     * 
     * @param relationalTable
     *        A physical table type for relational data sources.
     */
    public static PhysicalTable fromRelationalTable(RelationalTable relationalTable) {
        return builder().relationalTable(relationalTable).build();
    }

    /**
     * Create an instance of this class with {@link #relationalTable()} initialized to the given value.
     *
     * <p>
     * A physical table type for relational data sources.
     * </p>
     * 
     * @param relationalTable
     *        A physical table type for relational data sources.
     */
    public static PhysicalTable fromRelationalTable(Consumer<RelationalTable.Builder> relationalTable) {
        RelationalTable.Builder builder = RelationalTable.builder();
        relationalTable.accept(builder);
        return fromRelationalTable(builder.build());
    }

    /**
     * Create an instance of this class with {@link #customSql()} initialized to the given value.
     *
     * <p>
     * A physical table type built from the results of the custom SQL query.
     * </p>
     * 
     * @param customSql
     *        A physical table type built from the results of the custom SQL query.
     */
    public static PhysicalTable fromCustomSql(CustomSql customSql) {
        return builder().customSql(customSql).build();
    }

    /**
     * Create an instance of this class with {@link #customSql()} initialized to the given value.
     *
     * <p>
     * A physical table type built from the results of the custom SQL query.
     * </p>
     * 
     * @param customSql
     *        A physical table type built from the results of the custom SQL query.
     */
    public static PhysicalTable fromCustomSql(Consumer<CustomSql.Builder> customSql) {
        CustomSql.Builder builder = CustomSql.builder();
        customSql.accept(builder);
        return fromCustomSql(builder.build());
    }

    /**
     * Create an instance of this class with {@link #s3Source()} initialized to the given value.
     *
     * <p>
     * A physical table type for as S3 data source.
     * </p>
     * 
     * @param s3Source
     *        A physical table type for as S3 data source.
     */
    public static PhysicalTable fromS3Source(S3Source s3Source) {
        return builder().s3Source(s3Source).build();
    }

    /**
     * Create an instance of this class with {@link #s3Source()} initialized to the given value.
     *
     * <p>
     * A physical table type for as S3 data source.
     * </p>
     * 
     * @param s3Source
     *        A physical table type for as S3 data source.
     */
    public static PhysicalTable fromS3Source(Consumer<S3Source.Builder> s3Source) {
        S3Source.Builder builder = S3Source.builder();
        s3Source.accept(builder);
        return fromS3Source(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RelationalTable", RELATIONAL_TABLE_FIELD);
        map.put("CustomSql", CUSTOM_SQL_FIELD);
        map.put("S3Source", S3_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PhysicalTable, T> g) {
        return obj -> g.apply((PhysicalTable) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PhysicalTable> {
        /**
         * <p>
         * A physical table type for relational data sources.
         * </p>
         * 
         * @param relationalTable
         *        A physical table type for relational data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalTable(RelationalTable relationalTable);

        /**
         * <p>
         * A physical table type for relational data sources.
         * </p>
         * This is a convenience method that creates an instance of the {@link RelationalTable.Builder} avoiding the
         * need to create one manually via {@link RelationalTable#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RelationalTable.Builder#build()} is called immediately and its
         * result is passed to {@link #relationalTable(RelationalTable)}.
         * 
         * @param relationalTable
         *        a consumer that will call methods on {@link RelationalTable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relationalTable(RelationalTable)
         */
        default Builder relationalTable(Consumer<RelationalTable.Builder> relationalTable) {
            return relationalTable(RelationalTable.builder().applyMutation(relationalTable).build());
        }

        /**
         * <p>
         * A physical table type built from the results of the custom SQL query.
         * </p>
         * 
         * @param customSql
         *        A physical table type built from the results of the custom SQL query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customSql(CustomSql customSql);

        /**
         * <p>
         * A physical table type built from the results of the custom SQL query.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomSql.Builder} avoiding the need to
         * create one manually via {@link CustomSql#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomSql.Builder#build()} is called immediately and its result
         * is passed to {@link #customSql(CustomSql)}.
         * 
         * @param customSql
         *        a consumer that will call methods on {@link CustomSql.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customSql(CustomSql)
         */
        default Builder customSql(Consumer<CustomSql.Builder> customSql) {
            return customSql(CustomSql.builder().applyMutation(customSql).build());
        }

        /**
         * <p>
         * A physical table type for as S3 data source.
         * </p>
         * 
         * @param s3Source
         *        A physical table type for as S3 data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Source(S3Source s3Source);

        /**
         * <p>
         * A physical table type for as S3 data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Source.Builder} avoiding the need to
         * create one manually via {@link S3Source#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Source.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Source(S3Source)}.
         * 
         * @param s3Source
         *        a consumer that will call methods on {@link S3Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Source(S3Source)
         */
        default Builder s3Source(Consumer<S3Source.Builder> s3Source) {
            return s3Source(S3Source.builder().applyMutation(s3Source).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RelationalTable relationalTable;

        private CustomSql customSql;

        private S3Source s3Source;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PhysicalTable model) {
            relationalTable(model.relationalTable);
            customSql(model.customSql);
            s3Source(model.s3Source);
        }

        public final RelationalTable.Builder getRelationalTable() {
            return relationalTable != null ? relationalTable.toBuilder() : null;
        }

        public final void setRelationalTable(RelationalTable.BuilderImpl relationalTable) {
            Object oldValue = this.relationalTable;
            this.relationalTable = relationalTable != null ? relationalTable.build() : null;
            handleUnionValueChange(Type.RELATIONAL_TABLE, oldValue, this.relationalTable);
        }

        @Override
        public final Builder relationalTable(RelationalTable relationalTable) {
            Object oldValue = this.relationalTable;
            this.relationalTable = relationalTable;
            handleUnionValueChange(Type.RELATIONAL_TABLE, oldValue, this.relationalTable);
            return this;
        }

        public final CustomSql.Builder getCustomSql() {
            return customSql != null ? customSql.toBuilder() : null;
        }

        public final void setCustomSql(CustomSql.BuilderImpl customSql) {
            Object oldValue = this.customSql;
            this.customSql = customSql != null ? customSql.build() : null;
            handleUnionValueChange(Type.CUSTOM_SQL, oldValue, this.customSql);
        }

        @Override
        public final Builder customSql(CustomSql customSql) {
            Object oldValue = this.customSql;
            this.customSql = customSql;
            handleUnionValueChange(Type.CUSTOM_SQL, oldValue, this.customSql);
            return this;
        }

        public final S3Source.Builder getS3Source() {
            return s3Source != null ? s3Source.toBuilder() : null;
        }

        public final void setS3Source(S3Source.BuilderImpl s3Source) {
            Object oldValue = this.s3Source;
            this.s3Source = s3Source != null ? s3Source.build() : null;
            handleUnionValueChange(Type.S3_SOURCE, oldValue, this.s3Source);
        }

        @Override
        public final Builder s3Source(S3Source s3Source) {
            Object oldValue = this.s3Source;
            this.s3Source = s3Source;
            handleUnionValueChange(Type.S3_SOURCE, oldValue, this.s3Source);
            return this;
        }

        @Override
        public PhysicalTable build() {
            return new PhysicalTable(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PhysicalTable#type()
     */
    public enum Type {
        RELATIONAL_TABLE,

        CUSTOM_SQL,

        S3_SOURCE,

        UNKNOWN_TO_SDK_VERSION
    }
}
