/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The declaration definition of a parameter.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html">Parameters in Amazon
 * QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterDeclaration implements SdkPojo, Serializable,
        ToCopyableBuilder<ParameterDeclaration.Builder, ParameterDeclaration> {
    private static final SdkField<StringParameterDeclaration> STRING_PARAMETER_DECLARATION_FIELD = SdkField
            .<StringParameterDeclaration> builder(MarshallingType.SDK_POJO)
            .memberName("StringParameterDeclaration")
            .getter(getter(ParameterDeclaration::stringParameterDeclaration))
            .setter(setter(Builder::stringParameterDeclaration))
            .constructor(StringParameterDeclaration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringParameterDeclaration").build())
            .build();

    private static final SdkField<DecimalParameterDeclaration> DECIMAL_PARAMETER_DECLARATION_FIELD = SdkField
            .<DecimalParameterDeclaration> builder(MarshallingType.SDK_POJO)
            .memberName("DecimalParameterDeclaration")
            .getter(getter(ParameterDeclaration::decimalParameterDeclaration))
            .setter(setter(Builder::decimalParameterDeclaration))
            .constructor(DecimalParameterDeclaration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecimalParameterDeclaration")
                    .build()).build();

    private static final SdkField<IntegerParameterDeclaration> INTEGER_PARAMETER_DECLARATION_FIELD = SdkField
            .<IntegerParameterDeclaration> builder(MarshallingType.SDK_POJO)
            .memberName("IntegerParameterDeclaration")
            .getter(getter(ParameterDeclaration::integerParameterDeclaration))
            .setter(setter(Builder::integerParameterDeclaration))
            .constructor(IntegerParameterDeclaration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerParameterDeclaration")
                    .build()).build();

    private static final SdkField<DateTimeParameterDeclaration> DATE_TIME_PARAMETER_DECLARATION_FIELD = SdkField
            .<DateTimeParameterDeclaration> builder(MarshallingType.SDK_POJO)
            .memberName("DateTimeParameterDeclaration")
            .getter(getter(ParameterDeclaration::dateTimeParameterDeclaration))
            .setter(setter(Builder::dateTimeParameterDeclaration))
            .constructor(DateTimeParameterDeclaration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateTimeParameterDeclaration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STRING_PARAMETER_DECLARATION_FIELD, DECIMAL_PARAMETER_DECLARATION_FIELD, INTEGER_PARAMETER_DECLARATION_FIELD,
            DATE_TIME_PARAMETER_DECLARATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final StringParameterDeclaration stringParameterDeclaration;

    private final DecimalParameterDeclaration decimalParameterDeclaration;

    private final IntegerParameterDeclaration integerParameterDeclaration;

    private final DateTimeParameterDeclaration dateTimeParameterDeclaration;

    private ParameterDeclaration(BuilderImpl builder) {
        this.stringParameterDeclaration = builder.stringParameterDeclaration;
        this.decimalParameterDeclaration = builder.decimalParameterDeclaration;
        this.integerParameterDeclaration = builder.integerParameterDeclaration;
        this.dateTimeParameterDeclaration = builder.dateTimeParameterDeclaration;
    }

    /**
     * <p>
     * A parameter declaration for the <code>String</code> data type.
     * </p>
     * 
     * @return A parameter declaration for the <code>String</code> data type.
     */
    public final StringParameterDeclaration stringParameterDeclaration() {
        return stringParameterDeclaration;
    }

    /**
     * <p>
     * A parameter declaration for the <code>Decimal</code> data type.
     * </p>
     * 
     * @return A parameter declaration for the <code>Decimal</code> data type.
     */
    public final DecimalParameterDeclaration decimalParameterDeclaration() {
        return decimalParameterDeclaration;
    }

    /**
     * <p>
     * A parameter declaration for the <code>Integer</code> data type.
     * </p>
     * 
     * @return A parameter declaration for the <code>Integer</code> data type.
     */
    public final IntegerParameterDeclaration integerParameterDeclaration() {
        return integerParameterDeclaration;
    }

    /**
     * <p>
     * A parameter declaration for the <code>DateTime</code> data type.
     * </p>
     * 
     * @return A parameter declaration for the <code>DateTime</code> data type.
     */
    public final DateTimeParameterDeclaration dateTimeParameterDeclaration() {
        return dateTimeParameterDeclaration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stringParameterDeclaration());
        hashCode = 31 * hashCode + Objects.hashCode(decimalParameterDeclaration());
        hashCode = 31 * hashCode + Objects.hashCode(integerParameterDeclaration());
        hashCode = 31 * hashCode + Objects.hashCode(dateTimeParameterDeclaration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterDeclaration)) {
            return false;
        }
        ParameterDeclaration other = (ParameterDeclaration) obj;
        return Objects.equals(stringParameterDeclaration(), other.stringParameterDeclaration())
                && Objects.equals(decimalParameterDeclaration(), other.decimalParameterDeclaration())
                && Objects.equals(integerParameterDeclaration(), other.integerParameterDeclaration())
                && Objects.equals(dateTimeParameterDeclaration(), other.dateTimeParameterDeclaration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParameterDeclaration").add("StringParameterDeclaration", stringParameterDeclaration())
                .add("DecimalParameterDeclaration", decimalParameterDeclaration())
                .add("IntegerParameterDeclaration", integerParameterDeclaration())
                .add("DateTimeParameterDeclaration", dateTimeParameterDeclaration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringParameterDeclaration":
            return Optional.ofNullable(clazz.cast(stringParameterDeclaration()));
        case "DecimalParameterDeclaration":
            return Optional.ofNullable(clazz.cast(decimalParameterDeclaration()));
        case "IntegerParameterDeclaration":
            return Optional.ofNullable(clazz.cast(integerParameterDeclaration()));
        case "DateTimeParameterDeclaration":
            return Optional.ofNullable(clazz.cast(dateTimeParameterDeclaration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StringParameterDeclaration", STRING_PARAMETER_DECLARATION_FIELD);
        map.put("DecimalParameterDeclaration", DECIMAL_PARAMETER_DECLARATION_FIELD);
        map.put("IntegerParameterDeclaration", INTEGER_PARAMETER_DECLARATION_FIELD);
        map.put("DateTimeParameterDeclaration", DATE_TIME_PARAMETER_DECLARATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParameterDeclaration, T> g) {
        return obj -> g.apply((ParameterDeclaration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterDeclaration> {
        /**
         * <p>
         * A parameter declaration for the <code>String</code> data type.
         * </p>
         * 
         * @param stringParameterDeclaration
         *        A parameter declaration for the <code>String</code> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringParameterDeclaration(StringParameterDeclaration stringParameterDeclaration);

        /**
         * <p>
         * A parameter declaration for the <code>String</code> data type.
         * </p>
         * This is a convenience method that creates an instance of the {@link StringParameterDeclaration.Builder}
         * avoiding the need to create one manually via {@link StringParameterDeclaration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringParameterDeclaration.Builder#build()} is called immediately
         * and its result is passed to {@link #stringParameterDeclaration(StringParameterDeclaration)}.
         * 
         * @param stringParameterDeclaration
         *        a consumer that will call methods on {@link StringParameterDeclaration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringParameterDeclaration(StringParameterDeclaration)
         */
        default Builder stringParameterDeclaration(Consumer<StringParameterDeclaration.Builder> stringParameterDeclaration) {
            return stringParameterDeclaration(StringParameterDeclaration.builder().applyMutation(stringParameterDeclaration)
                    .build());
        }

        /**
         * <p>
         * A parameter declaration for the <code>Decimal</code> data type.
         * </p>
         * 
         * @param decimalParameterDeclaration
         *        A parameter declaration for the <code>Decimal</code> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decimalParameterDeclaration(DecimalParameterDeclaration decimalParameterDeclaration);

        /**
         * <p>
         * A parameter declaration for the <code>Decimal</code> data type.
         * </p>
         * This is a convenience method that creates an instance of the {@link DecimalParameterDeclaration.Builder}
         * avoiding the need to create one manually via {@link DecimalParameterDeclaration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DecimalParameterDeclaration.Builder#build()} is called
         * immediately and its result is passed to {@link #decimalParameterDeclaration(DecimalParameterDeclaration)}.
         * 
         * @param decimalParameterDeclaration
         *        a consumer that will call methods on {@link DecimalParameterDeclaration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decimalParameterDeclaration(DecimalParameterDeclaration)
         */
        default Builder decimalParameterDeclaration(Consumer<DecimalParameterDeclaration.Builder> decimalParameterDeclaration) {
            return decimalParameterDeclaration(DecimalParameterDeclaration.builder().applyMutation(decimalParameterDeclaration)
                    .build());
        }

        /**
         * <p>
         * A parameter declaration for the <code>Integer</code> data type.
         * </p>
         * 
         * @param integerParameterDeclaration
         *        A parameter declaration for the <code>Integer</code> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerParameterDeclaration(IntegerParameterDeclaration integerParameterDeclaration);

        /**
         * <p>
         * A parameter declaration for the <code>Integer</code> data type.
         * </p>
         * This is a convenience method that creates an instance of the {@link IntegerParameterDeclaration.Builder}
         * avoiding the need to create one manually via {@link IntegerParameterDeclaration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntegerParameterDeclaration.Builder#build()} is called
         * immediately and its result is passed to {@link #integerParameterDeclaration(IntegerParameterDeclaration)}.
         * 
         * @param integerParameterDeclaration
         *        a consumer that will call methods on {@link IntegerParameterDeclaration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integerParameterDeclaration(IntegerParameterDeclaration)
         */
        default Builder integerParameterDeclaration(Consumer<IntegerParameterDeclaration.Builder> integerParameterDeclaration) {
            return integerParameterDeclaration(IntegerParameterDeclaration.builder().applyMutation(integerParameterDeclaration)
                    .build());
        }

        /**
         * <p>
         * A parameter declaration for the <code>DateTime</code> data type.
         * </p>
         * 
         * @param dateTimeParameterDeclaration
         *        A parameter declaration for the <code>DateTime</code> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTimeParameterDeclaration(DateTimeParameterDeclaration dateTimeParameterDeclaration);

        /**
         * <p>
         * A parameter declaration for the <code>DateTime</code> data type.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateTimeParameterDeclaration.Builder}
         * avoiding the need to create one manually via {@link DateTimeParameterDeclaration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateTimeParameterDeclaration.Builder#build()} is called
         * immediately and its result is passed to {@link #dateTimeParameterDeclaration(DateTimeParameterDeclaration)}.
         * 
         * @param dateTimeParameterDeclaration
         *        a consumer that will call methods on {@link DateTimeParameterDeclaration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateTimeParameterDeclaration(DateTimeParameterDeclaration)
         */
        default Builder dateTimeParameterDeclaration(Consumer<DateTimeParameterDeclaration.Builder> dateTimeParameterDeclaration) {
            return dateTimeParameterDeclaration(DateTimeParameterDeclaration.builder()
                    .applyMutation(dateTimeParameterDeclaration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StringParameterDeclaration stringParameterDeclaration;

        private DecimalParameterDeclaration decimalParameterDeclaration;

        private IntegerParameterDeclaration integerParameterDeclaration;

        private DateTimeParameterDeclaration dateTimeParameterDeclaration;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterDeclaration model) {
            stringParameterDeclaration(model.stringParameterDeclaration);
            decimalParameterDeclaration(model.decimalParameterDeclaration);
            integerParameterDeclaration(model.integerParameterDeclaration);
            dateTimeParameterDeclaration(model.dateTimeParameterDeclaration);
        }

        public final StringParameterDeclaration.Builder getStringParameterDeclaration() {
            return stringParameterDeclaration != null ? stringParameterDeclaration.toBuilder() : null;
        }

        public final void setStringParameterDeclaration(StringParameterDeclaration.BuilderImpl stringParameterDeclaration) {
            this.stringParameterDeclaration = stringParameterDeclaration != null ? stringParameterDeclaration.build() : null;
        }

        @Override
        public final Builder stringParameterDeclaration(StringParameterDeclaration stringParameterDeclaration) {
            this.stringParameterDeclaration = stringParameterDeclaration;
            return this;
        }

        public final DecimalParameterDeclaration.Builder getDecimalParameterDeclaration() {
            return decimalParameterDeclaration != null ? decimalParameterDeclaration.toBuilder() : null;
        }

        public final void setDecimalParameterDeclaration(DecimalParameterDeclaration.BuilderImpl decimalParameterDeclaration) {
            this.decimalParameterDeclaration = decimalParameterDeclaration != null ? decimalParameterDeclaration.build() : null;
        }

        @Override
        public final Builder decimalParameterDeclaration(DecimalParameterDeclaration decimalParameterDeclaration) {
            this.decimalParameterDeclaration = decimalParameterDeclaration;
            return this;
        }

        public final IntegerParameterDeclaration.Builder getIntegerParameterDeclaration() {
            return integerParameterDeclaration != null ? integerParameterDeclaration.toBuilder() : null;
        }

        public final void setIntegerParameterDeclaration(IntegerParameterDeclaration.BuilderImpl integerParameterDeclaration) {
            this.integerParameterDeclaration = integerParameterDeclaration != null ? integerParameterDeclaration.build() : null;
        }

        @Override
        public final Builder integerParameterDeclaration(IntegerParameterDeclaration integerParameterDeclaration) {
            this.integerParameterDeclaration = integerParameterDeclaration;
            return this;
        }

        public final DateTimeParameterDeclaration.Builder getDateTimeParameterDeclaration() {
            return dateTimeParameterDeclaration != null ? dateTimeParameterDeclaration.toBuilder() : null;
        }

        public final void setDateTimeParameterDeclaration(DateTimeParameterDeclaration.BuilderImpl dateTimeParameterDeclaration) {
            this.dateTimeParameterDeclaration = dateTimeParameterDeclaration != null ? dateTimeParameterDeclaration.build()
                    : null;
        }

        @Override
        public final Builder dateTimeParameterDeclaration(DateTimeParameterDeclaration dateTimeParameterDeclaration) {
            this.dateTimeParameterDeclaration = dateTimeParameterDeclaration;
            return this;
        }

        @Override
        public ParameterDeclaration build() {
            return new ParameterDeclaration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
