/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An integer parameter for a dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntegerDatasetParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<IntegerDatasetParameter.Builder, IntegerDatasetParameter> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(IntegerDatasetParameter::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(IntegerDatasetParameter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VALUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValueType").getter(getter(IntegerDatasetParameter::valueTypeAsString))
            .setter(setter(Builder::valueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueType").build()).build();

    private static final SdkField<IntegerDatasetParameterDefaultValues> DEFAULT_VALUES_FIELD = SdkField
            .<IntegerDatasetParameterDefaultValues> builder(MarshallingType.SDK_POJO).memberName("DefaultValues")
            .getter(getter(IntegerDatasetParameter::defaultValues)).setter(setter(Builder::defaultValues))
            .constructor(IntegerDatasetParameterDefaultValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValues").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            VALUE_TYPE_FIELD, DEFAULT_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String valueType;

    private final IntegerDatasetParameterDefaultValues defaultValues;

    private IntegerDatasetParameter(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.valueType = builder.valueType;
        this.defaultValues = builder.defaultValues;
    }

    /**
     * <p>
     * An identifier for the integer parameter created in the dataset.
     * </p>
     * 
     * @return An identifier for the integer parameter created in the dataset.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the integer parameter that is created in the dataset.
     * </p>
     * 
     * @return The name of the integer parameter that is created in the dataset.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The value type of the dataset parameter. Valid values are <code>single value</code> or <code>multi value</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueType} will
     * return {@link DatasetParameterValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #valueTypeAsString}.
     * </p>
     * 
     * @return The value type of the dataset parameter. Valid values are <code>single value</code> or
     *         <code>multi value</code>.
     * @see DatasetParameterValueType
     */
    public final DatasetParameterValueType valueType() {
        return DatasetParameterValueType.fromValue(valueType);
    }

    /**
     * <p>
     * The value type of the dataset parameter. Valid values are <code>single value</code> or <code>multi value</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueType} will
     * return {@link DatasetParameterValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #valueTypeAsString}.
     * </p>
     * 
     * @return The value type of the dataset parameter. Valid values are <code>single value</code> or
     *         <code>multi value</code>.
     * @see DatasetParameterValueType
     */
    public final String valueTypeAsString() {
        return valueType;
    }

    /**
     * <p>
     * A list of default values for a given integer parameter. This structure only accepts static values.
     * </p>
     * 
     * @return A list of default values for a given integer parameter. This structure only accepts static values.
     */
    public final IntegerDatasetParameterDefaultValues defaultValues() {
        return defaultValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(valueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValues());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegerDatasetParameter)) {
            return false;
        }
        IntegerDatasetParameter other = (IntegerDatasetParameter) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(valueTypeAsString(), other.valueTypeAsString())
                && Objects.equals(defaultValues(), other.defaultValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntegerDatasetParameter").add("Id", id()).add("Name", name())
                .add("ValueType", valueTypeAsString()).add("DefaultValues", defaultValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ValueType":
            return Optional.ofNullable(clazz.cast(valueTypeAsString()));
        case "DefaultValues":
            return Optional.ofNullable(clazz.cast(defaultValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ValueType", VALUE_TYPE_FIELD);
        map.put("DefaultValues", DEFAULT_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntegerDatasetParameter, T> g) {
        return obj -> g.apply((IntegerDatasetParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntegerDatasetParameter> {
        /**
         * <p>
         * An identifier for the integer parameter created in the dataset.
         * </p>
         * 
         * @param id
         *        An identifier for the integer parameter created in the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the integer parameter that is created in the dataset.
         * </p>
         * 
         * @param name
         *        The name of the integer parameter that is created in the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value type of the dataset parameter. Valid values are <code>single value</code> or
         * <code>multi value</code>.
         * </p>
         * 
         * @param valueType
         *        The value type of the dataset parameter. Valid values are <code>single value</code> or
         *        <code>multi value</code>.
         * @see DatasetParameterValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetParameterValueType
         */
        Builder valueType(String valueType);

        /**
         * <p>
         * The value type of the dataset parameter. Valid values are <code>single value</code> or
         * <code>multi value</code>.
         * </p>
         * 
         * @param valueType
         *        The value type of the dataset parameter. Valid values are <code>single value</code> or
         *        <code>multi value</code>.
         * @see DatasetParameterValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetParameterValueType
         */
        Builder valueType(DatasetParameterValueType valueType);

        /**
         * <p>
         * A list of default values for a given integer parameter. This structure only accepts static values.
         * </p>
         * 
         * @param defaultValues
         *        A list of default values for a given integer parameter. This structure only accepts static values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValues(IntegerDatasetParameterDefaultValues defaultValues);

        /**
         * <p>
         * A list of default values for a given integer parameter. This structure only accepts static values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link IntegerDatasetParameterDefaultValues.Builder} avoiding the need to create one manually via
         * {@link IntegerDatasetParameterDefaultValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntegerDatasetParameterDefaultValues.Builder#build()} is called
         * immediately and its result is passed to {@link #defaultValues(IntegerDatasetParameterDefaultValues)}.
         * 
         * @param defaultValues
         *        a consumer that will call methods on {@link IntegerDatasetParameterDefaultValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultValues(IntegerDatasetParameterDefaultValues)
         */
        default Builder defaultValues(Consumer<IntegerDatasetParameterDefaultValues.Builder> defaultValues) {
            return defaultValues(IntegerDatasetParameterDefaultValues.builder().applyMutation(defaultValues).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String valueType;

        private IntegerDatasetParameterDefaultValues defaultValues;

        private BuilderImpl() {
        }

        private BuilderImpl(IntegerDatasetParameter model) {
            id(model.id);
            name(model.name);
            valueType(model.valueType);
            defaultValues(model.defaultValues);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getValueType() {
            return valueType;
        }

        public final void setValueType(String valueType) {
            this.valueType = valueType;
        }

        @Override
        public final Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public final Builder valueType(DatasetParameterValueType valueType) {
            this.valueType(valueType == null ? null : valueType.toString());
            return this;
        }

        public final IntegerDatasetParameterDefaultValues.Builder getDefaultValues() {
            return defaultValues != null ? defaultValues.toBuilder() : null;
        }

        public final void setDefaultValues(IntegerDatasetParameterDefaultValues.BuilderImpl defaultValues) {
            this.defaultValues = defaultValues != null ? defaultValues.build() : null;
        }

        @Override
        public final Builder defaultValues(IntegerDatasetParameterDefaultValues defaultValues) {
            this.defaultValues = defaultValues;
            return this;
        }

        @Override
        public IntegerDatasetParameter build() {
            return new IntegerDatasetParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
