/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The point style of the geospatial map.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialPointStyleOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialPointStyleOptions.Builder, GeospatialPointStyleOptions> {
    private static final SdkField<String> SELECTED_POINT_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectedPointStyle").getter(getter(GeospatialPointStyleOptions::selectedPointStyleAsString))
            .setter(setter(Builder::selectedPointStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedPointStyle").build())
            .build();

    private static final SdkField<ClusterMarkerConfiguration> CLUSTER_MARKER_CONFIGURATION_FIELD = SdkField
            .<ClusterMarkerConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ClusterMarkerConfiguration")
            .getter(getter(GeospatialPointStyleOptions::clusterMarkerConfiguration))
            .setter(setter(Builder::clusterMarkerConfiguration))
            .constructor(ClusterMarkerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterMarkerConfiguration").build())
            .build();

    private static final SdkField<GeospatialHeatmapConfiguration> HEATMAP_CONFIGURATION_FIELD = SdkField
            .<GeospatialHeatmapConfiguration> builder(MarshallingType.SDK_POJO).memberName("HeatmapConfiguration")
            .getter(getter(GeospatialPointStyleOptions::heatmapConfiguration)).setter(setter(Builder::heatmapConfiguration))
            .constructor(GeospatialHeatmapConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeatmapConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTED_POINT_STYLE_FIELD,
            CLUSTER_MARKER_CONFIGURATION_FIELD, HEATMAP_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String selectedPointStyle;

    private final ClusterMarkerConfiguration clusterMarkerConfiguration;

    private final GeospatialHeatmapConfiguration heatmapConfiguration;

    private GeospatialPointStyleOptions(BuilderImpl builder) {
        this.selectedPointStyle = builder.selectedPointStyle;
        this.clusterMarkerConfiguration = builder.clusterMarkerConfiguration;
        this.heatmapConfiguration = builder.heatmapConfiguration;
    }

    /**
     * <p>
     * The selected point styles (point, cluster) of the geospatial map.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #selectedPointStyle} will return {@link GeospatialSelectedPointStyle#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #selectedPointStyleAsString}.
     * </p>
     * 
     * @return The selected point styles (point, cluster) of the geospatial map.
     * @see GeospatialSelectedPointStyle
     */
    public final GeospatialSelectedPointStyle selectedPointStyle() {
        return GeospatialSelectedPointStyle.fromValue(selectedPointStyle);
    }

    /**
     * <p>
     * The selected point styles (point, cluster) of the geospatial map.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #selectedPointStyle} will return {@link GeospatialSelectedPointStyle#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #selectedPointStyleAsString}.
     * </p>
     * 
     * @return The selected point styles (point, cluster) of the geospatial map.
     * @see GeospatialSelectedPointStyle
     */
    public final String selectedPointStyleAsString() {
        return selectedPointStyle;
    }

    /**
     * <p>
     * The cluster marker configuration of the geospatial point style.
     * </p>
     * 
     * @return The cluster marker configuration of the geospatial point style.
     */
    public final ClusterMarkerConfiguration clusterMarkerConfiguration() {
        return clusterMarkerConfiguration;
    }

    /**
     * <p>
     * The heatmap configuration of the geospatial point style.
     * </p>
     * 
     * @return The heatmap configuration of the geospatial point style.
     */
    public final GeospatialHeatmapConfiguration heatmapConfiguration() {
        return heatmapConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(selectedPointStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clusterMarkerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(heatmapConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialPointStyleOptions)) {
            return false;
        }
        GeospatialPointStyleOptions other = (GeospatialPointStyleOptions) obj;
        return Objects.equals(selectedPointStyleAsString(), other.selectedPointStyleAsString())
                && Objects.equals(clusterMarkerConfiguration(), other.clusterMarkerConfiguration())
                && Objects.equals(heatmapConfiguration(), other.heatmapConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialPointStyleOptions").add("SelectedPointStyle", selectedPointStyleAsString())
                .add("ClusterMarkerConfiguration", clusterMarkerConfiguration())
                .add("HeatmapConfiguration", heatmapConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SelectedPointStyle":
            return Optional.ofNullable(clazz.cast(selectedPointStyleAsString()));
        case "ClusterMarkerConfiguration":
            return Optional.ofNullable(clazz.cast(clusterMarkerConfiguration()));
        case "HeatmapConfiguration":
            return Optional.ofNullable(clazz.cast(heatmapConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SelectedPointStyle", SELECTED_POINT_STYLE_FIELD);
        map.put("ClusterMarkerConfiguration", CLUSTER_MARKER_CONFIGURATION_FIELD);
        map.put("HeatmapConfiguration", HEATMAP_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialPointStyleOptions, T> g) {
        return obj -> g.apply((GeospatialPointStyleOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialPointStyleOptions> {
        /**
         * <p>
         * The selected point styles (point, cluster) of the geospatial map.
         * </p>
         * 
         * @param selectedPointStyle
         *        The selected point styles (point, cluster) of the geospatial map.
         * @see GeospatialSelectedPointStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeospatialSelectedPointStyle
         */
        Builder selectedPointStyle(String selectedPointStyle);

        /**
         * <p>
         * The selected point styles (point, cluster) of the geospatial map.
         * </p>
         * 
         * @param selectedPointStyle
         *        The selected point styles (point, cluster) of the geospatial map.
         * @see GeospatialSelectedPointStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeospatialSelectedPointStyle
         */
        Builder selectedPointStyle(GeospatialSelectedPointStyle selectedPointStyle);

        /**
         * <p>
         * The cluster marker configuration of the geospatial point style.
         * </p>
         * 
         * @param clusterMarkerConfiguration
         *        The cluster marker configuration of the geospatial point style.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterMarkerConfiguration(ClusterMarkerConfiguration clusterMarkerConfiguration);

        /**
         * <p>
         * The cluster marker configuration of the geospatial point style.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterMarkerConfiguration.Builder}
         * avoiding the need to create one manually via {@link ClusterMarkerConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterMarkerConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #clusterMarkerConfiguration(ClusterMarkerConfiguration)}.
         * 
         * @param clusterMarkerConfiguration
         *        a consumer that will call methods on {@link ClusterMarkerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterMarkerConfiguration(ClusterMarkerConfiguration)
         */
        default Builder clusterMarkerConfiguration(Consumer<ClusterMarkerConfiguration.Builder> clusterMarkerConfiguration) {
            return clusterMarkerConfiguration(ClusterMarkerConfiguration.builder().applyMutation(clusterMarkerConfiguration)
                    .build());
        }

        /**
         * <p>
         * The heatmap configuration of the geospatial point style.
         * </p>
         * 
         * @param heatmapConfiguration
         *        The heatmap configuration of the geospatial point style.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heatmapConfiguration(GeospatialHeatmapConfiguration heatmapConfiguration);

        /**
         * <p>
         * The heatmap configuration of the geospatial point style.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialHeatmapConfiguration.Builder}
         * avoiding the need to create one manually via {@link GeospatialHeatmapConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialHeatmapConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #heatmapConfiguration(GeospatialHeatmapConfiguration)}.
         * 
         * @param heatmapConfiguration
         *        a consumer that will call methods on {@link GeospatialHeatmapConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #heatmapConfiguration(GeospatialHeatmapConfiguration)
         */
        default Builder heatmapConfiguration(Consumer<GeospatialHeatmapConfiguration.Builder> heatmapConfiguration) {
            return heatmapConfiguration(GeospatialHeatmapConfiguration.builder().applyMutation(heatmapConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String selectedPointStyle;

        private ClusterMarkerConfiguration clusterMarkerConfiguration;

        private GeospatialHeatmapConfiguration heatmapConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialPointStyleOptions model) {
            selectedPointStyle(model.selectedPointStyle);
            clusterMarkerConfiguration(model.clusterMarkerConfiguration);
            heatmapConfiguration(model.heatmapConfiguration);
        }

        public final String getSelectedPointStyle() {
            return selectedPointStyle;
        }

        public final void setSelectedPointStyle(String selectedPointStyle) {
            this.selectedPointStyle = selectedPointStyle;
        }

        @Override
        public final Builder selectedPointStyle(String selectedPointStyle) {
            this.selectedPointStyle = selectedPointStyle;
            return this;
        }

        @Override
        public final Builder selectedPointStyle(GeospatialSelectedPointStyle selectedPointStyle) {
            this.selectedPointStyle(selectedPointStyle == null ? null : selectedPointStyle.toString());
            return this;
        }

        public final ClusterMarkerConfiguration.Builder getClusterMarkerConfiguration() {
            return clusterMarkerConfiguration != null ? clusterMarkerConfiguration.toBuilder() : null;
        }

        public final void setClusterMarkerConfiguration(ClusterMarkerConfiguration.BuilderImpl clusterMarkerConfiguration) {
            this.clusterMarkerConfiguration = clusterMarkerConfiguration != null ? clusterMarkerConfiguration.build() : null;
        }

        @Override
        public final Builder clusterMarkerConfiguration(ClusterMarkerConfiguration clusterMarkerConfiguration) {
            this.clusterMarkerConfiguration = clusterMarkerConfiguration;
            return this;
        }

        public final GeospatialHeatmapConfiguration.Builder getHeatmapConfiguration() {
            return heatmapConfiguration != null ? heatmapConfiguration.toBuilder() : null;
        }

        public final void setHeatmapConfiguration(GeospatialHeatmapConfiguration.BuilderImpl heatmapConfiguration) {
            this.heatmapConfiguration = heatmapConfiguration != null ? heatmapConfiguration.build() : null;
        }

        @Override
        public final Builder heatmapConfiguration(GeospatialHeatmapConfiguration heatmapConfiguration) {
            this.heatmapConfiguration = heatmapConfiguration;
            return this;
        }

        @Override
        public GeospatialPointStyleOptions build() {
            return new GeospatialPointStyleOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
