/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The symbol style for null data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialNullSymbolStyle implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialNullSymbolStyle.Builder, GeospatialNullSymbolStyle> {
    private static final SdkField<String> FILL_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FillColor").getter(getter(GeospatialNullSymbolStyle::fillColor)).setter(setter(Builder::fillColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FillColor").build()).build();

    private static final SdkField<String> STROKE_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StrokeColor").getter(getter(GeospatialNullSymbolStyle::strokeColor))
            .setter(setter(Builder::strokeColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StrokeColor").build()).build();

    private static final SdkField<Double> STROKE_WIDTH_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("StrokeWidth").getter(getter(GeospatialNullSymbolStyle::strokeWidth))
            .setter(setter(Builder::strokeWidth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StrokeWidth").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILL_COLOR_FIELD,
            STROKE_COLOR_FIELD, STROKE_WIDTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fillColor;

    private final String strokeColor;

    private final Double strokeWidth;

    private GeospatialNullSymbolStyle(BuilderImpl builder) {
        this.fillColor = builder.fillColor;
        this.strokeColor = builder.strokeColor;
        this.strokeWidth = builder.strokeWidth;
    }

    /**
     * <p>
     * The color and opacity values for the fill color.
     * </p>
     * 
     * @return The color and opacity values for the fill color.
     */
    public final String fillColor() {
        return fillColor;
    }

    /**
     * <p>
     * The color and opacity values for the stroke color.
     * </p>
     * 
     * @return The color and opacity values for the stroke color.
     */
    public final String strokeColor() {
        return strokeColor;
    }

    /**
     * <p>
     * The width of the border stroke.
     * </p>
     * 
     * @return The width of the border stroke.
     */
    public final Double strokeWidth() {
        return strokeWidth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fillColor());
        hashCode = 31 * hashCode + Objects.hashCode(strokeColor());
        hashCode = 31 * hashCode + Objects.hashCode(strokeWidth());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialNullSymbolStyle)) {
            return false;
        }
        GeospatialNullSymbolStyle other = (GeospatialNullSymbolStyle) obj;
        return Objects.equals(fillColor(), other.fillColor()) && Objects.equals(strokeColor(), other.strokeColor())
                && Objects.equals(strokeWidth(), other.strokeWidth());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialNullSymbolStyle").add("FillColor", fillColor()).add("StrokeColor", strokeColor())
                .add("StrokeWidth", strokeWidth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FillColor":
            return Optional.ofNullable(clazz.cast(fillColor()));
        case "StrokeColor":
            return Optional.ofNullable(clazz.cast(strokeColor()));
        case "StrokeWidth":
            return Optional.ofNullable(clazz.cast(strokeWidth()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FillColor", FILL_COLOR_FIELD);
        map.put("StrokeColor", STROKE_COLOR_FIELD);
        map.put("StrokeWidth", STROKE_WIDTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialNullSymbolStyle, T> g) {
        return obj -> g.apply((GeospatialNullSymbolStyle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialNullSymbolStyle> {
        /**
         * <p>
         * The color and opacity values for the fill color.
         * </p>
         * 
         * @param fillColor
         *        The color and opacity values for the fill color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fillColor(String fillColor);

        /**
         * <p>
         * The color and opacity values for the stroke color.
         * </p>
         * 
         * @param strokeColor
         *        The color and opacity values for the stroke color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder strokeColor(String strokeColor);

        /**
         * <p>
         * The width of the border stroke.
         * </p>
         * 
         * @param strokeWidth
         *        The width of the border stroke.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder strokeWidth(Double strokeWidth);
    }

    static final class BuilderImpl implements Builder {
        private String fillColor;

        private String strokeColor;

        private Double strokeWidth;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialNullSymbolStyle model) {
            fillColor(model.fillColor);
            strokeColor(model.strokeColor);
            strokeWidth(model.strokeWidth);
        }

        public final String getFillColor() {
            return fillColor;
        }

        public final void setFillColor(String fillColor) {
            this.fillColor = fillColor;
        }

        @Override
        public final Builder fillColor(String fillColor) {
            this.fillColor = fillColor;
            return this;
        }

        public final String getStrokeColor() {
            return strokeColor;
        }

        public final void setStrokeColor(String strokeColor) {
            this.strokeColor = strokeColor;
        }

        @Override
        public final Builder strokeColor(String strokeColor) {
            this.strokeColor = strokeColor;
            return this;
        }

        public final Double getStrokeWidth() {
            return strokeWidth;
        }

        public final void setStrokeWidth(Double strokeWidth) {
            this.strokeWidth = strokeWidth;
        }

        @Override
        public final Builder strokeWidth(Double strokeWidth) {
            this.strokeWidth = strokeWidth;
            return this;
        }

        @Override
        public GeospatialNullSymbolStyle build() {
            return new GeospatialNullSymbolStyle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
