/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A username and password credential pair to use to import a data source resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetBundleImportJobDataSourceCredentialPair implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetBundleImportJobDataSourceCredentialPair.Builder, AssetBundleImportJobDataSourceCredentialPair> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(AssetBundleImportJobDataSourceCredentialPair::username))
            .setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(AssetBundleImportJobDataSourceCredentialPair::password))
            .setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(USERNAME_FIELD, PASSWORD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String username;

    private final String password;

    private AssetBundleImportJobDataSourceCredentialPair(BuilderImpl builder) {
        this.username = builder.username;
        this.password = builder.password;
    }

    /**
     * <p>
     * The username for the data source connection.
     * </p>
     * 
     * @return The username for the data source connection.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * The password for the data source connection.
     * </p>
     * 
     * @return The password for the data source connection.
     */
    public final String password() {
        return password;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobDataSourceCredentialPair)) {
            return false;
        }
        AssetBundleImportJobDataSourceCredentialPair other = (AssetBundleImportJobDataSourceCredentialPair) obj;
        return Objects.equals(username(), other.username()) && Objects.equals(password(), other.password());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetBundleImportJobDataSourceCredentialPair").add("Username", username())
                .add("Password", password()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Username", USERNAME_FIELD);
        map.put("Password", PASSWORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobDataSourceCredentialPair, T> g) {
        return obj -> g.apply((AssetBundleImportJobDataSourceCredentialPair) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetBundleImportJobDataSourceCredentialPair> {
        /**
         * <p>
         * The username for the data source connection.
         * </p>
         * 
         * @param username
         *        The username for the data source connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The password for the data source connection.
         * </p>
         * 
         * @param password
         *        The password for the data source connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);
    }

    static final class BuilderImpl implements Builder {
        private String username;

        private String password;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobDataSourceCredentialPair model) {
            username(model.username);
            password(model.password);
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        @Override
        public AssetBundleImportJobDataSourceCredentialPair build() {
            return new AssetBundleImportJobDataSourceCredentialPair(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
