/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The arc configuration of a <code>GaugeChartVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArcConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ArcConfiguration.Builder, ArcConfiguration> {
    private static final SdkField<Double> ARC_ANGLE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ArcAngle").getter(getter(ArcConfiguration::arcAngle)).setter(setter(Builder::arcAngle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArcAngle").build()).build();

    private static final SdkField<String> ARC_THICKNESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArcThickness").getter(getter(ArcConfiguration::arcThicknessAsString))
            .setter(setter(Builder::arcThickness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArcThickness").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARC_ANGLE_FIELD,
            ARC_THICKNESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double arcAngle;

    private final String arcThickness;

    private ArcConfiguration(BuilderImpl builder) {
        this.arcAngle = builder.arcAngle;
        this.arcThickness = builder.arcThickness;
    }

    /**
     * <p>
     * The option that determines the arc angle of a <code>GaugeChartVisual</code>.
     * </p>
     * 
     * @return The option that determines the arc angle of a <code>GaugeChartVisual</code>.
     */
    public final Double arcAngle() {
        return arcAngle;
    }

    /**
     * <p>
     * The options that determine the arc thickness of a <code>GaugeChartVisual</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #arcThickness} will
     * return {@link ArcThicknessOptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #arcThicknessAsString}.
     * </p>
     * 
     * @return The options that determine the arc thickness of a <code>GaugeChartVisual</code>.
     * @see ArcThicknessOptions
     */
    public final ArcThicknessOptions arcThickness() {
        return ArcThicknessOptions.fromValue(arcThickness);
    }

    /**
     * <p>
     * The options that determine the arc thickness of a <code>GaugeChartVisual</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #arcThickness} will
     * return {@link ArcThicknessOptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #arcThicknessAsString}.
     * </p>
     * 
     * @return The options that determine the arc thickness of a <code>GaugeChartVisual</code>.
     * @see ArcThicknessOptions
     */
    public final String arcThicknessAsString() {
        return arcThickness;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arcAngle());
        hashCode = 31 * hashCode + Objects.hashCode(arcThicknessAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArcConfiguration)) {
            return false;
        }
        ArcConfiguration other = (ArcConfiguration) obj;
        return Objects.equals(arcAngle(), other.arcAngle())
                && Objects.equals(arcThicknessAsString(), other.arcThicknessAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArcConfiguration").add("ArcAngle", arcAngle()).add("ArcThickness", arcThicknessAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArcAngle":
            return Optional.ofNullable(clazz.cast(arcAngle()));
        case "ArcThickness":
            return Optional.ofNullable(clazz.cast(arcThicknessAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ArcAngle", ARC_ANGLE_FIELD);
        map.put("ArcThickness", ARC_THICKNESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArcConfiguration, T> g) {
        return obj -> g.apply((ArcConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArcConfiguration> {
        /**
         * <p>
         * The option that determines the arc angle of a <code>GaugeChartVisual</code>.
         * </p>
         * 
         * @param arcAngle
         *        The option that determines the arc angle of a <code>GaugeChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arcAngle(Double arcAngle);

        /**
         * <p>
         * The options that determine the arc thickness of a <code>GaugeChartVisual</code>.
         * </p>
         * 
         * @param arcThickness
         *        The options that determine the arc thickness of a <code>GaugeChartVisual</code>.
         * @see ArcThicknessOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArcThicknessOptions
         */
        Builder arcThickness(String arcThickness);

        /**
         * <p>
         * The options that determine the arc thickness of a <code>GaugeChartVisual</code>.
         * </p>
         * 
         * @param arcThickness
         *        The options that determine the arc thickness of a <code>GaugeChartVisual</code>.
         * @see ArcThicknessOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArcThicknessOptions
         */
        Builder arcThickness(ArcThicknessOptions arcThickness);
    }

    static final class BuilderImpl implements Builder {
        private Double arcAngle;

        private String arcThickness;

        private BuilderImpl() {
        }

        private BuilderImpl(ArcConfiguration model) {
            arcAngle(model.arcAngle);
            arcThickness(model.arcThickness);
        }

        public final Double getArcAngle() {
            return arcAngle;
        }

        public final void setArcAngle(Double arcAngle) {
            this.arcAngle = arcAngle;
        }

        @Override
        public final Builder arcAngle(Double arcAngle) {
            this.arcAngle = arcAngle;
            return this;
        }

        public final String getArcThickness() {
            return arcThickness;
        }

        public final void setArcThickness(String arcThickness) {
            this.arcThickness = arcThickness;
        }

        @Override
        public final Builder arcThickness(String arcThickness) {
            this.arcThickness = arcThickness;
            return this;
        }

        @Override
        public final Builder arcThickness(ArcThicknessOptions arcThickness) {
            this.arcThickness(arcThickness == null ? null : arcThickness.toString());
            return this;
        }

        @Override
        public ArcConfiguration build() {
            return new ArcConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
