/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AssetBundleRestrictiveResourceIdListCopier;
import software.amazon.awssdk.services.quicksight.model.Tag;
import software.amazon.awssdk.services.quicksight.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetBundleImportJobDashboardOverrideTags
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetBundleImportJobDashboardOverrideTags> {
    private static final SdkField<List<String>> DASHBOARD_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DashboardIds").getter(AssetBundleImportJobDashboardOverrideTags.getter(AssetBundleImportJobDashboardOverrideTags::dashboardIds)).setter(AssetBundleImportJobDashboardOverrideTags.setter(Builder::dashboardIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(AssetBundleImportJobDashboardOverrideTags.getter(AssetBundleImportJobDashboardOverrideTags::tags)).setter(AssetBundleImportJobDashboardOverrideTags.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_IDS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssetBundleImportJobDashboardOverrideTags.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> dashboardIds;
    private final List<Tag> tags;

    private AssetBundleImportJobDashboardOverrideTags(BuilderImpl builder) {
        this.dashboardIds = builder.dashboardIds;
        this.tags = builder.tags;
    }

    public final boolean hasDashboardIds() {
        return this.dashboardIds != null && !(this.dashboardIds instanceof SdkAutoConstructList);
    }

    public final List<String> dashboardIds() {
        return this.dashboardIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDashboardIds() ? this.dashboardIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobDashboardOverrideTags)) {
            return false;
        }
        AssetBundleImportJobDashboardOverrideTags other = (AssetBundleImportJobDashboardOverrideTags)obj;
        return this.hasDashboardIds() == other.hasDashboardIds() && Objects.equals(this.dashboardIds(), other.dashboardIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"AssetBundleImportJobDashboardOverrideTags").add("DashboardIds", this.hasDashboardIds() ? this.dashboardIds() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardIds": {
                return Optional.ofNullable(clazz.cast(this.dashboardIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DashboardIds", DASHBOARD_IDS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobDashboardOverrideTags, T> g) {
        return obj -> g.apply((AssetBundleImportJobDashboardOverrideTags)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> dashboardIds = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobDashboardOverrideTags model) {
            this.dashboardIds(model.dashboardIds);
            this.tags(model.tags);
        }

        public final Collection<String> getDashboardIds() {
            if (this.dashboardIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dashboardIds;
        }

        public final void setDashboardIds(Collection<String> dashboardIds) {
            this.dashboardIds = AssetBundleRestrictiveResourceIdListCopier.copy(dashboardIds);
        }

        @Override
        public final Builder dashboardIds(Collection<String> dashboardIds) {
            this.dashboardIds = AssetBundleRestrictiveResourceIdListCopier.copy(dashboardIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardIds(String ... dashboardIds) {
            this.dashboardIds(Arrays.asList(dashboardIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AssetBundleImportJobDashboardOverrideTags build() {
            return new AssetBundleImportJobDashboardOverrideTags(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetBundleImportJobDashboardOverrideTags> {
        public Builder dashboardIds(Collection<String> var1);

        public Builder dashboardIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

