/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ClusterMarkerConfiguration;
import software.amazon.awssdk.services.quicksight.model.GeospatialHeatmapConfiguration;
import software.amazon.awssdk.services.quicksight.model.GeospatialSelectedPointStyle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeospatialPointStyleOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeospatialPointStyleOptions> {
    private static final SdkField<String> SELECTED_POINT_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectedPointStyle").getter(GeospatialPointStyleOptions.getter(GeospatialPointStyleOptions::selectedPointStyleAsString)).setter(GeospatialPointStyleOptions.setter(Builder::selectedPointStyle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedPointStyle").build()}).build();
    private static final SdkField<ClusterMarkerConfiguration> CLUSTER_MARKER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClusterMarkerConfiguration").getter(GeospatialPointStyleOptions.getter(GeospatialPointStyleOptions::clusterMarkerConfiguration)).setter(GeospatialPointStyleOptions.setter(Builder::clusterMarkerConfiguration)).constructor(ClusterMarkerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterMarkerConfiguration").build()}).build();
    private static final SdkField<GeospatialHeatmapConfiguration> HEATMAP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HeatmapConfiguration").getter(GeospatialPointStyleOptions.getter(GeospatialPointStyleOptions::heatmapConfiguration)).setter(GeospatialPointStyleOptions.setter(Builder::heatmapConfiguration)).constructor(GeospatialHeatmapConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeatmapConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTED_POINT_STYLE_FIELD, CLUSTER_MARKER_CONFIGURATION_FIELD, HEATMAP_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GeospatialPointStyleOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String selectedPointStyle;
    private final ClusterMarkerConfiguration clusterMarkerConfiguration;
    private final GeospatialHeatmapConfiguration heatmapConfiguration;

    private GeospatialPointStyleOptions(BuilderImpl builder) {
        this.selectedPointStyle = builder.selectedPointStyle;
        this.clusterMarkerConfiguration = builder.clusterMarkerConfiguration;
        this.heatmapConfiguration = builder.heatmapConfiguration;
    }

    public final GeospatialSelectedPointStyle selectedPointStyle() {
        return GeospatialSelectedPointStyle.fromValue(this.selectedPointStyle);
    }

    public final String selectedPointStyleAsString() {
        return this.selectedPointStyle;
    }

    public final ClusterMarkerConfiguration clusterMarkerConfiguration() {
        return this.clusterMarkerConfiguration;
    }

    public final GeospatialHeatmapConfiguration heatmapConfiguration() {
        return this.heatmapConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.selectedPointStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterMarkerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.heatmapConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialPointStyleOptions)) {
            return false;
        }
        GeospatialPointStyleOptions other = (GeospatialPointStyleOptions)obj;
        return Objects.equals(this.selectedPointStyleAsString(), other.selectedPointStyleAsString()) && Objects.equals(this.clusterMarkerConfiguration(), other.clusterMarkerConfiguration()) && Objects.equals(this.heatmapConfiguration(), other.heatmapConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"GeospatialPointStyleOptions").add("SelectedPointStyle", (Object)this.selectedPointStyleAsString()).add("ClusterMarkerConfiguration", (Object)this.clusterMarkerConfiguration()).add("HeatmapConfiguration", (Object)this.heatmapConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SelectedPointStyle": {
                return Optional.ofNullable(clazz.cast(this.selectedPointStyleAsString()));
            }
            case "ClusterMarkerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.clusterMarkerConfiguration()));
            }
            case "HeatmapConfiguration": {
                return Optional.ofNullable(clazz.cast(this.heatmapConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SelectedPointStyle", SELECTED_POINT_STYLE_FIELD);
        map.put("ClusterMarkerConfiguration", CLUSTER_MARKER_CONFIGURATION_FIELD);
        map.put("HeatmapConfiguration", HEATMAP_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialPointStyleOptions, T> g) {
        return obj -> g.apply((GeospatialPointStyleOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String selectedPointStyle;
        private ClusterMarkerConfiguration clusterMarkerConfiguration;
        private GeospatialHeatmapConfiguration heatmapConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialPointStyleOptions model) {
            this.selectedPointStyle(model.selectedPointStyle);
            this.clusterMarkerConfiguration(model.clusterMarkerConfiguration);
            this.heatmapConfiguration(model.heatmapConfiguration);
        }

        public final String getSelectedPointStyle() {
            return this.selectedPointStyle;
        }

        public final void setSelectedPointStyle(String selectedPointStyle) {
            this.selectedPointStyle = selectedPointStyle;
        }

        @Override
        public final Builder selectedPointStyle(String selectedPointStyle) {
            this.selectedPointStyle = selectedPointStyle;
            return this;
        }

        @Override
        public final Builder selectedPointStyle(GeospatialSelectedPointStyle selectedPointStyle) {
            this.selectedPointStyle(selectedPointStyle == null ? null : selectedPointStyle.toString());
            return this;
        }

        public final ClusterMarkerConfiguration.Builder getClusterMarkerConfiguration() {
            return this.clusterMarkerConfiguration != null ? this.clusterMarkerConfiguration.toBuilder() : null;
        }

        public final void setClusterMarkerConfiguration(ClusterMarkerConfiguration.BuilderImpl clusterMarkerConfiguration) {
            this.clusterMarkerConfiguration = clusterMarkerConfiguration != null ? clusterMarkerConfiguration.build() : null;
        }

        @Override
        public final Builder clusterMarkerConfiguration(ClusterMarkerConfiguration clusterMarkerConfiguration) {
            this.clusterMarkerConfiguration = clusterMarkerConfiguration;
            return this;
        }

        public final GeospatialHeatmapConfiguration.Builder getHeatmapConfiguration() {
            return this.heatmapConfiguration != null ? this.heatmapConfiguration.toBuilder() : null;
        }

        public final void setHeatmapConfiguration(GeospatialHeatmapConfiguration.BuilderImpl heatmapConfiguration) {
            this.heatmapConfiguration = heatmapConfiguration != null ? heatmapConfiguration.build() : null;
        }

        @Override
        public final Builder heatmapConfiguration(GeospatialHeatmapConfiguration heatmapConfiguration) {
            this.heatmapConfiguration = heatmapConfiguration;
            return this;
        }

        public GeospatialPointStyleOptions build() {
            return new GeospatialPointStyleOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeospatialPointStyleOptions> {
        public Builder selectedPointStyle(String var1);

        public Builder selectedPointStyle(GeospatialSelectedPointStyle var1);

        public Builder clusterMarkerConfiguration(ClusterMarkerConfiguration var1);

        default public Builder clusterMarkerConfiguration(Consumer<ClusterMarkerConfiguration.Builder> clusterMarkerConfiguration) {
            return this.clusterMarkerConfiguration((ClusterMarkerConfiguration)((ClusterMarkerConfiguration.Builder)ClusterMarkerConfiguration.builder().applyMutation(clusterMarkerConfiguration)).build());
        }

        public Builder heatmapConfiguration(GeospatialHeatmapConfiguration var1);

        default public Builder heatmapConfiguration(Consumer<GeospatialHeatmapConfiguration.Builder> heatmapConfiguration) {
            return this.heatmapConfiguration((GeospatialHeatmapConfiguration)((GeospatialHeatmapConfiguration.Builder)GeospatialHeatmapConfiguration.builder().applyMutation(heatmapConfiguration)).build());
        }
    }
}

