/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.CapabilityState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Capabilities
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Capabilities> {
    private static final SdkField<String> EXPORT_TO_CSV_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportToCsv").getter(Capabilities.getter(Capabilities::exportToCsvAsString)).setter(Capabilities.setter(Builder::exportToCsv)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToCsv").build()}).build();
    private static final SdkField<String> EXPORT_TO_EXCEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportToExcel").getter(Capabilities.getter(Capabilities::exportToExcelAsString)).setter(Capabilities.setter(Builder::exportToExcel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToExcel").build()}).build();
    private static final SdkField<String> EXPORT_TO_PDF_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportToPdf").getter(Capabilities.getter(Capabilities::exportToPdfAsString)).setter(Capabilities.setter(Builder::exportToPdf)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToPdf").build()}).build();
    private static final SdkField<String> PRINT_REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrintReports").getter(Capabilities.getter(Capabilities::printReportsAsString)).setter(Capabilities.setter(Builder::printReports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrintReports").build()}).build();
    private static final SdkField<String> CREATE_AND_UPDATE_THEMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateAndUpdateThemes").getter(Capabilities.getter(Capabilities::createAndUpdateThemesAsString)).setter(Capabilities.setter(Builder::createAndUpdateThemes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateAndUpdateThemes").build()}).build();
    private static final SdkField<String> ADD_OR_RUN_ANOMALY_DETECTION_FOR_ANALYSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddOrRunAnomalyDetectionForAnalyses").getter(Capabilities.getter(Capabilities::addOrRunAnomalyDetectionForAnalysesAsString)).setter(Capabilities.setter(Builder::addOrRunAnomalyDetectionForAnalyses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddOrRunAnomalyDetectionForAnalyses").build()}).build();
    private static final SdkField<String> SHARE_ANALYSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareAnalyses").getter(Capabilities.getter(Capabilities::shareAnalysesAsString)).setter(Capabilities.setter(Builder::shareAnalyses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareAnalyses").build()}).build();
    private static final SdkField<String> CREATE_AND_UPDATE_DATASETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateAndUpdateDatasets").getter(Capabilities.getter(Capabilities::createAndUpdateDatasetsAsString)).setter(Capabilities.setter(Builder::createAndUpdateDatasets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateAndUpdateDatasets").build()}).build();
    private static final SdkField<String> SHARE_DATASETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareDatasets").getter(Capabilities.getter(Capabilities::shareDatasetsAsString)).setter(Capabilities.setter(Builder::shareDatasets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareDatasets").build()}).build();
    private static final SdkField<String> SUBSCRIBE_DASHBOARD_EMAIL_REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscribeDashboardEmailReports").getter(Capabilities.getter(Capabilities::subscribeDashboardEmailReportsAsString)).setter(Capabilities.setter(Builder::subscribeDashboardEmailReports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscribeDashboardEmailReports").build()}).build();
    private static final SdkField<String> CREATE_AND_UPDATE_DASHBOARD_EMAIL_REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateAndUpdateDashboardEmailReports").getter(Capabilities.getter(Capabilities::createAndUpdateDashboardEmailReportsAsString)).setter(Capabilities.setter(Builder::createAndUpdateDashboardEmailReports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateAndUpdateDashboardEmailReports").build()}).build();
    private static final SdkField<String> SHARE_DASHBOARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareDashboards").getter(Capabilities.getter(Capabilities::shareDashboardsAsString)).setter(Capabilities.setter(Builder::shareDashboards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareDashboards").build()}).build();
    private static final SdkField<String> CREATE_AND_UPDATE_THRESHOLD_ALERTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateAndUpdateThresholdAlerts").getter(Capabilities.getter(Capabilities::createAndUpdateThresholdAlertsAsString)).setter(Capabilities.setter(Builder::createAndUpdateThresholdAlerts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateAndUpdateThresholdAlerts").build()}).build();
    private static final SdkField<String> RENAME_SHARED_FOLDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RenameSharedFolders").getter(Capabilities.getter(Capabilities::renameSharedFoldersAsString)).setter(Capabilities.setter(Builder::renameSharedFolders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenameSharedFolders").build()}).build();
    private static final SdkField<String> CREATE_SHARED_FOLDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateSharedFolders").getter(Capabilities.getter(Capabilities::createSharedFoldersAsString)).setter(Capabilities.setter(Builder::createSharedFolders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateSharedFolders").build()}).build();
    private static final SdkField<String> CREATE_AND_UPDATE_DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateAndUpdateDataSources").getter(Capabilities.getter(Capabilities::createAndUpdateDataSourcesAsString)).setter(Capabilities.setter(Builder::createAndUpdateDataSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateAndUpdateDataSources").build()}).build();
    private static final SdkField<String> SHARE_DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareDataSources").getter(Capabilities.getter(Capabilities::shareDataSourcesAsString)).setter(Capabilities.setter(Builder::shareDataSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareDataSources").build()}).build();
    private static final SdkField<String> VIEW_ACCOUNT_SPICE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViewAccountSPICECapacity").getter(Capabilities.getter(Capabilities::viewAccountSPICECapacityAsString)).setter(Capabilities.setter(Builder::viewAccountSPICECapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewAccountSPICECapacity").build()}).build();
    private static final SdkField<String> CREATE_SPICE_DATASET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateSPICEDataset").getter(Capabilities.getter(Capabilities::createSPICEDatasetAsString)).setter(Capabilities.setter(Builder::createSPICEDataset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateSPICEDataset").build()}).build();
    private static final SdkField<String> EXPORT_TO_PDF_IN_SCHEDULED_REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportToPdfInScheduledReports").getter(Capabilities.getter(Capabilities::exportToPdfInScheduledReportsAsString)).setter(Capabilities.setter(Builder::exportToPdfInScheduledReports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToPdfInScheduledReports").build()}).build();
    private static final SdkField<String> EXPORT_TO_CSV_IN_SCHEDULED_REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportToCsvInScheduledReports").getter(Capabilities.getter(Capabilities::exportToCsvInScheduledReportsAsString)).setter(Capabilities.setter(Builder::exportToCsvInScheduledReports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToCsvInScheduledReports").build()}).build();
    private static final SdkField<String> EXPORT_TO_EXCEL_IN_SCHEDULED_REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportToExcelInScheduledReports").getter(Capabilities.getter(Capabilities::exportToExcelInScheduledReportsAsString)).setter(Capabilities.setter(Builder::exportToExcelInScheduledReports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToExcelInScheduledReports").build()}).build();
    private static final SdkField<String> INCLUDE_CONTENT_IN_SCHEDULED_REPORTS_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IncludeContentInScheduledReportsEmail").getter(Capabilities.getter(Capabilities::includeContentInScheduledReportsEmailAsString)).setter(Capabilities.setter(Builder::includeContentInScheduledReportsEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeContentInScheduledReportsEmail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_TO_CSV_FIELD, EXPORT_TO_EXCEL_FIELD, EXPORT_TO_PDF_FIELD, PRINT_REPORTS_FIELD, CREATE_AND_UPDATE_THEMES_FIELD, ADD_OR_RUN_ANOMALY_DETECTION_FOR_ANALYSES_FIELD, SHARE_ANALYSES_FIELD, CREATE_AND_UPDATE_DATASETS_FIELD, SHARE_DATASETS_FIELD, SUBSCRIBE_DASHBOARD_EMAIL_REPORTS_FIELD, CREATE_AND_UPDATE_DASHBOARD_EMAIL_REPORTS_FIELD, SHARE_DASHBOARDS_FIELD, CREATE_AND_UPDATE_THRESHOLD_ALERTS_FIELD, RENAME_SHARED_FOLDERS_FIELD, CREATE_SHARED_FOLDERS_FIELD, CREATE_AND_UPDATE_DATA_SOURCES_FIELD, SHARE_DATA_SOURCES_FIELD, VIEW_ACCOUNT_SPICE_CAPACITY_FIELD, CREATE_SPICE_DATASET_FIELD, EXPORT_TO_PDF_IN_SCHEDULED_REPORTS_FIELD, EXPORT_TO_CSV_IN_SCHEDULED_REPORTS_FIELD, EXPORT_TO_EXCEL_IN_SCHEDULED_REPORTS_FIELD, INCLUDE_CONTENT_IN_SCHEDULED_REPORTS_EMAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Capabilities.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String exportToCsv;
    private final String exportToExcel;
    private final String exportToPdf;
    private final String printReports;
    private final String createAndUpdateThemes;
    private final String addOrRunAnomalyDetectionForAnalyses;
    private final String shareAnalyses;
    private final String createAndUpdateDatasets;
    private final String shareDatasets;
    private final String subscribeDashboardEmailReports;
    private final String createAndUpdateDashboardEmailReports;
    private final String shareDashboards;
    private final String createAndUpdateThresholdAlerts;
    private final String renameSharedFolders;
    private final String createSharedFolders;
    private final String createAndUpdateDataSources;
    private final String shareDataSources;
    private final String viewAccountSPICECapacity;
    private final String createSPICEDataset;
    private final String exportToPdfInScheduledReports;
    private final String exportToCsvInScheduledReports;
    private final String exportToExcelInScheduledReports;
    private final String includeContentInScheduledReportsEmail;

    private Capabilities(BuilderImpl builder) {
        this.exportToCsv = builder.exportToCsv;
        this.exportToExcel = builder.exportToExcel;
        this.exportToPdf = builder.exportToPdf;
        this.printReports = builder.printReports;
        this.createAndUpdateThemes = builder.createAndUpdateThemes;
        this.addOrRunAnomalyDetectionForAnalyses = builder.addOrRunAnomalyDetectionForAnalyses;
        this.shareAnalyses = builder.shareAnalyses;
        this.createAndUpdateDatasets = builder.createAndUpdateDatasets;
        this.shareDatasets = builder.shareDatasets;
        this.subscribeDashboardEmailReports = builder.subscribeDashboardEmailReports;
        this.createAndUpdateDashboardEmailReports = builder.createAndUpdateDashboardEmailReports;
        this.shareDashboards = builder.shareDashboards;
        this.createAndUpdateThresholdAlerts = builder.createAndUpdateThresholdAlerts;
        this.renameSharedFolders = builder.renameSharedFolders;
        this.createSharedFolders = builder.createSharedFolders;
        this.createAndUpdateDataSources = builder.createAndUpdateDataSources;
        this.shareDataSources = builder.shareDataSources;
        this.viewAccountSPICECapacity = builder.viewAccountSPICECapacity;
        this.createSPICEDataset = builder.createSPICEDataset;
        this.exportToPdfInScheduledReports = builder.exportToPdfInScheduledReports;
        this.exportToCsvInScheduledReports = builder.exportToCsvInScheduledReports;
        this.exportToExcelInScheduledReports = builder.exportToExcelInScheduledReports;
        this.includeContentInScheduledReportsEmail = builder.includeContentInScheduledReportsEmail;
    }

    public final CapabilityState exportToCsv() {
        return CapabilityState.fromValue(this.exportToCsv);
    }

    public final String exportToCsvAsString() {
        return this.exportToCsv;
    }

    public final CapabilityState exportToExcel() {
        return CapabilityState.fromValue(this.exportToExcel);
    }

    public final String exportToExcelAsString() {
        return this.exportToExcel;
    }

    public final CapabilityState exportToPdf() {
        return CapabilityState.fromValue(this.exportToPdf);
    }

    public final String exportToPdfAsString() {
        return this.exportToPdf;
    }

    public final CapabilityState printReports() {
        return CapabilityState.fromValue(this.printReports);
    }

    public final String printReportsAsString() {
        return this.printReports;
    }

    public final CapabilityState createAndUpdateThemes() {
        return CapabilityState.fromValue(this.createAndUpdateThemes);
    }

    public final String createAndUpdateThemesAsString() {
        return this.createAndUpdateThemes;
    }

    public final CapabilityState addOrRunAnomalyDetectionForAnalyses() {
        return CapabilityState.fromValue(this.addOrRunAnomalyDetectionForAnalyses);
    }

    public final String addOrRunAnomalyDetectionForAnalysesAsString() {
        return this.addOrRunAnomalyDetectionForAnalyses;
    }

    public final CapabilityState shareAnalyses() {
        return CapabilityState.fromValue(this.shareAnalyses);
    }

    public final String shareAnalysesAsString() {
        return this.shareAnalyses;
    }

    public final CapabilityState createAndUpdateDatasets() {
        return CapabilityState.fromValue(this.createAndUpdateDatasets);
    }

    public final String createAndUpdateDatasetsAsString() {
        return this.createAndUpdateDatasets;
    }

    public final CapabilityState shareDatasets() {
        return CapabilityState.fromValue(this.shareDatasets);
    }

    public final String shareDatasetsAsString() {
        return this.shareDatasets;
    }

    public final CapabilityState subscribeDashboardEmailReports() {
        return CapabilityState.fromValue(this.subscribeDashboardEmailReports);
    }

    public final String subscribeDashboardEmailReportsAsString() {
        return this.subscribeDashboardEmailReports;
    }

    public final CapabilityState createAndUpdateDashboardEmailReports() {
        return CapabilityState.fromValue(this.createAndUpdateDashboardEmailReports);
    }

    public final String createAndUpdateDashboardEmailReportsAsString() {
        return this.createAndUpdateDashboardEmailReports;
    }

    public final CapabilityState shareDashboards() {
        return CapabilityState.fromValue(this.shareDashboards);
    }

    public final String shareDashboardsAsString() {
        return this.shareDashboards;
    }

    public final CapabilityState createAndUpdateThresholdAlerts() {
        return CapabilityState.fromValue(this.createAndUpdateThresholdAlerts);
    }

    public final String createAndUpdateThresholdAlertsAsString() {
        return this.createAndUpdateThresholdAlerts;
    }

    public final CapabilityState renameSharedFolders() {
        return CapabilityState.fromValue(this.renameSharedFolders);
    }

    public final String renameSharedFoldersAsString() {
        return this.renameSharedFolders;
    }

    public final CapabilityState createSharedFolders() {
        return CapabilityState.fromValue(this.createSharedFolders);
    }

    public final String createSharedFoldersAsString() {
        return this.createSharedFolders;
    }

    public final CapabilityState createAndUpdateDataSources() {
        return CapabilityState.fromValue(this.createAndUpdateDataSources);
    }

    public final String createAndUpdateDataSourcesAsString() {
        return this.createAndUpdateDataSources;
    }

    public final CapabilityState shareDataSources() {
        return CapabilityState.fromValue(this.shareDataSources);
    }

    public final String shareDataSourcesAsString() {
        return this.shareDataSources;
    }

    public final CapabilityState viewAccountSPICECapacity() {
        return CapabilityState.fromValue(this.viewAccountSPICECapacity);
    }

    public final String viewAccountSPICECapacityAsString() {
        return this.viewAccountSPICECapacity;
    }

    public final CapabilityState createSPICEDataset() {
        return CapabilityState.fromValue(this.createSPICEDataset);
    }

    public final String createSPICEDatasetAsString() {
        return this.createSPICEDataset;
    }

    public final CapabilityState exportToPdfInScheduledReports() {
        return CapabilityState.fromValue(this.exportToPdfInScheduledReports);
    }

    public final String exportToPdfInScheduledReportsAsString() {
        return this.exportToPdfInScheduledReports;
    }

    public final CapabilityState exportToCsvInScheduledReports() {
        return CapabilityState.fromValue(this.exportToCsvInScheduledReports);
    }

    public final String exportToCsvInScheduledReportsAsString() {
        return this.exportToCsvInScheduledReports;
    }

    public final CapabilityState exportToExcelInScheduledReports() {
        return CapabilityState.fromValue(this.exportToExcelInScheduledReports);
    }

    public final String exportToExcelInScheduledReportsAsString() {
        return this.exportToExcelInScheduledReports;
    }

    public final CapabilityState includeContentInScheduledReportsEmail() {
        return CapabilityState.fromValue(this.includeContentInScheduledReportsEmail);
    }

    public final String includeContentInScheduledReportsEmailAsString() {
        return this.includeContentInScheduledReportsEmail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exportToCsvAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportToExcelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportToPdfAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.printReportsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createAndUpdateThemesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.addOrRunAnomalyDetectionForAnalysesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareAnalysesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createAndUpdateDatasetsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareDatasetsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscribeDashboardEmailReportsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createAndUpdateDashboardEmailReportsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareDashboardsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createAndUpdateThresholdAlertsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.renameSharedFoldersAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createSharedFoldersAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createAndUpdateDataSourcesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareDataSourcesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewAccountSPICECapacityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createSPICEDatasetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportToPdfInScheduledReportsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportToCsvInScheduledReportsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportToExcelInScheduledReportsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeContentInScheduledReportsEmailAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Capabilities)) {
            return false;
        }
        Capabilities other = (Capabilities)obj;
        return Objects.equals(this.exportToCsvAsString(), other.exportToCsvAsString()) && Objects.equals(this.exportToExcelAsString(), other.exportToExcelAsString()) && Objects.equals(this.exportToPdfAsString(), other.exportToPdfAsString()) && Objects.equals(this.printReportsAsString(), other.printReportsAsString()) && Objects.equals(this.createAndUpdateThemesAsString(), other.createAndUpdateThemesAsString()) && Objects.equals(this.addOrRunAnomalyDetectionForAnalysesAsString(), other.addOrRunAnomalyDetectionForAnalysesAsString()) && Objects.equals(this.shareAnalysesAsString(), other.shareAnalysesAsString()) && Objects.equals(this.createAndUpdateDatasetsAsString(), other.createAndUpdateDatasetsAsString()) && Objects.equals(this.shareDatasetsAsString(), other.shareDatasetsAsString()) && Objects.equals(this.subscribeDashboardEmailReportsAsString(), other.subscribeDashboardEmailReportsAsString()) && Objects.equals(this.createAndUpdateDashboardEmailReportsAsString(), other.createAndUpdateDashboardEmailReportsAsString()) && Objects.equals(this.shareDashboardsAsString(), other.shareDashboardsAsString()) && Objects.equals(this.createAndUpdateThresholdAlertsAsString(), other.createAndUpdateThresholdAlertsAsString()) && Objects.equals(this.renameSharedFoldersAsString(), other.renameSharedFoldersAsString()) && Objects.equals(this.createSharedFoldersAsString(), other.createSharedFoldersAsString()) && Objects.equals(this.createAndUpdateDataSourcesAsString(), other.createAndUpdateDataSourcesAsString()) && Objects.equals(this.shareDataSourcesAsString(), other.shareDataSourcesAsString()) && Objects.equals(this.viewAccountSPICECapacityAsString(), other.viewAccountSPICECapacityAsString()) && Objects.equals(this.createSPICEDatasetAsString(), other.createSPICEDatasetAsString()) && Objects.equals(this.exportToPdfInScheduledReportsAsString(), other.exportToPdfInScheduledReportsAsString()) && Objects.equals(this.exportToCsvInScheduledReportsAsString(), other.exportToCsvInScheduledReportsAsString()) && Objects.equals(this.exportToExcelInScheduledReportsAsString(), other.exportToExcelInScheduledReportsAsString()) && Objects.equals(this.includeContentInScheduledReportsEmailAsString(), other.includeContentInScheduledReportsEmailAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Capabilities").add("ExportToCsv", (Object)this.exportToCsvAsString()).add("ExportToExcel", (Object)this.exportToExcelAsString()).add("ExportToPdf", (Object)this.exportToPdfAsString()).add("PrintReports", (Object)this.printReportsAsString()).add("CreateAndUpdateThemes", (Object)this.createAndUpdateThemesAsString()).add("AddOrRunAnomalyDetectionForAnalyses", (Object)this.addOrRunAnomalyDetectionForAnalysesAsString()).add("ShareAnalyses", (Object)this.shareAnalysesAsString()).add("CreateAndUpdateDatasets", (Object)this.createAndUpdateDatasetsAsString()).add("ShareDatasets", (Object)this.shareDatasetsAsString()).add("SubscribeDashboardEmailReports", (Object)this.subscribeDashboardEmailReportsAsString()).add("CreateAndUpdateDashboardEmailReports", (Object)this.createAndUpdateDashboardEmailReportsAsString()).add("ShareDashboards", (Object)this.shareDashboardsAsString()).add("CreateAndUpdateThresholdAlerts", (Object)this.createAndUpdateThresholdAlertsAsString()).add("RenameSharedFolders", (Object)this.renameSharedFoldersAsString()).add("CreateSharedFolders", (Object)this.createSharedFoldersAsString()).add("CreateAndUpdateDataSources", (Object)this.createAndUpdateDataSourcesAsString()).add("ShareDataSources", (Object)this.shareDataSourcesAsString()).add("ViewAccountSPICECapacity", (Object)this.viewAccountSPICECapacityAsString()).add("CreateSPICEDataset", (Object)this.createSPICEDatasetAsString()).add("ExportToPdfInScheduledReports", (Object)this.exportToPdfInScheduledReportsAsString()).add("ExportToCsvInScheduledReports", (Object)this.exportToCsvInScheduledReportsAsString()).add("ExportToExcelInScheduledReports", (Object)this.exportToExcelInScheduledReportsAsString()).add("IncludeContentInScheduledReportsEmail", (Object)this.includeContentInScheduledReportsEmailAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportToCsv": {
                return Optional.ofNullable(clazz.cast(this.exportToCsvAsString()));
            }
            case "ExportToExcel": {
                return Optional.ofNullable(clazz.cast(this.exportToExcelAsString()));
            }
            case "ExportToPdf": {
                return Optional.ofNullable(clazz.cast(this.exportToPdfAsString()));
            }
            case "PrintReports": {
                return Optional.ofNullable(clazz.cast(this.printReportsAsString()));
            }
            case "CreateAndUpdateThemes": {
                return Optional.ofNullable(clazz.cast(this.createAndUpdateThemesAsString()));
            }
            case "AddOrRunAnomalyDetectionForAnalyses": {
                return Optional.ofNullable(clazz.cast(this.addOrRunAnomalyDetectionForAnalysesAsString()));
            }
            case "ShareAnalyses": {
                return Optional.ofNullable(clazz.cast(this.shareAnalysesAsString()));
            }
            case "CreateAndUpdateDatasets": {
                return Optional.ofNullable(clazz.cast(this.createAndUpdateDatasetsAsString()));
            }
            case "ShareDatasets": {
                return Optional.ofNullable(clazz.cast(this.shareDatasetsAsString()));
            }
            case "SubscribeDashboardEmailReports": {
                return Optional.ofNullable(clazz.cast(this.subscribeDashboardEmailReportsAsString()));
            }
            case "CreateAndUpdateDashboardEmailReports": {
                return Optional.ofNullable(clazz.cast(this.createAndUpdateDashboardEmailReportsAsString()));
            }
            case "ShareDashboards": {
                return Optional.ofNullable(clazz.cast(this.shareDashboardsAsString()));
            }
            case "CreateAndUpdateThresholdAlerts": {
                return Optional.ofNullable(clazz.cast(this.createAndUpdateThresholdAlertsAsString()));
            }
            case "RenameSharedFolders": {
                return Optional.ofNullable(clazz.cast(this.renameSharedFoldersAsString()));
            }
            case "CreateSharedFolders": {
                return Optional.ofNullable(clazz.cast(this.createSharedFoldersAsString()));
            }
            case "CreateAndUpdateDataSources": {
                return Optional.ofNullable(clazz.cast(this.createAndUpdateDataSourcesAsString()));
            }
            case "ShareDataSources": {
                return Optional.ofNullable(clazz.cast(this.shareDataSourcesAsString()));
            }
            case "ViewAccountSPICECapacity": {
                return Optional.ofNullable(clazz.cast(this.viewAccountSPICECapacityAsString()));
            }
            case "CreateSPICEDataset": {
                return Optional.ofNullable(clazz.cast(this.createSPICEDatasetAsString()));
            }
            case "ExportToPdfInScheduledReports": {
                return Optional.ofNullable(clazz.cast(this.exportToPdfInScheduledReportsAsString()));
            }
            case "ExportToCsvInScheduledReports": {
                return Optional.ofNullable(clazz.cast(this.exportToCsvInScheduledReportsAsString()));
            }
            case "ExportToExcelInScheduledReports": {
                return Optional.ofNullable(clazz.cast(this.exportToExcelInScheduledReportsAsString()));
            }
            case "IncludeContentInScheduledReportsEmail": {
                return Optional.ofNullable(clazz.cast(this.includeContentInScheduledReportsEmailAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ExportToCsv", EXPORT_TO_CSV_FIELD);
        map.put("ExportToExcel", EXPORT_TO_EXCEL_FIELD);
        map.put("ExportToPdf", EXPORT_TO_PDF_FIELD);
        map.put("PrintReports", PRINT_REPORTS_FIELD);
        map.put("CreateAndUpdateThemes", CREATE_AND_UPDATE_THEMES_FIELD);
        map.put("AddOrRunAnomalyDetectionForAnalyses", ADD_OR_RUN_ANOMALY_DETECTION_FOR_ANALYSES_FIELD);
        map.put("ShareAnalyses", SHARE_ANALYSES_FIELD);
        map.put("CreateAndUpdateDatasets", CREATE_AND_UPDATE_DATASETS_FIELD);
        map.put("ShareDatasets", SHARE_DATASETS_FIELD);
        map.put("SubscribeDashboardEmailReports", SUBSCRIBE_DASHBOARD_EMAIL_REPORTS_FIELD);
        map.put("CreateAndUpdateDashboardEmailReports", CREATE_AND_UPDATE_DASHBOARD_EMAIL_REPORTS_FIELD);
        map.put("ShareDashboards", SHARE_DASHBOARDS_FIELD);
        map.put("CreateAndUpdateThresholdAlerts", CREATE_AND_UPDATE_THRESHOLD_ALERTS_FIELD);
        map.put("RenameSharedFolders", RENAME_SHARED_FOLDERS_FIELD);
        map.put("CreateSharedFolders", CREATE_SHARED_FOLDERS_FIELD);
        map.put("CreateAndUpdateDataSources", CREATE_AND_UPDATE_DATA_SOURCES_FIELD);
        map.put("ShareDataSources", SHARE_DATA_SOURCES_FIELD);
        map.put("ViewAccountSPICECapacity", VIEW_ACCOUNT_SPICE_CAPACITY_FIELD);
        map.put("CreateSPICEDataset", CREATE_SPICE_DATASET_FIELD);
        map.put("ExportToPdfInScheduledReports", EXPORT_TO_PDF_IN_SCHEDULED_REPORTS_FIELD);
        map.put("ExportToCsvInScheduledReports", EXPORT_TO_CSV_IN_SCHEDULED_REPORTS_FIELD);
        map.put("ExportToExcelInScheduledReports", EXPORT_TO_EXCEL_IN_SCHEDULED_REPORTS_FIELD);
        map.put("IncludeContentInScheduledReportsEmail", INCLUDE_CONTENT_IN_SCHEDULED_REPORTS_EMAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Capabilities, T> g) {
        return obj -> g.apply((Capabilities)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String exportToCsv;
        private String exportToExcel;
        private String exportToPdf;
        private String printReports;
        private String createAndUpdateThemes;
        private String addOrRunAnomalyDetectionForAnalyses;
        private String shareAnalyses;
        private String createAndUpdateDatasets;
        private String shareDatasets;
        private String subscribeDashboardEmailReports;
        private String createAndUpdateDashboardEmailReports;
        private String shareDashboards;
        private String createAndUpdateThresholdAlerts;
        private String renameSharedFolders;
        private String createSharedFolders;
        private String createAndUpdateDataSources;
        private String shareDataSources;
        private String viewAccountSPICECapacity;
        private String createSPICEDataset;
        private String exportToPdfInScheduledReports;
        private String exportToCsvInScheduledReports;
        private String exportToExcelInScheduledReports;
        private String includeContentInScheduledReportsEmail;

        private BuilderImpl() {
        }

        private BuilderImpl(Capabilities model) {
            this.exportToCsv(model.exportToCsv);
            this.exportToExcel(model.exportToExcel);
            this.exportToPdf(model.exportToPdf);
            this.printReports(model.printReports);
            this.createAndUpdateThemes(model.createAndUpdateThemes);
            this.addOrRunAnomalyDetectionForAnalyses(model.addOrRunAnomalyDetectionForAnalyses);
            this.shareAnalyses(model.shareAnalyses);
            this.createAndUpdateDatasets(model.createAndUpdateDatasets);
            this.shareDatasets(model.shareDatasets);
            this.subscribeDashboardEmailReports(model.subscribeDashboardEmailReports);
            this.createAndUpdateDashboardEmailReports(model.createAndUpdateDashboardEmailReports);
            this.shareDashboards(model.shareDashboards);
            this.createAndUpdateThresholdAlerts(model.createAndUpdateThresholdAlerts);
            this.renameSharedFolders(model.renameSharedFolders);
            this.createSharedFolders(model.createSharedFolders);
            this.createAndUpdateDataSources(model.createAndUpdateDataSources);
            this.shareDataSources(model.shareDataSources);
            this.viewAccountSPICECapacity(model.viewAccountSPICECapacity);
            this.createSPICEDataset(model.createSPICEDataset);
            this.exportToPdfInScheduledReports(model.exportToPdfInScheduledReports);
            this.exportToCsvInScheduledReports(model.exportToCsvInScheduledReports);
            this.exportToExcelInScheduledReports(model.exportToExcelInScheduledReports);
            this.includeContentInScheduledReportsEmail(model.includeContentInScheduledReportsEmail);
        }

        public final String getExportToCsv() {
            return this.exportToCsv;
        }

        public final void setExportToCsv(String exportToCsv) {
            this.exportToCsv = exportToCsv;
        }

        @Override
        public final Builder exportToCsv(String exportToCsv) {
            this.exportToCsv = exportToCsv;
            return this;
        }

        @Override
        public final Builder exportToCsv(CapabilityState exportToCsv) {
            this.exportToCsv(exportToCsv == null ? null : exportToCsv.toString());
            return this;
        }

        public final String getExportToExcel() {
            return this.exportToExcel;
        }

        public final void setExportToExcel(String exportToExcel) {
            this.exportToExcel = exportToExcel;
        }

        @Override
        public final Builder exportToExcel(String exportToExcel) {
            this.exportToExcel = exportToExcel;
            return this;
        }

        @Override
        public final Builder exportToExcel(CapabilityState exportToExcel) {
            this.exportToExcel(exportToExcel == null ? null : exportToExcel.toString());
            return this;
        }

        public final String getExportToPdf() {
            return this.exportToPdf;
        }

        public final void setExportToPdf(String exportToPdf) {
            this.exportToPdf = exportToPdf;
        }

        @Override
        public final Builder exportToPdf(String exportToPdf) {
            this.exportToPdf = exportToPdf;
            return this;
        }

        @Override
        public final Builder exportToPdf(CapabilityState exportToPdf) {
            this.exportToPdf(exportToPdf == null ? null : exportToPdf.toString());
            return this;
        }

        public final String getPrintReports() {
            return this.printReports;
        }

        public final void setPrintReports(String printReports) {
            this.printReports = printReports;
        }

        @Override
        public final Builder printReports(String printReports) {
            this.printReports = printReports;
            return this;
        }

        @Override
        public final Builder printReports(CapabilityState printReports) {
            this.printReports(printReports == null ? null : printReports.toString());
            return this;
        }

        public final String getCreateAndUpdateThemes() {
            return this.createAndUpdateThemes;
        }

        public final void setCreateAndUpdateThemes(String createAndUpdateThemes) {
            this.createAndUpdateThemes = createAndUpdateThemes;
        }

        @Override
        public final Builder createAndUpdateThemes(String createAndUpdateThemes) {
            this.createAndUpdateThemes = createAndUpdateThemes;
            return this;
        }

        @Override
        public final Builder createAndUpdateThemes(CapabilityState createAndUpdateThemes) {
            this.createAndUpdateThemes(createAndUpdateThemes == null ? null : createAndUpdateThemes.toString());
            return this;
        }

        public final String getAddOrRunAnomalyDetectionForAnalyses() {
            return this.addOrRunAnomalyDetectionForAnalyses;
        }

        public final void setAddOrRunAnomalyDetectionForAnalyses(String addOrRunAnomalyDetectionForAnalyses) {
            this.addOrRunAnomalyDetectionForAnalyses = addOrRunAnomalyDetectionForAnalyses;
        }

        @Override
        public final Builder addOrRunAnomalyDetectionForAnalyses(String addOrRunAnomalyDetectionForAnalyses) {
            this.addOrRunAnomalyDetectionForAnalyses = addOrRunAnomalyDetectionForAnalyses;
            return this;
        }

        @Override
        public final Builder addOrRunAnomalyDetectionForAnalyses(CapabilityState addOrRunAnomalyDetectionForAnalyses) {
            this.addOrRunAnomalyDetectionForAnalyses(addOrRunAnomalyDetectionForAnalyses == null ? null : addOrRunAnomalyDetectionForAnalyses.toString());
            return this;
        }

        public final String getShareAnalyses() {
            return this.shareAnalyses;
        }

        public final void setShareAnalyses(String shareAnalyses) {
            this.shareAnalyses = shareAnalyses;
        }

        @Override
        public final Builder shareAnalyses(String shareAnalyses) {
            this.shareAnalyses = shareAnalyses;
            return this;
        }

        @Override
        public final Builder shareAnalyses(CapabilityState shareAnalyses) {
            this.shareAnalyses(shareAnalyses == null ? null : shareAnalyses.toString());
            return this;
        }

        public final String getCreateAndUpdateDatasets() {
            return this.createAndUpdateDatasets;
        }

        public final void setCreateAndUpdateDatasets(String createAndUpdateDatasets) {
            this.createAndUpdateDatasets = createAndUpdateDatasets;
        }

        @Override
        public final Builder createAndUpdateDatasets(String createAndUpdateDatasets) {
            this.createAndUpdateDatasets = createAndUpdateDatasets;
            return this;
        }

        @Override
        public final Builder createAndUpdateDatasets(CapabilityState createAndUpdateDatasets) {
            this.createAndUpdateDatasets(createAndUpdateDatasets == null ? null : createAndUpdateDatasets.toString());
            return this;
        }

        public final String getShareDatasets() {
            return this.shareDatasets;
        }

        public final void setShareDatasets(String shareDatasets) {
            this.shareDatasets = shareDatasets;
        }

        @Override
        public final Builder shareDatasets(String shareDatasets) {
            this.shareDatasets = shareDatasets;
            return this;
        }

        @Override
        public final Builder shareDatasets(CapabilityState shareDatasets) {
            this.shareDatasets(shareDatasets == null ? null : shareDatasets.toString());
            return this;
        }

        public final String getSubscribeDashboardEmailReports() {
            return this.subscribeDashboardEmailReports;
        }

        public final void setSubscribeDashboardEmailReports(String subscribeDashboardEmailReports) {
            this.subscribeDashboardEmailReports = subscribeDashboardEmailReports;
        }

        @Override
        public final Builder subscribeDashboardEmailReports(String subscribeDashboardEmailReports) {
            this.subscribeDashboardEmailReports = subscribeDashboardEmailReports;
            return this;
        }

        @Override
        public final Builder subscribeDashboardEmailReports(CapabilityState subscribeDashboardEmailReports) {
            this.subscribeDashboardEmailReports(subscribeDashboardEmailReports == null ? null : subscribeDashboardEmailReports.toString());
            return this;
        }

        public final String getCreateAndUpdateDashboardEmailReports() {
            return this.createAndUpdateDashboardEmailReports;
        }

        public final void setCreateAndUpdateDashboardEmailReports(String createAndUpdateDashboardEmailReports) {
            this.createAndUpdateDashboardEmailReports = createAndUpdateDashboardEmailReports;
        }

        @Override
        public final Builder createAndUpdateDashboardEmailReports(String createAndUpdateDashboardEmailReports) {
            this.createAndUpdateDashboardEmailReports = createAndUpdateDashboardEmailReports;
            return this;
        }

        @Override
        public final Builder createAndUpdateDashboardEmailReports(CapabilityState createAndUpdateDashboardEmailReports) {
            this.createAndUpdateDashboardEmailReports(createAndUpdateDashboardEmailReports == null ? null : createAndUpdateDashboardEmailReports.toString());
            return this;
        }

        public final String getShareDashboards() {
            return this.shareDashboards;
        }

        public final void setShareDashboards(String shareDashboards) {
            this.shareDashboards = shareDashboards;
        }

        @Override
        public final Builder shareDashboards(String shareDashboards) {
            this.shareDashboards = shareDashboards;
            return this;
        }

        @Override
        public final Builder shareDashboards(CapabilityState shareDashboards) {
            this.shareDashboards(shareDashboards == null ? null : shareDashboards.toString());
            return this;
        }

        public final String getCreateAndUpdateThresholdAlerts() {
            return this.createAndUpdateThresholdAlerts;
        }

        public final void setCreateAndUpdateThresholdAlerts(String createAndUpdateThresholdAlerts) {
            this.createAndUpdateThresholdAlerts = createAndUpdateThresholdAlerts;
        }

        @Override
        public final Builder createAndUpdateThresholdAlerts(String createAndUpdateThresholdAlerts) {
            this.createAndUpdateThresholdAlerts = createAndUpdateThresholdAlerts;
            return this;
        }

        @Override
        public final Builder createAndUpdateThresholdAlerts(CapabilityState createAndUpdateThresholdAlerts) {
            this.createAndUpdateThresholdAlerts(createAndUpdateThresholdAlerts == null ? null : createAndUpdateThresholdAlerts.toString());
            return this;
        }

        public final String getRenameSharedFolders() {
            return this.renameSharedFolders;
        }

        public final void setRenameSharedFolders(String renameSharedFolders) {
            this.renameSharedFolders = renameSharedFolders;
        }

        @Override
        public final Builder renameSharedFolders(String renameSharedFolders) {
            this.renameSharedFolders = renameSharedFolders;
            return this;
        }

        @Override
        public final Builder renameSharedFolders(CapabilityState renameSharedFolders) {
            this.renameSharedFolders(renameSharedFolders == null ? null : renameSharedFolders.toString());
            return this;
        }

        public final String getCreateSharedFolders() {
            return this.createSharedFolders;
        }

        public final void setCreateSharedFolders(String createSharedFolders) {
            this.createSharedFolders = createSharedFolders;
        }

        @Override
        public final Builder createSharedFolders(String createSharedFolders) {
            this.createSharedFolders = createSharedFolders;
            return this;
        }

        @Override
        public final Builder createSharedFolders(CapabilityState createSharedFolders) {
            this.createSharedFolders(createSharedFolders == null ? null : createSharedFolders.toString());
            return this;
        }

        public final String getCreateAndUpdateDataSources() {
            return this.createAndUpdateDataSources;
        }

        public final void setCreateAndUpdateDataSources(String createAndUpdateDataSources) {
            this.createAndUpdateDataSources = createAndUpdateDataSources;
        }

        @Override
        public final Builder createAndUpdateDataSources(String createAndUpdateDataSources) {
            this.createAndUpdateDataSources = createAndUpdateDataSources;
            return this;
        }

        @Override
        public final Builder createAndUpdateDataSources(CapabilityState createAndUpdateDataSources) {
            this.createAndUpdateDataSources(createAndUpdateDataSources == null ? null : createAndUpdateDataSources.toString());
            return this;
        }

        public final String getShareDataSources() {
            return this.shareDataSources;
        }

        public final void setShareDataSources(String shareDataSources) {
            this.shareDataSources = shareDataSources;
        }

        @Override
        public final Builder shareDataSources(String shareDataSources) {
            this.shareDataSources = shareDataSources;
            return this;
        }

        @Override
        public final Builder shareDataSources(CapabilityState shareDataSources) {
            this.shareDataSources(shareDataSources == null ? null : shareDataSources.toString());
            return this;
        }

        public final String getViewAccountSPICECapacity() {
            return this.viewAccountSPICECapacity;
        }

        public final void setViewAccountSPICECapacity(String viewAccountSPICECapacity) {
            this.viewAccountSPICECapacity = viewAccountSPICECapacity;
        }

        @Override
        public final Builder viewAccountSPICECapacity(String viewAccountSPICECapacity) {
            this.viewAccountSPICECapacity = viewAccountSPICECapacity;
            return this;
        }

        @Override
        public final Builder viewAccountSPICECapacity(CapabilityState viewAccountSPICECapacity) {
            this.viewAccountSPICECapacity(viewAccountSPICECapacity == null ? null : viewAccountSPICECapacity.toString());
            return this;
        }

        public final String getCreateSPICEDataset() {
            return this.createSPICEDataset;
        }

        public final void setCreateSPICEDataset(String createSPICEDataset) {
            this.createSPICEDataset = createSPICEDataset;
        }

        @Override
        public final Builder createSPICEDataset(String createSPICEDataset) {
            this.createSPICEDataset = createSPICEDataset;
            return this;
        }

        @Override
        public final Builder createSPICEDataset(CapabilityState createSPICEDataset) {
            this.createSPICEDataset(createSPICEDataset == null ? null : createSPICEDataset.toString());
            return this;
        }

        public final String getExportToPdfInScheduledReports() {
            return this.exportToPdfInScheduledReports;
        }

        public final void setExportToPdfInScheduledReports(String exportToPdfInScheduledReports) {
            this.exportToPdfInScheduledReports = exportToPdfInScheduledReports;
        }

        @Override
        public final Builder exportToPdfInScheduledReports(String exportToPdfInScheduledReports) {
            this.exportToPdfInScheduledReports = exportToPdfInScheduledReports;
            return this;
        }

        @Override
        public final Builder exportToPdfInScheduledReports(CapabilityState exportToPdfInScheduledReports) {
            this.exportToPdfInScheduledReports(exportToPdfInScheduledReports == null ? null : exportToPdfInScheduledReports.toString());
            return this;
        }

        public final String getExportToCsvInScheduledReports() {
            return this.exportToCsvInScheduledReports;
        }

        public final void setExportToCsvInScheduledReports(String exportToCsvInScheduledReports) {
            this.exportToCsvInScheduledReports = exportToCsvInScheduledReports;
        }

        @Override
        public final Builder exportToCsvInScheduledReports(String exportToCsvInScheduledReports) {
            this.exportToCsvInScheduledReports = exportToCsvInScheduledReports;
            return this;
        }

        @Override
        public final Builder exportToCsvInScheduledReports(CapabilityState exportToCsvInScheduledReports) {
            this.exportToCsvInScheduledReports(exportToCsvInScheduledReports == null ? null : exportToCsvInScheduledReports.toString());
            return this;
        }

        public final String getExportToExcelInScheduledReports() {
            return this.exportToExcelInScheduledReports;
        }

        public final void setExportToExcelInScheduledReports(String exportToExcelInScheduledReports) {
            this.exportToExcelInScheduledReports = exportToExcelInScheduledReports;
        }

        @Override
        public final Builder exportToExcelInScheduledReports(String exportToExcelInScheduledReports) {
            this.exportToExcelInScheduledReports = exportToExcelInScheduledReports;
            return this;
        }

        @Override
        public final Builder exportToExcelInScheduledReports(CapabilityState exportToExcelInScheduledReports) {
            this.exportToExcelInScheduledReports(exportToExcelInScheduledReports == null ? null : exportToExcelInScheduledReports.toString());
            return this;
        }

        public final String getIncludeContentInScheduledReportsEmail() {
            return this.includeContentInScheduledReportsEmail;
        }

        public final void setIncludeContentInScheduledReportsEmail(String includeContentInScheduledReportsEmail) {
            this.includeContentInScheduledReportsEmail = includeContentInScheduledReportsEmail;
        }

        @Override
        public final Builder includeContentInScheduledReportsEmail(String includeContentInScheduledReportsEmail) {
            this.includeContentInScheduledReportsEmail = includeContentInScheduledReportsEmail;
            return this;
        }

        @Override
        public final Builder includeContentInScheduledReportsEmail(CapabilityState includeContentInScheduledReportsEmail) {
            this.includeContentInScheduledReportsEmail(includeContentInScheduledReportsEmail == null ? null : includeContentInScheduledReportsEmail.toString());
            return this;
        }

        public Capabilities build() {
            return new Capabilities(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Capabilities> {
        public Builder exportToCsv(String var1);

        public Builder exportToCsv(CapabilityState var1);

        public Builder exportToExcel(String var1);

        public Builder exportToExcel(CapabilityState var1);

        public Builder exportToPdf(String var1);

        public Builder exportToPdf(CapabilityState var1);

        public Builder printReports(String var1);

        public Builder printReports(CapabilityState var1);

        public Builder createAndUpdateThemes(String var1);

        public Builder createAndUpdateThemes(CapabilityState var1);

        public Builder addOrRunAnomalyDetectionForAnalyses(String var1);

        public Builder addOrRunAnomalyDetectionForAnalyses(CapabilityState var1);

        public Builder shareAnalyses(String var1);

        public Builder shareAnalyses(CapabilityState var1);

        public Builder createAndUpdateDatasets(String var1);

        public Builder createAndUpdateDatasets(CapabilityState var1);

        public Builder shareDatasets(String var1);

        public Builder shareDatasets(CapabilityState var1);

        public Builder subscribeDashboardEmailReports(String var1);

        public Builder subscribeDashboardEmailReports(CapabilityState var1);

        public Builder createAndUpdateDashboardEmailReports(String var1);

        public Builder createAndUpdateDashboardEmailReports(CapabilityState var1);

        public Builder shareDashboards(String var1);

        public Builder shareDashboards(CapabilityState var1);

        public Builder createAndUpdateThresholdAlerts(String var1);

        public Builder createAndUpdateThresholdAlerts(CapabilityState var1);

        public Builder renameSharedFolders(String var1);

        public Builder renameSharedFolders(CapabilityState var1);

        public Builder createSharedFolders(String var1);

        public Builder createSharedFolders(CapabilityState var1);

        public Builder createAndUpdateDataSources(String var1);

        public Builder createAndUpdateDataSources(CapabilityState var1);

        public Builder shareDataSources(String var1);

        public Builder shareDataSources(CapabilityState var1);

        public Builder viewAccountSPICECapacity(String var1);

        public Builder viewAccountSPICECapacity(CapabilityState var1);

        public Builder createSPICEDataset(String var1);

        public Builder createSPICEDataset(CapabilityState var1);

        public Builder exportToPdfInScheduledReports(String var1);

        public Builder exportToPdfInScheduledReports(CapabilityState var1);

        public Builder exportToCsvInScheduledReports(String var1);

        public Builder exportToCsvInScheduledReports(CapabilityState var1);

        public Builder exportToExcelInScheduledReports(String var1);

        public Builder exportToExcelInScheduledReports(CapabilityState var1);

        public Builder includeContentInScheduledReportsEmail(String var1);

        public Builder includeContentInScheduledReportsEmail(CapabilityState var1);
    }
}

