/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBrandRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateBrandRequest.Builder, UpdateBrandRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(UpdateBrandRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> BRAND_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BrandId").getter(getter(UpdateBrandRequest::brandId)).setter(setter(Builder::brandId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("BrandId").build()).build();

    private static final SdkField<BrandDefinition> BRAND_DEFINITION_FIELD = SdkField
            .<BrandDefinition> builder(MarshallingType.SDK_POJO).memberName("BrandDefinition")
            .getter(getter(UpdateBrandRequest::brandDefinition)).setter(setter(Builder::brandDefinition))
            .constructor(BrandDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            BRAND_ID_FIELD, BRAND_DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String brandId;

    private final BrandDefinition brandDefinition;

    private UpdateBrandRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.brandId = builder.brandId;
        this.brandDefinition = builder.brandDefinition;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the brand.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the brand.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID of the QuickSight brand.
     * </p>
     * 
     * @return The ID of the QuickSight brand.
     */
    public final String brandId() {
        return brandId;
    }

    /**
     * <p>
     * The definition of the brand.
     * </p>
     * 
     * @return The definition of the brand.
     */
    public final BrandDefinition brandDefinition() {
        return brandDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(brandId());
        hashCode = 31 * hashCode + Objects.hashCode(brandDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrandRequest)) {
            return false;
        }
        UpdateBrandRequest other = (UpdateBrandRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(brandId(), other.brandId())
                && Objects.equals(brandDefinition(), other.brandDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBrandRequest").add("AwsAccountId", awsAccountId()).add("BrandId", brandId())
                .add("BrandDefinition", brandDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "BrandId":
            return Optional.ofNullable(clazz.cast(brandId()));
        case "BrandDefinition":
            return Optional.ofNullable(clazz.cast(brandDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("BrandId", BRAND_ID_FIELD);
        map.put("BrandDefinition", BRAND_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBrandRequest, T> g) {
        return obj -> g.apply((UpdateBrandRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBrandRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the brand.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that owns the brand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID of the QuickSight brand.
         * </p>
         * 
         * @param brandId
         *        The ID of the QuickSight brand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brandId(String brandId);

        /**
         * <p>
         * The definition of the brand.
         * </p>
         * 
         * @param brandDefinition
         *        The definition of the brand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brandDefinition(BrandDefinition brandDefinition);

        /**
         * <p>
         * The definition of the brand.
         * </p>
         * This is a convenience method that creates an instance of the {@link BrandDefinition.Builder} avoiding the
         * need to create one manually via {@link BrandDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BrandDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #brandDefinition(BrandDefinition)}.
         * 
         * @param brandDefinition
         *        a consumer that will call methods on {@link BrandDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #brandDefinition(BrandDefinition)
         */
        default Builder brandDefinition(Consumer<BrandDefinition.Builder> brandDefinition) {
            return brandDefinition(BrandDefinition.builder().applyMutation(brandDefinition).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String brandId;

        private BrandDefinition brandDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBrandRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            brandId(model.brandId);
            brandDefinition(model.brandDefinition);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getBrandId() {
            return brandId;
        }

        public final void setBrandId(String brandId) {
            this.brandId = brandId;
        }

        @Override
        public final Builder brandId(String brandId) {
            this.brandId = brandId;
            return this;
        }

        public final BrandDefinition.Builder getBrandDefinition() {
            return brandDefinition != null ? brandDefinition.toBuilder() : null;
        }

        public final void setBrandDefinition(BrandDefinition.BuilderImpl brandDefinition) {
            this.brandDefinition = brandDefinition != null ? brandDefinition.build() : null;
        }

        @Override
        public final Builder brandDefinition(BrandDefinition brandDefinition) {
            this.brandDefinition = brandDefinition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBrandRequest build() {
            return new UpdateBrandRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
