/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The text format for the title.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ShortFormatText implements SdkPojo, Serializable, ToCopyableBuilder<ShortFormatText.Builder, ShortFormatText> {
    private static final SdkField<String> PLAIN_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlainText").getter(getter(ShortFormatText::plainText)).setter(setter(Builder::plainText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlainText").build()).build();

    private static final SdkField<String> RICH_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RichText").getter(getter(ShortFormatText::richText)).setter(setter(Builder::richText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RichText").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAIN_TEXT_FIELD,
            RICH_TEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String plainText;

    private final String richText;

    private ShortFormatText(BuilderImpl builder) {
        this.plainText = builder.plainText;
        this.richText = builder.richText;
    }

    /**
     * <p>
     * Plain text format.
     * </p>
     * 
     * @return Plain text format.
     */
    public final String plainText() {
        return plainText;
    }

    /**
     * <p>
     * Rich text. Examples of rich text include bold, underline, and italics.
     * </p>
     * 
     * @return Rich text. Examples of rich text include bold, underline, and italics.
     */
    public final String richText() {
        return richText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(plainText());
        hashCode = 31 * hashCode + Objects.hashCode(richText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShortFormatText)) {
            return false;
        }
        ShortFormatText other = (ShortFormatText) obj;
        return Objects.equals(plainText(), other.plainText()) && Objects.equals(richText(), other.richText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ShortFormatText").add("PlainText", plainText()).add("RichText", richText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlainText":
            return Optional.ofNullable(clazz.cast(plainText()));
        case "RichText":
            return Optional.ofNullable(clazz.cast(richText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PlainText", PLAIN_TEXT_FIELD);
        map.put("RichText", RICH_TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ShortFormatText, T> g) {
        return obj -> g.apply((ShortFormatText) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ShortFormatText> {
        /**
         * <p>
         * Plain text format.
         * </p>
         * 
         * @param plainText
         *        Plain text format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder plainText(String plainText);

        /**
         * <p>
         * Rich text. Examples of rich text include bold, underline, and italics.
         * </p>
         * 
         * @param richText
         *        Rich text. Examples of rich text include bold, underline, and italics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder richText(String richText);
    }

    static final class BuilderImpl implements Builder {
        private String plainText;

        private String richText;

        private BuilderImpl() {
        }

        private BuilderImpl(ShortFormatText model) {
            plainText(model.plainText);
            richText(model.richText);
        }

        public final String getPlainText() {
            return plainText;
        }

        public final void setPlainText(String plainText) {
            this.plainText = plainText;
        }

        @Override
        public final Builder plainText(String plainText) {
            this.plainText = plainText;
            return this;
        }

        public final String getRichText() {
            return richText;
        }

        public final void setRichText(String richText) {
            this.richText = richText;
        }

        @Override
        public final Builder richText(String richText) {
            this.richText = richText;
            return this;
        }

        @Override
        public ShortFormatText build() {
            return new ShortFormatText(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
