/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field wells of a radar chart visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RadarChartFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<RadarChartFieldWells.Builder, RadarChartFieldWells> {
    private static final SdkField<RadarChartAggregatedFieldWells> RADAR_CHART_AGGREGATED_FIELD_WELLS_FIELD = SdkField
            .<RadarChartAggregatedFieldWells> builder(MarshallingType.SDK_POJO)
            .memberName("RadarChartAggregatedFieldWells")
            .getter(getter(RadarChartFieldWells::radarChartAggregatedFieldWells))
            .setter(setter(Builder::radarChartAggregatedFieldWells))
            .constructor(RadarChartAggregatedFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RadarChartAggregatedFieldWells")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RADAR_CHART_AGGREGATED_FIELD_WELLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RadarChartAggregatedFieldWells radarChartAggregatedFieldWells;

    private RadarChartFieldWells(BuilderImpl builder) {
        this.radarChartAggregatedFieldWells = builder.radarChartAggregatedFieldWells;
    }

    /**
     * <p>
     * The aggregated field wells of a radar chart visual.
     * </p>
     * 
     * @return The aggregated field wells of a radar chart visual.
     */
    public final RadarChartAggregatedFieldWells radarChartAggregatedFieldWells() {
        return radarChartAggregatedFieldWells;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(radarChartAggregatedFieldWells());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RadarChartFieldWells)) {
            return false;
        }
        RadarChartFieldWells other = (RadarChartFieldWells) obj;
        return Objects.equals(radarChartAggregatedFieldWells(), other.radarChartAggregatedFieldWells());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RadarChartFieldWells").add("RadarChartAggregatedFieldWells", radarChartAggregatedFieldWells())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RadarChartAggregatedFieldWells":
            return Optional.ofNullable(clazz.cast(radarChartAggregatedFieldWells()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RadarChartAggregatedFieldWells", RADAR_CHART_AGGREGATED_FIELD_WELLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RadarChartFieldWells, T> g) {
        return obj -> g.apply((RadarChartFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RadarChartFieldWells> {
        /**
         * <p>
         * The aggregated field wells of a radar chart visual.
         * </p>
         * 
         * @param radarChartAggregatedFieldWells
         *        The aggregated field wells of a radar chart visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder radarChartAggregatedFieldWells(RadarChartAggregatedFieldWells radarChartAggregatedFieldWells);

        /**
         * <p>
         * The aggregated field wells of a radar chart visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link RadarChartAggregatedFieldWells.Builder}
         * avoiding the need to create one manually via {@link RadarChartAggregatedFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RadarChartAggregatedFieldWells.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #radarChartAggregatedFieldWells(RadarChartAggregatedFieldWells)}.
         * 
         * @param radarChartAggregatedFieldWells
         *        a consumer that will call methods on {@link RadarChartAggregatedFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #radarChartAggregatedFieldWells(RadarChartAggregatedFieldWells)
         */
        default Builder radarChartAggregatedFieldWells(
                Consumer<RadarChartAggregatedFieldWells.Builder> radarChartAggregatedFieldWells) {
            return radarChartAggregatedFieldWells(RadarChartAggregatedFieldWells.builder()
                    .applyMutation(radarChartAggregatedFieldWells).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RadarChartAggregatedFieldWells radarChartAggregatedFieldWells;

        private BuilderImpl() {
        }

        private BuilderImpl(RadarChartFieldWells model) {
            radarChartAggregatedFieldWells(model.radarChartAggregatedFieldWells);
        }

        public final RadarChartAggregatedFieldWells.Builder getRadarChartAggregatedFieldWells() {
            return radarChartAggregatedFieldWells != null ? radarChartAggregatedFieldWells.toBuilder() : null;
        }

        public final void setRadarChartAggregatedFieldWells(
                RadarChartAggregatedFieldWells.BuilderImpl radarChartAggregatedFieldWells) {
            this.radarChartAggregatedFieldWells = radarChartAggregatedFieldWells != null ? radarChartAggregatedFieldWells.build()
                    : null;
        }

        @Override
        public final Builder radarChartAggregatedFieldWells(RadarChartAggregatedFieldWells radarChartAggregatedFieldWells) {
            this.radarChartAggregatedFieldWells = radarChartAggregatedFieldWells;
            return this;
        }

        @Override
        public RadarChartFieldWells build() {
            return new RadarChartFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
