/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a pie chart.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PieChartConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PieChartConfiguration.Builder, PieChartConfiguration> {
    private static final SdkField<PieChartFieldWells> FIELD_WELLS_FIELD = SdkField
            .<PieChartFieldWells> builder(MarshallingType.SDK_POJO).memberName("FieldWells")
            .getter(getter(PieChartConfiguration::fieldWells)).setter(setter(Builder::fieldWells))
            .constructor(PieChartFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()).build();

    private static final SdkField<PieChartSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField
            .<PieChartSortConfiguration> builder(MarshallingType.SDK_POJO).memberName("SortConfiguration")
            .getter(getter(PieChartConfiguration::sortConfiguration)).setter(setter(Builder::sortConfiguration))
            .constructor(PieChartSortConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()).build();

    private static final SdkField<DonutOptions> DONUT_OPTIONS_FIELD = SdkField.<DonutOptions> builder(MarshallingType.SDK_POJO)
            .memberName("DonutOptions").getter(getter(PieChartConfiguration::donutOptions)).setter(setter(Builder::donutOptions))
            .constructor(DonutOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DonutOptions").build()).build();

    private static final SdkField<SmallMultiplesOptions> SMALL_MULTIPLES_OPTIONS_FIELD = SdkField
            .<SmallMultiplesOptions> builder(MarshallingType.SDK_POJO).memberName("SmallMultiplesOptions")
            .getter(getter(PieChartConfiguration::smallMultiplesOptions)).setter(setter(Builder::smallMultiplesOptions))
            .constructor(SmallMultiplesOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmallMultiplesOptions").build())
            .build();

    private static final SdkField<ChartAxisLabelOptions> CATEGORY_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("CategoryLabelOptions")
            .getter(getter(PieChartConfiguration::categoryLabelOptions)).setter(setter(Builder::categoryLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryLabelOptions").build())
            .build();

    private static final SdkField<ChartAxisLabelOptions> VALUE_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("ValueLabelOptions")
            .getter(getter(PieChartConfiguration::valueLabelOptions)).setter(setter(Builder::valueLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueLabelOptions").build()).build();

    private static final SdkField<LegendOptions> LEGEND_FIELD = SdkField.<LegendOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Legend").getter(getter(PieChartConfiguration::legend)).setter(setter(Builder::legend))
            .constructor(LegendOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legend").build()).build();

    private static final SdkField<DataLabelOptions> DATA_LABELS_FIELD = SdkField
            .<DataLabelOptions> builder(MarshallingType.SDK_POJO).memberName("DataLabels")
            .getter(getter(PieChartConfiguration::dataLabels)).setter(setter(Builder::dataLabels))
            .constructor(DataLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLabels").build()).build();

    private static final SdkField<TooltipOptions> TOOLTIP_FIELD = SdkField.<TooltipOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Tooltip").getter(getter(PieChartConfiguration::tooltip)).setter(setter(Builder::tooltip))
            .constructor(TooltipOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()).build();

    private static final SdkField<VisualPalette> VISUAL_PALETTE_FIELD = SdkField
            .<VisualPalette> builder(MarshallingType.SDK_POJO).memberName("VisualPalette")
            .getter(getter(PieChartConfiguration::visualPalette)).setter(setter(Builder::visualPalette))
            .constructor(VisualPalette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualPalette").build()).build();

    private static final SdkField<List<ContributionAnalysisDefault>> CONTRIBUTION_ANALYSIS_DEFAULTS_FIELD = SdkField
            .<List<ContributionAnalysisDefault>> builder(MarshallingType.LIST)
            .memberName("ContributionAnalysisDefaults")
            .getter(getter(PieChartConfiguration::contributionAnalysisDefaults))
            .setter(setter(Builder::contributionAnalysisDefaults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributionAnalysisDefaults")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContributionAnalysisDefault> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContributionAnalysisDefault::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField
            .<VisualInteractionOptions> builder(MarshallingType.SDK_POJO).memberName("Interactions")
            .getter(getter(PieChartConfiguration::interactions)).setter(setter(Builder::interactions))
            .constructor(VisualInteractionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD,
            SORT_CONFIGURATION_FIELD, DONUT_OPTIONS_FIELD, SMALL_MULTIPLES_OPTIONS_FIELD, CATEGORY_LABEL_OPTIONS_FIELD,
            VALUE_LABEL_OPTIONS_FIELD, LEGEND_FIELD, DATA_LABELS_FIELD, TOOLTIP_FIELD, VISUAL_PALETTE_FIELD,
            CONTRIBUTION_ANALYSIS_DEFAULTS_FIELD, INTERACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PieChartFieldWells fieldWells;

    private final PieChartSortConfiguration sortConfiguration;

    private final DonutOptions donutOptions;

    private final SmallMultiplesOptions smallMultiplesOptions;

    private final ChartAxisLabelOptions categoryLabelOptions;

    private final ChartAxisLabelOptions valueLabelOptions;

    private final LegendOptions legend;

    private final DataLabelOptions dataLabels;

    private final TooltipOptions tooltip;

    private final VisualPalette visualPalette;

    private final List<ContributionAnalysisDefault> contributionAnalysisDefaults;

    private final VisualInteractionOptions interactions;

    private PieChartConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.donutOptions = builder.donutOptions;
        this.smallMultiplesOptions = builder.smallMultiplesOptions;
        this.categoryLabelOptions = builder.categoryLabelOptions;
        this.valueLabelOptions = builder.valueLabelOptions;
        this.legend = builder.legend;
        this.dataLabels = builder.dataLabels;
        this.tooltip = builder.tooltip;
        this.visualPalette = builder.visualPalette;
        this.contributionAnalysisDefaults = builder.contributionAnalysisDefaults;
        this.interactions = builder.interactions;
    }

    /**
     * <p>
     * The field wells of the visual.
     * </p>
     * 
     * @return The field wells of the visual.
     */
    public final PieChartFieldWells fieldWells() {
        return fieldWells;
    }

    /**
     * <p>
     * The sort configuration of a pie chart.
     * </p>
     * 
     * @return The sort configuration of a pie chart.
     */
    public final PieChartSortConfiguration sortConfiguration() {
        return sortConfiguration;
    }

    /**
     * <p>
     * The options that determine the shape of the chart. This option determines whether the chart is a pie chart or a
     * donut chart.
     * </p>
     * 
     * @return The options that determine the shape of the chart. This option determines whether the chart is a pie
     *         chart or a donut chart.
     */
    public final DonutOptions donutOptions() {
        return donutOptions;
    }

    /**
     * <p>
     * The small multiples setup for the visual.
     * </p>
     * 
     * @return The small multiples setup for the visual.
     */
    public final SmallMultiplesOptions smallMultiplesOptions() {
        return smallMultiplesOptions;
    }

    /**
     * <p>
     * The label options of the group/color that is displayed in a pie chart.
     * </p>
     * 
     * @return The label options of the group/color that is displayed in a pie chart.
     */
    public final ChartAxisLabelOptions categoryLabelOptions() {
        return categoryLabelOptions;
    }

    /**
     * <p>
     * The label options for the value that is displayed in a pie chart.
     * </p>
     * 
     * @return The label options for the value that is displayed in a pie chart.
     */
    public final ChartAxisLabelOptions valueLabelOptions() {
        return valueLabelOptions;
    }

    /**
     * <p>
     * The legend display setup of the visual.
     * </p>
     * 
     * @return The legend display setup of the visual.
     */
    public final LegendOptions legend() {
        return legend;
    }

    /**
     * <p>
     * The options that determine if visual data labels are displayed.
     * </p>
     * 
     * @return The options that determine if visual data labels are displayed.
     */
    public final DataLabelOptions dataLabels() {
        return dataLabels;
    }

    /**
     * <p>
     * The tooltip display setup of the visual.
     * </p>
     * 
     * @return The tooltip display setup of the visual.
     */
    public final TooltipOptions tooltip() {
        return tooltip;
    }

    /**
     * <p>
     * The palette (chart color) display setup of the visual.
     * </p>
     * 
     * @return The palette (chart color) display setup of the visual.
     */
    public final VisualPalette visualPalette() {
        return visualPalette;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContributionAnalysisDefaults property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasContributionAnalysisDefaults() {
        return contributionAnalysisDefaults != null && !(contributionAnalysisDefaults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The contribution analysis (anomaly configuration) setup of the visual.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContributionAnalysisDefaults} method.
     * </p>
     * 
     * @return The contribution analysis (anomaly configuration) setup of the visual.
     */
    public final List<ContributionAnalysisDefault> contributionAnalysisDefaults() {
        return contributionAnalysisDefaults;
    }

    /**
     * <p>
     * The general visual interactions setup for a visual.
     * </p>
     * 
     * @return The general visual interactions setup for a visual.
     */
    public final VisualInteractionOptions interactions() {
        return interactions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(donutOptions());
        hashCode = 31 * hashCode + Objects.hashCode(smallMultiplesOptions());
        hashCode = 31 * hashCode + Objects.hashCode(categoryLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(valueLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(legend());
        hashCode = 31 * hashCode + Objects.hashCode(dataLabels());
        hashCode = 31 * hashCode + Objects.hashCode(tooltip());
        hashCode = 31 * hashCode + Objects.hashCode(visualPalette());
        hashCode = 31 * hashCode + Objects.hashCode(hasContributionAnalysisDefaults() ? contributionAnalysisDefaults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(interactions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PieChartConfiguration)) {
            return false;
        }
        PieChartConfiguration other = (PieChartConfiguration) obj;
        return Objects.equals(fieldWells(), other.fieldWells()) && Objects.equals(sortConfiguration(), other.sortConfiguration())
                && Objects.equals(donutOptions(), other.donutOptions())
                && Objects.equals(smallMultiplesOptions(), other.smallMultiplesOptions())
                && Objects.equals(categoryLabelOptions(), other.categoryLabelOptions())
                && Objects.equals(valueLabelOptions(), other.valueLabelOptions()) && Objects.equals(legend(), other.legend())
                && Objects.equals(dataLabels(), other.dataLabels()) && Objects.equals(tooltip(), other.tooltip())
                && Objects.equals(visualPalette(), other.visualPalette())
                && hasContributionAnalysisDefaults() == other.hasContributionAnalysisDefaults()
                && Objects.equals(contributionAnalysisDefaults(), other.contributionAnalysisDefaults())
                && Objects.equals(interactions(), other.interactions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PieChartConfiguration").add("FieldWells", fieldWells())
                .add("SortConfiguration", sortConfiguration()).add("DonutOptions", donutOptions())
                .add("SmallMultiplesOptions", smallMultiplesOptions()).add("CategoryLabelOptions", categoryLabelOptions())
                .add("ValueLabelOptions", valueLabelOptions()).add("Legend", legend()).add("DataLabels", dataLabels())
                .add("Tooltip", tooltip()).add("VisualPalette", visualPalette())
                .add("ContributionAnalysisDefaults", hasContributionAnalysisDefaults() ? contributionAnalysisDefaults() : null)
                .add("Interactions", interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldWells":
            return Optional.ofNullable(clazz.cast(fieldWells()));
        case "SortConfiguration":
            return Optional.ofNullable(clazz.cast(sortConfiguration()));
        case "DonutOptions":
            return Optional.ofNullable(clazz.cast(donutOptions()));
        case "SmallMultiplesOptions":
            return Optional.ofNullable(clazz.cast(smallMultiplesOptions()));
        case "CategoryLabelOptions":
            return Optional.ofNullable(clazz.cast(categoryLabelOptions()));
        case "ValueLabelOptions":
            return Optional.ofNullable(clazz.cast(valueLabelOptions()));
        case "Legend":
            return Optional.ofNullable(clazz.cast(legend()));
        case "DataLabels":
            return Optional.ofNullable(clazz.cast(dataLabels()));
        case "Tooltip":
            return Optional.ofNullable(clazz.cast(tooltip()));
        case "VisualPalette":
            return Optional.ofNullable(clazz.cast(visualPalette()));
        case "ContributionAnalysisDefaults":
            return Optional.ofNullable(clazz.cast(contributionAnalysisDefaults()));
        case "Interactions":
            return Optional.ofNullable(clazz.cast(interactions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldWells", FIELD_WELLS_FIELD);
        map.put("SortConfiguration", SORT_CONFIGURATION_FIELD);
        map.put("DonutOptions", DONUT_OPTIONS_FIELD);
        map.put("SmallMultiplesOptions", SMALL_MULTIPLES_OPTIONS_FIELD);
        map.put("CategoryLabelOptions", CATEGORY_LABEL_OPTIONS_FIELD);
        map.put("ValueLabelOptions", VALUE_LABEL_OPTIONS_FIELD);
        map.put("Legend", LEGEND_FIELD);
        map.put("DataLabels", DATA_LABELS_FIELD);
        map.put("Tooltip", TOOLTIP_FIELD);
        map.put("VisualPalette", VISUAL_PALETTE_FIELD);
        map.put("ContributionAnalysisDefaults", CONTRIBUTION_ANALYSIS_DEFAULTS_FIELD);
        map.put("Interactions", INTERACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PieChartConfiguration, T> g) {
        return obj -> g.apply((PieChartConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PieChartConfiguration> {
        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * 
         * @param fieldWells
         *        The field wells of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldWells(PieChartFieldWells fieldWells);

        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link PieChartFieldWells.Builder} avoiding the
         * need to create one manually via {@link PieChartFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PieChartFieldWells.Builder#build()} is called immediately and its
         * result is passed to {@link #fieldWells(PieChartFieldWells)}.
         * 
         * @param fieldWells
         *        a consumer that will call methods on {@link PieChartFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldWells(PieChartFieldWells)
         */
        default Builder fieldWells(Consumer<PieChartFieldWells.Builder> fieldWells) {
            return fieldWells(PieChartFieldWells.builder().applyMutation(fieldWells).build());
        }

        /**
         * <p>
         * The sort configuration of a pie chart.
         * </p>
         * 
         * @param sortConfiguration
         *        The sort configuration of a pie chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortConfiguration(PieChartSortConfiguration sortConfiguration);

        /**
         * <p>
         * The sort configuration of a pie chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link PieChartSortConfiguration.Builder}
         * avoiding the need to create one manually via {@link PieChartSortConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PieChartSortConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #sortConfiguration(PieChartSortConfiguration)}.
         * 
         * @param sortConfiguration
         *        a consumer that will call methods on {@link PieChartSortConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortConfiguration(PieChartSortConfiguration)
         */
        default Builder sortConfiguration(Consumer<PieChartSortConfiguration.Builder> sortConfiguration) {
            return sortConfiguration(PieChartSortConfiguration.builder().applyMutation(sortConfiguration).build());
        }

        /**
         * <p>
         * The options that determine the shape of the chart. This option determines whether the chart is a pie chart or
         * a donut chart.
         * </p>
         * 
         * @param donutOptions
         *        The options that determine the shape of the chart. This option determines whether the chart is a pie
         *        chart or a donut chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder donutOptions(DonutOptions donutOptions);

        /**
         * <p>
         * The options that determine the shape of the chart. This option determines whether the chart is a pie chart or
         * a donut chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link DonutOptions.Builder} avoiding the need
         * to create one manually via {@link DonutOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DonutOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #donutOptions(DonutOptions)}.
         * 
         * @param donutOptions
         *        a consumer that will call methods on {@link DonutOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #donutOptions(DonutOptions)
         */
        default Builder donutOptions(Consumer<DonutOptions.Builder> donutOptions) {
            return donutOptions(DonutOptions.builder().applyMutation(donutOptions).build());
        }

        /**
         * <p>
         * The small multiples setup for the visual.
         * </p>
         * 
         * @param smallMultiplesOptions
         *        The small multiples setup for the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smallMultiplesOptions(SmallMultiplesOptions smallMultiplesOptions);

        /**
         * <p>
         * The small multiples setup for the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link SmallMultiplesOptions.Builder} avoiding
         * the need to create one manually via {@link SmallMultiplesOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SmallMultiplesOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #smallMultiplesOptions(SmallMultiplesOptions)}.
         * 
         * @param smallMultiplesOptions
         *        a consumer that will call methods on {@link SmallMultiplesOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smallMultiplesOptions(SmallMultiplesOptions)
         */
        default Builder smallMultiplesOptions(Consumer<SmallMultiplesOptions.Builder> smallMultiplesOptions) {
            return smallMultiplesOptions(SmallMultiplesOptions.builder().applyMutation(smallMultiplesOptions).build());
        }

        /**
         * <p>
         * The label options of the group/color that is displayed in a pie chart.
         * </p>
         * 
         * @param categoryLabelOptions
         *        The label options of the group/color that is displayed in a pie chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions);

        /**
         * <p>
         * The label options of the group/color that is displayed in a pie chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #categoryLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param categoryLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoryLabelOptions(ChartAxisLabelOptions)
         */
        default Builder categoryLabelOptions(Consumer<ChartAxisLabelOptions.Builder> categoryLabelOptions) {
            return categoryLabelOptions(ChartAxisLabelOptions.builder().applyMutation(categoryLabelOptions).build());
        }

        /**
         * <p>
         * The label options for the value that is displayed in a pie chart.
         * </p>
         * 
         * @param valueLabelOptions
         *        The label options for the value that is displayed in a pie chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueLabelOptions(ChartAxisLabelOptions valueLabelOptions);

        /**
         * <p>
         * The label options for the value that is displayed in a pie chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #valueLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param valueLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueLabelOptions(ChartAxisLabelOptions)
         */
        default Builder valueLabelOptions(Consumer<ChartAxisLabelOptions.Builder> valueLabelOptions) {
            return valueLabelOptions(ChartAxisLabelOptions.builder().applyMutation(valueLabelOptions).build());
        }

        /**
         * <p>
         * The legend display setup of the visual.
         * </p>
         * 
         * @param legend
         *        The legend display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legend(LegendOptions legend);

        /**
         * <p>
         * The legend display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link LegendOptions.Builder} avoiding the need
         * to create one manually via {@link LegendOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LegendOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #legend(LegendOptions)}.
         * 
         * @param legend
         *        a consumer that will call methods on {@link LegendOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #legend(LegendOptions)
         */
        default Builder legend(Consumer<LegendOptions.Builder> legend) {
            return legend(LegendOptions.builder().applyMutation(legend).build());
        }

        /**
         * <p>
         * The options that determine if visual data labels are displayed.
         * </p>
         * 
         * @param dataLabels
         *        The options that determine if visual data labels are displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLabels(DataLabelOptions dataLabels);

        /**
         * <p>
         * The options that determine if visual data labels are displayed.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLabelOptions.Builder} avoiding the
         * need to create one manually via {@link DataLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLabelOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #dataLabels(DataLabelOptions)}.
         * 
         * @param dataLabels
         *        a consumer that will call methods on {@link DataLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataLabels(DataLabelOptions)
         */
        default Builder dataLabels(Consumer<DataLabelOptions.Builder> dataLabels) {
            return dataLabels(DataLabelOptions.builder().applyMutation(dataLabels).build());
        }

        /**
         * <p>
         * The tooltip display setup of the visual.
         * </p>
         * 
         * @param tooltip
         *        The tooltip display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooltip(TooltipOptions tooltip);

        /**
         * <p>
         * The tooltip display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link TooltipOptions.Builder} avoiding the need
         * to create one manually via {@link TooltipOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TooltipOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #tooltip(TooltipOptions)}.
         * 
         * @param tooltip
         *        a consumer that will call methods on {@link TooltipOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tooltip(TooltipOptions)
         */
        default Builder tooltip(Consumer<TooltipOptions.Builder> tooltip) {
            return tooltip(TooltipOptions.builder().applyMutation(tooltip).build());
        }

        /**
         * <p>
         * The palette (chart color) display setup of the visual.
         * </p>
         * 
         * @param visualPalette
         *        The palette (chart color) display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualPalette(VisualPalette visualPalette);

        /**
         * <p>
         * The palette (chart color) display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualPalette.Builder} avoiding the need
         * to create one manually via {@link VisualPalette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualPalette.Builder#build()} is called immediately and its
         * result is passed to {@link #visualPalette(VisualPalette)}.
         * 
         * @param visualPalette
         *        a consumer that will call methods on {@link VisualPalette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visualPalette(VisualPalette)
         */
        default Builder visualPalette(Consumer<VisualPalette.Builder> visualPalette) {
            return visualPalette(VisualPalette.builder().applyMutation(visualPalette).build());
        }

        /**
         * <p>
         * The contribution analysis (anomaly configuration) setup of the visual.
         * </p>
         * 
         * @param contributionAnalysisDefaults
         *        The contribution analysis (anomaly configuration) setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributionAnalysisDefaults(Collection<ContributionAnalysisDefault> contributionAnalysisDefaults);

        /**
         * <p>
         * The contribution analysis (anomaly configuration) setup of the visual.
         * </p>
         * 
         * @param contributionAnalysisDefaults
         *        The contribution analysis (anomaly configuration) setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributionAnalysisDefaults(ContributionAnalysisDefault... contributionAnalysisDefaults);

        /**
         * <p>
         * The contribution analysis (anomaly configuration) setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ContributionAnalysisDefault.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.ContributionAnalysisDefault#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ContributionAnalysisDefault.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #contributionAnalysisDefaults(List<ContributionAnalysisDefault>)}.
         * 
         * @param contributionAnalysisDefaults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ContributionAnalysisDefault.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contributionAnalysisDefaults(java.util.Collection<ContributionAnalysisDefault>)
         */
        Builder contributionAnalysisDefaults(Consumer<ContributionAnalysisDefault.Builder>... contributionAnalysisDefaults);

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * 
         * @param interactions
         *        The general visual interactions setup for a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactions(VisualInteractionOptions interactions);

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualInteractionOptions.Builder}
         * avoiding the need to create one manually via {@link VisualInteractionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualInteractionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #interactions(VisualInteractionOptions)}.
         * 
         * @param interactions
         *        a consumer that will call methods on {@link VisualInteractionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interactions(VisualInteractionOptions)
         */
        default Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return interactions(VisualInteractionOptions.builder().applyMutation(interactions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PieChartFieldWells fieldWells;

        private PieChartSortConfiguration sortConfiguration;

        private DonutOptions donutOptions;

        private SmallMultiplesOptions smallMultiplesOptions;

        private ChartAxisLabelOptions categoryLabelOptions;

        private ChartAxisLabelOptions valueLabelOptions;

        private LegendOptions legend;

        private DataLabelOptions dataLabels;

        private TooltipOptions tooltip;

        private VisualPalette visualPalette;

        private List<ContributionAnalysisDefault> contributionAnalysisDefaults = DefaultSdkAutoConstructList.getInstance();

        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(PieChartConfiguration model) {
            fieldWells(model.fieldWells);
            sortConfiguration(model.sortConfiguration);
            donutOptions(model.donutOptions);
            smallMultiplesOptions(model.smallMultiplesOptions);
            categoryLabelOptions(model.categoryLabelOptions);
            valueLabelOptions(model.valueLabelOptions);
            legend(model.legend);
            dataLabels(model.dataLabels);
            tooltip(model.tooltip);
            visualPalette(model.visualPalette);
            contributionAnalysisDefaults(model.contributionAnalysisDefaults);
            interactions(model.interactions);
        }

        public final PieChartFieldWells.Builder getFieldWells() {
            return fieldWells != null ? fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(PieChartFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(PieChartFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final PieChartSortConfiguration.Builder getSortConfiguration() {
            return sortConfiguration != null ? sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(PieChartSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(PieChartSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final DonutOptions.Builder getDonutOptions() {
            return donutOptions != null ? donutOptions.toBuilder() : null;
        }

        public final void setDonutOptions(DonutOptions.BuilderImpl donutOptions) {
            this.donutOptions = donutOptions != null ? donutOptions.build() : null;
        }

        @Override
        public final Builder donutOptions(DonutOptions donutOptions) {
            this.donutOptions = donutOptions;
            return this;
        }

        public final SmallMultiplesOptions.Builder getSmallMultiplesOptions() {
            return smallMultiplesOptions != null ? smallMultiplesOptions.toBuilder() : null;
        }

        public final void setSmallMultiplesOptions(SmallMultiplesOptions.BuilderImpl smallMultiplesOptions) {
            this.smallMultiplesOptions = smallMultiplesOptions != null ? smallMultiplesOptions.build() : null;
        }

        @Override
        public final Builder smallMultiplesOptions(SmallMultiplesOptions smallMultiplesOptions) {
            this.smallMultiplesOptions = smallMultiplesOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getCategoryLabelOptions() {
            return categoryLabelOptions != null ? categoryLabelOptions.toBuilder() : null;
        }

        public final void setCategoryLabelOptions(ChartAxisLabelOptions.BuilderImpl categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions != null ? categoryLabelOptions.build() : null;
        }

        @Override
        public final Builder categoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getValueLabelOptions() {
            return valueLabelOptions != null ? valueLabelOptions.toBuilder() : null;
        }

        public final void setValueLabelOptions(ChartAxisLabelOptions.BuilderImpl valueLabelOptions) {
            this.valueLabelOptions = valueLabelOptions != null ? valueLabelOptions.build() : null;
        }

        @Override
        public final Builder valueLabelOptions(ChartAxisLabelOptions valueLabelOptions) {
            this.valueLabelOptions = valueLabelOptions;
            return this;
        }

        public final LegendOptions.Builder getLegend() {
            return legend != null ? legend.toBuilder() : null;
        }

        public final void setLegend(LegendOptions.BuilderImpl legend) {
            this.legend = legend != null ? legend.build() : null;
        }

        @Override
        public final Builder legend(LegendOptions legend) {
            this.legend = legend;
            return this;
        }

        public final DataLabelOptions.Builder getDataLabels() {
            return dataLabels != null ? dataLabels.toBuilder() : null;
        }

        public final void setDataLabels(DataLabelOptions.BuilderImpl dataLabels) {
            this.dataLabels = dataLabels != null ? dataLabels.build() : null;
        }

        @Override
        public final Builder dataLabels(DataLabelOptions dataLabels) {
            this.dataLabels = dataLabels;
            return this;
        }

        public final TooltipOptions.Builder getTooltip() {
            return tooltip != null ? tooltip.toBuilder() : null;
        }

        public final void setTooltip(TooltipOptions.BuilderImpl tooltip) {
            this.tooltip = tooltip != null ? tooltip.build() : null;
        }

        @Override
        public final Builder tooltip(TooltipOptions tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public final VisualPalette.Builder getVisualPalette() {
            return visualPalette != null ? visualPalette.toBuilder() : null;
        }

        public final void setVisualPalette(VisualPalette.BuilderImpl visualPalette) {
            this.visualPalette = visualPalette != null ? visualPalette.build() : null;
        }

        @Override
        public final Builder visualPalette(VisualPalette visualPalette) {
            this.visualPalette = visualPalette;
            return this;
        }

        public final List<ContributionAnalysisDefault.Builder> getContributionAnalysisDefaults() {
            List<ContributionAnalysisDefault.Builder> result = ContributionAnalysisDefaultListCopier
                    .copyToBuilder(this.contributionAnalysisDefaults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContributionAnalysisDefaults(
                Collection<ContributionAnalysisDefault.BuilderImpl> contributionAnalysisDefaults) {
            this.contributionAnalysisDefaults = ContributionAnalysisDefaultListCopier
                    .copyFromBuilder(contributionAnalysisDefaults);
        }

        @Override
        public final Builder contributionAnalysisDefaults(Collection<ContributionAnalysisDefault> contributionAnalysisDefaults) {
            this.contributionAnalysisDefaults = ContributionAnalysisDefaultListCopier.copy(contributionAnalysisDefaults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributionAnalysisDefaults(ContributionAnalysisDefault... contributionAnalysisDefaults) {
            contributionAnalysisDefaults(Arrays.asList(contributionAnalysisDefaults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributionAnalysisDefaults(
                Consumer<ContributionAnalysisDefault.Builder>... contributionAnalysisDefaults) {
            contributionAnalysisDefaults(Stream.of(contributionAnalysisDefaults)
                    .map(c -> ContributionAnalysisDefault.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return interactions != null ? interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        @Override
        public PieChartConfiguration build() {
            return new PieChartConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
