/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata for a column that is used as the input of a transform operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputColumn implements SdkPojo, Serializable, ToCopyableBuilder<InputColumn.Builder, InputColumn> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(InputColumn::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(InputColumn::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> SUB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubType").getter(getter(InputColumn::subTypeAsString)).setter(setter(Builder::subType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            SUB_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final String subType;

    private InputColumn(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.subType = builder.subType;
    }

    /**
     * <p>
     * The name of this column in the underlying data source.
     * </p>
     * 
     * @return The name of this column in the underlying data source.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The data type of the column.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InputColumnDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The data type of the column.
     * @see InputColumnDataType
     */
    public final InputColumnDataType type() {
        return InputColumnDataType.fromValue(type);
    }

    /**
     * <p>
     * The data type of the column.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InputColumnDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The data type of the column.
     * @see InputColumnDataType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The sub data type of the column. Sub types are only available for decimal columns that are part of a SPICE
     * dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subType} will
     * return {@link ColumnDataSubType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #subTypeAsString}.
     * </p>
     * 
     * @return The sub data type of the column. Sub types are only available for decimal columns that are part of a
     *         SPICE dataset.
     * @see ColumnDataSubType
     */
    public final ColumnDataSubType subType() {
        return ColumnDataSubType.fromValue(subType);
    }

    /**
     * <p>
     * The sub data type of the column. Sub types are only available for decimal columns that are part of a SPICE
     * dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subType} will
     * return {@link ColumnDataSubType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #subTypeAsString}.
     * </p>
     * 
     * @return The sub data type of the column. Sub types are only available for decimal columns that are part of a
     *         SPICE dataset.
     * @see ColumnDataSubType
     */
    public final String subTypeAsString() {
        return subType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputColumn)) {
            return false;
        }
        InputColumn other = (InputColumn) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(subTypeAsString(), other.subTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputColumn").add("Name", name()).add("Type", typeAsString()).add("SubType", subTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "SubType":
            return Optional.ofNullable(clazz.cast(subTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("SubType", SUB_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputColumn, T> g) {
        return obj -> g.apply((InputColumn) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputColumn> {
        /**
         * <p>
         * The name of this column in the underlying data source.
         * </p>
         * 
         * @param name
         *        The name of this column in the underlying data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data type of the column.
         * </p>
         * 
         * @param type
         *        The data type of the column.
         * @see InputColumnDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputColumnDataType
         */
        Builder type(String type);

        /**
         * <p>
         * The data type of the column.
         * </p>
         * 
         * @param type
         *        The data type of the column.
         * @see InputColumnDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputColumnDataType
         */
        Builder type(InputColumnDataType type);

        /**
         * <p>
         * The sub data type of the column. Sub types are only available for decimal columns that are part of a SPICE
         * dataset.
         * </p>
         * 
         * @param subType
         *        The sub data type of the column. Sub types are only available for decimal columns that are part of a
         *        SPICE dataset.
         * @see ColumnDataSubType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColumnDataSubType
         */
        Builder subType(String subType);

        /**
         * <p>
         * The sub data type of the column. Sub types are only available for decimal columns that are part of a SPICE
         * dataset.
         * </p>
         * 
         * @param subType
         *        The sub data type of the column. Sub types are only available for decimal columns that are part of a
         *        SPICE dataset.
         * @see ColumnDataSubType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColumnDataSubType
         */
        Builder subType(ColumnDataSubType subType);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private String subType;

        private BuilderImpl() {
        }

        private BuilderImpl(InputColumn model) {
            name(model.name);
            type(model.type);
            subType(model.subType);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InputColumnDataType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSubType() {
            return subType;
        }

        public final void setSubType(String subType) {
            this.subType = subType;
        }

        @Override
        public final Builder subType(String subType) {
            this.subType = subType;
            return this;
        }

        @Override
        public final Builder subType(ColumnDataSubType subType) {
            this.subType(subType == null ? null : subType.toString());
            return this;
        }

        @Override
        public InputColumn build() {
            return new InputColumn(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
