/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The map style properties for a map.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialMapStyle implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialMapStyle.Builder, GeospatialMapStyle> {
    private static final SdkField<String> BASE_MAP_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseMapStyle").getter(getter(GeospatialMapStyle::baseMapStyleAsString))
            .setter(setter(Builder::baseMapStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseMapStyle").build()).build();

    private static final SdkField<String> BACKGROUND_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackgroundColor").getter(getter(GeospatialMapStyle::backgroundColor))
            .setter(setter(Builder::backgroundColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackgroundColor").build()).build();

    private static final SdkField<String> BASE_MAP_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseMapVisibility").getter(getter(GeospatialMapStyle::baseMapVisibilityAsString))
            .setter(setter(Builder::baseMapVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseMapVisibility").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_MAP_STYLE_FIELD,
            BACKGROUND_COLOR_FIELD, BASE_MAP_VISIBILITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String baseMapStyle;

    private final String backgroundColor;

    private final String baseMapVisibility;

    private GeospatialMapStyle(BuilderImpl builder) {
        this.baseMapStyle = builder.baseMapStyle;
        this.backgroundColor = builder.backgroundColor;
        this.baseMapVisibility = builder.baseMapVisibility;
    }

    /**
     * <p>
     * The selected base map style.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #baseMapStyle} will
     * return {@link BaseMapStyleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #baseMapStyleAsString}.
     * </p>
     * 
     * @return The selected base map style.
     * @see BaseMapStyleType
     */
    public final BaseMapStyleType baseMapStyle() {
        return BaseMapStyleType.fromValue(baseMapStyle);
    }

    /**
     * <p>
     * The selected base map style.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #baseMapStyle} will
     * return {@link BaseMapStyleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #baseMapStyleAsString}.
     * </p>
     * 
     * @return The selected base map style.
     * @see BaseMapStyleType
     */
    public final String baseMapStyleAsString() {
        return baseMapStyle;
    }

    /**
     * <p>
     * The background color and opacity values for a map.
     * </p>
     * 
     * @return The background color and opacity values for a map.
     */
    public final String backgroundColor() {
        return backgroundColor;
    }

    /**
     * <p>
     * The state of visibility for the base map.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #baseMapVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #baseMapVisibilityAsString}.
     * </p>
     * 
     * @return The state of visibility for the base map.
     * @see Visibility
     */
    public final Visibility baseMapVisibility() {
        return Visibility.fromValue(baseMapVisibility);
    }

    /**
     * <p>
     * The state of visibility for the base map.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #baseMapVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #baseMapVisibilityAsString}.
     * </p>
     * 
     * @return The state of visibility for the base map.
     * @see Visibility
     */
    public final String baseMapVisibilityAsString() {
        return baseMapVisibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baseMapStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(backgroundColor());
        hashCode = 31 * hashCode + Objects.hashCode(baseMapVisibilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialMapStyle)) {
            return false;
        }
        GeospatialMapStyle other = (GeospatialMapStyle) obj;
        return Objects.equals(baseMapStyleAsString(), other.baseMapStyleAsString())
                && Objects.equals(backgroundColor(), other.backgroundColor())
                && Objects.equals(baseMapVisibilityAsString(), other.baseMapVisibilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialMapStyle").add("BaseMapStyle", baseMapStyleAsString())
                .add("BackgroundColor", backgroundColor()).add("BaseMapVisibility", baseMapVisibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaseMapStyle":
            return Optional.ofNullable(clazz.cast(baseMapStyleAsString()));
        case "BackgroundColor":
            return Optional.ofNullable(clazz.cast(backgroundColor()));
        case "BaseMapVisibility":
            return Optional.ofNullable(clazz.cast(baseMapVisibilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BaseMapStyle", BASE_MAP_STYLE_FIELD);
        map.put("BackgroundColor", BACKGROUND_COLOR_FIELD);
        map.put("BaseMapVisibility", BASE_MAP_VISIBILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialMapStyle, T> g) {
        return obj -> g.apply((GeospatialMapStyle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialMapStyle> {
        /**
         * <p>
         * The selected base map style.
         * </p>
         * 
         * @param baseMapStyle
         *        The selected base map style.
         * @see BaseMapStyleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BaseMapStyleType
         */
        Builder baseMapStyle(String baseMapStyle);

        /**
         * <p>
         * The selected base map style.
         * </p>
         * 
         * @param baseMapStyle
         *        The selected base map style.
         * @see BaseMapStyleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BaseMapStyleType
         */
        Builder baseMapStyle(BaseMapStyleType baseMapStyle);

        /**
         * <p>
         * The background color and opacity values for a map.
         * </p>
         * 
         * @param backgroundColor
         *        The background color and opacity values for a map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backgroundColor(String backgroundColor);

        /**
         * <p>
         * The state of visibility for the base map.
         * </p>
         * 
         * @param baseMapVisibility
         *        The state of visibility for the base map.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder baseMapVisibility(String baseMapVisibility);

        /**
         * <p>
         * The state of visibility for the base map.
         * </p>
         * 
         * @param baseMapVisibility
         *        The state of visibility for the base map.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder baseMapVisibility(Visibility baseMapVisibility);
    }

    static final class BuilderImpl implements Builder {
        private String baseMapStyle;

        private String backgroundColor;

        private String baseMapVisibility;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialMapStyle model) {
            baseMapStyle(model.baseMapStyle);
            backgroundColor(model.backgroundColor);
            baseMapVisibility(model.baseMapVisibility);
        }

        public final String getBaseMapStyle() {
            return baseMapStyle;
        }

        public final void setBaseMapStyle(String baseMapStyle) {
            this.baseMapStyle = baseMapStyle;
        }

        @Override
        public final Builder baseMapStyle(String baseMapStyle) {
            this.baseMapStyle = baseMapStyle;
            return this;
        }

        @Override
        public final Builder baseMapStyle(BaseMapStyleType baseMapStyle) {
            this.baseMapStyle(baseMapStyle == null ? null : baseMapStyle.toString());
            return this;
        }

        public final String getBackgroundColor() {
            return backgroundColor;
        }

        public final void setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        @Override
        public final Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public final String getBaseMapVisibility() {
            return baseMapVisibility;
        }

        public final void setBaseMapVisibility(String baseMapVisibility) {
            this.baseMapVisibility = baseMapVisibility;
        }

        @Override
        public final Builder baseMapVisibility(String baseMapVisibility) {
            this.baseMapVisibility = baseMapVisibility;
            return this;
        }

        @Override
        public final Builder baseMapVisibility(Visibility baseMapVisibility) {
            this.baseMapVisibility(baseMapVisibility == null ? null : baseMapVisibility.toString());
            return this;
        }

        @Override
        public GeospatialMapStyle build() {
            return new GeospatialMapStyle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
