/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The QA result that is made from generated answer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeneratedAnswerResult implements SdkPojo, Serializable,
        ToCopyableBuilder<GeneratedAnswerResult.Builder, GeneratedAnswerResult> {
    private static final SdkField<String> QUESTION_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionText").getter(getter(GeneratedAnswerResult::questionText)).setter(setter(Builder::questionText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionText").build()).build();

    private static final SdkField<String> ANSWER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnswerStatus").getter(getter(GeneratedAnswerResult::answerStatusAsString))
            .setter(setter(Builder::answerStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerStatus").build()).build();

    private static final SdkField<String> TOPIC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicId").getter(getter(GeneratedAnswerResult::topicId)).setter(setter(Builder::topicId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicId").build()).build();

    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicName").getter(getter(GeneratedAnswerResult::topicName)).setter(setter(Builder::topicName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicName").build()).build();

    private static final SdkField<String> RESTATEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Restatement").getter(getter(GeneratedAnswerResult::restatement)).setter(setter(Builder::restatement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Restatement").build()).build();

    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionId").getter(getter(GeneratedAnswerResult::questionId)).setter(setter(Builder::questionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()).build();

    private static final SdkField<String> ANSWER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnswerId").getter(getter(GeneratedAnswerResult::answerId)).setter(setter(Builder::answerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerId").build()).build();

    private static final SdkField<String> QUESTION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionUrl").getter(getter(GeneratedAnswerResult::questionUrl)).setter(setter(Builder::questionUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUESTION_TEXT_FIELD,
            ANSWER_STATUS_FIELD, TOPIC_ID_FIELD, TOPIC_NAME_FIELD, RESTATEMENT_FIELD, QUESTION_ID_FIELD, ANSWER_ID_FIELD,
            QUESTION_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String questionText;

    private final String answerStatus;

    private final String topicId;

    private final String topicName;

    private final String restatement;

    private final String questionId;

    private final String answerId;

    private final String questionUrl;

    private GeneratedAnswerResult(BuilderImpl builder) {
        this.questionText = builder.questionText;
        this.answerStatus = builder.answerStatus;
        this.topicId = builder.topicId;
        this.topicName = builder.topicName;
        this.restatement = builder.restatement;
        this.questionId = builder.questionId;
        this.answerId = builder.answerId;
        this.questionUrl = builder.questionUrl;
    }

    /**
     * <p>
     * The question text.
     * </p>
     * 
     * @return The question text.
     */
    public final String questionText() {
        return questionText;
    }

    /**
     * <p>
     * The answer status of the generated answer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #answerStatus} will
     * return {@link GeneratedAnswerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #answerStatusAsString}.
     * </p>
     * 
     * @return The answer status of the generated answer.
     * @see GeneratedAnswerStatus
     */
    public final GeneratedAnswerStatus answerStatus() {
        return GeneratedAnswerStatus.fromValue(answerStatus);
    }

    /**
     * <p>
     * The answer status of the generated answer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #answerStatus} will
     * return {@link GeneratedAnswerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #answerStatusAsString}.
     * </p>
     * 
     * @return The answer status of the generated answer.
     * @see GeneratedAnswerStatus
     */
    public final String answerStatusAsString() {
        return answerStatus;
    }

    /**
     * <p>
     * The ID of the topic.
     * </p>
     * 
     * @return The ID of the topic.
     */
    public final String topicId() {
        return topicId;
    }

    /**
     * <p>
     * The name of the topic.
     * </p>
     * 
     * @return The name of the topic.
     */
    public final String topicName() {
        return topicName;
    }

    /**
     * <p>
     * The restatement for the answer.
     * </p>
     * 
     * @return The restatement for the answer.
     */
    public final String restatement() {
        return restatement;
    }

    /**
     * <p>
     * The ID of the question.
     * </p>
     * 
     * @return The ID of the question.
     */
    public final String questionId() {
        return questionId;
    }

    /**
     * <p>
     * The ID of the answer.
     * </p>
     * 
     * @return The ID of the answer.
     */
    public final String answerId() {
        return answerId;
    }

    /**
     * <p>
     * The URL of the question.
     * </p>
     * 
     * @return The URL of the question.
     */
    public final String questionUrl() {
        return questionUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(questionText());
        hashCode = 31 * hashCode + Objects.hashCode(answerStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(topicId());
        hashCode = 31 * hashCode + Objects.hashCode(topicName());
        hashCode = 31 * hashCode + Objects.hashCode(restatement());
        hashCode = 31 * hashCode + Objects.hashCode(questionId());
        hashCode = 31 * hashCode + Objects.hashCode(answerId());
        hashCode = 31 * hashCode + Objects.hashCode(questionUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneratedAnswerResult)) {
            return false;
        }
        GeneratedAnswerResult other = (GeneratedAnswerResult) obj;
        return Objects.equals(questionText(), other.questionText())
                && Objects.equals(answerStatusAsString(), other.answerStatusAsString())
                && Objects.equals(topicId(), other.topicId()) && Objects.equals(topicName(), other.topicName())
                && Objects.equals(restatement(), other.restatement()) && Objects.equals(questionId(), other.questionId())
                && Objects.equals(answerId(), other.answerId()) && Objects.equals(questionUrl(), other.questionUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeneratedAnswerResult")
                .add("QuestionText", questionText() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AnswerStatus", answerStatusAsString()).add("TopicId", topicId()).add("TopicName", topicName())
                .add("Restatement", restatement() == null ? null : "*** Sensitive Data Redacted ***")
                .add("QuestionId", questionId()).add("AnswerId", answerId()).add("QuestionUrl", questionUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QuestionText":
            return Optional.ofNullable(clazz.cast(questionText()));
        case "AnswerStatus":
            return Optional.ofNullable(clazz.cast(answerStatusAsString()));
        case "TopicId":
            return Optional.ofNullable(clazz.cast(topicId()));
        case "TopicName":
            return Optional.ofNullable(clazz.cast(topicName()));
        case "Restatement":
            return Optional.ofNullable(clazz.cast(restatement()));
        case "QuestionId":
            return Optional.ofNullable(clazz.cast(questionId()));
        case "AnswerId":
            return Optional.ofNullable(clazz.cast(answerId()));
        case "QuestionUrl":
            return Optional.ofNullable(clazz.cast(questionUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QuestionText", QUESTION_TEXT_FIELD);
        map.put("AnswerStatus", ANSWER_STATUS_FIELD);
        map.put("TopicId", TOPIC_ID_FIELD);
        map.put("TopicName", TOPIC_NAME_FIELD);
        map.put("Restatement", RESTATEMENT_FIELD);
        map.put("QuestionId", QUESTION_ID_FIELD);
        map.put("AnswerId", ANSWER_ID_FIELD);
        map.put("QuestionUrl", QUESTION_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeneratedAnswerResult, T> g) {
        return obj -> g.apply((GeneratedAnswerResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeneratedAnswerResult> {
        /**
         * <p>
         * The question text.
         * </p>
         * 
         * @param questionText
         *        The question text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionText(String questionText);

        /**
         * <p>
         * The answer status of the generated answer.
         * </p>
         * 
         * @param answerStatus
         *        The answer status of the generated answer.
         * @see GeneratedAnswerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeneratedAnswerStatus
         */
        Builder answerStatus(String answerStatus);

        /**
         * <p>
         * The answer status of the generated answer.
         * </p>
         * 
         * @param answerStatus
         *        The answer status of the generated answer.
         * @see GeneratedAnswerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeneratedAnswerStatus
         */
        Builder answerStatus(GeneratedAnswerStatus answerStatus);

        /**
         * <p>
         * The ID of the topic.
         * </p>
         * 
         * @param topicId
         *        The ID of the topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicId(String topicId);

        /**
         * <p>
         * The name of the topic.
         * </p>
         * 
         * @param topicName
         *        The name of the topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicName(String topicName);

        /**
         * <p>
         * The restatement for the answer.
         * </p>
         * 
         * @param restatement
         *        The restatement for the answer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restatement(String restatement);

        /**
         * <p>
         * The ID of the question.
         * </p>
         * 
         * @param questionId
         *        The ID of the question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionId(String questionId);

        /**
         * <p>
         * The ID of the answer.
         * </p>
         * 
         * @param answerId
         *        The ID of the answer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answerId(String answerId);

        /**
         * <p>
         * The URL of the question.
         * </p>
         * 
         * @param questionUrl
         *        The URL of the question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionUrl(String questionUrl);
    }

    static final class BuilderImpl implements Builder {
        private String questionText;

        private String answerStatus;

        private String topicId;

        private String topicName;

        private String restatement;

        private String questionId;

        private String answerId;

        private String questionUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GeneratedAnswerResult model) {
            questionText(model.questionText);
            answerStatus(model.answerStatus);
            topicId(model.topicId);
            topicName(model.topicName);
            restatement(model.restatement);
            questionId(model.questionId);
            answerId(model.answerId);
            questionUrl(model.questionUrl);
        }

        public final String getQuestionText() {
            return questionText;
        }

        public final void setQuestionText(String questionText) {
            this.questionText = questionText;
        }

        @Override
        public final Builder questionText(String questionText) {
            this.questionText = questionText;
            return this;
        }

        public final String getAnswerStatus() {
            return answerStatus;
        }

        public final void setAnswerStatus(String answerStatus) {
            this.answerStatus = answerStatus;
        }

        @Override
        public final Builder answerStatus(String answerStatus) {
            this.answerStatus = answerStatus;
            return this;
        }

        @Override
        public final Builder answerStatus(GeneratedAnswerStatus answerStatus) {
            this.answerStatus(answerStatus == null ? null : answerStatus.toString());
            return this;
        }

        public final String getTopicId() {
            return topicId;
        }

        public final void setTopicId(String topicId) {
            this.topicId = topicId;
        }

        @Override
        public final Builder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public final String getTopicName() {
            return topicName;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final String getRestatement() {
            return restatement;
        }

        public final void setRestatement(String restatement) {
            this.restatement = restatement;
        }

        @Override
        public final Builder restatement(String restatement) {
            this.restatement = restatement;
            return this;
        }

        public final String getQuestionId() {
            return questionId;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final String getAnswerId() {
            return answerId;
        }

        public final void setAnswerId(String answerId) {
            this.answerId = answerId;
        }

        @Override
        public final Builder answerId(String answerId) {
            this.answerId = answerId;
            return this;
        }

        public final String getQuestionUrl() {
            return questionUrl;
        }

        public final void setQuestionUrl(String questionUrl) {
            this.questionUrl = questionUrl;
        }

        @Override
        public final Builder questionUrl(String questionUrl) {
            this.questionUrl = questionUrl;
            return this;
        }

        @Override
        public GeneratedAnswerResult build() {
            return new GeneratedAnswerResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
