/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determines the font settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Font implements SdkPojo, Serializable, ToCopyableBuilder<Font.Builder, Font> {
    private static final SdkField<String> FONT_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FontFamily").getter(getter(Font::fontFamily)).setter(setter(Builder::fontFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontFamily").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FONT_FAMILY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fontFamily;

    private Font(BuilderImpl builder) {
        this.fontFamily = builder.fontFamily;
    }

    /**
     * <p>
     * Determines the font family settings.
     * </p>
     * 
     * @return Determines the font family settings.
     */
    public final String fontFamily() {
        return fontFamily;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fontFamily());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Font)) {
            return false;
        }
        Font other = (Font) obj;
        return Objects.equals(fontFamily(), other.fontFamily());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Font").add("FontFamily", fontFamily()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FontFamily":
            return Optional.ofNullable(clazz.cast(fontFamily()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FontFamily", FONT_FAMILY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Font, T> g) {
        return obj -> g.apply((Font) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Font> {
        /**
         * <p>
         * Determines the font family settings.
         * </p>
         * 
         * @param fontFamily
         *        Determines the font family settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontFamily(String fontFamily);
    }

    static final class BuilderImpl implements Builder {
        private String fontFamily;

        private BuilderImpl() {
        }

        private BuilderImpl(Font model) {
            fontFamily(model.fontFamily);
        }

        public final String getFontFamily() {
            return fontFamily;
        }

        public final void setFontFamily(String fontFamily) {
            this.fontFamily = fontFamily;
        }

        @Override
        public final Builder fontFamily(String fontFamily) {
            this.fontFamily = fontFamily;
            return this;
        }

        @Override
        public Font build() {
            return new Font(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
