/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A control from a filter that is scoped across more than one sheet. This represents your filter control on a sheet
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterCrossSheetControl implements SdkPojo, Serializable,
        ToCopyableBuilder<FilterCrossSheetControl.Builder, FilterCrossSheetControl> {
    private static final SdkField<String> FILTER_CONTROL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterControlId").getter(getter(FilterCrossSheetControl::filterControlId))
            .setter(setter(Builder::filterControlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterControlId").build()).build();

    private static final SdkField<String> SOURCE_FILTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceFilterId").getter(getter(FilterCrossSheetControl::sourceFilterId))
            .setter(setter(Builder::sourceFilterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFilterId").build()).build();

    private static final SdkField<CascadingControlConfiguration> CASCADING_CONTROL_CONFIGURATION_FIELD = SdkField
            .<CascadingControlConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CascadingControlConfiguration")
            .getter(getter(FilterCrossSheetControl::cascadingControlConfiguration))
            .setter(setter(Builder::cascadingControlConfiguration))
            .constructor(CascadingControlConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CascadingControlConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CONTROL_ID_FIELD,
            SOURCE_FILTER_ID_FIELD, CASCADING_CONTROL_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String filterControlId;

    private final String sourceFilterId;

    private final CascadingControlConfiguration cascadingControlConfiguration;

    private FilterCrossSheetControl(BuilderImpl builder) {
        this.filterControlId = builder.filterControlId;
        this.sourceFilterId = builder.sourceFilterId;
        this.cascadingControlConfiguration = builder.cascadingControlConfiguration;
    }

    /**
     * <p>
     * The ID of the <code>FilterCrossSheetControl</code>.
     * </p>
     * 
     * @return The ID of the <code>FilterCrossSheetControl</code>.
     */
    public final String filterControlId() {
        return filterControlId;
    }

    /**
     * <p>
     * The source filter ID of the <code>FilterCrossSheetControl</code>.
     * </p>
     * 
     * @return The source filter ID of the <code>FilterCrossSheetControl</code>.
     */
    public final String sourceFilterId() {
        return sourceFilterId;
    }

    /**
     * <p>
     * The values that are displayed in a control can be configured to only show values that are valid based on what's
     * selected in other controls.
     * </p>
     * 
     * @return The values that are displayed in a control can be configured to only show values that are valid based on
     *         what's selected in other controls.
     */
    public final CascadingControlConfiguration cascadingControlConfiguration() {
        return cascadingControlConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterControlId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(cascadingControlConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterCrossSheetControl)) {
            return false;
        }
        FilterCrossSheetControl other = (FilterCrossSheetControl) obj;
        return Objects.equals(filterControlId(), other.filterControlId())
                && Objects.equals(sourceFilterId(), other.sourceFilterId())
                && Objects.equals(cascadingControlConfiguration(), other.cascadingControlConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterCrossSheetControl").add("FilterControlId", filterControlId())
                .add("SourceFilterId", sourceFilterId()).add("CascadingControlConfiguration", cascadingControlConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterControlId":
            return Optional.ofNullable(clazz.cast(filterControlId()));
        case "SourceFilterId":
            return Optional.ofNullable(clazz.cast(sourceFilterId()));
        case "CascadingControlConfiguration":
            return Optional.ofNullable(clazz.cast(cascadingControlConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FilterControlId", FILTER_CONTROL_ID_FIELD);
        map.put("SourceFilterId", SOURCE_FILTER_ID_FIELD);
        map.put("CascadingControlConfiguration", CASCADING_CONTROL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterCrossSheetControl, T> g) {
        return obj -> g.apply((FilterCrossSheetControl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterCrossSheetControl> {
        /**
         * <p>
         * The ID of the <code>FilterCrossSheetControl</code>.
         * </p>
         * 
         * @param filterControlId
         *        The ID of the <code>FilterCrossSheetControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterControlId(String filterControlId);

        /**
         * <p>
         * The source filter ID of the <code>FilterCrossSheetControl</code>.
         * </p>
         * 
         * @param sourceFilterId
         *        The source filter ID of the <code>FilterCrossSheetControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFilterId(String sourceFilterId);

        /**
         * <p>
         * The values that are displayed in a control can be configured to only show values that are valid based on
         * what's selected in other controls.
         * </p>
         * 
         * @param cascadingControlConfiguration
         *        The values that are displayed in a control can be configured to only show values that are valid based
         *        on what's selected in other controls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cascadingControlConfiguration(CascadingControlConfiguration cascadingControlConfiguration);

        /**
         * <p>
         * The values that are displayed in a control can be configured to only show values that are valid based on
         * what's selected in other controls.
         * </p>
         * This is a convenience method that creates an instance of the {@link CascadingControlConfiguration.Builder}
         * avoiding the need to create one manually via {@link CascadingControlConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CascadingControlConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #cascadingControlConfiguration(CascadingControlConfiguration)}.
         * 
         * @param cascadingControlConfiguration
         *        a consumer that will call methods on {@link CascadingControlConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cascadingControlConfiguration(CascadingControlConfiguration)
         */
        default Builder cascadingControlConfiguration(
                Consumer<CascadingControlConfiguration.Builder> cascadingControlConfiguration) {
            return cascadingControlConfiguration(CascadingControlConfiguration.builder()
                    .applyMutation(cascadingControlConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String filterControlId;

        private String sourceFilterId;

        private CascadingControlConfiguration cascadingControlConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterCrossSheetControl model) {
            filterControlId(model.filterControlId);
            sourceFilterId(model.sourceFilterId);
            cascadingControlConfiguration(model.cascadingControlConfiguration);
        }

        public final String getFilterControlId() {
            return filterControlId;
        }

        public final void setFilterControlId(String filterControlId) {
            this.filterControlId = filterControlId;
        }

        @Override
        public final Builder filterControlId(String filterControlId) {
            this.filterControlId = filterControlId;
            return this;
        }

        public final String getSourceFilterId() {
            return sourceFilterId;
        }

        public final void setSourceFilterId(String sourceFilterId) {
            this.sourceFilterId = sourceFilterId;
        }

        @Override
        public final Builder sourceFilterId(String sourceFilterId) {
            this.sourceFilterId = sourceFilterId;
            return this;
        }

        public final CascadingControlConfiguration.Builder getCascadingControlConfiguration() {
            return cascadingControlConfiguration != null ? cascadingControlConfiguration.toBuilder() : null;
        }

        public final void setCascadingControlConfiguration(CascadingControlConfiguration.BuilderImpl cascadingControlConfiguration) {
            this.cascadingControlConfiguration = cascadingControlConfiguration != null ? cascadingControlConfiguration.build()
                    : null;
        }

        @Override
        public final Builder cascadingControlConfiguration(CascadingControlConfiguration cascadingControlConfiguration) {
            this.cascadingControlConfiguration = cascadingControlConfiguration;
            return this;
        }

        @Override
        public FilterCrossSheetControl build() {
            return new FilterCrossSheetControl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
