/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines different defaults to the users or groups based on mapping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DynamicDefaultValue implements SdkPojo, Serializable,
        ToCopyableBuilder<DynamicDefaultValue.Builder, DynamicDefaultValue> {
    private static final SdkField<ColumnIdentifier> USER_NAME_COLUMN_FIELD = SdkField
            .<ColumnIdentifier> builder(MarshallingType.SDK_POJO).memberName("UserNameColumn")
            .getter(getter(DynamicDefaultValue::userNameColumn)).setter(setter(Builder::userNameColumn))
            .constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserNameColumn").build()).build();

    private static final SdkField<ColumnIdentifier> GROUP_NAME_COLUMN_FIELD = SdkField
            .<ColumnIdentifier> builder(MarshallingType.SDK_POJO).memberName("GroupNameColumn")
            .getter(getter(DynamicDefaultValue::groupNameColumn)).setter(setter(Builder::groupNameColumn))
            .constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupNameColumn").build()).build();

    private static final SdkField<ColumnIdentifier> DEFAULT_VALUE_COLUMN_FIELD = SdkField
            .<ColumnIdentifier> builder(MarshallingType.SDK_POJO).memberName("DefaultValueColumn")
            .getter(getter(DynamicDefaultValue::defaultValueColumn)).setter(setter(Builder::defaultValueColumn))
            .constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValueColumn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_COLUMN_FIELD,
            GROUP_NAME_COLUMN_FIELD, DEFAULT_VALUE_COLUMN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ColumnIdentifier userNameColumn;

    private final ColumnIdentifier groupNameColumn;

    private final ColumnIdentifier defaultValueColumn;

    private DynamicDefaultValue(BuilderImpl builder) {
        this.userNameColumn = builder.userNameColumn;
        this.groupNameColumn = builder.groupNameColumn;
        this.defaultValueColumn = builder.defaultValueColumn;
    }

    /**
     * <p>
     * The column that contains the username.
     * </p>
     * 
     * @return The column that contains the username.
     */
    public final ColumnIdentifier userNameColumn() {
        return userNameColumn;
    }

    /**
     * <p>
     * The column that contains the group name.
     * </p>
     * 
     * @return The column that contains the group name.
     */
    public final ColumnIdentifier groupNameColumn() {
        return groupNameColumn;
    }

    /**
     * <p>
     * The column that contains the default value of each user or group.
     * </p>
     * 
     * @return The column that contains the default value of each user or group.
     */
    public final ColumnIdentifier defaultValueColumn() {
        return defaultValueColumn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userNameColumn());
        hashCode = 31 * hashCode + Objects.hashCode(groupNameColumn());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValueColumn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamicDefaultValue)) {
            return false;
        }
        DynamicDefaultValue other = (DynamicDefaultValue) obj;
        return Objects.equals(userNameColumn(), other.userNameColumn())
                && Objects.equals(groupNameColumn(), other.groupNameColumn())
                && Objects.equals(defaultValueColumn(), other.defaultValueColumn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DynamicDefaultValue").add("UserNameColumn", userNameColumn())
                .add("GroupNameColumn", groupNameColumn()).add("DefaultValueColumn", defaultValueColumn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserNameColumn":
            return Optional.ofNullable(clazz.cast(userNameColumn()));
        case "GroupNameColumn":
            return Optional.ofNullable(clazz.cast(groupNameColumn()));
        case "DefaultValueColumn":
            return Optional.ofNullable(clazz.cast(defaultValueColumn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserNameColumn", USER_NAME_COLUMN_FIELD);
        map.put("GroupNameColumn", GROUP_NAME_COLUMN_FIELD);
        map.put("DefaultValueColumn", DEFAULT_VALUE_COLUMN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DynamicDefaultValue, T> g) {
        return obj -> g.apply((DynamicDefaultValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DynamicDefaultValue> {
        /**
         * <p>
         * The column that contains the username.
         * </p>
         * 
         * @param userNameColumn
         *        The column that contains the username.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userNameColumn(ColumnIdentifier userNameColumn);

        /**
         * <p>
         * The column that contains the username.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #userNameColumn(ColumnIdentifier)}.
         * 
         * @param userNameColumn
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userNameColumn(ColumnIdentifier)
         */
        default Builder userNameColumn(Consumer<ColumnIdentifier.Builder> userNameColumn) {
            return userNameColumn(ColumnIdentifier.builder().applyMutation(userNameColumn).build());
        }

        /**
         * <p>
         * The column that contains the group name.
         * </p>
         * 
         * @param groupNameColumn
         *        The column that contains the group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNameColumn(ColumnIdentifier groupNameColumn);

        /**
         * <p>
         * The column that contains the group name.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #groupNameColumn(ColumnIdentifier)}.
         * 
         * @param groupNameColumn
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupNameColumn(ColumnIdentifier)
         */
        default Builder groupNameColumn(Consumer<ColumnIdentifier.Builder> groupNameColumn) {
            return groupNameColumn(ColumnIdentifier.builder().applyMutation(groupNameColumn).build());
        }

        /**
         * <p>
         * The column that contains the default value of each user or group.
         * </p>
         * 
         * @param defaultValueColumn
         *        The column that contains the default value of each user or group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValueColumn(ColumnIdentifier defaultValueColumn);

        /**
         * <p>
         * The column that contains the default value of each user or group.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultValueColumn(ColumnIdentifier)}.
         * 
         * @param defaultValueColumn
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultValueColumn(ColumnIdentifier)
         */
        default Builder defaultValueColumn(Consumer<ColumnIdentifier.Builder> defaultValueColumn) {
            return defaultValueColumn(ColumnIdentifier.builder().applyMutation(defaultValueColumn).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ColumnIdentifier userNameColumn;

        private ColumnIdentifier groupNameColumn;

        private ColumnIdentifier defaultValueColumn;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamicDefaultValue model) {
            userNameColumn(model.userNameColumn);
            groupNameColumn(model.groupNameColumn);
            defaultValueColumn(model.defaultValueColumn);
        }

        public final ColumnIdentifier.Builder getUserNameColumn() {
            return userNameColumn != null ? userNameColumn.toBuilder() : null;
        }

        public final void setUserNameColumn(ColumnIdentifier.BuilderImpl userNameColumn) {
            this.userNameColumn = userNameColumn != null ? userNameColumn.build() : null;
        }

        @Override
        public final Builder userNameColumn(ColumnIdentifier userNameColumn) {
            this.userNameColumn = userNameColumn;
            return this;
        }

        public final ColumnIdentifier.Builder getGroupNameColumn() {
            return groupNameColumn != null ? groupNameColumn.toBuilder() : null;
        }

        public final void setGroupNameColumn(ColumnIdentifier.BuilderImpl groupNameColumn) {
            this.groupNameColumn = groupNameColumn != null ? groupNameColumn.build() : null;
        }

        @Override
        public final Builder groupNameColumn(ColumnIdentifier groupNameColumn) {
            this.groupNameColumn = groupNameColumn;
            return this;
        }

        public final ColumnIdentifier.Builder getDefaultValueColumn() {
            return defaultValueColumn != null ? defaultValueColumn.toBuilder() : null;
        }

        public final void setDefaultValueColumn(ColumnIdentifier.BuilderImpl defaultValueColumn) {
            this.defaultValueColumn = defaultValueColumn != null ? defaultValueColumn.build() : null;
        }

        @Override
        public final Builder defaultValueColumn(ColumnIdentifier defaultValueColumn) {
            this.defaultValueColumn = defaultValueColumn;
            return this;
        }

        @Override
        public DynamicDefaultValue build() {
            return new DynamicDefaultValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
