/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBrandResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeBrandResponse.Builder, DescribeBrandResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeBrandResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<BrandDetail> BRAND_DETAIL_FIELD = SdkField.<BrandDetail> builder(MarshallingType.SDK_POJO)
            .memberName("BrandDetail").getter(getter(DescribeBrandResponse::brandDetail)).setter(setter(Builder::brandDetail))
            .constructor(BrandDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandDetail").build()).build();

    private static final SdkField<BrandDefinition> BRAND_DEFINITION_FIELD = SdkField
            .<BrandDefinition> builder(MarshallingType.SDK_POJO).memberName("BrandDefinition")
            .getter(getter(DescribeBrandResponse::brandDefinition)).setter(setter(Builder::brandDefinition))
            .constructor(BrandDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            BRAND_DETAIL_FIELD, BRAND_DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String requestId;

    private final BrandDetail brandDetail;

    private final BrandDefinition brandDefinition;

    private DescribeBrandResponse(BuilderImpl builder) {
        super(builder);
        this.requestId = builder.requestId;
        this.brandDetail = builder.brandDetail;
        this.brandDefinition = builder.brandDefinition;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The details of the brand.
     * </p>
     * 
     * @return The details of the brand.
     */
    public final BrandDetail brandDetail() {
        return brandDetail;
    }

    /**
     * <p>
     * The definition of the brand.
     * </p>
     * 
     * @return The definition of the brand.
     */
    public final BrandDefinition brandDefinition() {
        return brandDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(brandDetail());
        hashCode = 31 * hashCode + Objects.hashCode(brandDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBrandResponse)) {
            return false;
        }
        DescribeBrandResponse other = (DescribeBrandResponse) obj;
        return Objects.equals(requestId(), other.requestId()) && Objects.equals(brandDetail(), other.brandDetail())
                && Objects.equals(brandDefinition(), other.brandDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBrandResponse").add("RequestId", requestId()).add("BrandDetail", brandDetail())
                .add("BrandDefinition", brandDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "BrandDetail":
            return Optional.ofNullable(clazz.cast(brandDetail()));
        case "BrandDefinition":
            return Optional.ofNullable(clazz.cast(brandDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("BrandDetail", BRAND_DETAIL_FIELD);
        map.put("BrandDefinition", BRAND_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeBrandResponse, T> g) {
        return obj -> g.apply((DescribeBrandResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBrandResponse> {
        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The details of the brand.
         * </p>
         * 
         * @param brandDetail
         *        The details of the brand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brandDetail(BrandDetail brandDetail);

        /**
         * <p>
         * The details of the brand.
         * </p>
         * This is a convenience method that creates an instance of the {@link BrandDetail.Builder} avoiding the need to
         * create one manually via {@link BrandDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BrandDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #brandDetail(BrandDetail)}.
         * 
         * @param brandDetail
         *        a consumer that will call methods on {@link BrandDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #brandDetail(BrandDetail)
         */
        default Builder brandDetail(Consumer<BrandDetail.Builder> brandDetail) {
            return brandDetail(BrandDetail.builder().applyMutation(brandDetail).build());
        }

        /**
         * <p>
         * The definition of the brand.
         * </p>
         * 
         * @param brandDefinition
         *        The definition of the brand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brandDefinition(BrandDefinition brandDefinition);

        /**
         * <p>
         * The definition of the brand.
         * </p>
         * This is a convenience method that creates an instance of the {@link BrandDefinition.Builder} avoiding the
         * need to create one manually via {@link BrandDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BrandDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #brandDefinition(BrandDefinition)}.
         * 
         * @param brandDefinition
         *        a consumer that will call methods on {@link BrandDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #brandDefinition(BrandDefinition)
         */
        default Builder brandDefinition(Consumer<BrandDefinition.Builder> brandDefinition) {
            return brandDefinition(BrandDefinition.builder().applyMutation(brandDefinition).build());
        }
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String requestId;

        private BrandDetail brandDetail;

        private BrandDefinition brandDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBrandResponse model) {
            super(model);
            requestId(model.requestId);
            brandDetail(model.brandDetail);
            brandDefinition(model.brandDefinition);
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final BrandDetail.Builder getBrandDetail() {
            return brandDetail != null ? brandDetail.toBuilder() : null;
        }

        public final void setBrandDetail(BrandDetail.BuilderImpl brandDetail) {
            this.brandDetail = brandDetail != null ? brandDetail.build() : null;
        }

        @Override
        public final Builder brandDetail(BrandDetail brandDetail) {
            this.brandDetail = brandDetail;
            return this;
        }

        public final BrandDefinition.Builder getBrandDefinition() {
            return brandDefinition != null ? brandDefinition.toBuilder() : null;
        }

        public final void setBrandDefinition(BrandDefinition.BuilderImpl brandDefinition) {
            this.brandDefinition = brandDefinition != null ? brandDefinition.build() : null;
        }

        @Override
        public final Builder brandDefinition(BrandDefinition brandDefinition) {
            this.brandDefinition = brandDefinition;
            return this;
        }

        @Override
        public DescribeBrandResponse build() {
            return new DescribeBrandResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
