/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a <code>CustomContentVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomContentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomContentConfiguration.Builder, CustomContentConfiguration> {
    private static final SdkField<String> CONTENT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentUrl").getter(getter(CustomContentConfiguration::contentUrl)).setter(setter(Builder::contentUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentUrl").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(CustomContentConfiguration::contentTypeAsString))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final SdkField<String> IMAGE_SCALING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageScaling").getter(getter(CustomContentConfiguration::imageScalingAsString))
            .setter(setter(Builder::imageScaling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageScaling").build()).build();

    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField
            .<VisualInteractionOptions> builder(MarshallingType.SDK_POJO).memberName("Interactions")
            .getter(getter(CustomContentConfiguration::interactions)).setter(setter(Builder::interactions))
            .constructor(VisualInteractionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_URL_FIELD,
            CONTENT_TYPE_FIELD, IMAGE_SCALING_FIELD, INTERACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String contentUrl;

    private final String contentType;

    private final String imageScaling;

    private final VisualInteractionOptions interactions;

    private CustomContentConfiguration(BuilderImpl builder) {
        this.contentUrl = builder.contentUrl;
        this.contentType = builder.contentType;
        this.imageScaling = builder.imageScaling;
        this.interactions = builder.interactions;
    }

    /**
     * <p>
     * The input URL that links to the custom content that you want in the custom visual.
     * </p>
     * 
     * @return The input URL that links to the custom content that you want in the custom visual.
     */
    public final String contentUrl() {
        return contentUrl;
    }

    /**
     * <p>
     * The content type of the custom content visual. You can use this to have the visual render as an image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link CustomContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contentTypeAsString}.
     * </p>
     * 
     * @return The content type of the custom content visual. You can use this to have the visual render as an image.
     * @see CustomContentType
     */
    public final CustomContentType contentType() {
        return CustomContentType.fromValue(contentType);
    }

    /**
     * <p>
     * The content type of the custom content visual. You can use this to have the visual render as an image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link CustomContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contentTypeAsString}.
     * </p>
     * 
     * @return The content type of the custom content visual. You can use this to have the visual render as an image.
     * @see CustomContentType
     */
    public final String contentTypeAsString() {
        return contentType;
    }

    /**
     * <p>
     * The sizing options for the size of the custom content visual. This structure is required when the
     * <code>ContentType</code> of the visual is <code>'IMAGE'</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imageScaling} will
     * return {@link CustomContentImageScalingConfiguration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #imageScalingAsString}.
     * </p>
     * 
     * @return The sizing options for the size of the custom content visual. This structure is required when the
     *         <code>ContentType</code> of the visual is <code>'IMAGE'</code>.
     * @see CustomContentImageScalingConfiguration
     */
    public final CustomContentImageScalingConfiguration imageScaling() {
        return CustomContentImageScalingConfiguration.fromValue(imageScaling);
    }

    /**
     * <p>
     * The sizing options for the size of the custom content visual. This structure is required when the
     * <code>ContentType</code> of the visual is <code>'IMAGE'</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imageScaling} will
     * return {@link CustomContentImageScalingConfiguration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #imageScalingAsString}.
     * </p>
     * 
     * @return The sizing options for the size of the custom content visual. This structure is required when the
     *         <code>ContentType</code> of the visual is <code>'IMAGE'</code>.
     * @see CustomContentImageScalingConfiguration
     */
    public final String imageScalingAsString() {
        return imageScaling;
    }

    /**
     * <p>
     * The general visual interactions setup for a visual.
     * </p>
     * 
     * @return The general visual interactions setup for a visual.
     */
    public final VisualInteractionOptions interactions() {
        return interactions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentUrl());
        hashCode = 31 * hashCode + Objects.hashCode(contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageScalingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(interactions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomContentConfiguration)) {
            return false;
        }
        CustomContentConfiguration other = (CustomContentConfiguration) obj;
        return Objects.equals(contentUrl(), other.contentUrl())
                && Objects.equals(contentTypeAsString(), other.contentTypeAsString())
                && Objects.equals(imageScalingAsString(), other.imageScalingAsString())
                && Objects.equals(interactions(), other.interactions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomContentConfiguration").add("ContentUrl", contentUrl())
                .add("ContentType", contentTypeAsString()).add("ImageScaling", imageScalingAsString())
                .add("Interactions", interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContentUrl":
            return Optional.ofNullable(clazz.cast(contentUrl()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentTypeAsString()));
        case "ImageScaling":
            return Optional.ofNullable(clazz.cast(imageScalingAsString()));
        case "Interactions":
            return Optional.ofNullable(clazz.cast(interactions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContentUrl", CONTENT_URL_FIELD);
        map.put("ContentType", CONTENT_TYPE_FIELD);
        map.put("ImageScaling", IMAGE_SCALING_FIELD);
        map.put("Interactions", INTERACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomContentConfiguration, T> g) {
        return obj -> g.apply((CustomContentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomContentConfiguration> {
        /**
         * <p>
         * The input URL that links to the custom content that you want in the custom visual.
         * </p>
         * 
         * @param contentUrl
         *        The input URL that links to the custom content that you want in the custom visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentUrl(String contentUrl);

        /**
         * <p>
         * The content type of the custom content visual. You can use this to have the visual render as an image.
         * </p>
         * 
         * @param contentType
         *        The content type of the custom content visual. You can use this to have the visual render as an image.
         * @see CustomContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomContentType
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The content type of the custom content visual. You can use this to have the visual render as an image.
         * </p>
         * 
         * @param contentType
         *        The content type of the custom content visual. You can use this to have the visual render as an image.
         * @see CustomContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomContentType
         */
        Builder contentType(CustomContentType contentType);

        /**
         * <p>
         * The sizing options for the size of the custom content visual. This structure is required when the
         * <code>ContentType</code> of the visual is <code>'IMAGE'</code>.
         * </p>
         * 
         * @param imageScaling
         *        The sizing options for the size of the custom content visual. This structure is required when the
         *        <code>ContentType</code> of the visual is <code>'IMAGE'</code>.
         * @see CustomContentImageScalingConfiguration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomContentImageScalingConfiguration
         */
        Builder imageScaling(String imageScaling);

        /**
         * <p>
         * The sizing options for the size of the custom content visual. This structure is required when the
         * <code>ContentType</code> of the visual is <code>'IMAGE'</code>.
         * </p>
         * 
         * @param imageScaling
         *        The sizing options for the size of the custom content visual. This structure is required when the
         *        <code>ContentType</code> of the visual is <code>'IMAGE'</code>.
         * @see CustomContentImageScalingConfiguration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomContentImageScalingConfiguration
         */
        Builder imageScaling(CustomContentImageScalingConfiguration imageScaling);

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * 
         * @param interactions
         *        The general visual interactions setup for a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactions(VisualInteractionOptions interactions);

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualInteractionOptions.Builder}
         * avoiding the need to create one manually via {@link VisualInteractionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualInteractionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #interactions(VisualInteractionOptions)}.
         * 
         * @param interactions
         *        a consumer that will call methods on {@link VisualInteractionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interactions(VisualInteractionOptions)
         */
        default Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return interactions(VisualInteractionOptions.builder().applyMutation(interactions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String contentUrl;

        private String contentType;

        private String imageScaling;

        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomContentConfiguration model) {
            contentUrl(model.contentUrl);
            contentType(model.contentType);
            imageScaling(model.imageScaling);
            interactions(model.interactions);
        }

        public final String getContentUrl() {
            return contentUrl;
        }

        public final void setContentUrl(String contentUrl) {
            this.contentUrl = contentUrl;
        }

        @Override
        public final Builder contentUrl(String contentUrl) {
            this.contentUrl = contentUrl;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(CustomContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final String getImageScaling() {
            return imageScaling;
        }

        public final void setImageScaling(String imageScaling) {
            this.imageScaling = imageScaling;
        }

        @Override
        public final Builder imageScaling(String imageScaling) {
            this.imageScaling = imageScaling;
            return this;
        }

        @Override
        public final Builder imageScaling(CustomContentImageScalingConfiguration imageScaling) {
            this.imageScaling(imageScaling == null ? null : imageScaling.toString());
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return interactions != null ? interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        @Override
        public CustomContentConfiguration build() {
            return new CustomContentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
