/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field wells of a <code>BarChartVisual</code>.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BarChartFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<BarChartFieldWells.Builder, BarChartFieldWells> {
    private static final SdkField<BarChartAggregatedFieldWells> BAR_CHART_AGGREGATED_FIELD_WELLS_FIELD = SdkField
            .<BarChartAggregatedFieldWells> builder(MarshallingType.SDK_POJO)
            .memberName("BarChartAggregatedFieldWells")
            .getter(getter(BarChartFieldWells::barChartAggregatedFieldWells))
            .setter(setter(Builder::barChartAggregatedFieldWells))
            .constructor(BarChartAggregatedFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BarChartAggregatedFieldWells")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(BAR_CHART_AGGREGATED_FIELD_WELLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BarChartAggregatedFieldWells barChartAggregatedFieldWells;

    private BarChartFieldWells(BuilderImpl builder) {
        this.barChartAggregatedFieldWells = builder.barChartAggregatedFieldWells;
    }

    /**
     * <p>
     * The aggregated field wells of a bar chart.
     * </p>
     * 
     * @return The aggregated field wells of a bar chart.
     */
    public final BarChartAggregatedFieldWells barChartAggregatedFieldWells() {
        return barChartAggregatedFieldWells;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(barChartAggregatedFieldWells());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BarChartFieldWells)) {
            return false;
        }
        BarChartFieldWells other = (BarChartFieldWells) obj;
        return Objects.equals(barChartAggregatedFieldWells(), other.barChartAggregatedFieldWells());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BarChartFieldWells").add("BarChartAggregatedFieldWells", barChartAggregatedFieldWells()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BarChartAggregatedFieldWells":
            return Optional.ofNullable(clazz.cast(barChartAggregatedFieldWells()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BarChartAggregatedFieldWells", BAR_CHART_AGGREGATED_FIELD_WELLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BarChartFieldWells, T> g) {
        return obj -> g.apply((BarChartFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BarChartFieldWells> {
        /**
         * <p>
         * The aggregated field wells of a bar chart.
         * </p>
         * 
         * @param barChartAggregatedFieldWells
         *        The aggregated field wells of a bar chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder barChartAggregatedFieldWells(BarChartAggregatedFieldWells barChartAggregatedFieldWells);

        /**
         * <p>
         * The aggregated field wells of a bar chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link BarChartAggregatedFieldWells.Builder}
         * avoiding the need to create one manually via {@link BarChartAggregatedFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BarChartAggregatedFieldWells.Builder#build()} is called
         * immediately and its result is passed to {@link #barChartAggregatedFieldWells(BarChartAggregatedFieldWells)}.
         * 
         * @param barChartAggregatedFieldWells
         *        a consumer that will call methods on {@link BarChartAggregatedFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #barChartAggregatedFieldWells(BarChartAggregatedFieldWells)
         */
        default Builder barChartAggregatedFieldWells(Consumer<BarChartAggregatedFieldWells.Builder> barChartAggregatedFieldWells) {
            return barChartAggregatedFieldWells(BarChartAggregatedFieldWells.builder()
                    .applyMutation(barChartAggregatedFieldWells).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BarChartAggregatedFieldWells barChartAggregatedFieldWells;

        private BuilderImpl() {
        }

        private BuilderImpl(BarChartFieldWells model) {
            barChartAggregatedFieldWells(model.barChartAggregatedFieldWells);
        }

        public final BarChartAggregatedFieldWells.Builder getBarChartAggregatedFieldWells() {
            return barChartAggregatedFieldWells != null ? barChartAggregatedFieldWells.toBuilder() : null;
        }

        public final void setBarChartAggregatedFieldWells(BarChartAggregatedFieldWells.BuilderImpl barChartAggregatedFieldWells) {
            this.barChartAggregatedFieldWells = barChartAggregatedFieldWells != null ? barChartAggregatedFieldWells.build()
                    : null;
        }

        @Override
        public final Builder barChartAggregatedFieldWells(BarChartAggregatedFieldWells barChartAggregatedFieldWells) {
            this.barChartAggregatedFieldWells = barChartAggregatedFieldWells;
            return this;
        }

        @Override
        public BarChartFieldWells build() {
            return new BarChartFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
