/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter that you apply when searching for one or more analyses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisSearchFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalysisSearchFilter.Builder, AnalysisSearchFilter> {
    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operator").getter(getter(AnalysisSearchFilter::operatorAsString)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AnalysisSearchFilter::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(AnalysisSearchFilter::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATOR_FIELD, NAME_FIELD,
            VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String operator;

    private final String name;

    private final String value;

    private AnalysisSearchFilter(BuilderImpl builder) {
        this.operator = builder.operator;
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * The comparison operator that you want to use as a filter, for example <code>"Operator": "StringEquals"</code>.
     * Valid values are <code>"StringEquals"</code> and <code>"StringLike"</code>.
     * </p>
     * <p>
     * If you set the operator value to <code>"StringEquals"</code>, you need to provide an ownership related filter in
     * the <code>"NAME"</code> field and the arn of the user or group whose folders you want to search in the
     * <code>"Value"</code> field. For example,
     * <code>"Name":"DIRECT_QUICKSIGHT_OWNER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>
     * .
     * </p>
     * <p>
     * If you set the value to <code>"StringLike"</code>, you need to provide the name of the folders you are searching
     * for. For example, <code>"Name":"ANALYSIS_NAME", "Operator": "StringLike", "Value": "Test"</code>. The
     * <code>"StringLike"</code> operator only supports the <code>NAME</code> value <code>ANALYSIS_NAME</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link FilterOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The comparison operator that you want to use as a filter, for example
     *         <code>"Operator": "StringEquals"</code>. Valid values are <code>"StringEquals"</code> and
     *         <code>"StringLike"</code>.</p>
     *         <p>
     *         If you set the operator value to <code>"StringEquals"</code>, you need to provide an ownership related
     *         filter in the <code>"NAME"</code> field and the arn of the user or group whose folders you want to search
     *         in the <code>"Value"</code> field. For example,
     *         <code>"Name":"DIRECT_QUICKSIGHT_OWNER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>
     *         .
     *         </p>
     *         <p>
     *         If you set the value to <code>"StringLike"</code>, you need to provide the name of the folders you are
     *         searching for. For example,
     *         <code>"Name":"ANALYSIS_NAME", "Operator": "StringLike", "Value": "Test"</code>. The
     *         <code>"StringLike"</code> operator only supports the <code>NAME</code> value <code>ANALYSIS_NAME</code>.
     * @see FilterOperator
     */
    public final FilterOperator operator() {
        return FilterOperator.fromValue(operator);
    }

    /**
     * <p>
     * The comparison operator that you want to use as a filter, for example <code>"Operator": "StringEquals"</code>.
     * Valid values are <code>"StringEquals"</code> and <code>"StringLike"</code>.
     * </p>
     * <p>
     * If you set the operator value to <code>"StringEquals"</code>, you need to provide an ownership related filter in
     * the <code>"NAME"</code> field and the arn of the user or group whose folders you want to search in the
     * <code>"Value"</code> field. For example,
     * <code>"Name":"DIRECT_QUICKSIGHT_OWNER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>
     * .
     * </p>
     * <p>
     * If you set the value to <code>"StringLike"</code>, you need to provide the name of the folders you are searching
     * for. For example, <code>"Name":"ANALYSIS_NAME", "Operator": "StringLike", "Value": "Test"</code>. The
     * <code>"StringLike"</code> operator only supports the <code>NAME</code> value <code>ANALYSIS_NAME</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link FilterOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The comparison operator that you want to use as a filter, for example
     *         <code>"Operator": "StringEquals"</code>. Valid values are <code>"StringEquals"</code> and
     *         <code>"StringLike"</code>.</p>
     *         <p>
     *         If you set the operator value to <code>"StringEquals"</code>, you need to provide an ownership related
     *         filter in the <code>"NAME"</code> field and the arn of the user or group whose folders you want to search
     *         in the <code>"Value"</code> field. For example,
     *         <code>"Name":"DIRECT_QUICKSIGHT_OWNER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>
     *         .
     *         </p>
     *         <p>
     *         If you set the value to <code>"StringLike"</code>, you need to provide the name of the folders you are
     *         searching for. For example,
     *         <code>"Name":"ANALYSIS_NAME", "Operator": "StringLike", "Value": "Test"</code>. The
     *         <code>"StringLike"</code> operator only supports the <code>NAME</code> value <code>ANALYSIS_NAME</code>.
     * @see FilterOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    /**
     * <p>
     * The name of the value that you want to use as a filter, for example <code>"Name": "QUICKSIGHT_OWNER"</code>.
     * </p>
     * <p>
     * Valid values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN listed
     * as one of the analysis' owners or viewers are returned. Implicit permissions from folders or groups are
     * considered.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN listed as one of
     * the owners of the analyses are returned. Implicit permissions from folders or groups are considered.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DIRECT_QUICKSIGHT_SOLE_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN
     * listed as the only owner of the analysis are returned. Implicit permissions from folders or groups are not
     * considered.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DIRECT_QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN listed as
     * one of the owners of the analyses are returned. Implicit permissions from folders or groups are not considered.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DIRECT_QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN
     * listed as one of the owners or viewers of the analyses are returned. Implicit permissions from folders or groups
     * are not considered.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ANALYSIS_NAME</code>: Any analyses whose names have a substring match to this value will be returned.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link AnalysisFilterAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the value that you want to use as a filter, for example
     *         <code>"Name": "QUICKSIGHT_OWNER"</code>.</p>
     *         <p>
     *         Valid values are defined as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any analyses with that
     *         ARN listed as one of the analysis' owners or viewers are returned. Implicit permissions from folders or
     *         groups are considered.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN listed
     *         as one of the owners of the analyses are returned. Implicit permissions from folders or groups are
     *         considered.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DIRECT_QUICKSIGHT_SOLE_OWNER</code>: Provide an ARN of a user or group, and any analyses with that
     *         ARN listed as the only owner of the analysis are returned. Implicit permissions from folders or groups
     *         are not considered.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DIRECT_QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN
     *         listed as one of the owners of the analyses are returned. Implicit permissions from folders or groups are
     *         not considered.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DIRECT_QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any analyses with
     *         that ARN listed as one of the owners or viewers of the analyses are returned. Implicit permissions from
     *         folders or groups are not considered.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ANALYSIS_NAME</code>: Any analyses whose names have a substring match to this value will be
     *         returned.
     *         </p>
     *         </li>
     * @see AnalysisFilterAttribute
     */
    public final AnalysisFilterAttribute name() {
        return AnalysisFilterAttribute.fromValue(name);
    }

    /**
     * <p>
     * The name of the value that you want to use as a filter, for example <code>"Name": "QUICKSIGHT_OWNER"</code>.
     * </p>
     * <p>
     * Valid values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN listed
     * as one of the analysis' owners or viewers are returned. Implicit permissions from folders or groups are
     * considered.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN listed as one of
     * the owners of the analyses are returned. Implicit permissions from folders or groups are considered.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DIRECT_QUICKSIGHT_SOLE_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN
     * listed as the only owner of the analysis are returned. Implicit permissions from folders or groups are not
     * considered.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DIRECT_QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN listed as
     * one of the owners of the analyses are returned. Implicit permissions from folders or groups are not considered.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DIRECT_QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN
     * listed as one of the owners or viewers of the analyses are returned. Implicit permissions from folders or groups
     * are not considered.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ANALYSIS_NAME</code>: Any analyses whose names have a substring match to this value will be returned.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link AnalysisFilterAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the value that you want to use as a filter, for example
     *         <code>"Name": "QUICKSIGHT_OWNER"</code>.</p>
     *         <p>
     *         Valid values are defined as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any analyses with that
     *         ARN listed as one of the analysis' owners or viewers are returned. Implicit permissions from folders or
     *         groups are considered.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN listed
     *         as one of the owners of the analyses are returned. Implicit permissions from folders or groups are
     *         considered.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DIRECT_QUICKSIGHT_SOLE_OWNER</code>: Provide an ARN of a user or group, and any analyses with that
     *         ARN listed as the only owner of the analysis are returned. Implicit permissions from folders or groups
     *         are not considered.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DIRECT_QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN
     *         listed as one of the owners of the analyses are returned. Implicit permissions from folders or groups are
     *         not considered.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DIRECT_QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any analyses with
     *         that ARN listed as one of the owners or viewers of the analyses are returned. Implicit permissions from
     *         folders or groups are not considered.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ANALYSIS_NAME</code>: Any analyses whose names have a substring match to this value will be
     *         returned.
     *         </p>
     *         </li>
     * @see AnalysisFilterAttribute
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The value of the named item, in this case <code>QUICKSIGHT_USER</code>, that you want to use as a filter, for
     * example <code>"Value"</code>. An example is <code>"arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>.
     * </p>
     * 
     * @return The value of the named item, in this case <code>QUICKSIGHT_USER</code>, that you want to use as a filter,
     *         for example <code>"Value"</code>. An example is
     *         <code>"arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisSearchFilter)) {
            return false;
        }
        AnalysisSearchFilter other = (AnalysisSearchFilter) obj;
        return Objects.equals(operatorAsString(), other.operatorAsString())
                && Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisSearchFilter").add("Operator", operatorAsString()).add("Name", nameAsString())
                .add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Operator", OPERATOR_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisSearchFilter, T> g) {
        return obj -> g.apply((AnalysisSearchFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisSearchFilter> {
        /**
         * <p>
         * The comparison operator that you want to use as a filter, for example <code>"Operator": "StringEquals"</code>
         * . Valid values are <code>"StringEquals"</code> and <code>"StringLike"</code>.
         * </p>
         * <p>
         * If you set the operator value to <code>"StringEquals"</code>, you need to provide an ownership related filter
         * in the <code>"NAME"</code> field and the arn of the user or group whose folders you want to search in the
         * <code>"Value"</code> field. For example,
         * <code>"Name":"DIRECT_QUICKSIGHT_OWNER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>
         * .
         * </p>
         * <p>
         * If you set the value to <code>"StringLike"</code>, you need to provide the name of the folders you are
         * searching for. For example, <code>"Name":"ANALYSIS_NAME", "Operator": "StringLike", "Value": "Test"</code>.
         * The <code>"StringLike"</code> operator only supports the <code>NAME</code> value <code>ANALYSIS_NAME</code>.
         * </p>
         * 
         * @param operator
         *        The comparison operator that you want to use as a filter, for example
         *        <code>"Operator": "StringEquals"</code>. Valid values are <code>"StringEquals"</code> and
         *        <code>"StringLike"</code>.</p>
         *        <p>
         *        If you set the operator value to <code>"StringEquals"</code>, you need to provide an ownership related
         *        filter in the <code>"NAME"</code> field and the arn of the user or group whose folders you want to
         *        search in the <code>"Value"</code> field. For example,
         *        <code>"Name":"DIRECT_QUICKSIGHT_OWNER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>
         *        .
         *        </p>
         *        <p>
         *        If you set the value to <code>"StringLike"</code>, you need to provide the name of the folders you are
         *        searching for. For example,
         *        <code>"Name":"ANALYSIS_NAME", "Operator": "StringLike", "Value": "Test"</code>. The
         *        <code>"StringLike"</code> operator only supports the <code>NAME</code> value
         *        <code>ANALYSIS_NAME</code>.
         * @see FilterOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The comparison operator that you want to use as a filter, for example <code>"Operator": "StringEquals"</code>
         * . Valid values are <code>"StringEquals"</code> and <code>"StringLike"</code>.
         * </p>
         * <p>
         * If you set the operator value to <code>"StringEquals"</code>, you need to provide an ownership related filter
         * in the <code>"NAME"</code> field and the arn of the user or group whose folders you want to search in the
         * <code>"Value"</code> field. For example,
         * <code>"Name":"DIRECT_QUICKSIGHT_OWNER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>
         * .
         * </p>
         * <p>
         * If you set the value to <code>"StringLike"</code>, you need to provide the name of the folders you are
         * searching for. For example, <code>"Name":"ANALYSIS_NAME", "Operator": "StringLike", "Value": "Test"</code>.
         * The <code>"StringLike"</code> operator only supports the <code>NAME</code> value <code>ANALYSIS_NAME</code>.
         * </p>
         * 
         * @param operator
         *        The comparison operator that you want to use as a filter, for example
         *        <code>"Operator": "StringEquals"</code>. Valid values are <code>"StringEquals"</code> and
         *        <code>"StringLike"</code>.</p>
         *        <p>
         *        If you set the operator value to <code>"StringEquals"</code>, you need to provide an ownership related
         *        filter in the <code>"NAME"</code> field and the arn of the user or group whose folders you want to
         *        search in the <code>"Value"</code> field. For example,
         *        <code>"Name":"DIRECT_QUICKSIGHT_OWNER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>
         *        .
         *        </p>
         *        <p>
         *        If you set the value to <code>"StringLike"</code>, you need to provide the name of the folders you are
         *        searching for. For example,
         *        <code>"Name":"ANALYSIS_NAME", "Operator": "StringLike", "Value": "Test"</code>. The
         *        <code>"StringLike"</code> operator only supports the <code>NAME</code> value
         *        <code>ANALYSIS_NAME</code>.
         * @see FilterOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterOperator
         */
        Builder operator(FilterOperator operator);

        /**
         * <p>
         * The name of the value that you want to use as a filter, for example <code>"Name": "QUICKSIGHT_OWNER"</code>.
         * </p>
         * <p>
         * Valid values are defined as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN
         * listed as one of the analysis' owners or viewers are returned. Implicit permissions from folders or groups
         * are considered.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN listed as
         * one of the owners of the analyses are returned. Implicit permissions from folders or groups are considered.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DIRECT_QUICKSIGHT_SOLE_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN
         * listed as the only owner of the analysis are returned. Implicit permissions from folders or groups are not
         * considered.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DIRECT_QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN
         * listed as one of the owners of the analyses are returned. Implicit permissions from folders or groups are not
         * considered.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DIRECT_QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any analyses with that
         * ARN listed as one of the owners or viewers of the analyses are returned. Implicit permissions from folders or
         * groups are not considered.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ANALYSIS_NAME</code>: Any analyses whose names have a substring match to this value will be returned.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The name of the value that you want to use as a filter, for example
         *        <code>"Name": "QUICKSIGHT_OWNER"</code>.</p>
         *        <p>
         *        Valid values are defined as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any analyses with that
         *        ARN listed as one of the analysis' owners or viewers are returned. Implicit permissions from folders
         *        or groups are considered.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN
         *        listed as one of the owners of the analyses are returned. Implicit permissions from folders or groups
         *        are considered.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DIRECT_QUICKSIGHT_SOLE_OWNER</code>: Provide an ARN of a user or group, and any analyses with
         *        that ARN listed as the only owner of the analysis are returned. Implicit permissions from folders or
         *        groups are not considered.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DIRECT_QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any analyses with that
         *        ARN listed as one of the owners of the analyses are returned. Implicit permissions from folders or
         *        groups are not considered.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DIRECT_QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any analyses
         *        with that ARN listed as one of the owners or viewers of the analyses are returned. Implicit
         *        permissions from folders or groups are not considered.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ANALYSIS_NAME</code>: Any analyses whose names have a substring match to this value will be
         *        returned.
         *        </p>
         *        </li>
         * @see AnalysisFilterAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisFilterAttribute
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the value that you want to use as a filter, for example <code>"Name": "QUICKSIGHT_OWNER"</code>.
         * </p>
         * <p>
         * Valid values are defined as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN
         * listed as one of the analysis' owners or viewers are returned. Implicit permissions from folders or groups
         * are considered.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN listed as
         * one of the owners of the analyses are returned. Implicit permissions from folders or groups are considered.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DIRECT_QUICKSIGHT_SOLE_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN
         * listed as the only owner of the analysis are returned. Implicit permissions from folders or groups are not
         * considered.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DIRECT_QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN
         * listed as one of the owners of the analyses are returned. Implicit permissions from folders or groups are not
         * considered.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DIRECT_QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any analyses with that
         * ARN listed as one of the owners or viewers of the analyses are returned. Implicit permissions from folders or
         * groups are not considered.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ANALYSIS_NAME</code>: Any analyses whose names have a substring match to this value will be returned.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The name of the value that you want to use as a filter, for example
         *        <code>"Name": "QUICKSIGHT_OWNER"</code>.</p>
         *        <p>
         *        Valid values are defined as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any analyses with that
         *        ARN listed as one of the analysis' owners or viewers are returned. Implicit permissions from folders
         *        or groups are considered.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any analyses with that ARN
         *        listed as one of the owners of the analyses are returned. Implicit permissions from folders or groups
         *        are considered.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DIRECT_QUICKSIGHT_SOLE_OWNER</code>: Provide an ARN of a user or group, and any analyses with
         *        that ARN listed as the only owner of the analysis are returned. Implicit permissions from folders or
         *        groups are not considered.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DIRECT_QUICKSIGHT_OWNER</code>: Provide an ARN of a user or group, and any analyses with that
         *        ARN listed as one of the owners of the analyses are returned. Implicit permissions from folders or
         *        groups are not considered.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DIRECT_QUICKSIGHT_VIEWER_OR_OWNER</code>: Provide an ARN of a user or group, and any analyses
         *        with that ARN listed as one of the owners or viewers of the analyses are returned. Implicit
         *        permissions from folders or groups are not considered.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ANALYSIS_NAME</code>: Any analyses whose names have a substring match to this value will be
         *        returned.
         *        </p>
         *        </li>
         * @see AnalysisFilterAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisFilterAttribute
         */
        Builder name(AnalysisFilterAttribute name);

        /**
         * <p>
         * The value of the named item, in this case <code>QUICKSIGHT_USER</code>, that you want to use as a filter, for
         * example <code>"Value"</code>. An example is
         * <code>"arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>.
         * </p>
         * 
         * @param value
         *        The value of the named item, in this case <code>QUICKSIGHT_USER</code>, that you want to use as a
         *        filter, for example <code>"Value"</code>. An example is
         *        <code>"arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String operator;

        private String name;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisSearchFilter model) {
            operator(model.operator);
            name(model.name);
            value(model.value);
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(FilterOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(AnalysisFilterAttribute name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public AnalysisSearchFilter build() {
            return new AnalysisSearchFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
